/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.player_mobs;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import se.gory_moon.player_mobs.Configs;
import se.gory_moon.player_mobs.LangKeys;
import se.gory_moon.player_mobs.PlayerMobsCommand;
import se.gory_moon.player_mobs.entity.EntityRegistry;
import se.gory_moon.player_mobs.repack.registrate.providers.ProviderType;
import se.gory_moon.player_mobs.sound.SoundRegistry;
import se.gory_moon.player_mobs.utils.CustomRegistrate;
import se.gory_moon.player_mobs.utils.NameManager;

@Mod(value="player_mobs")
public class PlayerMobs {
    private static final Lazy<CustomRegistrate> REGISTRATE = Lazy.of(() -> CustomRegistrate.create("player_mobs"));

    public PlayerMobs() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(EntityRegistry::registerEntityAttributes);
        modBus.addListener(this::gatherData);
        IEventBus eventBus = MinecraftForge.EVENT_BUS;
        eventBus.addListener(this::registerCommands);
        eventBus.addListener(this::serverAboutToStart);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Configs.commonSpec);
        modBus.register((Object)Configs.COMMON);
        EntityRegistry.init();
        SoundRegistry.init();
    }

    public static CustomRegistrate getRegistrate() {
        return (CustomRegistrate)REGISTRATE.get();
    }

    private void gatherData(GatherDataEvent event) {
        PlayerMobs.getRegistrate().addDataGenerator(ProviderType.LANG, prov -> {
            prov.add(LangKeys.COMMANDS_RELOAD_START.key(), "[PlayerMobs] Reloading remote links... ");
            prov.add(LangKeys.COMMANDS_RELOAD_DONE.key(), "[PlayerMobs] Reloaded remote links with %d names");
            prov.add(LangKeys.COMMANDS_SPAWN_SUCCESS.key(), "[PlayerMobs] Spawned %s");
            prov.add(LangKeys.COMMANDS_SPAWN_FAILED.key(), "[PlayerMobs] Unable to spawn entity");
            prov.add(LangKeys.COMMANDS_SPAWN_UUID.key(), "[PlayerMobs] Unable to spawn entity due to duplicate UUIDs");
            prov.add(LangKeys.COMMANDS_SPAWN_INVALID_POS.key(), "[PlayerMobs] Invalid position for spawn");
        });
    }

    private void serverAboutToStart(ServerAboutToStartEvent event) {
        NameManager.INSTANCE.init();
    }

    private void registerCommands(RegisterCommandsEvent event) {
        PlayerMobsCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }
}

