/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.player_mobs.repack.registrate.util.entry;

import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryObject;
import se.gory_moon.player_mobs.repack.registrate.AbstractRegistrate;
import se.gory_moon.player_mobs.repack.registrate.util.nullness.NonNullSupplier;
import se.gory_moon.player_mobs.repack.registrate.util.nullness.NonnullType;

public class RegistryEntry<T extends IForgeRegistryEntry<? super T>>
implements NonNullSupplier<T> {
    private static RegistryEntry<?> EMPTY;
    private final AbstractRegistrate<?> owner;
    @Nullable
    private final RegistryObject<T> delegate;

    public static <T extends IForgeRegistryEntry<? super T>> RegistryEntry<T> empty() {
        RegistryEntry<?> t = EMPTY;
        return t;
    }

    public RegistryEntry(AbstractRegistrate<?> owner, RegistryObject<T> delegate) {
        if (EMPTY != null && owner == null) {
            throw new NullPointerException("Owner must not be null");
        }
        if (EMPTY != null && delegate == null) {
            throw new NullPointerException("Delegate must not be null");
        }
        this.owner = owner;
        this.delegate = delegate;
    }

    public void updateReference(IForgeRegistry<? super T> registry) {
        RegistryObject<T> delegate = this.delegate;
        Objects.requireNonNull(delegate, "Registry entry is empty").updateReference(registry);
    }

    @Override
    @NonnullType
    public T get() {
        RegistryObject delegate = this.delegate;
        return (T)((IForgeRegistryEntry)Objects.requireNonNull(this.getUnchecked(), () -> delegate == null ? "Registry entry is empty" : "Registry entry not present: " + delegate.getId()));
    }

    @Nullable
    public T getUnchecked() {
        RegistryObject<T> delegate = this.delegate;
        return (T)(delegate == null ? null : delegate.orElse(null));
    }

    public <R extends IForgeRegistryEntry<R>, E extends R> RegistryEntry<E> getSibling(Class<? super R> registryType) {
        return this == EMPTY ? RegistryEntry.empty() : this.owner.get(this.getId().m_135815_(), registryType);
    }

    public <R extends IForgeRegistryEntry<R>, E extends R> RegistryEntry<E> getSibling(IForgeRegistry<R> registry) {
        return this.getSibling(registry.getRegistrySuperType());
    }

    public RegistryEntry<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        if (!this.isPresent() || predicate.test(this.get())) {
            return this;
        }
        return RegistryEntry.empty();
    }

    public <R extends IForgeRegistryEntry<? super T>> boolean is(R entry) {
        return this.get() == entry;
    }

    protected static <E extends RegistryEntry<?>> E cast(Class<? super E> clazz, RegistryEntry<?> entry) {
        if (clazz.isInstance(entry)) {
            return (E)entry;
        }
        throw new IllegalArgumentException("Could not convert RegistryEntry: expecting " + clazz + ", found " + entry.getClass());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegistryEntry)) {
            return false;
        }
        RegistryEntry other = (RegistryEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RegistryObject<T> this$delegate = this.delegate;
        RegistryObject<T> other$delegate = other.delegate;
        return !(this$delegate == null ? other$delegate != null : !this$delegate.equals(other$delegate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RegistryEntry;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RegistryObject<T> $delegate = this.delegate;
        result = result * 59 + ($delegate == null ? 43 : $delegate.hashCode());
        return result;
    }

    public ResourceLocation getId() {
        return this.delegate.getId();
    }

    public Stream<T> stream() {
        return this.delegate.stream();
    }

    public boolean isPresent() {
        return this.delegate.isPresent();
    }

    public void ifPresent(Consumer<? super T> consumer) {
        this.delegate.ifPresent(consumer);
    }

    public <U> Optional<U> map(Function<? super T, ? extends U> mapper) {
        return this.delegate.map(mapper);
    }

    public <U> Optional<U> flatMap(Function<? super T, Optional<U>> mapper) {
        return this.delegate.flatMap(mapper);
    }

    public <U> Supplier<U> lazyMap(Function<? super T, ? extends U> mapper) {
        return this.delegate.lazyMap(mapper);
    }

    public T orElse(T other) {
        return (T)this.delegate.orElse(other);
    }

    public T orElseGet(Supplier<? extends T> other) {
        return (T)this.delegate.orElseGet(other);
    }

    public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        return (T)this.delegate.orElseThrow(exceptionSupplier);
    }

    static {
        try {
            RegistryEntry ret = new RegistryEntry(null, (RegistryObject)ObfuscationReflectionHelper.findMethod(RegistryObject.class, (String)"empty", (Class[])new Class[0]).invoke(null, new Object[0]));
            EMPTY = ret;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static interface Exclusions<T extends IForgeRegistryEntry<? super T>> {
        public T get();

        public RegistryObject<T> filter(Predicate<? super T> var1);

        public void updateReference(IForgeRegistry<? extends T> var1);
    }
}

