/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.player_mobs.utils;

import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import se.gory_moon.player_mobs.Configs;
import se.gory_moon.player_mobs.entity.EntityRegistry;
import se.gory_moon.player_mobs.entity.PlayerMobEntity;

@Mod.EventBusSubscriber(modid="player_mobs")
public class SpawnHandler {
    private static MobSpawnSettings.SpawnerData getPlayerMobSpawner() {
        return new MobSpawnSettings.SpawnerData((EntityType)EntityRegistry.PLAYER_MOB_ENTITY.get(), ((Integer)Configs.COMMON.spawnWeight.get()).intValue(), ((Integer)Configs.COMMON.spawnMinSize.get()).intValue(), ((Integer)Configs.COMMON.spawnMaxSize.get()).intValue());
    }

    @SubscribeEvent
    public static void onBiomeLoad(BiomeLoadingEvent event) {
        List spawnersList = event.getSpawns().getSpawner(MobCategory.MONSTER);
        boolean hasZombies = false;
        for (MobSpawnSettings.SpawnerData spawners : spawnersList) {
            if (spawners.f_48404_ != EntityType.f_20501_) continue;
            hasZombies = true;
            break;
        }
        if (hasZombies) {
            spawnersList.add(SpawnHandler.getPlayerMobSpawner());
        }
    }

    @SubscribeEvent
    public static void onCheckSpawn(LivingSpawnEvent.CheckSpawn event) {
        if (event.getEntityLiving() instanceof PlayerMobEntity) {
            ResourceKey worldKey = Level.f_46428_;
            if (event.getWorld() instanceof ServerLevelAccessor) {
                worldKey = ((ServerLevelAccessor)event.getWorld()).m_6018_().m_46472_();
            } else if (event.getWorld() instanceof Level) {
                worldKey = ((Level)event.getWorld()).m_46472_();
            }
            if (Configs.COMMON.isDimensionBlocked((ResourceKey<Level>)worldKey)) {
                event.setResult(Event.Result.DENY);
            }
        }
    }
}

