/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering;

import com.mojang.brigadier.CommandDispatcher;
import dev.theagameplayer.puresuffering.client.ClientTransitionHandler;
import dev.theagameplayer.puresuffering.client.InvasionSkyRenderHandler;
import dev.theagameplayer.puresuffering.client.renderer.InvasionFogRenderer;
import dev.theagameplayer.puresuffering.client.renderer.InvasionSkyRenderer;
import dev.theagameplayer.puresuffering.command.PSCommands;
import dev.theagameplayer.puresuffering.config.PSConfigValues;
import dev.theagameplayer.puresuffering.data.InvasionTypeManager;
import dev.theagameplayer.puresuffering.invasion.Invasion;
import dev.theagameplayer.puresuffering.network.PSPacketHandler;
import dev.theagameplayer.puresuffering.network.packet.UpdateXPMultPacket;
import dev.theagameplayer.puresuffering.registries.PSPotions;
import dev.theagameplayer.puresuffering.registries.other.PSEntityPredicates;
import dev.theagameplayer.puresuffering.registries.other.PSGameRulesRegistry;
import dev.theagameplayer.puresuffering.util.InvasionListType;
import dev.theagameplayer.puresuffering.util.InvasionRendererMap;
import dev.theagameplayer.puresuffering.util.ServerTimeUtil;
import dev.theagameplayer.puresuffering.util.text.InvasionListTextComponent;
import dev.theagameplayer.puresuffering.world.ClientInvasionWorldInfo;
import dev.theagameplayer.puresuffering.world.FixedInvasionWorldData;
import dev.theagameplayer.puresuffering.world.InvasionWorldData;
import dev.theagameplayer.puresuffering.world.TimedInvasionWorldData;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.monster.HoglinEntity;
import net.minecraft.entity.monster.VexEntity;
import net.minecraft.entity.monster.ZoglinEntity;
import net.minecraft.entity.monster.piglin.AbstractPiglinEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.client.ISkyRenderHandler;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityMobGriefingEvent;
import net.minecraftforge.event.entity.living.LivingConversionEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class PSEventManager {
    private static final Logger LOGGER = LogManager.getLogger((String)"puresuffering");

    public static void attachClientEventListeners(IEventBus modBusIn, IEventBus forgeBusIn) {
        forgeBusIn.addListener(ClientEvents::loggedIn);
        forgeBusIn.addListener(ClientEvents::loggedOut);
        forgeBusIn.addListener(ClientEvents::fogColors);
        forgeBusIn.addListener(ClientEvents::renderGameOverlayText);
        forgeBusIn.addListener(ClientEvents::renderWorldLast);
    }

    public static void attachCommonEventListeners(IEventBus modBusIn, IEventBus forgeBusIn) {
        forgeBusIn.addListener(BaseEvents::addReloadListeners);
        forgeBusIn.addListener(BaseEvents::registerCommands);
        forgeBusIn.addListener(BaseEvents::worldTick);
        forgeBusIn.addListener(EntityEvents::joinWorld);
        forgeBusIn.addListener(EntityEvents::mobGriefing);
        forgeBusIn.addListener(LivingEvents::livingConversion);
        forgeBusIn.addListener(LivingEvents::livingUpdate);
        forgeBusIn.addListener(LivingEvents::experienceDrop);
        forgeBusIn.addListener(LivingEvents::checkSpawn);
        forgeBusIn.addListener(LivingEvents::specialSpawn);
        forgeBusIn.addListener(LivingEvents::allowDespawn);
        forgeBusIn.addListener(PlayerEvents::playerLoggedIn);
        forgeBusIn.addListener(PlayerEvents::playerRespawn);
        forgeBusIn.addListener(PlayerEvents::playerChangeDimension);
        forgeBusIn.addListener(PlayerEvents::playerSleepInBed);
        forgeBusIn.addListener(ServerEvents::serverStarted);
        forgeBusIn.addListener(ServerEvents::serverStarting);
        forgeBusIn.addListener(ServerEvents::serverStopping);
    }

    public static final class ServerEvents {
        public static void serverStarted(FMLServerStartedEvent eventIn) {
            if (PSConfigValues.common.multiThreadedInvasions) {
                for (InvasionWorldData iwData : InvasionWorldData.getInvasionData().values()) {
                    eventIn.getServer().func_82010_a((Runnable)new Thread(() -> {
                        if (!iwData.hasFixedTime()) {
                            ((TimedInvasionWorldData)iwData).getInvasionSpawner().invasionTick(eventIn.getServer(), iwData.getWorld());
                        } else {
                            ((FixedInvasionWorldData)iwData).getInvasionSpawner().invasionTick(eventIn.getServer(), iwData.getWorld());
                        }
                    }, "Invasion Ticker: " + iwData.func_195925_e()));
                }
            } else {
                eventIn.getServer().func_82010_a((Runnable)new Thread(() -> {
                    for (InvasionWorldData iwData : InvasionWorldData.getInvasionData().values()) {
                        if (iwData.getWorld().func_217369_A().isEmpty()) continue;
                        if (!iwData.hasFixedTime()) {
                            ((TimedInvasionWorldData)iwData).getInvasionSpawner().invasionTick(eventIn.getServer(), iwData.getWorld());
                            continue;
                        }
                        ((FixedInvasionWorldData)iwData).getInvasionSpawner().invasionTick(eventIn.getServer(), iwData.getWorld());
                    }
                }, "Invasion Ticker"));
            }
        }

        public static void serverStarting(FMLServerStartingEvent eventIn) {
            PSConfigValues.resync(PSConfigValues.common);
            eventIn.getServer().func_212370_w().forEach(level -> InvasionWorldData.getInvasionData().put((ServerWorld)level, (InvasionWorldData)level.func_217481_x().func_215752_a(() -> level.func_230315_m_().func_241514_p_() ? new FixedInvasionWorldData((ServerWorld)level) : new TimedInvasionWorldData((ServerWorld)level), InvasionWorldData.getFileId(level.func_230315_m_()))));
        }

        public static void serverStopping(FMLServerStoppingEvent eventIn) {
            PSConfigValues.resync(PSConfigValues.common);
        }
    }

    public static final class PlayerEvents {
        public static void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent eventIn) {
            PlayerEvents.updatePlayer((PlayerEvent)eventIn);
        }

        public static void playerRespawn(PlayerEvent.PlayerRespawnEvent eventIn) {
            if (PSConfigValues.common.hyperAggression) {
                eventIn.getEntityLiving().func_195064_c(new EffectInstance((Effect)PSPotions.BLESSING.get(), PSConfigValues.common.blessingEffectRespawnDuration, 0));
            }
            PlayerEvents.updatePlayer((PlayerEvent)eventIn);
        }

        public static void playerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent eventIn) {
            if (PSConfigValues.common.hyperAggression) {
                eventIn.getEntityLiving().func_195064_c(new EffectInstance((Effect)PSPotions.BLESSING.get(), PSConfigValues.common.blessingEffectDimensionChangeDuration, 0));
            }
            PlayerEvents.updatePlayer((PlayerEvent)eventIn);
        }

        private static void updatePlayer(PlayerEvent eventIn) {
            if (eventIn.getPlayer() instanceof ServerPlayerEntity) {
                ServerPlayerEntity player = (ServerPlayerEntity)eventIn.getPlayer();
                InvasionWorldData iwData = InvasionWorldData.getInvasionData().get((ServerWorld)player.field_70170_p);
                if (iwData != null) {
                    if (!iwData.hasFixedTime()) {
                        TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                        tiwData.getInvasionSpawner().getDayInvasions().update(player);
                        tiwData.getInvasionSpawner().getNightInvasions().update(player);
                    } else {
                        FixedInvasionWorldData fiwData = (FixedInvasionWorldData)iwData;
                        fiwData.getInvasionSpawner().getInvasions().update(player);
                    }
                }
                ServerTimeUtil.updateTime(player);
            }
        }

        public static void playerSleepInBed(PlayerSleepInBedEvent eventIn) {
            block2: {
                TimedInvasionWorldData tiwData;
                ServerWorld world;
                block3: {
                    world = (ServerWorld)eventIn.getPlayer().field_70170_p;
                    InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(world);
                    if (iwData == null || iwData.hasFixedTime()) break block2;
                    tiwData = (TimedInvasionWorldData)iwData;
                    if (!ServerTimeUtil.isServerDay(world, tiwData) || tiwData.getInvasionSpawner().getDayInvasions().isEmpty()) break block3;
                    for (Invasion invasion : tiwData.getInvasionSpawner().getDayInvasions()) {
                        if (!PSConfigValues.common.forceInvasionSleeplessness && !invasion.getType().getSeverityInfo().get(invasion.getSeverity()).forcesNoSleep()) continue;
                        eventIn.setResult(PlayerEntity.SleepResult.NOT_POSSIBLE_NOW);
                        return;
                    }
                    break block2;
                }
                if (!ServerTimeUtil.isServerNight(world, tiwData) || tiwData.getInvasionSpawner().getNightInvasions().isEmpty()) break block2;
                for (Invasion invasion : tiwData.getInvasionSpawner().getNightInvasions()) {
                    if (!PSConfigValues.common.forceInvasionSleeplessness && !invasion.getType().getSeverityInfo().get(invasion.getSeverity()).forcesNoSleep()) continue;
                    eventIn.setResult(PlayerEntity.SleepResult.NOT_POSSIBLE_NOW);
                    return;
                }
            }
        }
    }

    public static final class LivingEvents {
        public static void livingConversion(LivingConversionEvent.Post eventIn) {
            if (eventIn.getOutcome().getClassification(false) == EntityClassification.MONSTER) {
                CompoundNBT persistentData = eventIn.getEntityLiving().getPersistentData();
                CompoundNBT outcomeData = eventIn.getOutcome().getPersistentData();
                if (persistentData.func_74764_b("InvasionMob")) {
                    outcomeData.func_74778_a("InvasionMob", persistentData.func_74779_i("InvasionMob"));
                }
                if (persistentData.func_74764_b("AntiGrief")) {
                    outcomeData.func_74778_a("AntiGrief", persistentData.func_74779_i("AntiGrief"));
                }
            }
        }

        public static void livingUpdate(LivingEvent.LivingUpdateEvent eventIn) {
            if (eventIn.getEntityLiving() instanceof MobEntity && eventIn.getEntityLiving().getPersistentData().func_74764_b("InvasionMob") && (eventIn.getEntityLiving().func_70643_av() == null || !eventIn.getEntityLiving().func_70643_av().func_70089_S()) && PSConfigValues.common.hyperAggression && !PSConfigValues.common.hyperAggressionBlacklist.contains(eventIn.getEntityLiving().func_200600_R().getRegistryName().toString())) {
                MobEntity mob = (MobEntity)eventIn.getEntityLiving();
                if (mob.func_70638_az() instanceof PlayerEntity) {
                    return;
                }
                PlayerEntity player = mob.field_70170_p.func_190525_a(mob.func_226277_ct_(), mob.func_226278_cu_(), mob.func_226281_cx_(), 144.0, PSEntityPredicates.HYPER_AGGRESSION);
                if (player != null && player.func_70089_S()) {
                    if (mob instanceof AbstractPiglinEntity) {
                        mob.func_213375_cj().func_233696_a_(MemoryModuleType.field_234078_L_, (Object)player.func_110124_au(), 12000L);
                    } else if (mob instanceof HoglinEntity) {
                        mob.func_213375_cj().func_218189_b(MemoryModuleType.field_223021_x);
                        mob.func_213375_cj().func_218189_b(MemoryModuleType.field_220953_n);
                        mob.func_213375_cj().func_233696_a_(MemoryModuleType.field_234103_o_, (Object)player, 12000L);
                    } else if (mob instanceof ZoglinEntity) {
                        mob.func_213375_cj().func_218189_b(MemoryModuleType.field_223021_x);
                        mob.func_213375_cj().func_233696_a_(MemoryModuleType.field_234103_o_, (Object)player, 12000L);
                    } else {
                        mob.func_70624_b((LivingEntity)player);
                    }
                }
            }
        }

        public static void experienceDrop(LivingExperienceDropEvent eventIn) {
            CompoundNBT persistentData = eventIn.getEntityLiving().getPersistentData();
            if (PSConfigValues.common.useXPMultiplier && persistentData.func_74764_b("InvasionMob")) {
                ServerWorld serverWorld = (ServerWorld)eventIn.getEntityLiving().field_70170_p;
                InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(serverWorld);
                if (iwData != null) {
                    if (!iwData.hasFixedTime()) {
                        TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                        if (ServerTimeUtil.isServerDay(serverWorld, tiwData)) {
                            tiwData.setDayXPMultiplier(tiwData.getDayXPMultiplier() + 1.0);
                            double log = Math.log1p(tiwData.getDayXPMultiplier()) / Math.E;
                            eventIn.setDroppedExperience((int)((double)eventIn.getOriginalExperience() * log));
                            PSPacketHandler.sendToAllClients(new UpdateXPMultPacket(log, InvasionListType.DAY));
                        } else if (ServerTimeUtil.isServerNight(serverWorld, tiwData)) {
                            tiwData.setNightXPMultiplier(tiwData.getNightXPMultiplier() + 1.0);
                            double log = Math.log1p(tiwData.getNightXPMultiplier()) / Math.E;
                            eventIn.setDroppedExperience((int)((double)eventIn.getOriginalExperience() * log));
                            PSPacketHandler.sendToAllClients(new UpdateXPMultPacket(log, InvasionListType.NIGHT));
                        }
                    } else {
                        FixedInvasionWorldData fiwData = (FixedInvasionWorldData)iwData;
                        fiwData.setXPMultiplier(fiwData.getXPMultiplier() + 1.0);
                        double log = Math.log1p(fiwData.getXPMultiplier()) / Math.E;
                        eventIn.setDroppedExperience((int)((double)eventIn.getOriginalExperience() * log));
                        PSPacketHandler.sendToAllClients(new UpdateXPMultPacket(log, InvasionListType.FIXED));
                    }
                }
            }
        }

        public static void checkSpawn(LivingSpawnEvent.CheckSpawn eventIn) {
            if (!eventIn.getWorld().func_201670_d() && eventIn.getSpawnReason().equals((Object)SpawnReason.NATURAL)) {
                ServerWorld serverWorld = (ServerWorld)eventIn.getWorld();
                InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(serverWorld);
                if (iwData != null) {
                    if (serverWorld.field_73012_v.nextInt(10000) < PSConfigValues.common.naturalSpawnChance) {
                        eventIn.setResult(Event.Result.DEFAULT);
                    } else if (!iwData.hasFixedTime()) {
                        TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                        if (ServerTimeUtil.isServerDay(serverWorld, tiwData) && !tiwData.getInvasionSpawner().getDayInvasions().isEmpty() || ServerTimeUtil.isServerNight(serverWorld, tiwData) && !tiwData.getInvasionSpawner().getNightInvasions().isEmpty()) {
                            eventIn.setResult(Event.Result.DENY);
                        }
                    } else {
                        FixedInvasionWorldData fiwData = (FixedInvasionWorldData)iwData;
                        if (!fiwData.getInvasionSpawner().getInvasions().isEmpty()) {
                            eventIn.setResult(Event.Result.DENY);
                        }
                    }
                }
            }
        }

        public static void specialSpawn(LivingSpawnEvent.SpecialSpawn eventIn) {
            if (!eventIn.getWorld().func_201670_d() && eventIn.getEntityLiving().getClassification(false) == EntityClassification.MONSTER && eventIn.getSpawnReason() == SpawnReason.NATURAL) {
                ServerWorld serverWorld = (ServerWorld)eventIn.getWorld();
                InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(serverWorld);
                if (iwData != null) {
                    if (!iwData.hasFixedTime()) {
                        TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                        CompoundNBT persistentData = eventIn.getEntityLiving().getPersistentData();
                        if (!tiwData.getInvasionSpawner().getDayInvasions().isEmpty() || !tiwData.getInvasionSpawner().getNightInvasions().isEmpty()) {
                            persistentData.func_74757_a("AntiGrief", false);
                        }
                    } else {
                        FixedInvasionWorldData fiwData = (FixedInvasionWorldData)iwData;
                        if (!fiwData.getInvasionSpawner().getInvasions().isEmpty()) {
                            eventIn.getEntityLiving().getPersistentData().func_74757_a("AntiGrief", true);
                        }
                    }
                }
            }
        }

        public static void allowDespawn(LivingSpawnEvent.AllowDespawn eventIn) {
            if (!eventIn.getWorld().func_201670_d() && PSConfigValues.common.shouldMobsDieAtEndOfInvasions && eventIn.getEntityLiving() instanceof MobEntity) {
                ServerWorld serverWorld = (ServerWorld)eventIn.getWorld();
                InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(serverWorld);
                MobEntity mobEntity = (MobEntity)eventIn.getEntityLiving();
                CompoundNBT persistentData = mobEntity.getPersistentData();
                if (iwData != null && persistentData.func_74764_b("InvasionMob")) {
                    if (!iwData.hasFixedTime()) {
                        TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                        if (ServerTimeUtil.isServerDay(serverWorld, tiwData)) {
                            for (Invasion invasion : tiwData.getInvasionSpawner().getDayInvasions()) {
                                if (!persistentData.func_74779_i("InvasionMob").equals(invasion.getType().getId().toString())) continue;
                                return;
                            }
                            eventIn.setResult(Event.Result.ALLOW);
                        } else if (ServerTimeUtil.isServerNight(serverWorld, tiwData)) {
                            for (Invasion invasion : tiwData.getInvasionSpawner().getNightInvasions()) {
                                if (!persistentData.func_74779_i("InvasionMob").equals(invasion.getType().getId().toString())) continue;
                                return;
                            }
                            eventIn.setResult(Event.Result.ALLOW);
                        }
                    } else {
                        FixedInvasionWorldData fiwData = (FixedInvasionWorldData)iwData;
                        for (Invasion invasion : fiwData.getInvasionSpawner().getInvasions()) {
                            if (!persistentData.func_74779_i("InvasionMob").equals(invasion.getType().getId().toString())) continue;
                            return;
                        }
                        eventIn.setResult(Event.Result.ALLOW);
                    }
                }
            }
        }
    }

    public static final class EntityEvents {
        public static void joinWorld(EntityJoinWorldEvent eventIn) {
            VexEntity vexEntity;
            if (eventIn.getEntity() instanceof TameableEntity) {
                TameableEntity tameableEntity = (TameableEntity)eventIn.getEntity();
                if (tameableEntity.func_70902_q() != null && tameableEntity.func_70902_q().getPersistentData().func_74764_b("AntiGrief")) {
                    tameableEntity.getPersistentData().func_74757_a("AntiGrief", tameableEntity.func_70902_q().getPersistentData().func_74767_n("AntiGrief"));
                }
            } else if (PSConfigValues.common.weakenedVexes && eventIn.getEntity() instanceof VexEntity && (vexEntity = (VexEntity)eventIn.getEntity()).func_190645_o() != null && vexEntity.func_190645_o().getPersistentData().func_74764_b("InvasionMob")) {
                vexEntity.func_190653_a(25 + eventIn.getWorld().func_201674_k().nextInt(65));
            }
        }

        public static void mobGriefing(EntityMobGriefingEvent eventIn) {
            if (!PSConfigValues.common.explosionsDestroyBlocks && eventIn.getEntity() != null && eventIn.getEntity().getPersistentData().func_74764_b("AntiGrief")) {
                eventIn.setResult(Event.Result.DENY);
            }
        }
    }

    public static final class BaseEvents {
        private static InvasionTypeManager invasionTypeManager = new InvasionTypeManager();

        public static void addReloadListeners(AddReloadListenerEvent eventIn) {
            eventIn.addListener((IFutureReloadListener)invasionTypeManager);
        }

        public static InvasionTypeManager getInvasionTypeManager() {
            return invasionTypeManager;
        }

        public static void registerCommands(RegisterCommandsEvent eventIn) {
            PSCommands.build((CommandDispatcher<CommandSource>)eventIn.getDispatcher());
        }

        public static void worldTick(TickEvent.WorldTickEvent eventIn) {
            block8: {
                boolean flag;
                InvasionWorldData iwData;
                ServerWorld world;
                block9: {
                    TimedInvasionWorldData tiwData;
                    block11: {
                        block10: {
                            if (!eventIn.side.isServer() || eventIn.phase != TickEvent.Phase.END) break block8;
                            world = (ServerWorld)eventIn.world;
                            iwData = InvasionWorldData.getInvasionData().get(world);
                            if (iwData == null || !PSGameRulesRegistry.getEnableInvasions((World)world)) break block8;
                            if (iwData.hasFixedTime()) break block9;
                            tiwData = (TimedInvasionWorldData)iwData;
                            if (!ServerTimeUtil.isServerDay(world, tiwData) || tiwData.hasCheckedNight()) break block10;
                            tiwData.setDays(world.func_72820_D() / 24000L);
                            int amount = MathHelper.func_76125_a((int)((int)(world.func_72820_D() / (24000L * (long)PSConfigValues.common.nightDifficultyIncreaseDelay)) + 1), (int)0, (int)PSConfigValues.common.maxNightInvasions);
                            int chance = world.field_73012_v.nextInt((int)((double)PSConfigValues.common.nightDifficultyIncreaseDelay * PSConfigValues.common.nightCancelChanceMultiplier) + 1);
                            boolean cancelFlag = chance == 0 && amount > 1 && tiwData.getInvasionSpawner().getQueuedNightInvasions().isEmpty() && PSConfigValues.common.canNightInvasionsBeCanceled;
                            LOGGER.info("Day: " + iwData.getDays() + ", Possible Invasions: " + amount);
                            tiwData.getInvasionSpawner().setNightInvasions(world, cancelFlag, amount, tiwData.getDays());
                            PSPacketHandler.sendToAllClients(new UpdateXPMultPacket(0.0, InvasionListType.DAY));
                            tiwData.setDayXPMultiplier(0.0);
                            tiwData.setCheckedDay(false);
                            tiwData.setCheckedNight(true);
                            if (tiwData.getInvasionSpawner().getDayInvasions().isEmpty() && !tiwData.getInvasionSpawner().getDayInvasions().isCanceled()) break block8;
                            for (ServerPlayerEntity player : world.func_217369_A()) {
                                if (tiwData.getInvasionSpawner().getDayInvasions().isCanceled()) {
                                    player.func_145747_a((ITextComponent)new TranslationTextComponent("invasion.puresuffering.day.cancel").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), player.func_110124_au());
                                    continue;
                                }
                                player.func_145747_a((ITextComponent)new TranslationTextComponent("invasion.puresuffering.message1").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.RED)), player.func_110124_au());
                                player.func_145747_a((ITextComponent)new InvasionListTextComponent("invasion.puresuffering.message2", tiwData.getInvasionSpawner().getDayInvasions()).func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.DARK_RED)), player.func_110124_au());
                            }
                            break block8;
                        }
                        if (!ServerTimeUtil.isServerNight(world, tiwData) || tiwData.hasCheckedDay()) break block11;
                        tiwData.setDays(world.func_72820_D() / 24000L);
                        int amount = MathHelper.func_76125_a((int)((int)(world.func_72820_D() / (24000L * (long)PSConfigValues.common.dayDifficultyIncreaseDelay)) + 1), (int)0, (int)PSConfigValues.common.maxDayInvasions);
                        int chance = world.field_73012_v.nextInt((int)((double)PSConfigValues.common.dayDifficultyIncreaseDelay * PSConfigValues.common.dayCancelChanceMultiplier) + 1);
                        boolean cancelFlag = chance == 0 && amount > 1 && tiwData.getInvasionSpawner().getQueuedDayInvasions().isEmpty() && PSConfigValues.common.canDayInvasionsBeCanceled;
                        LOGGER.info("Night: " + iwData.getDays() + ", Possible Invasions: " + amount);
                        tiwData.getInvasionSpawner().setDayInvasions(world, cancelFlag, amount, tiwData.getDays());
                        PSPacketHandler.sendToAllClients(new UpdateXPMultPacket(0.0, InvasionListType.NIGHT));
                        tiwData.setNightXPMultiplier(0.0);
                        tiwData.setCheckedDay(true);
                        tiwData.setCheckedNight(false);
                        if (tiwData.getInvasionSpawner().getNightInvasions().isEmpty() && !tiwData.getInvasionSpawner().getNightInvasions().isCanceled()) break block8;
                        for (ServerPlayerEntity player : world.func_217369_A()) {
                            if (tiwData.getInvasionSpawner().getNightInvasions().isCanceled()) {
                                player.func_145747_a((ITextComponent)new TranslationTextComponent("invasion.puresuffering.night.cancel").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), player.func_110124_au());
                                continue;
                            }
                            player.func_145747_a((ITextComponent)new TranslationTextComponent("invasion.puresuffering.message1").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.RED)), player.func_110124_au());
                            player.func_145747_a((ITextComponent)new InvasionListTextComponent("invasion.puresuffering.message2", tiwData.getInvasionSpawner().getNightInvasions()).func_240699_a_(TextFormatting.DARK_RED), player.func_110124_au());
                        }
                        break block8;
                    }
                    tiwData.setCheckedDay(ServerTimeUtil.isServerNight(world, tiwData));
                    tiwData.setCheckedNight(ServerTimeUtil.isServerDay(world, tiwData));
                    break block8;
                }
                FixedInvasionWorldData fiwData = (FixedInvasionWorldData)iwData;
                boolean bl = flag = world.func_72820_D() % 24000L < 12000L;
                if (fiwData.isFirstCycle() ? flag : !flag) {
                    fiwData.setDays(world.func_72820_D() / 24000L);
                    int amount = MathHelper.func_76125_a((int)((int)(world.func_72820_D() / (24000L * (long)PSConfigValues.common.fixedDifficultyIncreaseDelay)) + 1), (int)0, (int)PSConfigValues.common.maxFixedInvasions);
                    int chance = world.field_73012_v.nextInt((int)((double)PSConfigValues.common.fixedDifficultyIncreaseDelay * PSConfigValues.common.fixedCancelChanceMultiplier) + 1);
                    boolean cancelFlag = chance == 0 && amount > 1 && fiwData.getInvasionSpawner().getQueuedInvasions().isEmpty() && PSConfigValues.common.canFixedInvasionsBeCanceled;
                    LOGGER.info("Cycle: " + iwData.getDays() + ", Possible Invasions: " + amount);
                    fiwData.getInvasionSpawner().setInvasions(world, cancelFlag, amount, fiwData.getDays());
                    fiwData.setFirstCycle(!fiwData.isFirstCycle());
                    PSPacketHandler.sendToAllClients(new UpdateXPMultPacket(0.0, InvasionListType.FIXED));
                    fiwData.setXPMultiplier(0.0);
                    if (!fiwData.getInvasionSpawner().getInvasions().isEmpty() || fiwData.getInvasionSpawner().getInvasions().isCanceled()) {
                        for (ServerPlayerEntity player : world.func_217369_A()) {
                            if (fiwData.getInvasionSpawner().getInvasions().isCanceled()) {
                                player.func_145747_a((ITextComponent)new TranslationTextComponent("invasion.puresuffering.fixed.cancel").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), player.func_110124_au());
                                continue;
                            }
                            player.func_145747_a((ITextComponent)new TranslationTextComponent("invasion.puresuffering.message1").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.RED)), player.func_110124_au());
                            player.func_145747_a((ITextComponent)new InvasionListTextComponent("invasion.puresuffering.message2", fiwData.getInvasionSpawner().getInvasions()).func_240699_a_(TextFormatting.DARK_RED), player.func_110124_au());
                        }
                    }
                }
            }
        }
    }

    public static final class ClientEvents {
        public static void loggedIn(ClientPlayerNetworkEvent.LoggedInEvent eventIn) {
            PSConfigValues.resync(PSConfigValues.client);
        }

        public static void loggedOut(ClientPlayerNetworkEvent.LoggedOutEvent eventIn) {
            Minecraft mc = Minecraft.func_71410_x();
            ClientInvasionWorldInfo.getDayClientInfo(mc.field_71441_e).getRendererMap().clear();
            ClientInvasionWorldInfo.getNightClientInfo(mc.field_71441_e).getRendererMap().clear();
            ClientInvasionWorldInfo.getFixedClientInfo(mc.field_71441_e).getRendererMap().clear();
            PSConfigValues.resync(PSConfigValues.client);
        }

        public static void fogColors(EntityViewRenderEvent.FogColors eventIn) {
            Minecraft mc = Minecraft.func_71410_x();
            if (!mc.field_71441_e.func_230315_m_().func_241514_p_()) {
                float red = 0.0f;
                float green = 0.0f;
                float blue = 0.0f;
                ClientInvasionWorldInfo dayInfo = ClientInvasionWorldInfo.getDayClientInfo(mc.field_71441_e);
                ClientInvasionWorldInfo nightInfo = ClientInvasionWorldInfo.getNightClientInfo(mc.field_71441_e);
                if (dayInfo.isClientTime() && !dayInfo.getRendererMap().isEmpty()) {
                    ArrayList<InvasionSkyRenderer> rendererList = dayInfo.getRendererMap().getRenderersOf(renderer -> renderer.getFogRenderer().isFogColorChanged());
                    for (InvasionSkyRenderer renderer2 : rendererList) {
                        InvasionFogRenderer fogRenderer = renderer2.getFogRenderer();
                        red += fogRenderer.getRedOffset() / (float)rendererList.size();
                        green += fogRenderer.getGreenOffset() / (float)rendererList.size();
                        blue += fogRenderer.getBlueOffset() / (float)rendererList.size();
                    }
                } else if (nightInfo.isClientTime() && !nightInfo.getRendererMap().isEmpty()) {
                    ArrayList<InvasionSkyRenderer> rendererList = nightInfo.getRendererMap().getRenderersOf(renderer -> renderer.getFogRenderer().isFogColorChanged());
                    for (InvasionSkyRenderer renderer3 : rendererList) {
                        InvasionFogRenderer fogRenderer = renderer3.getFogRenderer();
                        red += fogRenderer.getRedOffset() / (float)rendererList.size();
                        green += fogRenderer.getGreenOffset() / (float)rendererList.size();
                        blue += fogRenderer.getBlueOffset() / (float)rendererList.size();
                    }
                }
                ClientTransitionHandler.tickFogColor(eventIn, red, green, blue, mc.field_71441_e.func_72820_D() % 12000L);
            } else {
                float red = 0.0f;
                float green = 0.0f;
                float blue = 0.0f;
                InvasionRendererMap fixedRenderers = ClientInvasionWorldInfo.getFixedClientInfo(mc.field_71441_e).getRendererMap();
                if (!fixedRenderers.isEmpty()) {
                    ArrayList<InvasionSkyRenderer> rendererList = fixedRenderers.getRenderersOf(renderer -> renderer.getFogRenderer().isFogColorChanged());
                    for (InvasionSkyRenderer renderer4 : rendererList) {
                        InvasionFogRenderer fogRenderer = renderer4.getFogRenderer();
                        red += fogRenderer.getRedOffset() / (float)rendererList.size();
                        green += fogRenderer.getGreenOffset() / (float)rendererList.size();
                        blue += fogRenderer.getBlueOffset() / (float)rendererList.size();
                    }
                }
                ClientTransitionHandler.tickFogColor(eventIn, red, green, blue, mc.field_71441_e.func_72820_D() % 12000L);
            }
        }

        public static void renderGameOverlayText(RenderGameOverlayEvent.Text eventIn) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71474_y.field_74330_P) {
                eventIn.getLeft().add("");
                if (!mc.field_71441_e.func_230315_m_().func_241514_p_()) {
                    ClientInvasionWorldInfo dayInfo = ClientInvasionWorldInfo.getDayClientInfo(mc.field_71441_e);
                    ClientInvasionWorldInfo nightInfo = ClientInvasionWorldInfo.getNightClientInfo(mc.field_71441_e);
                    if (dayInfo.isClientTime()) {
                        eventIn.getLeft().add(TextFormatting.RED + "[PureSuffering]" + TextFormatting.RESET + " Current Day Invasions: " + dayInfo.getInvasionsCount());
                        eventIn.getLeft().add(TextFormatting.RED + "[PureSuffering]" + TextFormatting.RESET + " Day Invasion XP Multiplier: " + (PSConfigValues.common.useXPMultiplier ? dayInfo.getXPMultiplier() + "x" : "Disabled"));
                        eventIn.getLeft().add(TextFormatting.RED + "[PureSuffering]" + TextFormatting.RESET + " Night Invasion XP Multiplier: " + (PSConfigValues.common.useXPMultiplier ? nightInfo.getXPMultiplier() + "x" : "Disabled"));
                        return;
                    }
                    if (nightInfo.isClientTime()) {
                        eventIn.getLeft().add(TextFormatting.RED + "[PureSuffering]" + TextFormatting.RESET + " Current Night Invasions: " + nightInfo.getInvasionsCount());
                        eventIn.getLeft().add(TextFormatting.RED + "[PureSuffering]" + TextFormatting.RESET + " Night Invasion XP Multiplier: " + (PSConfigValues.common.useXPMultiplier ? nightInfo.getXPMultiplier() + "x" : "Disabled"));
                        eventIn.getLeft().add(TextFormatting.RED + "[PureSuffering]" + TextFormatting.RESET + " Day Invasion XP Multiplier: " + (PSConfigValues.common.useXPMultiplier ? dayInfo.getXPMultiplier() + "x" : "Disabled"));
                        return;
                    }
                } else {
                    ClientInvasionWorldInfo fixedInfo = ClientInvasionWorldInfo.getFixedClientInfo(mc.field_71441_e);
                    eventIn.getLeft().add(TextFormatting.RED + "[PureSuffering]" + TextFormatting.RESET + " Current Invasions: " + fixedInfo.getInvasionsCount());
                    eventIn.getLeft().add(TextFormatting.RED + "[PureSuffering]" + TextFormatting.RESET + " Invasion XP Multiplier: " + (PSConfigValues.common.useXPMultiplier ? fixedInfo.getXPMultiplier() + "x" : "Disabled"));
                }
            }
        }

        public static void renderWorldLast(RenderWorldLastEvent eventIn) {
            ISkyRenderHandler skyRenderHandler;
            Minecraft mc = Minecraft.func_71410_x();
            ClientWorld clientWorld = mc.field_71441_e;
            if (clientWorld != null && PSConfigValues.client.useSkyBoxRenderer && !((skyRenderHandler = clientWorld.func_239132_a_().getSkyRenderHandler()) instanceof InvasionSkyRenderHandler)) {
                clientWorld.func_239132_a_().setSkyRenderHandler((ISkyRenderHandler)new InvasionSkyRenderHandler(skyRenderHandler));
            }
        }
    }
}

