/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.theagameplayer.puresuffering.client.ClientTransitionHandler;
import dev.theagameplayer.puresuffering.client.renderer.InvasionSkyRenderer;
import dev.theagameplayer.puresuffering.world.ClientInvasionWorldInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.client.world.DimensionRenderInfo;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.ISkyRenderHandler;

public final class InvasionSkyRenderHandler
implements ISkyRenderHandler {
    private static final ResourceLocation DEFAULT_SUN = new ResourceLocation("textures/environment/sun.png");
    private static final ResourceLocation DEFAULT_MOON = new ResourceLocation("textures/environment/moon_phases.png");
    private static final ResourceLocation DEFAULT_END_SKY = new ResourceLocation("textures/environment/end_sky.png");
    private final HashMap<InvasionSkyRenderer, Boolean> rendererMap = new HashMap();
    private final ArrayList<InvasionSkyRenderer> weatherVisibilityList = new ArrayList();
    private final ArrayList<InvasionSkyRenderer> skyColorList = new ArrayList();
    private ResourceLocation sunTexture;
    private ResourceLocation moonTexture;
    private ResourceLocation skyTexture;
    private final ISkyRenderHandler skyRenderer;

    public InvasionSkyRenderHandler(ISkyRenderHandler skyRendererIn) {
        this.skyRenderer = skyRendererIn;
    }

    public void render(int ticksIn, float partialTicksIn, MatrixStack matrixStackIn, ClientWorld worldIn, Minecraft mcIn) {
        ClientInvasionWorldInfo nightInfo;
        Object dayInfo;
        this.rendererMap.clear();
        if (!worldIn.func_217369_A().isEmpty()) {
            if (!worldIn.func_230315_m_().func_241514_p_()) {
                dayInfo = ClientInvasionWorldInfo.getDayClientInfo(mcIn.field_71441_e);
                nightInfo = ClientInvasionWorldInfo.getNightClientInfo(mcIn.field_71441_e);
                if (((ClientInvasionWorldInfo)dayInfo).isClientTime() && !((ClientInvasionWorldInfo)dayInfo).getRendererMap().isEmpty()) {
                    for (Map.Entry<InvasionSkyRenderer, Boolean> entry : ((ClientInvasionWorldInfo)dayInfo).getRendererMap()) {
                        this.rendererMap.put(entry.getKey(), entry.getValue());
                    }
                } else if (nightInfo.isClientTime() && !nightInfo.getRendererMap().isEmpty()) {
                    for (Map.Entry<InvasionSkyRenderer, Boolean> entry : nightInfo.getRendererMap()) {
                        this.rendererMap.put(entry.getKey(), entry.getValue());
                    }
                }
            } else {
                for (Map.Entry entry : ClientInvasionWorldInfo.getFixedClientInfo(mcIn.field_71441_e).getRendererMap()) {
                    this.rendererMap.put((InvasionSkyRenderer)entry.getKey(), (Boolean)entry.getValue());
                }
            }
        }
        if (!this.rendererMap.isEmpty()) {
            dayInfo = ClientInvasionWorldInfo.getDayClientInfo(mcIn.field_71441_e);
            nightInfo = ClientInvasionWorldInfo.getNightClientInfo(mcIn.field_71441_e);
            if (worldIn.func_239132_a_().func_241683_c_() == DimensionRenderInfo.FogType.NORMAL) {
                this.weatherVisibilityList.clear();
                this.skyColorList.clear();
                this.sunTexture = null;
                this.moonTexture = null;
                for (Map.Entry<InvasionSkyRenderer, Boolean> entry : this.rendererMap.entrySet()) {
                    InvasionSkyRenderer renderer = entry.getKey();
                    if (renderer.getSunTexture() != null && entry.getValue().booleanValue() && ((ClientInvasionWorldInfo)dayInfo).isClientTime()) {
                        this.sunTexture = renderer.getSunTexture();
                    }
                    if (renderer.getMoonTexture() != null && entry.getValue().booleanValue() && nightInfo.isClientTime()) {
                        this.moonTexture = renderer.getMoonTexture();
                    }
                    if (renderer.isWeatherVisibilityChanged()) {
                        this.weatherVisibilityList.add(renderer);
                    }
                    if (!renderer.isSkyColorChanged()) continue;
                    this.skyColorList.add(renderer);
                }
                this.renderInvasionSky(matrixStackIn, mcIn, worldIn, partialTicksIn, worldIn.func_72820_D() % 12000L);
                return;
            }
            if (worldIn.func_239132_a_().func_241683_c_() == DimensionRenderInfo.FogType.END) {
                this.skyTexture = null;
                for (Map.Entry<InvasionSkyRenderer, Boolean> entry : this.rendererMap.entrySet()) {
                    InvasionSkyRenderer renderer = entry.getKey();
                    if (renderer.getFixedSkyTexture() == null || !entry.getValue().booleanValue()) continue;
                    this.skyTexture = renderer.getFixedSkyTexture();
                }
                this.renderEndInvasionSkybox(matrixStackIn, mcIn, worldIn, partialTicksIn, ticksIn);
            }
        }
        ISkyRenderHandler renderer = worldIn.func_239132_a_().getSkyRenderHandler();
        worldIn.func_239132_a_().setSkyRenderHandler(null);
        if (this.skyRenderer == null) {
            mcIn.field_71438_f.func_228424_a_(matrixStackIn, partialTicksIn);
        } else {
            this.skyRenderer.render(ticksIn, partialTicksIn, matrixStackIn, worldIn, mcIn);
        }
        worldIn.func_239132_a_().setSkyRenderHandler(renderer);
    }

    private void renderInvasionSky(MatrixStack matrixStackIn, Minecraft mcIn, ClientWorld worldIn, float partialTicksIn, long dayTimeIn) {
        ClientInvasionWorldInfo dayInfo = ClientInvasionWorldInfo.getDayClientInfo(worldIn);
        ClientInvasionWorldInfo nightInfo = ClientInvasionWorldInfo.getNightClientInfo(worldIn);
        Vector3d vector3d = worldIn.func_228318_a_(mcIn.field_71460_t.func_215316_n().func_216780_d(), partialTicksIn);
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        for (InvasionSkyRenderer renderer : this.skyColorList) {
            r += renderer.getRedOffset() / (float)this.skyColorList.size();
            g += renderer.getGreenOffset() / (float)this.skyColorList.size();
            b += renderer.getBlueOffset() / (float)this.skyColorList.size();
        }
        float f = ClientTransitionHandler.tickSkyColor((float)vector3d.field_72450_a, r, dayTimeIn);
        float f1 = ClientTransitionHandler.tickSkyColor((float)vector3d.field_72448_b, g, dayTimeIn);
        float f2 = ClientTransitionHandler.tickSkyColor((float)vector3d.field_72449_c, b, dayTimeIn);
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        RenderSystem.disableTexture();
        FogRenderer.func_228373_b_();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableFog();
        RenderSystem.color3f((float)f, (float)f1, (float)f2);
        mcIn.field_71438_f.field_175012_t.func_177359_a();
        mcIn.field_71438_f.field_175014_r.func_227892_a_(0L);
        mcIn.field_71438_f.field_175012_t.func_227874_a_(matrixStackIn.func_227866_c_().func_227870_a_(), 7);
        VertexBuffer.func_177361_b();
        mcIn.field_71438_f.field_175014_r.func_227895_d_();
        RenderSystem.disableFog();
        RenderSystem.disableAlphaTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        float[] afloat = worldIn.func_239132_a_().func_230492_a_(worldIn.func_242415_f(partialTicksIn), partialTicksIn);
        if (afloat != null) {
            RenderSystem.disableTexture();
            RenderSystem.shadeModel((int)7425);
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
            float f3 = MathHelper.func_76126_a((float)worldIn.func_72929_e(partialTicksIn)) < 0.0f ? 180.0f : 0.0f;
            matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(f3));
            matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
            float f4 = afloat[0];
            float f5 = afloat[1];
            float f6 = afloat[2];
            Matrix4f matrix4f = matrixStackIn.func_227866_c_().func_227870_a_();
            bufferbuilder.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            bufferbuilder.func_227888_a_(matrix4f, 0.0f, 100.0f, 0.0f).func_227885_a_(f4, f5, f6, afloat[3] / (float)this.rendererMap.size()).func_181675_d();
            for (int j = 0; j <= 16; ++j) {
                float f7 = (float)j * ((float)Math.PI * 2) / 16.0f;
                float f8 = MathHelper.func_76126_a((float)f7);
                float f9 = MathHelper.func_76134_b((float)f7);
                bufferbuilder.func_227888_a_(matrix4f, f8 * 120.0f, f9 * 120.0f, -f9 * 40.0f * afloat[3]).func_227885_a_(afloat[0], afloat[1], afloat[2], 0.0f).func_181675_d();
            }
            bufferbuilder.func_178977_d();
            WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
            matrixStackIn.func_227865_b_();
            RenderSystem.shadeModel((int)7424);
        }
        RenderSystem.enableTexture();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        matrixStackIn.func_227860_a_();
        float f11 = MathHelper.func_76131_a((float)((this.sunTexture == null && dayInfo.isClientTime() || this.moonTexture == null && nightInfo.isClientTime() ? 1.0f : ClientTransitionHandler.tickSunMoonAlpha(1.0f, dayTimeIn)) - worldIn.func_72867_j(partialTicksIn)), (float)0.0f, (float)1.0f);
        float f12 = 0.0f;
        for (InvasionSkyRenderer renderer : this.weatherVisibilityList) {
            f12 += renderer.getWeatherVisibility() / (float)this.weatherVisibilityList.size();
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(f11 + MathHelper.func_76131_a((float)ClientTransitionHandler.tickWeatherVisibility(f12, dayTimeIn), (float)0.0f, (float)1.0f)));
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
        matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(worldIn.func_242415_f(partialTicksIn) * 360.0f));
        Matrix4f matrix4f1 = matrixStackIn.func_227866_c_().func_227870_a_();
        this.renderSun(mcIn, bufferbuilder, matrix4f1, 30.0f, dayTimeIn);
        this.renderMoon(mcIn, bufferbuilder, matrix4f1, worldIn, 20.0f, dayTimeIn);
        RenderSystem.disableTexture();
        float f10 = worldIn.func_228330_j_(partialTicksIn) * f11;
        if (f10 > 0.0f) {
            RenderSystem.color4f((float)f10, (float)f10, (float)f10, (float)(f10 / (float)this.rendererMap.size()));
            mcIn.field_71438_f.field_175013_s.func_177359_a();
            mcIn.field_71438_f.field_175014_r.func_227892_a_(0L);
            mcIn.field_71438_f.field_175013_s.func_227874_a_(matrixStackIn.func_227866_c_().func_227870_a_(), 7);
            VertexBuffer.func_177361_b();
            mcIn.field_71438_f.field_175014_r.func_227895_d_();
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableFog();
        matrixStackIn.func_227865_b_();
        RenderSystem.disableTexture();
        RenderSystem.color3f((float)0.0f, (float)0.0f, (float)0.0f);
        double d0 = mcIn.field_71439_g.func_174824_e((float)partialTicksIn).field_72448_b - worldIn.func_72912_H().func_239159_f_();
        if (d0 < 0.0) {
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(0.0, 12.0, 0.0);
            mcIn.field_71438_f.field_175011_u.func_177359_a();
            mcIn.field_71438_f.field_175014_r.func_227892_a_(0L);
            mcIn.field_71438_f.field_175011_u.func_227874_a_(matrixStackIn.func_227866_c_().func_227870_a_(), 7);
            VertexBuffer.func_177361_b();
            mcIn.field_71438_f.field_175014_r.func_227895_d_();
            matrixStackIn.func_227865_b_();
        }
        if (worldIn.func_239132_a_().func_239216_b_()) {
            RenderSystem.color3f((float)(f * 0.2f + 0.04f), (float)(f1 * 0.2f + 0.04f), (float)(f2 * 0.6f + 0.1f));
        } else {
            RenderSystem.color3f((float)f, (float)f1, (float)f2);
        }
        RenderSystem.enableTexture();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableFog();
    }

    private void renderSun(Minecraft mcIn, BufferBuilder bufferBuilderIn, Matrix4f matrix4fIn, float f13In, long dayTimeIn) {
        boolean flag = dayTimeIn < 300L || dayTimeIn > 11699L;
        mcIn.field_71446_o.func_110577_a(this.sunTexture == null || flag ? DEFAULT_SUN : this.sunTexture);
        bufferBuilderIn.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferBuilderIn.func_227888_a_(matrix4fIn, -f13In, 100.0f, -f13In).func_225583_a_(0.0f, 0.0f).func_181675_d();
        bufferBuilderIn.func_227888_a_(matrix4fIn, f13In, 100.0f, -f13In).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferBuilderIn.func_227888_a_(matrix4fIn, f13In, 100.0f, f13In).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferBuilderIn.func_227888_a_(matrix4fIn, -f13In, 100.0f, f13In).func_225583_a_(0.0f, 1.0f).func_181675_d();
        bufferBuilderIn.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferBuilderIn);
    }

    private void renderMoon(Minecraft mcIn, BufferBuilder bufferBuilderIn, Matrix4f matrix4fIn, ClientWorld worldIn, float f13In, long dayTimeIn) {
        boolean flag = dayTimeIn < 300L || dayTimeIn > 11699L;
        mcIn.field_71446_o.func_110577_a(this.moonTexture == null || flag ? DEFAULT_MOON : this.moonTexture);
        int k = worldIn.func_242414_af();
        int l = k % 4;
        int i1 = k / 4 % 2;
        float f14 = (float)(l + 0) / 4.0f;
        float f15 = (float)(i1 + 0) / 2.0f;
        float f16 = (float)(l + 1) / 4.0f;
        float f17 = (float)(i1 + 1) / 2.0f;
        bufferBuilderIn.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferBuilderIn.func_227888_a_(matrix4fIn, -f13In, -100.0f, f13In).func_225583_a_(f16, f17).func_181675_d();
        bufferBuilderIn.func_227888_a_(matrix4fIn, f13In, -100.0f, f13In).func_225583_a_(f14, f17).func_181675_d();
        bufferBuilderIn.func_227888_a_(matrix4fIn, f13In, -100.0f, -f13In).func_225583_a_(f14, f15).func_181675_d();
        bufferBuilderIn.func_227888_a_(matrix4fIn, -f13In, -100.0f, -f13In).func_225583_a_(f16, f15).func_181675_d();
        bufferBuilderIn.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferBuilderIn);
    }

    private void renderEndInvasionSkybox(MatrixStack matrixStackIn, Minecraft mcIn, ClientWorld worldIn, float partialTicksIn, long dayTimeIn) {
        RenderSystem.disableAlphaTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.depthMask((boolean)false);
        mcIn.field_71446_o.func_110577_a(this.skyTexture == null ? DEFAULT_END_SKY : this.skyTexture);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        for (int i = 0; i < 6; ++i) {
            matrixStackIn.func_227860_a_();
            if (i == 1) {
                matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
            } else if (i == 2) {
                matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f));
            } else if (i == 3) {
                matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
            } else if (i == 4) {
                matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
            } else if (i == 5) {
                matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-90.0f));
            }
            Matrix4f matrix4f = matrixStackIn.func_227866_c_().func_227870_a_();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            bufferbuilder.func_227888_a_(matrix4f, -100.0f, -100.0f, -100.0f).func_225583_a_(0.0f, 0.0f).func_225586_a_(40, 40, 40, 255).func_181675_d();
            bufferbuilder.func_227888_a_(matrix4f, -100.0f, -100.0f, 100.0f).func_225583_a_(0.0f, 16.0f).func_225586_a_(40, 40, 40, 255).func_181675_d();
            bufferbuilder.func_227888_a_(matrix4f, 100.0f, -100.0f, 100.0f).func_225583_a_(16.0f, 16.0f).func_225586_a_(40, 40, 40, 255).func_181675_d();
            bufferbuilder.func_227888_a_(matrix4f, 100.0f, -100.0f, -100.0f).func_225583_a_(16.0f, 0.0f).func_225586_a_(40, 40, 40, 255).func_181675_d();
            tessellator.func_78381_a();
            matrixStackIn.func_227865_b_();
        }
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
    }
}

