/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.theagameplayer.puresuffering.PSEventManager;
import dev.theagameplayer.puresuffering.invasion.Invasion;
import dev.theagameplayer.puresuffering.invasion.InvasionType;
import dev.theagameplayer.puresuffering.world.FixedInvasionWorldData;
import dev.theagameplayer.puresuffering.world.InvasionWorldData;
import dev.theagameplayer.puresuffering.world.TimedInvasionWorldData;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.ResourceLocationArgument;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public final class AddInvasionsCommand {
    private static final DynamicCommandExceptionType ERROR_UNKNOWN_INVASION_TYPE = new DynamicCommandExceptionType(resourceLocation -> new TranslationTextComponent("commands.puresuffering.invasion_type.invasionTypeNotFound", new Object[]{resourceLocation}));
    private static final SuggestionProvider<CommandSource> SUGGEST_PRIMARY_DAY_INVASION_TYPES = (ctx, suggestionsBuilder) -> {
        Collection<InvasionType> collection = PSEventManager.BaseEvents.getInvasionTypeManager().getAllInvasionTypes();
        InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSource)ctx.getSource()).func_197023_e());
        return ISuggestionProvider.func_212476_a(collection.stream().filter(it -> !iwData.hasFixedTime() && it.getDimensions().contains(((CommandSource)ctx.getSource()).func_197023_e().func_234923_W_().func_240901_a_()) && it.getInvasionPriority() != InvasionType.InvasionPriority.SECONDARY_ONLY && it.getInvasionTime() != InvasionType.InvasionTime.NIGHT && it.getTimeChangeability() != InvasionType.TimeChangeability.ONLY_NIGHT).map(InvasionType::getId), (SuggestionsBuilder)suggestionsBuilder);
    };
    private static final SuggestionProvider<CommandSource> SUGGEST_SECONDARY_DAY_INVASION_TYPES = (ctx, suggestionsBuilder) -> {
        Collection<InvasionType> collection = PSEventManager.BaseEvents.getInvasionTypeManager().getAllInvasionTypes();
        InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSource)ctx.getSource()).func_197023_e());
        return ISuggestionProvider.func_212476_a(collection.stream().filter(it -> !iwData.hasFixedTime() && it.getDimensions().contains(((CommandSource)ctx.getSource()).func_197023_e().func_234923_W_().func_240901_a_()) && it.getInvasionPriority() != InvasionType.InvasionPriority.PRIMARY_ONLY && (AddInvasionsCommand.containsDayChangingInvasion(((TimedInvasionWorldData)iwData).getInvasionSpawner().getQueuedDayInvasions()) ? it.getInvasionTime() != InvasionType.InvasionTime.DAY && it.getTimeChangeability() != InvasionType.TimeChangeability.ONLY_DAY : it.getInvasionTime() != InvasionType.InvasionTime.NIGHT && it.getTimeChangeability() != InvasionType.TimeChangeability.ONLY_NIGHT)).map(InvasionType::getId), (SuggestionsBuilder)suggestionsBuilder);
    };
    private static final SuggestionProvider<CommandSource> SUGGEST_PRIMARY_NIGHT_INVASION_TYPES = (ctx, suggestionsBuilder) -> {
        Collection<InvasionType> collection = PSEventManager.BaseEvents.getInvasionTypeManager().getAllInvasionTypes();
        InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSource)ctx.getSource()).func_197023_e());
        return ISuggestionProvider.func_212476_a(collection.stream().filter(it -> !iwData.hasFixedTime() && it.getDimensions().contains(((CommandSource)ctx.getSource()).func_197023_e().func_234923_W_().func_240901_a_()) && it.getInvasionPriority() != InvasionType.InvasionPriority.SECONDARY_ONLY && it.getInvasionTime() != InvasionType.InvasionTime.DAY && it.getTimeChangeability() != InvasionType.TimeChangeability.ONLY_DAY).map(InvasionType::getId), (SuggestionsBuilder)suggestionsBuilder);
    };
    private static final SuggestionProvider<CommandSource> SUGGEST_SECONDARY_NIGHT_INVASION_TYPES = (ctx, suggestionsBuilder) -> {
        Collection<InvasionType> collection = PSEventManager.BaseEvents.getInvasionTypeManager().getAllInvasionTypes();
        InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSource)ctx.getSource()).func_197023_e());
        return ISuggestionProvider.func_212476_a(collection.stream().filter(it -> !iwData.hasFixedTime() && it.getDimensions().contains(((CommandSource)ctx.getSource()).func_197023_e().func_234923_W_().func_240901_a_()) && it.getInvasionPriority() != InvasionType.InvasionPriority.PRIMARY_ONLY && (AddInvasionsCommand.containsNightChangingInvasion(((TimedInvasionWorldData)iwData).getInvasionSpawner().getQueuedNightInvasions()) ? it.getInvasionTime() != InvasionType.InvasionTime.NIGHT && it.getTimeChangeability() != InvasionType.TimeChangeability.ONLY_NIGHT : it.getInvasionTime() != InvasionType.InvasionTime.DAY && it.getTimeChangeability() != InvasionType.TimeChangeability.ONLY_DAY)).map(InvasionType::getId), (SuggestionsBuilder)suggestionsBuilder);
    };
    private static final SuggestionProvider<CommandSource> SUGGEST_PRIMARY_FIXED_INVASION_TYPES = (ctx, suggestionsBuilder) -> {
        Collection<InvasionType> collection = PSEventManager.BaseEvents.getInvasionTypeManager().getAllInvasionTypes();
        InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSource)ctx.getSource()).func_197023_e());
        return ISuggestionProvider.func_212476_a(collection.stream().filter(it -> iwData.hasFixedTime() && it.getDimensions().contains(((CommandSource)ctx.getSource()).func_197023_e().func_234923_W_().func_240901_a_()) && it.getInvasionPriority() != InvasionType.InvasionPriority.SECONDARY_ONLY).map(InvasionType::getId), (SuggestionsBuilder)suggestionsBuilder);
    };
    private static final SuggestionProvider<CommandSource> SUGGEST_SECONDARY_FIXED_INVASION_TYPES = (ctx, suggestionsBuilder) -> {
        Collection<InvasionType> collection = PSEventManager.BaseEvents.getInvasionTypeManager().getAllInvasionTypes();
        InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSource)ctx.getSource()).func_197023_e());
        return ISuggestionProvider.func_212476_a(collection.stream().filter(it -> iwData.hasFixedTime() && it.getDimensions().contains(((CommandSource)ctx.getSource()).func_197023_e().func_234923_W_().func_240901_a_()) && it.getInvasionPriority() != InvasionType.InvasionPriority.PRIMARY_ONLY).map(InvasionType::getId), (SuggestionsBuilder)suggestionsBuilder);
    };

    public static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"add").requires(player -> player.func_197034_c(2))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"day").then(Commands.func_197057_a((String)"primary").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"invasionType", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests(SUGGEST_PRIMARY_DAY_INVASION_TYPES).then(Commands.func_197056_a((String)"severity", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSource)ctx.getSource()).func_197023_e());
            if (!iwData.hasFixedTime()) {
                TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSource>)ctx, "invasionType", "severity", true);
                tiwData.getInvasionSpawner().getQueuedDayInvasions().removeIf(i -> i.isPrimary());
                tiwData.getInvasionSpawner().getQueuedDayInvasions().add(invasion);
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.puresuffering.add.success.day.primary").func_230529_a_(invasion.getType().getComponent()).func_240702_b_("!").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.YELLOW)), true);
            } else {
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.puresuffering.nonfixed").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.RED)), true);
            }
            return 0;
        }))).then(Commands.func_197057_a((String)"random").executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSource)ctx.getSource()).func_197023_e());
            if (!iwData.hasFixedTime()) {
                TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSource>)ctx, "invasionType", null, true);
                tiwData.getInvasionSpawner().getQueuedDayInvasions().removeIf(i -> i.isPrimary());
                tiwData.getInvasionSpawner().getQueuedDayInvasions().add(invasion);
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.puresuffering.add.success.day.primary").func_230529_a_(invasion.getType().getComponent()).func_240702_b_("!").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.YELLOW)), true);
            } else {
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.puresuffering.nonfixed").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.RED)), true);
            }
            return 0;
        }))))).then(Commands.func_197057_a((String)"secondary").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"invasionType", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests(SUGGEST_SECONDARY_DAY_INVASION_TYPES).then(Commands.func_197056_a((String)"severity", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSource)ctx.getSource()).func_197023_e());
            if (!iwData.hasFixedTime()) {
                TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSource>)ctx, "invasionType", "severity", false);
                tiwData.getInvasionSpawner().getQueuedDayInvasions().add(invasion);
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.puresuffering.add.success.day.secondary").func_230529_a_(invasion.getType().getComponent()).func_240702_b_("!").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.YELLOW)), true);
            } else {
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.puresuffering.nonfixed").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.RED)), true);
            }
            return 0;
        }))).then(Commands.func_197057_a((String)"random").executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSource)ctx.getSource()).func_197023_e());
            if (!iwData.hasFixedTime()) {
                TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSource>)ctx, "invasionType", null, false);
                tiwData.getInvasionSpawner().getQueuedDayInvasions().add(invasion);
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.puresuffering.add.success.day.secondary").func_230529_a_(invasion.getType().getComponent()).func_240702_b_("!").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.YELLOW)), true);
            } else {
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.puresuffering.nonfixed").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.RED)), true);
            }
            return 0;
        })))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"night").then(Commands.func_197057_a((String)"primary").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"invasionType", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests(SUGGEST_PRIMARY_NIGHT_INVASION_TYPES).then(Commands.func_197056_a((String)"severity", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSource)ctx.getSource()).func_197023_e());
            if (!iwData.hasFixedTime()) {
                TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSource>)ctx, "invasionType", "severity", true);
                tiwData.getInvasionSpawner().getQueuedNightInvasions().removeIf(i -> i.isPrimary());
                tiwData.getInvasionSpawner().getQueuedNightInvasions().add(invasion);
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.puresuffering.add.success.night.primary").func_230529_a_(invasion.getType().getComponent()).func_240702_b_("!").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.YELLOW)), true);
            } else {
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.puresuffering.nonfixed").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.RED)), true);
            }
            return 0;
        }))).then(Commands.func_197057_a((String)"random").executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSource)ctx.getSource()).func_197023_e());
            if (!iwData.hasFixedTime()) {
                TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSource>)ctx, "invasionType", null, true);
                tiwData.getInvasionSpawner().getQueuedNightInvasions().removeIf(i -> i.isPrimary());
                tiwData.getInvasionSpawner().getQueuedNightInvasions().add(invasion);
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.puresuffering.add.success.night.primary").func_230529_a_(invasion.getType().getComponent()).func_240702_b_("!").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.YELLOW)), true);
            } else {
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.puresuffering.nonfixed").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.RED)), true);
            }
            return 0;
        }))))).then(Commands.func_197057_a((String)"secondary").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"invasionType", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests(SUGGEST_SECONDARY_NIGHT_INVASION_TYPES).then(Commands.func_197056_a((String)"severity", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSource)ctx.getSource()).func_197023_e());
            if (!iwData.hasFixedTime()) {
                TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSource>)ctx, "invasionType", "severity", false);
                tiwData.getInvasionSpawner().getQueuedNightInvasions().add(invasion);
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.puresuffering.add.success.night.secondary").func_230529_a_(invasion.getType().getComponent()).func_240702_b_("!").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.YELLOW)), true);
            } else {
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.puresuffering.nonfixed").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.RED)), true);
            }
            return 0;
        }))).then(Commands.func_197057_a((String)"random").executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSource)ctx.getSource()).func_197023_e());
            if (!iwData.hasFixedTime()) {
                TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSource>)ctx, "invasionType", null, false);
                tiwData.getInvasionSpawner().getQueuedNightInvasions().add(invasion);
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.puresuffering.add.success.night.secondary").func_230529_a_(invasion.getType().getComponent()).func_240702_b_("!").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.YELLOW)), true);
            } else {
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.puresuffering.nonfixed").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.RED)), true);
            }
            return 0;
        })))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"fixed").then(Commands.func_197057_a((String)"primary").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"invasionType", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests(SUGGEST_PRIMARY_FIXED_INVASION_TYPES).then(Commands.func_197056_a((String)"severity", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSource)ctx.getSource()).func_197023_e());
            if (iwData.hasFixedTime()) {
                FixedInvasionWorldData fiwData = (FixedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSource>)ctx, "invasionType", "severity", true);
                fiwData.getInvasionSpawner().getQueuedInvasions().removeIf(i -> i.isPrimary());
                fiwData.getInvasionSpawner().getQueuedInvasions().add(invasion);
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.puresuffering.add.success.fixed.primary").func_230529_a_(invasion.getType().getComponent()).func_240702_b_("!").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.YELLOW)), true);
            } else {
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.puresuffering.fixed").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.RED)), true);
            }
            return 0;
        }))).then(Commands.func_197057_a((String)"random").executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSource)ctx.getSource()).func_197023_e());
            if (iwData.hasFixedTime()) {
                FixedInvasionWorldData fiwData = (FixedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSource>)ctx, "invasionType", null, true);
                fiwData.getInvasionSpawner().getQueuedInvasions().removeIf(i -> i.isPrimary());
                fiwData.getInvasionSpawner().getQueuedInvasions().add(invasion);
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.puresuffering.add.success.fixed.primary").func_230529_a_(invasion.getType().getComponent()).func_240702_b_("!").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.YELLOW)), true);
            } else {
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.puresuffering.fixed").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.RED)), true);
            }
            return 0;
        }))))).then(Commands.func_197057_a((String)"secondary").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"invasionType", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests(SUGGEST_SECONDARY_FIXED_INVASION_TYPES).then(Commands.func_197056_a((String)"severity", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSource)ctx.getSource()).func_197023_e());
            if (iwData.hasFixedTime()) {
                FixedInvasionWorldData fiwData = (FixedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSource>)ctx, "invasionType", "severity", false);
                fiwData.getInvasionSpawner().getQueuedInvasions().add(invasion);
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.puresuffering.add.success.fixed.secondary").func_230529_a_(invasion.getType().getComponent()).func_240702_b_("!").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.YELLOW)), true);
            } else {
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.puresuffering.fixed").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.RED)), true);
            }
            return 0;
        }))).then(Commands.func_197057_a((String)"random").executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSource)ctx.getSource()).func_197023_e());
            if (iwData.hasFixedTime()) {
                FixedInvasionWorldData fiwData = (FixedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSource>)ctx, "invasionType", null, false);
                fiwData.getInvasionSpawner().getQueuedInvasions().add(invasion);
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.puresuffering.add.success.fixed.secondary").func_230529_a_(invasion.getType().getComponent()).func_240702_b_("!").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.YELLOW)), true);
            } else {
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.puresuffering.fixed").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.RED)), true);
            }
            return 0;
        })))));
    }

    private static boolean containsDayChangingInvasion(ArrayList<Invasion> invasionListIn) {
        for (Invasion invasion : invasionListIn) {
            if (invasion.getType().getInvasionTime() == InvasionType.InvasionTime.NIGHT || invasion.getType().getTimeModifier() != InvasionType.TimeModifier.DAY_TO_NIGHT) continue;
            return true;
        }
        return false;
    }

    private static boolean containsNightChangingInvasion(ArrayList<Invasion> invasionListIn) {
        for (Invasion invasion : invasionListIn) {
            if (invasion.getType().getInvasionTime() == InvasionType.InvasionTime.DAY || invasion.getType().getTimeModifier() != InvasionType.TimeModifier.NIGHT_TO_DAY) continue;
            return true;
        }
        return false;
    }

    private static Invasion getInvasion(CommandContext<CommandSource> ctxIn, String argIn, String arg1In, boolean isPrimaryIn) throws CommandSyntaxException {
        ResourceLocation resourceLocation = (ResourceLocation)ctxIn.getArgument(argIn, ResourceLocation.class);
        InvasionType invasionType = PSEventManager.BaseEvents.getInvasionTypeManager().getInvasionType(resourceLocation);
        if (invasionType == null) {
            throw ERROR_UNKNOWN_INVASION_TYPE.create((Object)resourceLocation);
        }
        int severity = arg1In == null ? ((CommandSource)ctxIn.getSource()).func_197023_e().func_201674_k().nextInt(invasionType.getMaxSeverity()) : MathHelper.func_76125_a((int)IntegerArgumentType.getInteger(ctxIn, (String)arg1In), (int)1, (int)invasionType.getMaxSeverity()) - 1;
        return new Invasion(invasionType, severity, isPrimaryIn);
    }
}

