/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.command;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.theagameplayer.puresuffering.PSEventManager;
import dev.theagameplayer.puresuffering.invasion.Invasion;
import dev.theagameplayer.puresuffering.invasion.InvasionType;
import dev.theagameplayer.puresuffering.util.ServerTimeUtil;
import dev.theagameplayer.puresuffering.world.FixedInvasionWorldData;
import dev.theagameplayer.puresuffering.world.InvasionWorldData;
import dev.theagameplayer.puresuffering.world.TimedInvasionWorldData;
import java.util.Collection;
import java.util.stream.Stream;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.ResourceLocationArgument;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public final class RemoveInvasionsCommand {
    private static final DynamicCommandExceptionType ERROR_UNKNOWN_INVASION_TYPE = new DynamicCommandExceptionType(resourceLocation -> new TranslationTextComponent("commands.puresuffering.invasion_type.invasionTypeNotFound", new Object[]{resourceLocation}));
    private static final SuggestionProvider<CommandSource> SUGGEST_CURRENT_INVASION_TYPES = (ctx, suggestionsBuilder) -> {
        Collection<InvasionType> collection = PSEventManager.BaseEvents.getInvasionTypeManager().getAllInvasionTypes();
        InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSource)ctx.getSource()).func_197023_e());
        if (!iwData.hasFixedTime()) {
            TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
            return ISuggestionProvider.func_212476_a(collection.stream().filter(invasionType -> {
                if (ServerTimeUtil.isServerDay(((CommandSource)ctx.getSource()).func_197023_e(), tiwData)) {
                    return RemoveInvasionsCommand.contains(tiwData.getInvasionSpawner().getDayInvasions(), invasionType);
                }
                if (ServerTimeUtil.isServerNight(((CommandSource)ctx.getSource()).func_197023_e(), tiwData)) {
                    return RemoveInvasionsCommand.contains(tiwData.getInvasionSpawner().getNightInvasions(), invasionType);
                }
                return false;
            }).map(InvasionType::getId), (SuggestionsBuilder)suggestionsBuilder);
        }
        FixedInvasionWorldData fiwData = (FixedInvasionWorldData)iwData;
        return ISuggestionProvider.func_212476_a(collection.stream().filter(invasionType -> RemoveInvasionsCommand.contains(fiwData.getInvasionSpawner().getInvasions(), invasionType)).map(InvasionType::getId), (SuggestionsBuilder)suggestionsBuilder);
    };
    private static final SuggestionProvider<CommandSource> SUGGEST_DAY_INVASION_TYPES = (ctx, suggestionsBuilder) -> {
        Collection<InvasionType> collection = PSEventManager.BaseEvents.getInvasionTypeManager().getAllInvasionTypes();
        InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSource)ctx.getSource()).func_197023_e());
        if (!iwData.hasFixedTime()) {
            TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
            return ISuggestionProvider.func_212476_a(collection.stream().filter(invasionType -> RemoveInvasionsCommand.contains(tiwData.getInvasionSpawner().getDayInvasions(), invasionType)).map(InvasionType::getId), (SuggestionsBuilder)suggestionsBuilder);
        }
        return ISuggestionProvider.func_212476_a((Stream)ImmutableList.of().stream(), (SuggestionsBuilder)suggestionsBuilder);
    };
    private static final SuggestionProvider<CommandSource> SUGGEST_NIGHT_INVASION_TYPES = (ctx, suggestionsBuilder) -> {
        Collection<InvasionType> collection = PSEventManager.BaseEvents.getInvasionTypeManager().getAllInvasionTypes();
        InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSource)ctx.getSource()).func_197023_e());
        if (!iwData.hasFixedTime()) {
            TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
            return ISuggestionProvider.func_212476_a(collection.stream().filter(invasionType -> RemoveInvasionsCommand.contains(tiwData.getInvasionSpawner().getNightInvasions(), invasionType)).map(InvasionType::getId), (SuggestionsBuilder)suggestionsBuilder);
        }
        return ISuggestionProvider.func_212476_a((Stream)ImmutableList.of().stream(), (SuggestionsBuilder)suggestionsBuilder);
    };
    private static final SuggestionProvider<CommandSource> SUGGEST_FIXED_INVASION_TYPES = (ctx, suggestionsBuilder) -> {
        Collection<InvasionType> collection = PSEventManager.BaseEvents.getInvasionTypeManager().getAllInvasionTypes();
        InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSource)ctx.getSource()).func_197023_e());
        if (iwData.hasFixedTime()) {
            FixedInvasionWorldData fiwData = (FixedInvasionWorldData)iwData;
            return ISuggestionProvider.func_212476_a(collection.stream().filter(invasionType -> RemoveInvasionsCommand.contains(fiwData.getInvasionSpawner().getInvasions(), invasionType)).map(InvasionType::getId), (SuggestionsBuilder)suggestionsBuilder);
        }
        return ISuggestionProvider.func_212476_a((Stream)ImmutableList.of().stream(), (SuggestionsBuilder)suggestionsBuilder);
    };
    private static final SuggestionProvider<CommandSource> SUGGEST_ALL_INVASION_TYPES = (ctx, suggestionsBuilder) -> {
        Collection<InvasionType> collection = PSEventManager.BaseEvents.getInvasionTypeManager().getAllInvasionTypes();
        InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSource)ctx.getSource()).func_197023_e());
        if (!iwData.hasFixedTime()) {
            TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
            return ISuggestionProvider.func_212476_a(collection.stream().filter(invasionType -> RemoveInvasionsCommand.contains(tiwData.getInvasionSpawner().getDayInvasions(), invasionType) || RemoveInvasionsCommand.contains(tiwData.getInvasionSpawner().getNightInvasions(), invasionType)).map(InvasionType::getId), (SuggestionsBuilder)suggestionsBuilder);
        }
        FixedInvasionWorldData fiwData = (FixedInvasionWorldData)iwData;
        return ISuggestionProvider.func_212476_a(collection.stream().filter(invasionType -> RemoveInvasionsCommand.contains(fiwData.getInvasionSpawner().getInvasions(), invasionType)).map(InvasionType::getId), (SuggestionsBuilder)suggestionsBuilder);
    };
    private static final SuggestionProvider<CommandSource> SUGGEST_QUEUED_DAY_INVASION_TYPES = (ctx, suggestionsBuilder) -> {
        Collection<InvasionType> collection = PSEventManager.BaseEvents.getInvasionTypeManager().getAllInvasionTypes();
        InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSource)ctx.getSource()).func_197023_e());
        if (!iwData.hasFixedTime()) {
            TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
            return ISuggestionProvider.func_212476_a(collection.stream().filter(invasionType -> RemoveInvasionsCommand.contains(tiwData.getInvasionSpawner().getQueuedDayInvasions(), invasionType)).map(InvasionType::getId), (SuggestionsBuilder)suggestionsBuilder);
        }
        return ISuggestionProvider.func_212476_a((Stream)ImmutableList.of().stream(), (SuggestionsBuilder)suggestionsBuilder);
    };
    private static final SuggestionProvider<CommandSource> SUGGEST_QUEUED_NIGHT_INVASION_TYPES = (ctx, suggestionsBuilder) -> {
        Collection<InvasionType> collection = PSEventManager.BaseEvents.getInvasionTypeManager().getAllInvasionTypes();
        InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSource)ctx.getSource()).func_197023_e());
        if (!iwData.hasFixedTime()) {
            TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
            return ISuggestionProvider.func_212476_a(collection.stream().filter(invasionType -> RemoveInvasionsCommand.contains(tiwData.getInvasionSpawner().getQueuedNightInvasions(), invasionType)).map(InvasionType::getId), (SuggestionsBuilder)suggestionsBuilder);
        }
        return ISuggestionProvider.func_212476_a((Stream)ImmutableList.of().stream(), (SuggestionsBuilder)suggestionsBuilder);
    };
    private static final SuggestionProvider<CommandSource> SUGGEST_QUEUED_FIXED_INVASION_TYPES = (ctx, suggestionsBuilder) -> {
        Collection<InvasionType> collection = PSEventManager.BaseEvents.getInvasionTypeManager().getAllInvasionTypes();
        InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSource)ctx.getSource()).func_197023_e());
        if (iwData.hasFixedTime()) {
            FixedInvasionWorldData fiwData = (FixedInvasionWorldData)iwData;
            return ISuggestionProvider.func_212476_a(collection.stream().filter(invasionType -> RemoveInvasionsCommand.contains(fiwData.getInvasionSpawner().getQueuedInvasions(), invasionType)).map(InvasionType::getId), (SuggestionsBuilder)suggestionsBuilder);
        }
        return ISuggestionProvider.func_212476_a((Stream)ImmutableList.of().stream(), (SuggestionsBuilder)suggestionsBuilder);
    };

    public static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"remove").requires(player -> player.func_197034_c(2))).then(Commands.func_197057_a((String)"current").then(Commands.func_197056_a((String)"invasionType", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests(SUGGEST_CURRENT_INVASION_TYPES).executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSource)ctx.getSource()).func_197023_e());
            if (!iwData.hasFixedTime()) {
                TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                if (ServerTimeUtil.isServerDay(((CommandSource)ctx.getSource()).func_197023_e(), tiwData)) {
                    Invasion invasion = RemoveInvasionsCommand.getInvasion(tiwData.getInvasionSpawner().getDayInvasions(), (CommandContext<CommandSource>)ctx, "invasionType");
                    tiwData.getInvasionSpawner().getDayInvasions().remove(invasion);
                    ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.puresuffering.remove.success.day." + (invasion.isPrimary() ? "primary" : "secondary")).func_230529_a_(invasion.getType().getComponent()).func_240702_b_("!").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.YELLOW)), true);
                } else if (ServerTimeUtil.isServerNight(((CommandSource)ctx.getSource()).func_197023_e(), tiwData)) {
                    Invasion invasion = RemoveInvasionsCommand.getInvasion(tiwData.getInvasionSpawner().getNightInvasions(), (CommandContext<CommandSource>)ctx, "invasionType");
                    tiwData.getInvasionSpawner().getNightInvasions().remove(invasion);
                    ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.puresuffering.remove.success.night." + (invasion.isPrimary() ? "primary" : "secondary")).func_230529_a_(invasion.getType().getComponent()).func_240702_b_("!").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.YELLOW)), true);
                } else {
                    ((CommandSource)ctx.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("commands.puresuffering.remove.failure").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.DARK_RED)));
                }
            } else {
                FixedInvasionWorldData fiwData = (FixedInvasionWorldData)iwData;
                Invasion invasion = RemoveInvasionsCommand.getInvasion(fiwData.getInvasionSpawner().getInvasions(), (CommandContext<CommandSource>)ctx, "invasionType");
                fiwData.getInvasionSpawner().getInvasions().remove(invasion);
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.puresuffering.remove.success.fixed." + (invasion.isPrimary() ? "primary" : "secondary")).func_230529_a_(invasion.getType().getComponent()).func_240702_b_("!").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.YELLOW)), true);
            }
            return 0;
        })))).then(Commands.func_197057_a((String)"day").then(Commands.func_197056_a((String)"invasionType", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests(SUGGEST_DAY_INVASION_TYPES).executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSource)ctx.getSource()).func_197023_e());
            if (!iwData.hasFixedTime()) {
                TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                Invasion invasion = RemoveInvasionsCommand.getInvasion(tiwData.getInvasionSpawner().getDayInvasions(), (CommandContext<CommandSource>)ctx, "invasionType");
                tiwData.getInvasionSpawner().getDayInvasions().remove(invasion);
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.puresuffering.remove.success.day." + (invasion.isPrimary() ? "primary" : "secondary")).func_230529_a_(invasion.getType().getComponent()).func_240702_b_("!").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.YELLOW)), true);
            } else {
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.puresuffering.nonfixed").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.RED)), true);
            }
            return 0;
        })))).then(Commands.func_197057_a((String)"night").then(Commands.func_197056_a((String)"invasionType", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests(SUGGEST_NIGHT_INVASION_TYPES).executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSource)ctx.getSource()).func_197023_e());
            if (!iwData.hasFixedTime()) {
                TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                Invasion invasion = RemoveInvasionsCommand.getInvasion(tiwData.getInvasionSpawner().getNightInvasions(), (CommandContext<CommandSource>)ctx, "invasionType");
                tiwData.getInvasionSpawner().getNightInvasions().remove(invasion);
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.puresuffering.remove.success.night." + (invasion.isPrimary() ? "primary" : "secondary")).func_230529_a_(invasion.getType().getComponent()).func_240702_b_("!").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.YELLOW)), true);
            } else {
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.puresuffering.nonfixed").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.RED)), true);
            }
            return 0;
        })))).then(Commands.func_197057_a((String)"fixed").then(Commands.func_197056_a((String)"invasionType", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests(SUGGEST_FIXED_INVASION_TYPES).executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSource)ctx.getSource()).func_197023_e());
            if (iwData.hasFixedTime()) {
                FixedInvasionWorldData fiwData = (FixedInvasionWorldData)iwData;
                Invasion invasion = RemoveInvasionsCommand.getInvasion(fiwData.getInvasionSpawner().getInvasions(), (CommandContext<CommandSource>)ctx, "invasionType");
                fiwData.getInvasionSpawner().getInvasions().remove(invasion);
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.puresuffering.remove.success.fixed." + (invasion.isPrimary() ? "primary" : "secondary")).func_230529_a_(invasion.getType().getComponent()).func_240702_b_("!").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.YELLOW)), true);
            } else {
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.puresuffering.fixed").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.RED)), true);
            }
            return 0;
        })))).then(Commands.func_197057_a((String)"all").then(Commands.func_197056_a((String)"invasionType", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests(SUGGEST_ALL_INVASION_TYPES).executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSource)ctx.getSource()).func_197023_e());
            if (!iwData.hasFixedTime()) {
                TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                ResourceLocation resourceLocation = (ResourceLocation)ctx.getArgument("invasionType", ResourceLocation.class);
                Invasion invasion = null;
                if (RemoveInvasionsCommand.contains(tiwData.getInvasionSpawner().getDayInvasions(), PSEventManager.BaseEvents.getInvasionTypeManager().getInvasionType(resourceLocation))) {
                    invasion = RemoveInvasionsCommand.getInvasion(tiwData.getInvasionSpawner().getDayInvasions(), (CommandContext<CommandSource>)ctx, "invasionType");
                    tiwData.getInvasionSpawner().getDayInvasions().remove(invasion);
                }
                if (RemoveInvasionsCommand.contains(tiwData.getInvasionSpawner().getNightInvasions(), PSEventManager.BaseEvents.getInvasionTypeManager().getInvasionType(resourceLocation))) {
                    invasion = RemoveInvasionsCommand.getInvasion(tiwData.getInvasionSpawner().getNightInvasions(), (CommandContext<CommandSource>)ctx, "invasionType");
                    tiwData.getInvasionSpawner().getNightInvasions().remove(invasion);
                }
                if (invasion != null) {
                    ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.puresuffering.remove.success.all." + (invasion.isPrimary() ? "primary" : "secondary")).func_230529_a_(invasion.getType().getComponent()).func_240702_b_("!").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.YELLOW)), true);
                }
            } else {
                FixedInvasionWorldData fiwData = (FixedInvasionWorldData)iwData;
                ResourceLocation resourceLocation = (ResourceLocation)ctx.getArgument("invasionType", ResourceLocation.class);
                Invasion invasion = null;
                if (RemoveInvasionsCommand.contains(fiwData.getInvasionSpawner().getInvasions(), PSEventManager.BaseEvents.getInvasionTypeManager().getInvasionType(resourceLocation))) {
                    invasion = RemoveInvasionsCommand.getInvasion(fiwData.getInvasionSpawner().getInvasions(), (CommandContext<CommandSource>)ctx, "invasionType");
                    fiwData.getInvasionSpawner().getInvasions().remove(invasion);
                }
                if (invasion != null) {
                    ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.puresuffering.remove.success.all." + (invasion.isPrimary() ? "primary" : "secondary")).func_230529_a_(invasion.getType().getComponent()).func_240702_b_("!").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.YELLOW)), true);
                }
            }
            return 0;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"queued").then(Commands.func_197057_a((String)"day").then(Commands.func_197056_a((String)"invasionType", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests(SUGGEST_QUEUED_DAY_INVASION_TYPES).executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSource)ctx.getSource()).func_197023_e());
            if (!iwData.hasFixedTime()) {
                TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                Invasion invasion = RemoveInvasionsCommand.getInvasion(tiwData.getInvasionSpawner().getQueuedDayInvasions(), (CommandContext<CommandSource>)ctx, "invasionType");
                tiwData.getInvasionSpawner().getQueuedDayInvasions().remove(invasion);
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.puresuffering.remove.success.queued.day." + (invasion.isPrimary() ? "primary" : "secondary")).func_230529_a_(invasion.getType().getComponent()).func_240702_b_("!").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.YELLOW)), true);
            } else {
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.puresuffering.nonfixed").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.RED)), true);
            }
            return 0;
        })))).then(Commands.func_197057_a((String)"night").then(Commands.func_197056_a((String)"invasionType", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests(SUGGEST_QUEUED_NIGHT_INVASION_TYPES).executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSource)ctx.getSource()).func_197023_e());
            if (!iwData.hasFixedTime()) {
                TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                Invasion invasion = RemoveInvasionsCommand.getInvasion(tiwData.getInvasionSpawner().getQueuedNightInvasions(), (CommandContext<CommandSource>)ctx, "invasionType");
                tiwData.getInvasionSpawner().getQueuedDayInvasions().remove(invasion);
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.puresuffering.remove.success.queued.night." + (invasion.isPrimary() ? "primary" : "secondary")).func_230529_a_(invasion.getType().getComponent()).func_240702_b_("!").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.YELLOW)), true);
            } else {
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.puresuffering.nonfixed").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.RED)), true);
            }
            return 0;
        })))).then(Commands.func_197057_a((String)"fixed").then(Commands.func_197056_a((String)"invasionType", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests(SUGGEST_QUEUED_FIXED_INVASION_TYPES).executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSource)ctx.getSource()).func_197023_e());
            if (iwData.hasFixedTime()) {
                FixedInvasionWorldData fiwData = (FixedInvasionWorldData)iwData;
                Invasion invasion = RemoveInvasionsCommand.getInvasion(fiwData.getInvasionSpawner().getQueuedInvasions(), (CommandContext<CommandSource>)ctx, "invasionType");
                fiwData.getInvasionSpawner().getQueuedInvasions().remove(invasion);
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.puresuffering.remove.success.queued.fixed." + (invasion.isPrimary() ? "primary" : "secondary")).func_230529_a_(invasion.getType().getComponent()).func_240702_b_("!").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.YELLOW)), true);
            } else {
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.puresuffering.fixed").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.RED)), true);
            }
            return 0;
        })))).then(Commands.func_197057_a((String)"all").then(Commands.func_197056_a((String)"invasionType", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests(SUGGEST_ALL_INVASION_TYPES).executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSource)ctx.getSource()).func_197023_e());
            if (!iwData.hasFixedTime()) {
                TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                ResourceLocation resourceLocation = (ResourceLocation)ctx.getArgument("invasionType", ResourceLocation.class);
                Invasion invasion = null;
                if (RemoveInvasionsCommand.contains(tiwData.getInvasionSpawner().getQueuedDayInvasions(), PSEventManager.BaseEvents.getInvasionTypeManager().getInvasionType(resourceLocation))) {
                    invasion = RemoveInvasionsCommand.getInvasion(tiwData.getInvasionSpawner().getQueuedDayInvasions(), (CommandContext<CommandSource>)ctx, "invasionType");
                    tiwData.getInvasionSpawner().getQueuedDayInvasions().remove(invasion);
                }
                if (RemoveInvasionsCommand.contains(tiwData.getInvasionSpawner().getQueuedNightInvasions(), PSEventManager.BaseEvents.getInvasionTypeManager().getInvasionType(resourceLocation))) {
                    invasion = RemoveInvasionsCommand.getInvasion(tiwData.getInvasionSpawner().getQueuedNightInvasions(), (CommandContext<CommandSource>)ctx, "invasionType");
                    tiwData.getInvasionSpawner().getQueuedNightInvasions().remove(invasion);
                }
                if (invasion != null) {
                    ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.puresuffering.remove.success.queued.all." + (invasion.isPrimary() ? "primary" : "secondary")).func_230529_a_(invasion.getType().getComponent()).func_240702_b_("!").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.YELLOW)), true);
                }
            } else {
                FixedInvasionWorldData fiwData = (FixedInvasionWorldData)iwData;
                ResourceLocation resourceLocation = (ResourceLocation)ctx.getArgument("invasionType", ResourceLocation.class);
                Invasion invasion = null;
                if (RemoveInvasionsCommand.contains(fiwData.getInvasionSpawner().getQueuedInvasions(), PSEventManager.BaseEvents.getInvasionTypeManager().getInvasionType(resourceLocation))) {
                    invasion = RemoveInvasionsCommand.getInvasion(fiwData.getInvasionSpawner().getQueuedInvasions(), (CommandContext<CommandSource>)ctx, "invasionType");
                    fiwData.getInvasionSpawner().getQueuedInvasions().remove(invasion);
                }
                if (invasion != null) {
                    ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.puresuffering.remove.success.queued.all." + (invasion.isPrimary() ? "primary" : "secondary")).func_230529_a_(invasion.getType().getComponent()).func_240702_b_("!").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.YELLOW)), true);
                }
            }
            return 0;
        }))));
    }

    private static boolean contains(Iterable<Invasion> invasionListIn, InvasionType invasionTypeIn) {
        for (Invasion invasion : invasionListIn) {
            if (invasion.getType() != invasionTypeIn) continue;
            return true;
        }
        return false;
    }

    private static Invasion getInvasion(Iterable<Invasion> invasionListIn, CommandContext<CommandSource> ctxIn, String argIn) throws CommandSyntaxException {
        ResourceLocation resourceLocation = (ResourceLocation)ctxIn.getArgument(argIn, ResourceLocation.class);
        InvasionType invasionType = PSEventManager.BaseEvents.getInvasionTypeManager().getInvasionType(resourceLocation);
        if (invasionType == null) {
            throw ERROR_UNKNOWN_INVASION_TYPE.create((Object)resourceLocation);
        }
        for (Invasion invasion : invasionListIn) {
            if (invasion.getType() != invasionType) continue;
            return invasion;
        }
        throw ERROR_UNKNOWN_INVASION_TYPE.create((Object)resourceLocation);
    }
}

