/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class PSConfig {
    private static final Logger LOGGER = LogManager.getLogger((String)"puresuffering");
    private static final String CONFIG = "puresuffering.config.";

    public static void initConfig() {
        Path configPath = FMLPaths.CONFIGDIR.get();
        Path psConfigPath = Paths.get(configPath.toAbsolutePath().toString(), "puresuffering");
        try {
            Files.createDirectory(psConfigPath, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException exceptionIn) {
            LOGGER.info("Config directory for puresuffering already exists!");
        }
        catch (IOException exceptionIn) {
            LOGGER.error("Failed to create puresuffering config directory!", (Throwable)exceptionIn);
        }
        PSConfig.loadConfig(CommonConfig.COMMON.build(), configPath.resolve("puresuffering/puresuffering-common.toml"));
        PSConfig.loadConfig(ClientConfig.CLIENT.build(), configPath.resolve("puresuffering/puresuffering-client.toml"));
    }

    private static void loadConfig(ForgeConfigSpec specIn, Path pathIn) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)pathIn).sync().autosave().preserveInsertionOrder().writingMode(WritingMode.REPLACE).build();
        configData.load();
        specIn.setConfig((CommentedConfig)configData);
    }

    public static final class ClientConfig {
        public static final ForgeConfigSpec.Builder CLIENT_BUILDER = new ForgeConfigSpec.Builder();
        public static final ClientConfig CLIENT = new ClientConfig();
        public final ForgeConfigSpec.BooleanValue useSkyBoxRenderer;
        public final ForgeConfigSpec.BooleanValue canInvasionsChangeBrightness;

        private ClientConfig() {
            CLIENT_BUILDER.push("Rendering");
            this.useSkyBoxRenderer = CLIENT_BUILDER.translation("puresuffering.config.use_sky_box_renderer").comment(new String[]{"Can render Invasions with a custom sky box renderer?", "NOTE: Set false with incompatible shaders!"}).define("useSkyBoxRenderer", true);
            this.canInvasionsChangeBrightness = CLIENT_BUILDER.translation("puresuffering.config.can_invasions_change_brightness").comment(new String[]{"Can Invasions change the brightness Values?", "NOTE: Set false with incompatible shaders!"}).define("canInvasionsChangeBrightness", true);
            CLIENT_BUILDER.pop();
        }

        private ForgeConfigSpec build() {
            return CLIENT_BUILDER.build();
        }
    }

    public static final class CommonConfig {
        public static final ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
        public static final CommonConfig COMMON = new CommonConfig();
        public final ForgeConfigSpec.IntValue primaryInvasionMobCap;
        public final ForgeConfigSpec.IntValue secondaryInvasionMobCap;
        public final ForgeConfigSpec.IntValue dayDifficultyIncreaseDelay;
        public final ForgeConfigSpec.IntValue nightDifficultyIncreaseDelay;
        public final ForgeConfigSpec.IntValue fixedDifficultyIncreaseDelay;
        public final ForgeConfigSpec.IntValue maxDayInvasions;
        public final ForgeConfigSpec.IntValue maxNightInvasions;
        public final ForgeConfigSpec.IntValue maxFixedInvasions;
        public final ForgeConfigSpec.BooleanValue multiThreadedInvasions;
        public final ForgeConfigSpec.BooleanValue consistentInvasions;
        public final ForgeConfigSpec.BooleanValue tieredInvasions;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> invasionBlacklist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> primaryWhitelist;
        public final ForgeConfigSpec.IntValue dayInvasionRarity;
        public final ForgeConfigSpec.IntValue nightInvasionRarity;
        public final ForgeConfigSpec.IntValue fixedInvasionRarity;
        public final ForgeConfigSpec.BooleanValue canDayInvasionsBeCanceled;
        public final ForgeConfigSpec.BooleanValue canNightInvasionsBeCanceled;
        public final ForgeConfigSpec.BooleanValue canFixedInvasionsBeCanceled;
        public final ForgeConfigSpec.DoubleValue dayCancelChanceMultiplier;
        public final ForgeConfigSpec.DoubleValue nightCancelChanceMultiplier;
        public final ForgeConfigSpec.DoubleValue fixedCancelChanceMultiplier;
        public final ForgeConfigSpec.BooleanValue hyperAggression;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> hyperAggressionBlacklist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> modBiomeBoostedBlacklist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> mobBiomeBoostedBlacklist;
        public final ForgeConfigSpec.BooleanValue forceInvasionSleeplessness;
        public final ForgeConfigSpec.BooleanValue weakenedVexes;
        public final ForgeConfigSpec.BooleanValue useXPMultiplier;
        public final ForgeConfigSpec.BooleanValue explosionsDestroyBlocks;
        public final ForgeConfigSpec.BooleanValue shouldMobsDieAtEndOfInvasions;
        public final ForgeConfigSpec.BooleanValue shouldMobsSpawnWithMaxRange;
        public final ForgeConfigSpec.IntValue naturalSpawnChance;
        public final ForgeConfigSpec.IntValue blessingEffectRespawnDuration;
        public final ForgeConfigSpec.IntValue blessingEffectDimensionChangeDuration;

        private CommonConfig() {
            COMMON_BUILDER.push("Gameplay");
            COMMON_BUILDER.push("InvasionDifficulty");
            this.primaryInvasionMobCap = COMMON_BUILDER.translation("puresuffering.config.primary_invasion_mob_cap").worldRestart().comment(new String[]{"The Max amount of mobs that can spawn from Primary Invasions at once.", "NOTE: Reduce for increased performance!"}).defineInRange("primaryInvasionMobCap", 100, 0, Integer.MAX_VALUE);
            this.secondaryInvasionMobCap = COMMON_BUILDER.translation("puresuffering.config.secondary_invasion_mob_cap").worldRestart().comment(new String[]{"The Max amount of mobs that can spawn from Primary Invasions at once.", "NOTE: Reduce for increased performance!"}).defineInRange("secondaryInvasionMobCap", 25, 0, Integer.MAX_VALUE);
            this.dayDifficultyIncreaseDelay = COMMON_BUILDER.translation("puresuffering.config.day_difficulty_increase_delay").worldRestart().comment("How many days should pass when the Day Invasion Difficulty increases?").defineInRange("dayDifficultyIncreaseDelay", 60, 0, Integer.MAX_VALUE);
            this.nightDifficultyIncreaseDelay = COMMON_BUILDER.translation("puresuffering.config.night_difficulty_increase_delay").worldRestart().comment("How many days should pass when the Night Invasion Difficulty increases?").defineInRange("nightDifficultyIncreaseDelay", 40, 0, Integer.MAX_VALUE);
            this.fixedDifficultyIncreaseDelay = COMMON_BUILDER.translation("puresuffering.config.fixed_difficulty_increase_delay").worldRestart().comment("How many days should pass when the Fixed Invasion Difficulty increases?").defineInRange("fixedDifficultyIncreaseDelay", 50, 0, Integer.MAX_VALUE);
            this.maxDayInvasions = COMMON_BUILDER.translation("puresuffering.config.max_day_invasions").worldRestart().comment("Max Day Invasions that can occur.").defineInRange("maxDayInvasions", 3, 0, Integer.MAX_VALUE);
            this.maxNightInvasions = COMMON_BUILDER.translation("puresuffering.config.max_night_invasions").worldRestart().comment("Max Night Invasions that can occur.").defineInRange("maxNightInvasions", 3, 0, Integer.MAX_VALUE);
            this.maxFixedInvasions = COMMON_BUILDER.translation("puresuffering.config.max_fixed_invasions").worldRestart().comment("Max Fixed Invasions that can occur.").defineInRange("maxFixedInvasions", 3, 0, Integer.MAX_VALUE);
            this.multiThreadedInvasions = COMMON_BUILDER.translation("puresuffering.config.multi_threaded_invasions").worldRestart().comment(new String[]{"Should a thread be added for every dimension's Invasion Spawner instead of just 1 for all?", "NOTE: This can boost performance on multi-threaded CPUs!"}).define("multiThreadedInvasions", false);
            this.consistentInvasions = COMMON_BUILDER.translation("puresuffering.config.consistent_invasions").worldRestart().comment("Should the rarity of Invasions act as a set delay between Invasions instead?").define("consistentInvasions", false);
            this.tieredInvasions = COMMON_BUILDER.translation("puresuffering.config.tiered_invasions").worldRestart().comment("Should invasions follow the tier system?").define("tieredInvasions", true);
            this.invasionBlacklist = COMMON_BUILDER.translation("puresuffering.config.invasion_blacklist").worldRestart().comment(new String[]{"List of Invasions that can't occur.", "Ex: 'puresuffering:solar_eclipse', 'puresuffering:phantom_zone' (must be surrounded by quotation marks)"}).defineList("invasionBlacklist", (List)ImmutableList.of(), string -> string != "");
            this.primaryWhitelist = COMMON_BUILDER.translation("puresuffering.config.primary_whitelist").worldRestart().comment(new String[]{"List of Invasions that can be primary invasions.", "NOTE: The Invasion's Priority cannot be labeled as Secondary Only!", "Ex: 'puresuffering:solar_eclipse', 'puresuffering:phantom_zone' (must be surrounded by quotation marks)"}).defineList("primaryWhitelist", (List)ImmutableList.of(), string -> string != "");
            COMMON_BUILDER.pop();
            COMMON_BUILDER.push("Balancing");
            this.dayInvasionRarity = COMMON_BUILDER.translation("puresuffering.config.day_invasion_rarity").worldRestart().comment("How often should Day Invasions occur.").defineInRange("dayInvasionRarity", 21, 1, 100);
            this.nightInvasionRarity = COMMON_BUILDER.translation("puresuffering.config.night_invasion_rarity").worldRestart().comment("How often should Night Invasions occur.").defineInRange("nightInvasionRarity", 3, 1, 100);
            this.fixedInvasionRarity = COMMON_BUILDER.translation("puresuffering.config.fixed_invasion_rarity").worldRestart().comment("How often should Fixed Invasions occur.").defineInRange("fixedInvasionRarity", 12, 1, 100);
            this.canDayInvasionsBeCanceled = COMMON_BUILDER.translation("puresuffering.config.can_day_invasions_be_canceled").worldRestart().comment("Can Day Invasions have a random chance to be canceled?").define("canDayInvasionsBeCanceled", true);
            this.canNightInvasionsBeCanceled = COMMON_BUILDER.translation("puresuffering.config.can_night_invasions_be_canceled").worldRestart().comment("Can Night Invasions have a random chance to be canceled?").define("canNightInvasionsBeCanceled", true);
            this.canFixedInvasionsBeCanceled = COMMON_BUILDER.translation("puresuffering.config.can_fixed_invasions_be_canceled").worldRestart().comment("Can Fixed Invasions have a random chance to be canceled?").define("canFixedInvasionsBeCanceled", true);
            this.dayCancelChanceMultiplier = COMMON_BUILDER.translation("puresuffering.config.day_cancel_chance_multiplier").worldRestart().comment(new String[]{"Chance for Day Invasions to be canceled.", "NOTE: Multiplied by Day Difficulty Increase Delay."}).defineInRange("dayCancelChanceMultiplier", 2.5, 0.0, 10.0);
            this.nightCancelChanceMultiplier = COMMON_BUILDER.translation("puresuffering.config.night_cancel_chance_multiplier").worldRestart().comment(new String[]{"Chance for Night Invasions to be canceled.", "NOTE: Multiplied by Night Difficulty Increase Delay."}).defineInRange("nightCancelChanceMultiplier", 2.5, 0.0, 10.0);
            this.fixedCancelChanceMultiplier = COMMON_BUILDER.translation("puresuffering.config.fixed_cancel_chance_multiplier").worldRestart().comment(new String[]{"Chance for Fixed Invasions to be canceled.", "NOTE: Multiplied by Fixed Difficulty Increase Delay."}).defineInRange("fixedCancelChanceMultiplier", 2.5, 0.0, 10.0);
            COMMON_BUILDER.pop();
            COMMON_BUILDER.push("Modifications");
            this.hyperAggression = COMMON_BUILDER.translation("puresuffering.config.hyper_aggression").worldRestart().comment("Should neutral invasion mobs agro the player when spawned?").define("hyperAggression", true);
            this.hyperAggressionBlacklist = COMMON_BUILDER.translation("puresuffering.config.hyper_aggression_blacklist").worldRestart().comment("List of Mobs that won't be hyper aggressive towards the player. (If setting is turned on)").defineList("hyperAggressionBlacklist", (List)ImmutableList.of((Object)"minecraft:vex"), string -> string != "");
            this.modBiomeBoostedBlacklist = COMMON_BUILDER.translation("puresuffering.config.mod_biome_boosted_blacklist").worldRestart().comment(new String[]{"List of Mods that won't be allowed to have their mobs spawn in Biome Boosted Invasions.", "Ex: 'johncraft', 'mutantbeasts'"}).defineList("modBiomeBoostedBlacklist", (List)ImmutableList.of(), string -> string != "");
            this.mobBiomeBoostedBlacklist = COMMON_BUILDER.translation("puresuffering.config.mob_biome_boosted_blacklist").worldRestart().comment(new String[]{"List of Mobs that won't be allowed to spawn in Biome Boosted Invasions.", "Ex: 'minecraft:enderman', 'mutantbeasts:mutant_creeper'"}).defineList("mobBiomeBoostedBlacklist", (List)ImmutableList.of(), string -> string != "");
            this.forceInvasionSleeplessness = COMMON_BUILDER.translation("puresuffering.config.force_invasion_sleeplessness").worldRestart().comment("Should players be unable to sleep during all invasions?").define("forceInvasionSleeplessness", false);
            this.weakenedVexes = COMMON_BUILDER.translation("puresuffering.config.weakened_vexes").worldRestart().comment("Should vexes in Invasions be weakened?").define("weakenedVexes", true);
            this.useXPMultiplier = COMMON_BUILDER.translation("puresuffering.config.use_xp_multiplier").worldRestart().comment("This determines whether invasion mobs should have an xp boost per kill.").define("useXPMultiplier", true);
            this.explosionsDestroyBlocks = COMMON_BUILDER.translation("puresuffering.config.explosions_destroy_blocks").worldRestart().comment("Should explosions caused by invasion mobs break blocks?").define("explosionsDestroy", false);
            this.shouldMobsDieAtEndOfInvasions = COMMON_BUILDER.translation("puresuffering.config.should_mobs_die_at_end_of_invasions").worldRestart().comment(new String[]{"Should Invasion Mobs die when the Invasions are over?", "NOTE: Can be used to reduce server lag."}).define("shouldMobsDieAtEndOfInvasions", false);
            this.shouldMobsSpawnWithMaxRange = COMMON_BUILDER.translation("puresuffering.config.should_mobs_spawn_with_max_range").worldRestart().comment(new String[]{"Should Invasion Mobs spawn with max follow range?", "NOTE: Very Taxing on server performance!"}).define("shouldMobsSpawnWithMaxRange", false);
            this.naturalSpawnChance = COMMON_BUILDER.translation("puresuffering.config.natural_spawn_chance").worldRestart().comment(new String[]{"The Chance of a naturally spawning mob has of spawning during an Invasion.", "NOTE: May affect performance at higher numbers!"}).defineInRange("naturalSpawnChance", 3, 0, 10000);
            this.blessingEffectRespawnDuration = COMMON_BUILDER.translation("puresuffering.config.blessing_effect_respawn_duration").worldRestart().comment("How many ticks the Blessing Effect lasts when respawning.").defineInRange("blessingEffectRespawnDuration", 600, 0, Integer.MAX_VALUE);
            this.blessingEffectDimensionChangeDuration = COMMON_BUILDER.translation("puresuffering.config.blessing_effect_dimension_change_duration").worldRestart().comment("How many ticks the Blessing Effect lasts when changing dimensions.").defineInRange("blessingEffectDimensionChangeDuration", 300, 0, Integer.MAX_VALUE);
            COMMON_BUILDER.pop();
            COMMON_BUILDER.pop();
        }

        private ForgeConfigSpec build() {
            return COMMON_BUILDER.build();
        }
    }
}

