/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.config;

import dev.theagameplayer.puresuffering.config.PSConfig;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class PSConfigValues {
    private static final Logger LOGGER = LogManager.getLogger((String)"puresuffering");
    public static CommonValues common = new CommonValues();
    public static ClientValues client = new ClientValues();

    public static final <C extends PSConfigValues> void resync(C configIn) {
        if (configIn == common) {
            common = new CommonValues();
        } else if (configIn == client) {
            client = new ClientValues();
        } else {
            LOGGER.error("Unknown Config Values: ", configIn);
        }
    }

    public static final class ClientValues
    extends PSConfigValues {
        public final boolean useSkyBoxRenderer;
        public final boolean canInvasionsChangeBrightness;

        private ClientValues() {
            this.useSkyBoxRenderer = (Boolean)PSConfig.ClientConfig.CLIENT.useSkyBoxRenderer.get();
            this.canInvasionsChangeBrightness = (Boolean)PSConfig.ClientConfig.CLIENT.canInvasionsChangeBrightness.get();
        }
    }

    public static final class CommonValues
    extends PSConfigValues {
        public final int primaryInvasionMobCap;
        public final int secondaryInvasionMobCap;
        public final int dayDifficultyIncreaseDelay;
        public final int nightDifficultyIncreaseDelay;
        public final int fixedDifficultyIncreaseDelay;
        public final int maxDayInvasions;
        public final int maxNightInvasions;
        public final int maxFixedInvasions;
        public final boolean multiThreadedInvasions;
        public final boolean consistentInvasions;
        public final boolean tieredInvasions;
        public final List<? extends String> invasionBlacklist;
        public final List<? extends String> primaryWhitelist;
        public final int dayInvasionRarity;
        public final int nightInvasionRarity;
        public final int fixedInvasionRarity;
        public final boolean canDayInvasionsBeCanceled;
        public final boolean canNightInvasionsBeCanceled;
        public final boolean canFixedInvasionsBeCanceled;
        public final double dayCancelChanceMultiplier;
        public final double nightCancelChanceMultiplier;
        public final double fixedCancelChanceMultiplier;
        public final boolean hyperAggression;
        public final List<? extends String> hyperAggressionBlacklist;
        public final List<? extends String> modBiomeBoostedBlacklist;
        public final List<? extends String> mobBiomeBoostedBlacklist;
        public final boolean forceInvasionSleeplessness;
        public final boolean weakenedVexes;
        public final boolean useXPMultiplier;
        public final boolean explosionsDestroyBlocks;
        public final boolean shouldMobsDieAtEndOfInvasions;
        public final boolean shouldMobsSpawnWithMaxRange;
        public final int naturalSpawnChance;
        public final int blessingEffectRespawnDuration;
        public final int blessingEffectDimensionChangeDuration;

        private CommonValues() {
            this.primaryInvasionMobCap = (Integer)PSConfig.CommonConfig.COMMON.primaryInvasionMobCap.get();
            this.secondaryInvasionMobCap = (Integer)PSConfig.CommonConfig.COMMON.secondaryInvasionMobCap.get();
            this.dayDifficultyIncreaseDelay = (Integer)PSConfig.CommonConfig.COMMON.dayDifficultyIncreaseDelay.get();
            this.nightDifficultyIncreaseDelay = (Integer)PSConfig.CommonConfig.COMMON.nightDifficultyIncreaseDelay.get();
            this.fixedDifficultyIncreaseDelay = (Integer)PSConfig.CommonConfig.COMMON.fixedDifficultyIncreaseDelay.get();
            this.maxDayInvasions = (Integer)PSConfig.CommonConfig.COMMON.maxDayInvasions.get();
            this.maxNightInvasions = (Integer)PSConfig.CommonConfig.COMMON.maxNightInvasions.get();
            this.maxFixedInvasions = (Integer)PSConfig.CommonConfig.COMMON.maxFixedInvasions.get();
            this.multiThreadedInvasions = (Boolean)PSConfig.CommonConfig.COMMON.multiThreadedInvasions.get();
            this.consistentInvasions = (Boolean)PSConfig.CommonConfig.COMMON.consistentInvasions.get();
            this.tieredInvasions = (Boolean)PSConfig.CommonConfig.COMMON.tieredInvasions.get();
            this.invasionBlacklist = (List)PSConfig.CommonConfig.COMMON.invasionBlacklist.get();
            this.primaryWhitelist = (List)PSConfig.CommonConfig.COMMON.primaryWhitelist.get();
            this.dayInvasionRarity = (Integer)PSConfig.CommonConfig.COMMON.dayInvasionRarity.get();
            this.nightInvasionRarity = (Integer)PSConfig.CommonConfig.COMMON.nightInvasionRarity.get();
            this.fixedInvasionRarity = (Integer)PSConfig.CommonConfig.COMMON.fixedInvasionRarity.get();
            this.canDayInvasionsBeCanceled = (Boolean)PSConfig.CommonConfig.COMMON.canDayInvasionsBeCanceled.get();
            this.canNightInvasionsBeCanceled = (Boolean)PSConfig.CommonConfig.COMMON.canNightInvasionsBeCanceled.get();
            this.canFixedInvasionsBeCanceled = (Boolean)PSConfig.CommonConfig.COMMON.canFixedInvasionsBeCanceled.get();
            this.dayCancelChanceMultiplier = (Double)PSConfig.CommonConfig.COMMON.dayCancelChanceMultiplier.get();
            this.nightCancelChanceMultiplier = (Double)PSConfig.CommonConfig.COMMON.nightCancelChanceMultiplier.get();
            this.fixedCancelChanceMultiplier = (Double)PSConfig.CommonConfig.COMMON.fixedCancelChanceMultiplier.get();
            this.hyperAggression = (Boolean)PSConfig.CommonConfig.COMMON.hyperAggression.get();
            this.hyperAggressionBlacklist = (List)PSConfig.CommonConfig.COMMON.hyperAggressionBlacklist.get();
            this.modBiomeBoostedBlacklist = (List)PSConfig.CommonConfig.COMMON.modBiomeBoostedBlacklist.get();
            this.mobBiomeBoostedBlacklist = (List)PSConfig.CommonConfig.COMMON.mobBiomeBoostedBlacklist.get();
            this.forceInvasionSleeplessness = (Boolean)PSConfig.CommonConfig.COMMON.forceInvasionSleeplessness.get();
            this.weakenedVexes = (Boolean)PSConfig.CommonConfig.COMMON.weakenedVexes.get();
            this.useXPMultiplier = (Boolean)PSConfig.CommonConfig.COMMON.useXPMultiplier.get();
            this.explosionsDestroyBlocks = (Boolean)PSConfig.CommonConfig.COMMON.explosionsDestroyBlocks.get();
            this.shouldMobsDieAtEndOfInvasions = (Boolean)PSConfig.CommonConfig.COMMON.shouldMobsDieAtEndOfInvasions.get();
            this.shouldMobsSpawnWithMaxRange = (Boolean)PSConfig.CommonConfig.COMMON.shouldMobsSpawnWithMaxRange.get();
            this.naturalSpawnChance = (Integer)PSConfig.CommonConfig.COMMON.naturalSpawnChance.get();
            this.blessingEffectRespawnDuration = (Integer)PSConfig.CommonConfig.COMMON.blessingEffectRespawnDuration.get();
            this.blessingEffectDimensionChangeDuration = (Integer)PSConfig.CommonConfig.COMMON.blessingEffectDimensionChangeDuration.get();
        }
    }
}

