/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.invasion;

import dev.theagameplayer.puresuffering.PSEventManager;
import dev.theagameplayer.puresuffering.config.PSConfigValues;
import dev.theagameplayer.puresuffering.invasion.InvasionType;
import dev.theagameplayer.puresuffering.util.InvasionSpawnerEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.biome.DefaultBiomeMagnifier;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Invasion {
    private static final Logger LOGGER = LogManager.getLogger((String)"puresuffering");
    private static final ArrayList<Biome> MIXED_BIOMES = new ArrayList(ForgeRegistries.BIOMES.getValues());
    private final ArrayList<UUID> invasionMobs = new ArrayList();
    private final InvasionType invasionType;
    private final int severity;
    private final boolean isPrimary;
    private final int mobCap;
    private final boolean shouldTick;
    private final ArrayList<InvasionSpawnerEntity> spawnPotentials = new ArrayList();
    private InvasionSpawnerEntity nextSpawnData = new InvasionSpawnerEntity();
    private int spawnDelay;

    public Invasion(InvasionType invasionTypeIn, int severityIn, boolean isPrimaryIn) {
        InvasionType.SeverityInfo info = invasionTypeIn.getSeverityInfo().get(severityIn);
        int mobCap = isPrimaryIn ? PSConfigValues.common.primaryInvasionMobCap : PSConfigValues.common.secondaryInvasionMobCap;
        this.invasionType = invasionTypeIn;
        this.severity = severityIn;
        this.isPrimary = isPrimaryIn;
        this.mobCap = (int)((float)mobCap * info.getMobCapPercentage()) + 1;
        this.shouldTick = info.getTickDelay() > -1 && (invasionTypeIn.getSpawningSystem() != InvasionType.SpawningSystem.DEFAULT || info.getMobSpawnList() != null && invasionTypeIn.getSpawningSystem() == InvasionType.SpawningSystem.DEFAULT);
    }

    public InvasionType getType() {
        return this.invasionType;
    }

    public int getSeverity() {
        return this.severity;
    }

    public boolean isPrimary() {
        return this.isPrimary;
    }

    public int getMobCap() {
        return this.mobCap;
    }

    public InvasionType.SeverityInfo getSeverityInfo() {
        return this.invasionType.getSeverityInfo().get(this.severity);
    }

    public void tick(ServerWorld worldIn) {
        this.invasionMobs.removeIf(uuid -> worldIn.func_217461_a(uuid) == null || !worldIn.func_217461_a(uuid).func_70089_S());
        switch (this.invasionType.getWeatherType()) {
            case DEFAULT: {
                break;
            }
            case CLEAR: {
                if (!worldIn.func_72896_J() && !worldIn.func_72911_I()) break;
                worldIn.func_241113_a_(600, 0, false, false);
                break;
            }
            case RAIN: {
                if (worldIn.func_72896_J()) break;
                worldIn.func_241113_a_(0, 600, true, false);
                break;
            }
            case THUNDER: {
                if (worldIn.func_72911_I()) break;
                worldIn.func_241113_a_(0, 600, true, true);
            }
        }
        if (this.shouldTick) {
            this.tickEntitySpawn(worldIn);
        }
    }

    protected void tickEntitySpawn(ServerWorld worldIn) {
        if (this.invasionMobs.size() < this.mobCap) {
            if (this.spawnDelay < 0) {
                this.delay(worldIn);
            }
            if (this.spawnDelay > 0) {
                --this.spawnDelay;
                return;
            }
            ChunkPos chunkPos = this.getSpawnChunk(worldIn);
            if (chunkPos == null || !worldIn.func_195588_v(chunkPos.func_206849_h())) {
                return;
            }
            List<MobSpawnInfo.Spawners> mobs = this.getMobSpawnList(worldIn, chunkPos);
            if (mobs.size() < 1) {
                return;
            }
            boolean flag1 = false;
            int clusterSize = worldIn.field_73012_v.nextInt(this.getSeverityInfo().getClusterSize()) + 1;
            for (int cluster = 0; cluster < clusterSize && this.invasionMobs.size() < this.mobCap; ++cluster) {
                MobSpawnInfo.Spawners spawners = mobs.get(worldIn.field_73012_v.nextInt(mobs.size()));
                int groupSize = worldIn.field_73012_v.nextInt(spawners.field_242590_e - spawners.field_242589_d + 1) + spawners.field_242589_d;
                this.nextSpawnData.getTag().func_74778_a("id", ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)spawners.field_242588_c).toString());
                CompoundNBT compoundNBT = this.nextSpawnData.getTag();
                Optional optional = EntityType.func_220347_a((CompoundNBT)compoundNBT);
                if (!optional.isPresent()) {
                    this.delay(worldIn);
                    return;
                }
                for (int count = 0; count < groupSize && this.invasionMobs.size() < this.mobCap; ++count) {
                    BlockPos spawnPos = this.getSpawnPos(worldIn, chunkPos, false);
                    if (spawnPos == null || !EntitySpawnPlacementRegistry.func_223515_a((EntityType)((EntityType)optional.get()), (IServerWorld)worldIn, (SpawnReason)SpawnReason.EVENT, (BlockPos)spawnPos, (Random)worldIn.func_201674_k())) continue;
                    Entity entity = EntityType.func_220335_a((CompoundNBT)compoundNBT, (World)worldIn, e -> {
                        e.func_70012_b((double)spawnPos.func_177958_n(), (double)spawnPos.func_177956_o(), (double)spawnPos.func_177952_p(), e.field_70177_z, e.field_70125_A);
                        return e;
                    });
                    if (entity == null) {
                        this.delay(worldIn);
                        return;
                    }
                    entity.func_70012_b(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), worldIn.field_73012_v.nextFloat() * 360.0f, 0.0f);
                    if (entity instanceof MobEntity) {
                        MobEntity mobEntity = (MobEntity)entity;
                        if (this.nextSpawnData.getTag().func_186856_d() == 1 && this.nextSpawnData.getTag().func_150297_b("id", 8) && !ForgeEventFactory.doSpecialSpawn((MobEntity)mobEntity, (World)worldIn, (float)((float)mobEntity.func_226277_ct_()), (float)((float)mobEntity.func_226278_cu_()), (float)((float)mobEntity.func_226281_cx_()), null, (SpawnReason)SpawnReason.EVENT)) {
                            this.spawnInvasionMob(worldIn, mobEntity);
                        }
                    }
                    if (entity instanceof LightningBoltEntity) {
                        LOGGER.info("LIGHTNING!!!");
                    }
                    if (!worldIn.func_242106_g(entity)) {
                        this.delay(worldIn);
                        return;
                    }
                    flag1 = true;
                }
            }
            if (flag1) {
                this.delay(worldIn);
            }
        }
    }

    protected void spawnInvasionMob(ServerWorld worldIn, MobEntity mobEntityIn) {
        mobEntityIn.getPersistentData().func_74778_a("InvasionMob", this.invasionType.getId().toString());
        mobEntityIn.getPersistentData().func_74757_a("AntiGrief", worldIn.func_230315_m_().func_241514_p_());
        mobEntityIn.func_213386_a((IServerWorld)worldIn, worldIn.func_175649_E(mobEntityIn.func_233580_cy_()), SpawnReason.EVENT, (ILivingEntityData)null, (CompoundNBT)null);
        if (PSConfigValues.common.shouldMobsSpawnWithMaxRange) {
            mobEntityIn.func_110148_a(Attributes.field_233819_b_).func_111128_a(2048.0);
        }
        this.invasionMobs.add(mobEntityIn.func_110124_au());
        worldIn.func_217379_c(2004, mobEntityIn.func_233580_cy_(), 0);
        mobEntityIn.func_70656_aK();
    }

    protected final void delay(ServerWorld worldIn) {
        this.spawnDelay = this.getSeverityInfo().getTickDelay();
        if (!this.spawnPotentials.isEmpty()) {
            this.nextSpawnData = (InvasionSpawnerEntity)WeightedRandom.func_76271_a((Random)worldIn.field_73012_v, this.spawnPotentials);
        }
    }

    protected final List<MobSpawnInfo.Spawners> getMobSpawnList(ServerWorld worldIn, ChunkPos chunkPosIn) {
        BlockPos biomePos = this.getSpawnPos(worldIn, chunkPosIn, true);
        ArrayList<MobSpawnInfo.Spawners> originalList = new ArrayList<MobSpawnInfo.Spawners>(this.getSeverityInfo().getMobSpawnList());
        switch (this.invasionType.getSpawningSystem()) {
            case DEFAULT: {
                break;
            }
            case BIOME_BOOSTED: {
                originalList.addAll(this.getBiomeSpawnList(biomePos, worldIn.func_217349_x(biomePos)));
                break;
            }
            case BIOME_MIXED: {
                originalList.addAll(this.getMixedSpawnList(worldIn));
            }
        }
        ArrayList<MobSpawnInfo.Spawners> newList = new ArrayList<MobSpawnInfo.Spawners>();
        if (!originalList.isEmpty()) {
            for (MobSpawnInfo.Spawners spawners : originalList) {
                for (int w = 0; w < spawners.field_76292_a; ++w) {
                    newList.add(spawners);
                }
            }
        }
        return newList;
    }

    private final ArrayList<MobSpawnInfo.Spawners> getBiomeSpawnList(BlockPos posIn, IChunk chunkIn) {
        ArrayList<MobSpawnInfo.Spawners> spawners = new ArrayList<MobSpawnInfo.Spawners>(DefaultBiomeMagnifier.INSTANCE.func_225532_a_(0L, posIn.func_177958_n(), posIn.func_177956_o(), posIn.func_177952_p(), (BiomeManager.IBiomeReader)chunkIn.func_225549_i_()).func_242433_b().func_242559_a(EntityClassification.MONSTER));
        spawners.removeIf(spawner -> {
            ResourceLocation name = spawner.field_242588_c.getRegistryName();
            return PSConfigValues.common.modBiomeBoostedBlacklist.contains(name.func_110624_b()) || PSConfigValues.common.mobBiomeBoostedBlacklist.contains(name.toString());
        });
        return spawners;
    }

    private final ArrayList<MobSpawnInfo.Spawners> getMixedSpawnList(ServerWorld worldIn) {
        ArrayList<MobSpawnInfo.Spawners> spawners = new ArrayList<MobSpawnInfo.Spawners>(MIXED_BIOMES.get(worldIn.field_73012_v.nextInt(MIXED_BIOMES.size())).func_242433_b().func_242559_a(EntityClassification.MONSTER));
        spawners.removeIf(spawner -> {
            ResourceLocation name = spawner.field_242588_c.getRegistryName();
            return PSConfigValues.common.modBiomeBoostedBlacklist.contains(name.func_110624_b()) || PSConfigValues.common.mobBiomeBoostedBlacklist.contains(name.toString());
        });
        return spawners;
    }

    private final ChunkPos getSpawnChunk(ServerWorld worldIn) {
        int players = worldIn.func_217369_A().size();
        if (players < 1) {
            return null;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)worldIn.func_217369_A().get(worldIn.field_73012_v.nextInt(players));
        ChunkPos chunkPos = worldIn.func_217349_x(player.func_233580_cy_()).func_76632_l();
        int chunkX = chunkPos.field_77276_a - 8 + worldIn.field_73012_v.nextInt(17);
        int chunkZ = chunkPos.field_77275_b - 8 + worldIn.field_73012_v.nextInt(17);
        boolean flag = chunkPos.field_77276_a == chunkX && chunkPos.field_77275_b == chunkZ;
        ChunkPos chunkPos1 = new ChunkPos(flag ? chunkX + this.getChunkOffset(worldIn) : chunkX, flag ? chunkZ + this.getChunkOffset(worldIn) : chunkZ);
        return chunkPos1;
    }

    private final int getChunkOffset(ServerWorld worldIn) {
        int offSet = worldIn.field_73012_v.nextInt(8) + 1;
        return worldIn.field_73012_v.nextBoolean() ? offSet : -offSet;
    }

    protected final BlockPos getSpawnPos(ServerWorld worldIn, ChunkPos chunkPosIn, boolean biomeCheckIn) {
        int x = chunkPosIn.func_180334_c() + worldIn.field_73012_v.nextInt(16);
        int z = chunkPosIn.func_180333_d() + worldIn.field_73012_v.nextInt(16);
        int surface = worldIn.func_201676_a(Heightmap.Type.WORLD_SURFACE, x, z) + 1;
        if (biomeCheckIn || !worldIn.func_230315_m_().func_236037_d_() && worldIn.field_73012_v.nextBoolean()) {
            return new BlockPos(x, surface, z);
        }
        BlockState air = Blocks.field_150350_a.func_176223_P();
        BlockState bedrock = Blocks.field_150357_h.func_176223_P();
        ArrayList<BlockPos> potentialPos = new ArrayList<BlockPos>();
        for (int y = 0; y < surface; ++y) {
            BlockPos pos = new BlockPos(x, y, z);
            if (worldIn.func_180495_p(pos) == air || worldIn.func_180495_p(pos) == bedrock || worldIn.func_180495_p(pos.func_177984_a()) != air) continue;
            potentialPos.add(pos.func_177984_a());
        }
        return potentialPos.size() > 0 ? (BlockPos)potentialPos.get(worldIn.field_73012_v.nextInt(potentialPos.size())) : new BlockPos(x, surface, z);
    }

    @Nullable
    public static Invasion load(CompoundNBT nbtIn) {
        if (PSEventManager.BaseEvents.getInvasionTypeManager().verifyInvasion(nbtIn.func_74779_i("InvasionType"))) {
            InvasionType invasionType = PSEventManager.BaseEvents.getInvasionTypeManager().getInvasionType(ResourceLocation.func_208304_a((String)nbtIn.func_74779_i("InvasionType")));
            Invasion invasion = new Invasion(invasionType, nbtIn.func_74762_e("Severity"), nbtIn.func_74767_n("IsPrimary"));
            CompoundNBT invasionMobs = nbtIn.func_74775_l("InvasionMobs");
            for (String name : invasionMobs.func_150296_c()) {
                invasion.invasionMobs.add(invasionMobs.func_186857_a(name));
            }
            return invasion;
        }
        return null;
    }

    public CompoundNBT save() {
        CompoundNBT nbt = new CompoundNBT();
        CompoundNBT mobs = new CompoundNBT();
        for (UUID id : this.invasionMobs) {
            mobs.func_186854_a(id.toString(), id);
        }
        nbt.func_218657_a("InvasionMobs", (INBT)mobs);
        nbt.func_74778_a("InvasionType", this.invasionType.toString());
        nbt.func_74768_a("Severity", this.severity);
        nbt.func_74757_a("IsPrimary", this.isPrimary);
        return nbt;
    }

    public String toString() {
        return this.invasionType.toString();
    }
}

