/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.invasion;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.theagameplayer.puresuffering.client.renderer.InvasionSkyRenderer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class InvasionType {
    private final ResourceLocation id;
    private final int rarity;
    private final int tier;
    private final InvasionTime invasionTime;
    private final InvasionPriority invasionPriority;
    private final SpawningSystem spawningSystem;
    private final TimeModifier timeModifier;
    private final TimeChangeability timeChangeability;
    private final WeatherType weatherType;
    private final List<SeverityInfo> severityInfo;
    private final List<ResourceLocation> dimensions;
    private final ITextComponent component;

    public InvasionType(ResourceLocation idIn, int rarityIn, int tierIn, InvasionTime invasionTimeIn, InvasionPriority invasionPriorityIn, SpawningSystem spawningSystemIn, TimeModifier timeModifierIn, TimeChangeability timeChangeabilityIn, WeatherType weatherTypeIn, List<SeverityInfo> severityInfoIn, List<ResourceLocation> dimensionsIn) {
        this.id = idIn;
        this.rarity = rarityIn;
        this.tier = tierIn;
        this.invasionTime = invasionTimeIn;
        this.invasionPriority = invasionPriorityIn;
        this.spawningSystem = spawningSystemIn;
        this.timeModifier = timeModifierIn;
        this.timeChangeability = timeChangeabilityIn;
        this.weatherType = weatherTypeIn;
        this.severityInfo = severityInfoIn;
        this.dimensions = dimensionsIn;
        String text = "invasion." + idIn.func_110624_b() + "." + idIn.func_110623_a();
        TranslationTextComponent component = new TranslationTextComponent(text);
        this.component = component.getString().equals(text) ? new StringTextComponent(this.formatDefaultText(idIn)) : component;
    }

    private String formatDefaultText(ResourceLocation idIn) {
        String str = idIn.func_110623_a().replace('_', ' ');
        if (str == null || str.length() == 0) {
            return str;
        }
        char[] buffer = str.toCharArray();
        boolean capitalizeNext = true;
        for (int i = 0; i < buffer.length; ++i) {
            char ch = buffer[i];
            if (Character.isWhitespace(ch)) {
                capitalizeNext = true;
                continue;
            }
            if (!capitalizeNext) continue;
            buffer[i] = Character.toTitleCase(ch);
            capitalizeNext = false;
        }
        return new String(buffer);
    }

    public Builder deconstruct() {
        ArrayList<SeverityInfo.Builder> severityInfo = new ArrayList<SeverityInfo.Builder>();
        for (SeverityInfo info : this.severityInfo) {
            severityInfo.add(info.deconstruct());
        }
        return new Builder(this.rarity, this.tier, this.invasionTime, this.invasionPriority, this.spawningSystem, this.timeModifier, this.timeChangeability, this.weatherType, severityInfo, this.dimensions);
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public int getRarity() {
        return this.rarity;
    }

    public int getTier() {
        return this.tier;
    }

    public InvasionTime getInvasionTime() {
        return this.invasionTime;
    }

    public InvasionPriority getInvasionPriority() {
        return this.invasionPriority;
    }

    public SpawningSystem getSpawningSystem() {
        return this.spawningSystem;
    }

    public TimeModifier getTimeModifier() {
        return this.timeModifier;
    }

    public TimeChangeability getTimeChangeability() {
        return this.timeChangeability;
    }

    public WeatherType getWeatherType() {
        return this.weatherType;
    }

    public List<SeverityInfo> getSeverityInfo() {
        return this.severityInfo;
    }

    public List<ResourceLocation> getDimensions() {
        return this.dimensions;
    }

    public ITextComponent getComponent() {
        return this.component;
    }

    public int getMaxSeverity() {
        return this.severityInfo.isEmpty() ? 1 : this.severityInfo.size();
    }

    public String toString() {
        return this.getId().toString();
    }

    public static class Builder {
        private static final Logger LOGGER = LogManager.getLogger((String)"puresuffering");
        private int rarity = 0;
        private int tier = 0;
        private InvasionTime invasionTime;
        private InvasionPriority invasionPriority = InvasionPriority.BOTH;
        private SpawningSystem spawningSystem = SpawningSystem.DEFAULT;
        private TimeModifier timeModifier = TimeModifier.NONE;
        private TimeChangeability timeChangeability = TimeChangeability.DEFAULT;
        private WeatherType weatherType = WeatherType.DEFAULT;
        private List<SeverityInfo.Builder> severityInfo;
        private List<ResourceLocation> dimensions;

        private Builder(int rarityIn, int tierIn, InvasionTime invasionTimeIn, InvasionPriority invasionPriorityIn, SpawningSystem spawningSystemIn, TimeModifier timeModifierIn, TimeChangeability timeChangeabilityIn, WeatherType weatherTypeIn, List<SeverityInfo.Builder> severityInfoIn, List<ResourceLocation> dimensionsIn) {
            this.rarity = rarityIn;
            this.tier = tierIn;
            this.invasionTime = invasionTimeIn;
            this.invasionPriority = invasionPriorityIn;
            this.spawningSystem = spawningSystemIn;
            this.timeModifier = timeModifierIn;
            this.timeChangeability = timeChangeabilityIn;
            this.weatherType = weatherTypeIn;
            this.severityInfo = severityInfoIn;
            this.dimensions = dimensionsIn;
        }

        private Builder() {
        }

        public static Builder invasionType() {
            return new Builder();
        }

        public Builder withRarity(int rarityIn) {
            this.rarity = rarityIn;
            return this;
        }

        public Builder withTier(int tierIn) {
            this.tier = tierIn;
            return this;
        }

        public Builder withInvasionTime(InvasionTime invasionTimeIn) {
            this.invasionTime = invasionTimeIn;
            return this;
        }

        public Builder withInvasionPriority(InvasionPriority invasionPriorityIn) {
            this.invasionPriority = invasionPriorityIn;
            return this;
        }

        public Builder withSpawningSystem(SpawningSystem spawningSystemIn) {
            this.spawningSystem = spawningSystemIn;
            return this;
        }

        public Builder withTimeModifier(TimeModifier timeModifierIn) {
            this.timeModifier = timeModifierIn;
            return this;
        }

        public Builder withTimeChangeability(TimeChangeability timeChangeabilityIn) {
            this.timeChangeability = timeChangeabilityIn;
            return this;
        }

        public Builder withWeatherType(WeatherType weatherTypeIn) {
            this.weatherType = weatherTypeIn;
            return this;
        }

        public Builder severityInfo(List<SeverityInfo.Builder> severityInfoIn) {
            this.severityInfo = severityInfoIn;
            return this;
        }

        public Builder dimensions(List<ResourceLocation> dimensionsIn) {
            this.dimensions = dimensionsIn;
            return this;
        }

        public InvasionType save(Consumer<InvasionType> consumerIn, String pathIn) {
            InvasionType invasionType = this.build(new ResourceLocation("puresuffering", pathIn));
            consumerIn.accept(invasionType);
            return invasionType;
        }

        public InvasionType build(ResourceLocation idIn) {
            ArrayList<SeverityInfo> severityInfo = new ArrayList<SeverityInfo>();
            if (this.severityInfo != null) {
                for (SeverityInfo.Builder builder : this.severityInfo) {
                    severityInfo.add(builder.build(idIn));
                }
            }
            return new InvasionType(idIn, this.rarity, this.tier, this.invasionTime, this.invasionPriority, this.spawningSystem, this.timeModifier, this.timeChangeability, this.weatherType, severityInfo, this.dimensions);
        }

        public JsonObject serializeToJson() {
            JsonArray jsonArray;
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("Rarity", (Number)this.rarity);
            jsonObject.addProperty("Tier", (Number)this.tier);
            jsonObject.addProperty("InvasionTime", this.invasionTime.toString());
            jsonObject.addProperty("InvasionPriority", this.invasionPriority.toString());
            jsonObject.addProperty("SpawningSystem", this.spawningSystem.toString());
            if (this.invasionTime != InvasionTime.DAY && this.timeModifier != TimeModifier.DAY_TO_NIGHT || this.invasionTime != InvasionTime.NIGHT && this.timeModifier != TimeModifier.NIGHT_TO_DAY || this.timeModifier == TimeModifier.NONE) {
                jsonObject.addProperty("TimeModifier", this.timeModifier.toString());
            }
            if (this.invasionTime != InvasionTime.DAY && this.timeChangeability != TimeChangeability.ONLY_DAY || this.invasionTime != InvasionTime.NIGHT && this.timeChangeability != TimeChangeability.ONLY_NIGHT || this.timeChangeability == TimeChangeability.DEFAULT) {
                jsonObject.addProperty("TimeChangeability", this.timeChangeability.toString());
            }
            jsonObject.addProperty("WeatherType", this.weatherType.toString());
            if (this.severityInfo != null) {
                jsonArray = new JsonArray();
                for (SeverityInfo.Builder builder : this.severityInfo) {
                    jsonArray.add((JsonElement)builder.serializeToJson());
                }
                jsonObject.add("SeverityInfo", (JsonElement)jsonArray);
            }
            if (this.dimensions != null) {
                jsonArray = new JsonArray();
                for (ResourceLocation id : this.dimensions) {
                    jsonArray.add(id.toString());
                }
                jsonObject.add("Dimensions", (JsonElement)jsonArray);
            }
            return jsonObject;
        }

        public static Builder fromJson(JsonObject jsonObjectIn) {
            int rarity = jsonObjectIn.get("Rarity").getAsInt();
            int tier = jsonObjectIn.get("Tier").getAsInt();
            InvasionTime invasionTime = null;
            for (InvasionTime time : InvasionTime.values()) {
                if (!time.toString().equals(jsonObjectIn.get("InvasionTime").getAsString())) continue;
                invasionTime = time;
                break;
            }
            InvasionPriority invasionPriority = null;
            for (InvasionPriority order : InvasionPriority.values()) {
                if (!order.toString().equals(jsonObjectIn.get("InvasionPriority").getAsString())) continue;
                invasionPriority = order;
                break;
            }
            SpawningSystem spawningSystem = null;
            for (SpawningSystem system : SpawningSystem.values()) {
                if (!system.toString().equals(jsonObjectIn.get("SpawningSystem").getAsString())) continue;
                spawningSystem = system;
                break;
            }
            TimeModifier timeModifier = null;
            for (TimeModifier modifier : TimeModifier.values()) {
                if (!modifier.toString().equals(jsonObjectIn.get("TimeModifier").getAsString()) || !(invasionTime != InvasionTime.DAY && modifier != TimeModifier.DAY_TO_NIGHT || invasionTime != InvasionTime.NIGHT && modifier != TimeModifier.NIGHT_TO_DAY) && modifier != TimeModifier.NONE) continue;
                timeModifier = modifier;
                break;
            }
            TimeChangeability timeChangeability = null;
            for (TimeChangeability changeability : TimeChangeability.values()) {
                if (!changeability.toString().equals(jsonObjectIn.get("TimeChangeability").getAsString()) || !(invasionTime != InvasionTime.DAY && changeability != TimeChangeability.ONLY_DAY || invasionTime != InvasionTime.NIGHT && changeability != TimeChangeability.ONLY_NIGHT) && changeability != TimeChangeability.DEFAULT) continue;
                timeChangeability = changeability;
                break;
            }
            WeatherType weatherType = null;
            for (WeatherType weather : WeatherType.values()) {
                if (!weather.toString().equals(jsonObjectIn.get("WeatherType").getAsString())) continue;
                weatherType = weather;
                break;
            }
            ArrayList<SeverityInfo.Builder> severityInfo = new ArrayList<SeverityInfo.Builder>();
            boolean errored = false;
            JsonArray jsonElement = jsonObjectIn.getAsJsonArray("SeverityInfo");
            if (jsonElement != null) {
                if (jsonElement.isJsonArray()) {
                    JsonArray jsonArray = jsonElement.getAsJsonArray();
                    for (int info = 0; info < jsonArray.size(); ++info) {
                        JsonElement jsonElement1 = jsonArray.get(info);
                        if (!jsonElement1.isJsonObject()) {
                            errored = true;
                            break;
                        }
                        severityInfo.add(SeverityInfo.Builder.fromJson(jsonElement1.getAsJsonObject()));
                    }
                } else {
                    errored = true;
                }
            }
            ArrayList<ResourceLocation> dimensions = new ArrayList<ResourceLocation>();
            JsonArray jsonElement2 = jsonObjectIn.getAsJsonArray("Dimensions");
            if (jsonElement2 != null) {
                if (jsonElement2.isJsonArray()) {
                    JsonArray jsonArray = jsonElement2.getAsJsonArray();
                    for (int dim = 0; dim < jsonArray.size(); ++dim) {
                        dimensions.add(ResourceLocation.func_208304_a((String)jsonArray.get(dim).getAsString()));
                    }
                } else {
                    errored = true;
                }
            }
            if (invasionTime == null || invasionPriority == null || spawningSystem == null || timeModifier == null || timeChangeability == null || weatherType == null || errored) {
                LOGGER.error("JsonElement is incorrectly setup: " + jsonObjectIn.toString() + ". Therefore InvasionType wasn't registered! Most likely a datapack error?");
            }
            return new Builder(rarity, tier, invasionTime, invasionPriority, spawningSystem, timeModifier, timeChangeability, weatherType, severityInfo, dimensions);
        }
    }

    public static class SeverityInfo {
        private final InvasionSkyRenderer skyRenderer;
        private final List<MobSpawnInfo.Spawners> mobSpawnList;
        private final float mobCapPercentage;
        private final boolean forceNoSleep;
        private final int lightLevel;
        private final int tickDelay;
        private final int clusterSize;

        private SeverityInfo(InvasionSkyRenderer skyRendererIn, List<MobSpawnInfo.Spawners> mobSpawnListIn, float mobCapPercentageIn, boolean forceNoSleepIn, int lightLevelIn, int tickDelayIn, int clusterSizeIn) {
            this.skyRenderer = skyRendererIn;
            this.mobSpawnList = mobSpawnListIn;
            this.mobCapPercentage = mobCapPercentageIn;
            this.forceNoSleep = forceNoSleepIn;
            this.lightLevel = lightLevelIn;
            this.tickDelay = tickDelayIn;
            this.clusterSize = clusterSizeIn;
        }

        public Builder deconstruct() {
            return new Builder(this.skyRenderer == null ? null : this.skyRenderer.deconstruct(), this.mobSpawnList, this.mobCapPercentage, this.forceNoSleep, this.lightLevel, this.tickDelay, this.clusterSize);
        }

        public InvasionSkyRenderer getSkyRenderer() {
            return this.skyRenderer;
        }

        public List<MobSpawnInfo.Spawners> getMobSpawnList() {
            return this.mobSpawnList;
        }

        public float getMobCapPercentage() {
            return this.mobCapPercentage;
        }

        public boolean forcesNoSleep() {
            return this.forceNoSleep;
        }

        public int getLightLevel() {
            return this.lightLevel;
        }

        public int getTickDelay() {
            return this.tickDelay;
        }

        public int getClusterSize() {
            return this.clusterSize;
        }

        public static class Builder {
            private static final Logger LOGGER = LogManager.getLogger((String)"puresuffering");
            private InvasionSkyRenderer.Builder skyRenderer = null;
            private List<MobSpawnInfo.Spawners> mobSpawnList;
            private float mobCapPercentage = 1.0f;
            private boolean forceNoSleep = false;
            private int lightLevel = -1;
            private int tickDelay = 6;
            private int clusterSize = 1;

            private Builder(InvasionSkyRenderer.Builder skyRendererIn, List<MobSpawnInfo.Spawners> mobSpawnListIn, float mobCapPercentageIn, boolean forceNoSleepIn, int lightLevelIn, int tickDelayIn, int clusterSizeIn) {
                this.skyRenderer = skyRendererIn;
                this.mobSpawnList = mobSpawnListIn;
                this.mobCapPercentage = mobCapPercentageIn;
                this.forceNoSleep = forceNoSleepIn;
                this.lightLevel = lightLevelIn;
                this.tickDelay = tickDelayIn;
                this.clusterSize = clusterSizeIn;
            }

            private Builder() {
            }

            public static Builder severityInfo() {
                return new Builder();
            }

            public Builder skyRenderer(InvasionSkyRenderer.Builder skyRendererIn) {
                this.skyRenderer = skyRendererIn;
                return this;
            }

            public Builder mobSpawnList(List<MobSpawnInfo.Spawners> mobSpawnListIn) {
                this.mobSpawnList = mobSpawnListIn;
                return this;
            }

            public Builder setMobCapMultiplier(float mobCapPercentageIn) {
                this.mobCapPercentage = mobCapPercentageIn;
                return this;
            }

            public Builder setForcesNoSleep() {
                this.forceNoSleep = true;
                return this;
            }

            public Builder withLightLevel(int lightLevelIn) {
                this.lightLevel = lightLevelIn;
                return this;
            }

            public Builder withTickDelay(int tickDelayIn) {
                this.tickDelay = tickDelayIn;
                return this;
            }

            public Builder withClusterSize(int clusterSizeIn) {
                this.clusterSize = clusterSizeIn;
                return this;
            }

            public SeverityInfo build(ResourceLocation idIn) {
                return new SeverityInfo(this.skyRenderer == null ? null : this.skyRenderer.build(idIn), this.mobSpawnList, this.mobCapPercentage, this.forceNoSleep, this.lightLevel, this.tickDelay, this.clusterSize);
            }

            public JsonObject serializeToJson() {
                JsonObject jsonObject = new JsonObject();
                if (this.skyRenderer != null) {
                    jsonObject.add("SkyRenderer", (JsonElement)this.skyRenderer.serializeToJson());
                }
                if (this.mobSpawnList != null) {
                    JsonArray jsonArray = new JsonArray();
                    for (MobSpawnInfo.Spawners spawnInfo : this.mobSpawnList) {
                        JsonObject jsonObject1 = new JsonObject();
                        jsonObject1.addProperty("EntityType", ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)spawnInfo.field_242588_c).toString());
                        jsonObject1.addProperty("Weight", (Number)spawnInfo.field_76292_a);
                        jsonObject1.addProperty("MinCount", (Number)spawnInfo.field_242589_d);
                        jsonObject1.addProperty("MaxCount", (Number)spawnInfo.field_242590_e);
                        jsonArray.add((JsonElement)jsonObject1);
                    }
                    jsonObject.add("MobSpawnList", (JsonElement)jsonArray);
                }
                jsonObject.addProperty("MobCapPercentage", (Number)Float.valueOf(this.mobCapPercentage));
                jsonObject.addProperty("ForceNoSleep", Boolean.valueOf(this.forceNoSleep));
                if (this.lightLevel > -1) {
                    jsonObject.addProperty("LightLevel", (Number)this.lightLevel);
                }
                jsonObject.addProperty("TickDelay", (Number)this.tickDelay);
                jsonObject.addProperty("ClusterSize", (Number)this.clusterSize);
                return jsonObject;
            }

            public static Builder fromJson(JsonObject jsonObjectIn) {
                JsonArray jsonElement1;
                InvasionSkyRenderer.Builder skyRenderer = null;
                ArrayList<MobSpawnInfo.Spawners> mobSpawnList = new ArrayList<MobSpawnInfo.Spawners>();
                float mobCapPercentage = MathHelper.func_76131_a((float)jsonObjectIn.get("MobCapPercentage").getAsFloat(), (float)0.0f, (float)1.0f);
                boolean forceNoSleep = jsonObjectIn.get("ForceNoSleep").getAsBoolean();
                int lightLevel = jsonObjectIn.has("LightLevel") ? MathHelper.func_76125_a((int)jsonObjectIn.get("LightLevel").getAsInt(), (int)0, (int)15) : -1;
                int tickDelay = jsonObjectIn.get("TickDelay").getAsInt();
                int clusterSize = jsonObjectIn.get("ClusterSize").getAsInt();
                boolean errored = false;
                JsonObject jsonElement = jsonObjectIn.getAsJsonObject("SkyRenderer");
                if (jsonElement != null) {
                    if (jsonElement.isJsonObject()) {
                        skyRenderer = InvasionSkyRenderer.Builder.fromJson(jsonElement.getAsJsonObject());
                    } else {
                        errored = true;
                    }
                }
                if ((jsonElement1 = jsonObjectIn.getAsJsonArray("MobSpawnList")) != null) {
                    if (jsonElement1.isJsonArray()) {
                        JsonArray jsonArray = jsonElement1.getAsJsonArray();
                        for (JsonElement jsonElement2 : jsonArray) {
                            if (jsonElement2.isJsonObject()) {
                                JsonObject jsonObject = jsonElement2.getAsJsonObject();
                                EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(ResourceLocation.func_208304_a((String)jsonObject.get("EntityType").getAsString()));
                                int weight = jsonObject.get("Weight").getAsInt();
                                int minCount = jsonObject.get("MinCount").getAsInt();
                                int maxCount = jsonObject.get("MaxCount").getAsInt();
                                mobSpawnList.add(new MobSpawnInfo.Spawners(type, weight, minCount, maxCount));
                                continue;
                            }
                            errored = true;
                            break;
                        }
                    } else {
                        errored = true;
                    }
                }
                if (errored) {
                    LOGGER.error("JsonElement is incorrectly setup: " + jsonObjectIn.toString() + ". Therefore InvasionType wasn't registered! Most likely a datapack error?");
                }
                return new Builder(skyRenderer, mobSpawnList, mobCapPercentage, forceNoSleep, lightLevel, tickDelay, clusterSize);
            }
        }
    }

    public static enum WeatherType {
        DEFAULT,
        CLEAR,
        RAIN,
        THUNDER;

    }

    public static enum TimeChangeability {
        DEFAULT,
        ONLY_NIGHT,
        ONLY_DAY;

    }

    public static enum TimeModifier {
        NONE,
        DAY_TO_NIGHT,
        NIGHT_TO_DAY;

    }

    public static enum SpawningSystem {
        DEFAULT,
        BIOME_BOOSTED,
        BIOME_MIXED;

    }

    public static enum InvasionPriority {
        BOTH,
        PRIMARY_ONLY,
        SECONDARY_ONLY;

    }

    public static enum InvasionTime {
        BOTH,
        NIGHT,
        DAY;

    }
}

