/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.network.packet;

import dev.theagameplayer.puresuffering.client.renderer.InvasionSkyRenderer;
import dev.theagameplayer.puresuffering.util.InvasionListType;
import dev.theagameplayer.puresuffering.world.ClientInvasionWorldInfo;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public final class RemoveInvasionPacket {
    private final InvasionSkyRenderer renderer;
    private final InvasionListType listType;

    public RemoveInvasionPacket(InvasionSkyRenderer rendererIn, InvasionListType listTypeIn) {
        this.renderer = rendererIn;
        this.listType = listTypeIn;
    }

    public static void encode(RemoveInvasionPacket msgIn, PacketBuffer bufIn) {
        msgIn.renderer.deconstruct().serializeToNetwork(bufIn);
        bufIn.func_192572_a(msgIn.renderer.getId());
        bufIn.func_179249_a((Enum)msgIn.listType);
    }

    public static RemoveInvasionPacket decode(PacketBuffer bufIn) {
        InvasionSkyRenderer renderer = InvasionSkyRenderer.Builder.fromNetwork(bufIn).build(bufIn.func_192575_l());
        return new RemoveInvasionPacket(renderer, (InvasionListType)bufIn.func_179257_a(InvasionListType.class));
    }

    public static class Handler {
        public static boolean handle(RemoveInvasionPacket msgIn, Supplier<NetworkEvent.Context> ctxIn) {
            ctxIn.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> Handler.lambda$null$1(msgIn, (Supplier)ctxIn)));
            return true;
        }

        private static void handlePacket(RemoveInvasionPacket msgIn, Supplier<NetworkEvent.Context> ctxIn) {
            Minecraft mc = Minecraft.func_71410_x();
            switch (msgIn.listType) {
                case DAY: {
                    ClientInvasionWorldInfo.getDayClientInfo(mc.field_71441_e).getRendererMap().remove(msgIn.renderer);
                    break;
                }
                case NIGHT: {
                    ClientInvasionWorldInfo.getNightClientInfo(mc.field_71441_e).getRendererMap().remove(msgIn.renderer);
                    break;
                }
                case FIXED: {
                    ClientInvasionWorldInfo.getFixedClientInfo(mc.field_71441_e).getRendererMap().remove(msgIn.renderer);
                }
            }
        }

        private static /* synthetic */ Runnable lambda$null$1(RemoveInvasionPacket msgIn, Supplier ctxIn) {
            return () -> Handler.lambda$null$0(msgIn, (Supplier)ctxIn);
        }

        private static /* synthetic */ void lambda$null$0(RemoveInvasionPacket msgIn, Supplier ctxIn) {
            Handler.handlePacket(msgIn, ctxIn);
        }
    }
}

