/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.network.packet;

import dev.theagameplayer.puresuffering.util.InvasionListType;
import dev.theagameplayer.puresuffering.world.ClientInvasionWorldInfo;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public final class UpdateCountPacket {
    private final int count;
    private final InvasionListType listType;

    public UpdateCountPacket(int countIn, InvasionListType listTypeIn) {
        this.count = countIn;
        this.listType = listTypeIn;
    }

    public static void encode(UpdateCountPacket msgIn, PacketBuffer bufIn) {
        bufIn.writeInt(msgIn.count);
        bufIn.func_179249_a((Enum)msgIn.listType);
    }

    public static UpdateCountPacket decode(PacketBuffer bufIn) {
        return new UpdateCountPacket(bufIn.readInt(), (InvasionListType)bufIn.func_179257_a(InvasionListType.class));
    }

    public static class Handler {
        public static boolean handle(UpdateCountPacket msgIn, Supplier<NetworkEvent.Context> ctxIn) {
            ctxIn.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> Handler.lambda$null$1(msgIn, (Supplier)ctxIn)));
            return true;
        }

        private static void handlePacket(UpdateCountPacket msgIn, Supplier<NetworkEvent.Context> ctxIn) {
            Minecraft mc = Minecraft.func_71410_x();
            switch (msgIn.listType) {
                case DAY: {
                    ClientInvasionWorldInfo.getDayClientInfo(mc.field_71441_e).setInvasionsCount(msgIn.count);
                    break;
                }
                case NIGHT: {
                    ClientInvasionWorldInfo.getNightClientInfo(mc.field_71441_e).setInvasionsCount(msgIn.count);
                    break;
                }
                case FIXED: {
                    ClientInvasionWorldInfo.getFixedClientInfo(mc.field_71441_e).setInvasionsCount(msgIn.count);
                }
            }
        }

        private static /* synthetic */ Runnable lambda$null$1(UpdateCountPacket msgIn, Supplier ctxIn) {
            return () -> Handler.lambda$null$0(msgIn, (Supplier)ctxIn);
        }

        private static /* synthetic */ void lambda$null$0(UpdateCountPacket msgIn, Supplier ctxIn) {
            Handler.handlePacket(msgIn, ctxIn);
        }
    }
}

