/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.network.packet;

import dev.theagameplayer.puresuffering.world.ClientInvasionWorldInfo;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public final class UpdateTimePacket {
    private final boolean isDay;
    private final boolean isTime;

    public UpdateTimePacket(boolean isDayIn, boolean isTimeIn) {
        this.isDay = isDayIn;
        this.isTime = isTimeIn;
    }

    public static void encode(UpdateTimePacket msgIn, PacketBuffer bufIn) {
        bufIn.writeBoolean(msgIn.isDay);
        bufIn.writeBoolean(msgIn.isTime);
    }

    public static UpdateTimePacket decode(PacketBuffer bufIn) {
        return new UpdateTimePacket(bufIn.readBoolean(), bufIn.readBoolean());
    }

    public static class Handler {
        public static boolean handle(UpdateTimePacket msgIn, Supplier<NetworkEvent.Context> ctxIn) {
            ctxIn.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> Handler.lambda$null$1(msgIn, (Supplier)ctxIn)));
            return true;
        }

        private static void handlePacket(UpdateTimePacket msgIn, Supplier<NetworkEvent.Context> ctxIn) {
            Minecraft mc = Minecraft.func_71410_x();
            if (msgIn.isDay) {
                ClientInvasionWorldInfo.getDayClientInfo(mc.field_71441_e).updateClientTime(msgIn.isTime);
            } else {
                ClientInvasionWorldInfo.getNightClientInfo(mc.field_71441_e).updateClientTime(msgIn.isTime);
            }
        }

        private static /* synthetic */ Runnable lambda$null$1(UpdateTimePacket msgIn, Supplier ctxIn) {
            return () -> Handler.lambda$null$0(msgIn, (Supplier)ctxIn);
        }

        private static /* synthetic */ void lambda$null$0(UpdateTimePacket msgIn, Supplier ctxIn) {
            Handler.handlePacket(msgIn, ctxIn);
        }
    }
}

