/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.network.packet;

import dev.theagameplayer.puresuffering.util.InvasionListType;
import dev.theagameplayer.puresuffering.world.ClientInvasionWorldInfo;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public final class UpdateXPMultPacket {
    private final double xpMult;
    private final InvasionListType listType;

    public UpdateXPMultPacket(double xpMultIn, InvasionListType listTypeIn) {
        this.xpMult = xpMultIn;
        this.listType = listTypeIn;
    }

    public static void encode(UpdateXPMultPacket msgIn, PacketBuffer bufIn) {
        bufIn.writeDouble(msgIn.xpMult);
        bufIn.func_179249_a((Enum)msgIn.listType);
    }

    public static UpdateXPMultPacket decode(PacketBuffer bufIn) {
        return new UpdateXPMultPacket(bufIn.readDouble(), (InvasionListType)bufIn.func_179257_a(InvasionListType.class));
    }

    public static class Handler {
        public static boolean handle(UpdateXPMultPacket msgIn, Supplier<NetworkEvent.Context> ctxIn) {
            ctxIn.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> Handler.lambda$null$1(msgIn, (Supplier)ctxIn)));
            return true;
        }

        private static void handlePacket(UpdateXPMultPacket msgIn, Supplier<NetworkEvent.Context> ctxIn) {
            Minecraft mc = Minecraft.func_71410_x();
            switch (msgIn.listType) {
                case DAY: {
                    ClientInvasionWorldInfo.getDayClientInfo(mc.field_71441_e).setXPMultiplier(msgIn.xpMult);
                    break;
                }
                case NIGHT: {
                    ClientInvasionWorldInfo.getNightClientInfo(mc.field_71441_e).setXPMultiplier(msgIn.xpMult);
                    break;
                }
                case FIXED: {
                    ClientInvasionWorldInfo.getFixedClientInfo(mc.field_71441_e).setXPMultiplier(msgIn.xpMult);
                }
            }
        }

        private static /* synthetic */ Runnable lambda$null$1(UpdateXPMultPacket msgIn, Supplier ctxIn) {
            return () -> Handler.lambda$null$0(msgIn, (Supplier)ctxIn);
        }

        private static /* synthetic */ void lambda$null$0(UpdateXPMultPacket msgIn, Supplier ctxIn) {
            Handler.handlePacket(msgIn, ctxIn);
        }
    }
}

