/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.spawner;

import dev.theagameplayer.puresuffering.PSEventManager;
import dev.theagameplayer.puresuffering.config.PSConfigValues;
import dev.theagameplayer.puresuffering.invasion.Invasion;
import dev.theagameplayer.puresuffering.invasion.InvasionType;
import dev.theagameplayer.puresuffering.util.InvasionChart;
import dev.theagameplayer.puresuffering.util.InvasionList;
import dev.theagameplayer.puresuffering.util.InvasionListType;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.server.ServerWorld;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class FixedInvasionSpawner {
    private static final Logger LOGGER = LogManager.getLogger((String)"puresuffering");
    private final InvasionList invasions = new InvasionList(InvasionListType.FIXED);
    private final ArrayList<Invasion> queuedInvasions = new ArrayList();
    private int interval;

    public void setInvasions(ServerWorld worldIn, boolean isCanceledIn, int amountIn, long daysIn) {
        int totalInvasions;
        this.invasions.clear();
        Random random = worldIn.field_73012_v;
        int n = !this.queuedInvasions.isEmpty() ? this.queuedInvasions.size() : (totalInvasions = this.calculateInvasions(random, amountIn, this.interval, isCanceledIn, daysIn == 0L));
        this.interval = this.interval > 0 ? this.interval - 1 : (PSConfigValues.common.consistentInvasions ? PSConfigValues.common.fixedInvasionRarity : random.nextInt(PSConfigValues.common.fixedInvasionRarity) + PSConfigValues.common.fixedInvasionRarity - (int)(daysIn % (long)PSConfigValues.common.fixedInvasionRarity));
        InvasionChart.refresh();
        InvasionChart potentialPrimaryInvasions = new InvasionChart(PSEventManager.BaseEvents.getInvasionTypeManager().getInvasionTypesOf(it -> !(!it.getDimensions().contains(worldIn.func_234923_W_().func_240901_a_()) || PSConfigValues.common.tieredInvasions && daysIn < (long)(it.getTier() * PSConfigValues.common.fixedDifficultyIncreaseDelay) || it.getInvasionPriority() == InvasionType.InvasionPriority.SECONDARY_ONLY || !PSConfigValues.common.primaryWhitelist.isEmpty() && !PSConfigValues.common.primaryWhitelist.contains(it.getId().toString()))));
        InvasionChart potentialSecondaryInvasions = new InvasionChart(PSEventManager.BaseEvents.getInvasionTypeManager().getInvasionTypesOf(it -> it.getDimensions().contains(worldIn.func_234923_W_().func_240901_a_()) && (!PSConfigValues.common.tieredInvasions || daysIn >= (long)(it.getTier() * PSConfigValues.common.fixedDifficultyIncreaseDelay)) && it.getInvasionPriority() != InvasionType.InvasionPriority.PRIMARY_ONLY));
        LOGGER.info("Setting Fixed Invasions: [");
        this.invasions.setCanceled(this.queuedInvasions.isEmpty() && isCanceledIn);
        if (!this.queuedInvasions.isEmpty()) {
            for (int q = 0; q < this.queuedInvasions.size(); ++q) {
                Invasion invasion = this.queuedInvasions.get(q);
                this.invasions.add(invasion);
                LOGGER.info("Queued Invasion " + (q + 1) + ": " + invasion.getType() + " - " + (invasion.getSeverity() + 1));
            }
            this.queuedInvasions.clear();
        } else {
            for (int inv = 0; inv < totalInvasions; ++inv) {
                InvasionType invasionType = this.getInvasionType(inv == 0 ? potentialPrimaryInvasions : potentialSecondaryInvasions, random);
                if (invasionType == null) continue;
                int severity = random.nextInt(random.nextInt(MathHelper.func_76125_a((int)((int)daysIn / PSConfigValues.common.fixedDifficultyIncreaseDelay - invasionType.getTier()), (int)1, (int)invasionType.getMaxSeverity())) + 1);
                Invasion invasion = new Invasion(invasionType, severity, inv == 0);
                this.invasions.add(invasion);
                LOGGER.info("Invasion " + (inv + 1) + ": " + invasionType + " - " + (severity + 1));
            }
        }
        LOGGER.info("]");
    }

    private int calculateInvasions(Random randomIn, int amountIn, int intervalIn, boolean isCanceledIn, boolean isFirstDayIn) {
        return !isFirstDayIn && intervalIn == 0 && amountIn > 0 && !isCanceledIn ? randomIn.nextInt(amountIn) + 1 : 0;
    }

    private InvasionType getInvasionType(InvasionChart invasionChartIn, Random randomIn) {
        return invasionChartIn.getInvasionInRange(randomIn.nextFloat());
    }

    public void invasionTick(MinecraftServer serverIn, ServerWorld worldIn) {
        if (!this.invasions.isEmpty()) {
            Invasion invasion = this.invasions.get(worldIn.func_201674_k().nextInt(this.invasions.size()));
            invasion.tick(worldIn);
        }
    }

    public void load(CompoundNBT nbtIn) {
        ListNBT invasionsNBT = nbtIn.func_150295_c("Invasions", 10);
        ListNBT queuedInvasionsNBT = nbtIn.func_150295_c("QueuedInvasions", 10);
        for (INBT inbt : invasionsNBT) {
            this.invasions.add(Invasion.load((CompoundNBT)inbt));
        }
        for (INBT inbt : queuedInvasionsNBT) {
            this.queuedInvasions.add(Invasion.load((CompoundNBT)inbt));
        }
        this.interval = nbtIn.func_74762_e("Interval");
    }

    public CompoundNBT save() {
        CompoundNBT nbt = new CompoundNBT();
        ListNBT invasionsNBT = new ListNBT();
        ListNBT queuedInvasionsNBT = new ListNBT();
        for (Invasion invasion : this.invasions) {
            invasionsNBT.add((Object)invasion.save());
        }
        for (Invasion invasion : this.queuedInvasions) {
            invasionsNBT.add((Object)invasion.save());
        }
        nbt.func_218657_a("Invasions", (INBT)invasionsNBT);
        nbt.func_218657_a("QueuedInvasions", (INBT)queuedInvasionsNBT);
        nbt.func_74768_a("Interval", this.interval);
        return nbt;
    }

    public InvasionList getInvasions() {
        return this.invasions;
    }

    public ArrayList<Invasion> getQueuedInvasions() {
        return this.queuedInvasions;
    }
}

