/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.spawner;

import dev.theagameplayer.puresuffering.PSEventManager;
import dev.theagameplayer.puresuffering.config.PSConfigValues;
import dev.theagameplayer.puresuffering.invasion.Invasion;
import dev.theagameplayer.puresuffering.invasion.InvasionType;
import dev.theagameplayer.puresuffering.util.InvasionChart;
import dev.theagameplayer.puresuffering.util.InvasionList;
import dev.theagameplayer.puresuffering.util.InvasionListType;
import dev.theagameplayer.puresuffering.util.ServerTimeUtil;
import dev.theagameplayer.puresuffering.world.InvasionWorldData;
import dev.theagameplayer.puresuffering.world.TimedInvasionWorldData;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.server.ServerWorld;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class TimedInvasionSpawner {
    private static final Logger LOGGER = LogManager.getLogger((String)"puresuffering");
    private final InvasionList nightInvasions = new InvasionList(InvasionListType.NIGHT);
    private final InvasionList dayInvasions = new InvasionList(InvasionListType.DAY);
    private final ArrayList<Invasion> queuedNightInvasions = new ArrayList();
    private final ArrayList<Invasion> queuedDayInvasions = new ArrayList();
    private boolean isNightChangedToDay;
    private boolean isDayChangedToNight;
    private int nightInterval;
    private int dayInterval;

    public void setNightInvasions(ServerWorld worldIn, boolean isCanceledIn, int amountIn, long daysIn) {
        int totalInvasions;
        this.nightInvasions.clear();
        Random random = worldIn.field_73012_v;
        this.isNightChangedToDay = false;
        int n = !this.queuedNightInvasions.isEmpty() ? this.queuedNightInvasions.size() : (totalInvasions = this.calculateInvasions(random, amountIn, this.nightInterval, isCanceledIn, daysIn == 0L));
        this.nightInterval = this.nightInterval > 0 ? this.nightInterval - 1 : (PSConfigValues.common.consistentInvasions ? PSConfigValues.common.nightInvasionRarity : random.nextInt(PSConfigValues.common.nightInvasionRarity) + PSConfigValues.common.nightInvasionRarity - (int)(daysIn % (long)PSConfigValues.common.nightInvasionRarity));
        InvasionChart.refresh();
        InvasionChart potentialPrimaryNightInvasions = new InvasionChart(PSEventManager.BaseEvents.getInvasionTypeManager().getInvasionTypesOf(it -> !(it.getInvasionTime() == InvasionType.InvasionTime.DAY || !it.getDimensions().contains(worldIn.func_234923_W_().func_240901_a_()) || PSConfigValues.common.tieredInvasions && daysIn < (long)(it.getTier() * PSConfigValues.common.nightDifficultyIncreaseDelay) || it.getInvasionPriority() == InvasionType.InvasionPriority.SECONDARY_ONLY || !PSConfigValues.common.primaryWhitelist.isEmpty() && !PSConfigValues.common.primaryWhitelist.contains(it.getId().toString()))));
        InvasionChart potentialSecondaryNightInvasions = new InvasionChart(PSEventManager.BaseEvents.getInvasionTypeManager().getInvasionTypesOf(it -> it.getInvasionTime() != InvasionType.InvasionTime.DAY && it.getDimensions().contains(worldIn.func_234923_W_().func_240901_a_()) && (!PSConfigValues.common.tieredInvasions || daysIn >= (long)(it.getTier() * PSConfigValues.common.nightDifficultyIncreaseDelay)) && it.getInvasionPriority() != InvasionType.InvasionPriority.PRIMARY_ONLY));
        InvasionChart potentialSecondaryDayInvasions = new InvasionChart(PSEventManager.BaseEvents.getInvasionTypeManager().getInvasionTypesOf(it -> it.getInvasionTime() != InvasionType.InvasionTime.NIGHT && it.getDimensions().contains(worldIn.func_234923_W_().func_240901_a_()) && (!PSConfigValues.common.tieredInvasions || daysIn >= (long)(it.getTier() * PSConfigValues.common.nightDifficultyIncreaseDelay)) && it.getInvasionPriority() != InvasionType.InvasionPriority.PRIMARY_ONLY && it.getTimeChangeability() != InvasionType.TimeChangeability.ONLY_DAY));
        LOGGER.info("Setting Night Invasions: [");
        this.nightInvasions.setCanceled(this.queuedNightInvasions.isEmpty() && isCanceledIn);
        if (!this.queuedNightInvasions.isEmpty()) {
            for (int q = 0; q < this.queuedNightInvasions.size(); ++q) {
                Invasion invasion = this.queuedNightInvasions.get(q);
                this.nightInvasions.add(invasion);
                LOGGER.info("Queued Invasion " + (q + 1) + ": " + invasion.getType() + " - " + (invasion.getSeverity() + 1));
            }
            this.queuedNightInvasions.clear();
        } else {
            for (int inv = 0; inv < totalInvasions; ++inv) {
                InvasionType invasionType = this.getInvasionType(inv == 0 ? potentialPrimaryNightInvasions : (this.isNightChangedToDay ? potentialSecondaryDayInvasions : potentialSecondaryNightInvasions), random);
                if (invasionType == null) continue;
                int severity = random.nextInt(random.nextInt(MathHelper.func_76125_a((int)((int)daysIn / PSConfigValues.common.nightDifficultyIncreaseDelay - invasionType.getTier()), (int)1, (int)invasionType.getMaxSeverity())) + 1);
                Invasion invasion = new Invasion(invasionType, severity, inv == 0);
                this.nightInvasions.add(invasion);
                LOGGER.info("Invasion " + (inv + 1) + ": " + invasionType + " - " + (severity + 1));
                this.isNightChangedToDay |= invasionType.getTimeModifier() == InvasionType.TimeModifier.NIGHT_TO_DAY;
            }
        }
        LOGGER.info("]");
    }

    public void setDayInvasions(ServerWorld worldIn, boolean isCanceledIn, int amountIn, long daysIn) {
        int totalInvasions;
        this.dayInvasions.clear();
        Random random = worldIn.field_73012_v;
        this.isDayChangedToNight = false;
        int n = !this.queuedDayInvasions.isEmpty() ? this.queuedDayInvasions.size() : (totalInvasions = this.calculateInvasions(random, amountIn, this.dayInterval, isCanceledIn, daysIn == 0L));
        this.dayInterval = this.dayInterval > 0 ? this.dayInterval - 1 : (PSConfigValues.common.consistentInvasions ? PSConfigValues.common.dayInvasionRarity : random.nextInt(PSConfigValues.common.dayInvasionRarity) + PSConfigValues.common.dayInvasionRarity - (int)(daysIn % (long)PSConfigValues.common.dayInvasionRarity));
        InvasionChart.refresh();
        InvasionChart potentialPrimaryDayInvasions = new InvasionChart(PSEventManager.BaseEvents.getInvasionTypeManager().getInvasionTypesOf(it -> !(it.getInvasionTime() == InvasionType.InvasionTime.NIGHT || !it.getDimensions().contains(worldIn.func_234923_W_().func_240901_a_()) || PSConfigValues.common.tieredInvasions && daysIn < (long)(it.getTier() * PSConfigValues.common.dayDifficultyIncreaseDelay) || it.getInvasionPriority() == InvasionType.InvasionPriority.SECONDARY_ONLY || !PSConfigValues.common.primaryWhitelist.isEmpty() && !PSConfigValues.common.primaryWhitelist.contains(it.getId().toString()))));
        InvasionChart potentialSecondaryDayInvasions = new InvasionChart(PSEventManager.BaseEvents.getInvasionTypeManager().getInvasionTypesOf(it -> it.getInvasionTime() != InvasionType.InvasionTime.NIGHT && it.getDimensions().contains(worldIn.func_234923_W_().func_240901_a_()) && (!PSConfigValues.common.tieredInvasions || daysIn >= (long)(it.getTier() * PSConfigValues.common.dayDifficultyIncreaseDelay)) && it.getInvasionPriority() != InvasionType.InvasionPriority.PRIMARY_ONLY));
        InvasionChart potentialSecondaryNightInvasions = new InvasionChart(PSEventManager.BaseEvents.getInvasionTypeManager().getInvasionTypesOf(it -> it.getInvasionTime() != InvasionType.InvasionTime.DAY && it.getDimensions().contains(worldIn.func_234923_W_().func_240901_a_()) && (!PSConfigValues.common.tieredInvasions || daysIn >= (long)(it.getTier() * PSConfigValues.common.dayDifficultyIncreaseDelay)) && it.getInvasionPriority() != InvasionType.InvasionPriority.PRIMARY_ONLY && it.getTimeChangeability() != InvasionType.TimeChangeability.ONLY_NIGHT));
        LOGGER.info("Setting Day Invasions: [");
        this.dayInvasions.setCanceled(this.queuedDayInvasions.isEmpty() && isCanceledIn);
        if (!this.queuedDayInvasions.isEmpty()) {
            for (int q = 0; q < this.queuedDayInvasions.size(); ++q) {
                Invasion invasion = this.queuedDayInvasions.get(q);
                this.dayInvasions.add(invasion);
                LOGGER.info("Queued Invasion " + (q + 1) + ": " + invasion.getType() + " - " + (invasion.getSeverity() + 1));
            }
            this.queuedDayInvasions.clear();
        } else {
            for (int inv = 0; inv < totalInvasions; ++inv) {
                InvasionType invasionType = this.getInvasionType(inv == 0 ? potentialPrimaryDayInvasions : (this.isDayChangedToNight ? potentialSecondaryNightInvasions : potentialSecondaryDayInvasions), random);
                if (invasionType == null) continue;
                int severity = random.nextInt(random.nextInt(MathHelper.func_76125_a((int)((int)daysIn / PSConfigValues.common.dayDifficultyIncreaseDelay - invasionType.getTier()), (int)1, (int)invasionType.getMaxSeverity())) + 1);
                Invasion invasion = new Invasion(invasionType, severity, inv == 0);
                this.dayInvasions.add(invasion);
                LOGGER.info("Invasion " + (inv + 1) + ": " + invasionType + " - " + (severity + 1));
                this.isDayChangedToNight |= invasionType.getTimeModifier() == InvasionType.TimeModifier.DAY_TO_NIGHT;
            }
        }
        LOGGER.info("]");
    }

    private int calculateInvasions(Random randomIn, int amountIn, int intervalIn, boolean isCanceledIn, boolean isFirstDayIn) {
        return !isFirstDayIn && intervalIn == 0 && amountIn > 0 && !isCanceledIn ? randomIn.nextInt(amountIn) + 1 : 0;
    }

    private InvasionType getInvasionType(InvasionChart invasionChartIn, Random randomIn) {
        return invasionChartIn.getInvasionInRange(randomIn.nextFloat());
    }

    public void invasionTick(MinecraftServer serverIn, ServerWorld worldIn) {
        TimedInvasionWorldData tiwData = (TimedInvasionWorldData)InvasionWorldData.getInvasionData().get(worldIn);
        if (!this.nightInvasions.isEmpty() && ServerTimeUtil.isServerNight(worldIn, tiwData)) {
            Invasion invasion = this.nightInvasions.get(worldIn.func_201674_k().nextInt(this.nightInvasions.size()));
            invasion.tick(worldIn);
        } else if (!this.dayInvasions.isEmpty() && ServerTimeUtil.isServerDay(worldIn, tiwData)) {
            Invasion invasion = this.dayInvasions.get(worldIn.func_201674_k().nextInt(this.dayInvasions.size()));
            invasion.tick(worldIn);
        }
    }

    public void load(CompoundNBT nbtIn) {
        ListNBT nightInvasionsNBT = nbtIn.func_150295_c("NightInvasions", 10);
        ListNBT dayInvasionsNBT = nbtIn.func_150295_c("DayInvasions", 10);
        ListNBT queuedNightInvasionsNBT = nbtIn.func_150295_c("QueuedNightInvasions", 10);
        ListNBT queuedDayInvasionsNBT = nbtIn.func_150295_c("QueuedDayInvasions", 10);
        for (INBT inbt : nightInvasionsNBT) {
            this.nightInvasions.add(Invasion.load((CompoundNBT)inbt));
        }
        for (INBT inbt : dayInvasionsNBT) {
            this.dayInvasions.add(Invasion.load((CompoundNBT)inbt));
        }
        for (INBT inbt : queuedNightInvasionsNBT) {
            this.queuedNightInvasions.add(Invasion.load((CompoundNBT)inbt));
        }
        for (INBT inbt : queuedDayInvasionsNBT) {
            this.queuedDayInvasions.add(Invasion.load((CompoundNBT)inbt));
        }
        this.isNightChangedToDay = nbtIn.func_74767_n("IsNightChangedToDay");
        this.isDayChangedToNight = nbtIn.func_74767_n("IsDayChangedToNight");
        this.nightInterval = nbtIn.func_74762_e("NightInterval");
        this.dayInterval = nbtIn.func_74762_e("DayInterval");
    }

    public CompoundNBT save() {
        CompoundNBT nbt = new CompoundNBT();
        ListNBT nightInvasionsNBT = new ListNBT();
        ListNBT dayInvasionsNBT = new ListNBT();
        ListNBT queuedNightInvasionsNBT = new ListNBT();
        ListNBT queuedDayInvasionsNBT = new ListNBT();
        for (Invasion invasion : this.nightInvasions) {
            nightInvasionsNBT.add((Object)invasion.save());
        }
        for (Invasion invasion : this.dayInvasions) {
            dayInvasionsNBT.add((Object)invasion.save());
        }
        for (Invasion invasion : this.queuedNightInvasions) {
            queuedNightInvasionsNBT.add((Object)invasion.save());
        }
        for (Invasion invasion : this.queuedDayInvasions) {
            queuedDayInvasionsNBT.add((Object)invasion.save());
        }
        nbt.func_218657_a("NightInvasions", (INBT)nightInvasionsNBT);
        nbt.func_218657_a("DayInvasions", (INBT)dayInvasionsNBT);
        nbt.func_218657_a("QueuedNightInvasions", (INBT)queuedNightInvasionsNBT);
        nbt.func_218657_a("QueuedDayInvasions", (INBT)queuedDayInvasionsNBT);
        nbt.func_74757_a("IsNightChangedToDay", this.isNightChangedToDay);
        nbt.func_74757_a("IsDayChangedToNight", this.isDayChangedToNight);
        nbt.func_74768_a("NightInterval", this.nightInterval);
        nbt.func_74768_a("DayInterval", this.dayInterval);
        return nbt;
    }

    public InvasionList getNightInvasions() {
        return this.nightInvasions;
    }

    public InvasionList getDayInvasions() {
        return this.dayInvasions;
    }

    public ArrayList<Invasion> getQueuedNightInvasions() {
        return this.queuedNightInvasions;
    }

    public ArrayList<Invasion> getQueuedDayInvasions() {
        return this.queuedDayInvasions;
    }
}

