/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.util;

import dev.theagameplayer.puresuffering.invasion.InvasionType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class InvasionChart {
    private static final ArrayList<InvasionType> USED_LIST = new ArrayList();
    private final ArrayList<InvasionType> invasionList = new ArrayList();
    private final ArrayList<InvasionRange> rangeList = new ArrayList();
    private float total = 0.0f;

    public InvasionChart(List<InvasionType> invasionListIn) {
        this.invasionList.addAll(invasionListIn);
        this.calcInvasionRanges();
    }

    public static void refresh() {
        USED_LIST.clear();
    }

    public InvasionType getInvasionInRange(float numberIn) {
        this.invasionList.removeIf(it -> USED_LIST.contains(it));
        this.calcInvasionRanges();
        InvasionType invasionType = null;
        for (InvasionRange range : this.rangeList) {
            if (!range.inRange(numberIn)) continue;
            invasionType = range.invasionType;
            USED_LIST.add(invasionType);
            break;
        }
        return invasionType;
    }

    private void calcInvasionRanges() {
        this.total = 0.0f;
        this.rangeList.clear();
        for (InvasionType invasionType : this.invasionList) {
            float rangeSize = 1.0f / (float)this.invasionList.size() / (float)(invasionType.getRarity() + 1);
            InvasionRange range = new InvasionRange(invasionType, this.total, this.total + rangeSize);
            this.total += rangeSize;
            this.rangeList.add(range);
        }
        Iterator<Object> iterator = this.rangeList.iterator();
        while (iterator.hasNext()) {
            InvasionRange range;
            InvasionRange invasionRange = range = (InvasionRange)iterator.next();
            invasionRange.min = invasionRange.min * (1.0f / this.total);
            invasionRange = range;
            invasionRange.max = invasionRange.max * (1.0f / this.total);
        }
    }

    public String toString() {
        return this.rangeList.toString();
    }

    private static final class InvasionRange {
        private final InvasionType invasionType;
        private float min;
        private float max;

        private InvasionRange(InvasionType invasionTypeIn, float minIn, float maxIn) {
            this.invasionType = invasionTypeIn;
            this.min = minIn;
            this.max = maxIn;
        }

        public boolean inRange(float numberIn) {
            return numberIn < this.max && numberIn >= this.min;
        }

        public String toString() {
            return "[ " + this.invasionType + " - " + (this.max - this.min) + " - " + this.min + ", " + this.max + " ]";
        }
    }
}

