/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.util;

import dev.theagameplayer.puresuffering.client.renderer.InvasionSkyRenderer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Predicate;

public final class InvasionRendererMap
implements Iterable<Map.Entry<InvasionSkyRenderer, Boolean>> {
    private final HashMap<InvasionSkyRenderer, Boolean> rendererMap = new HashMap();

    public void add(InvasionSkyRenderer rendererIn, boolean isPrimaryIn) {
        this.rendererMap.put(rendererIn, isPrimaryIn);
    }

    public void remove(InvasionSkyRenderer rendererIn) {
        this.rendererMap.remove(rendererIn);
    }

    public void clear() {
        this.rendererMap.clear();
    }

    public ArrayList<InvasionSkyRenderer> getRenderersOf(Predicate<InvasionSkyRenderer> predIn) {
        ArrayList<InvasionSkyRenderer> rendererList = new ArrayList<InvasionSkyRenderer>();
        for (InvasionSkyRenderer renderer : this.rendererMap.keySet()) {
            if (!predIn.test(renderer)) continue;
            rendererList.add(renderer);
        }
        return rendererList;
    }

    public int size() {
        return this.rendererMap.size();
    }

    public boolean isEmpty() {
        return this.rendererMap.isEmpty();
    }

    public boolean contains(InvasionSkyRenderer invasionIn) {
        return this.rendererMap.containsKey(invasionIn);
    }

    public InvasionSkyRenderer get(int indexIn) {
        return this.get(indexIn);
    }

    public String toString() {
        return this.rendererMap.toString();
    }

    @Override
    public Iterator<Map.Entry<InvasionSkyRenderer, Boolean>> iterator() {
        return this.rendererMap.entrySet().iterator();
    }
}

