/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.util.text;

import dev.theagameplayer.puresuffering.invasion.Invasion;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class InvasionText {
    private final boolean isPrimary;
    private final int severity;
    private final int rarity;
    private final int tier;
    private final int mobCap;

    public InvasionText(Invasion invasionIn) {
        this.isPrimary = invasionIn.isPrimary();
        this.severity = invasionIn.getSeverity() + 1;
        this.rarity = invasionIn.getType().getRarity() + 1;
        this.tier = invasionIn.getType().getTier() + 1;
        this.mobCap = invasionIn.getMobCap() - 1;
    }

    public IFormattableTextComponent getHoverText() {
        IFormattableTextComponent primaryComponent = new TranslationTextComponent("invasion.puresuffering.info1").func_240702_b_(this.isPrimary + ", ");
        IFormattableTextComponent severityComponent = new TranslationTextComponent("invasion.puresuffering.info2").func_240702_b_(this.severity + "\n");
        IFormattableTextComponent infoComponent = new TranslationTextComponent("invasion.puresuffering.info3").func_240702_b_("\n");
        IFormattableTextComponent rarityComponent = new TranslationTextComponent("invasion.puresuffering.info4").func_240702_b_(this.rarity + ", ");
        IFormattableTextComponent tierComponent = new TranslationTextComponent("invasion.puresuffering.info5").func_240702_b_(this.tier + ", ");
        IFormattableTextComponent mobCapComponent = new TranslationTextComponent("invasion.puresuffering.info6").func_240702_b_(this.mobCap + "");
        return primaryComponent.func_230529_a_((ITextComponent)severityComponent).func_230529_a_((ITextComponent)infoComponent).func_230529_a_((ITextComponent)rarityComponent).func_230529_a_((ITextComponent)tierComponent).func_230529_a_((ITextComponent)mobCapComponent);
    }
}

