/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.world;

import dev.theagameplayer.puresuffering.spawner.TimedInvasionSpawner;
import dev.theagameplayer.puresuffering.util.ServerTimeUtil;
import dev.theagameplayer.puresuffering.world.InvasionWorldData;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.world.server.ServerWorld;

public final class TimedInvasionWorldData
extends InvasionWorldData {
    private final TimedInvasionSpawner spawner = new TimedInvasionSpawner();
    private double dayXPMultiplier;
    private double nightXPMultiplier;
    private boolean checkedDay;
    private boolean checkedNight;
    private boolean prevDayCheck;
    private boolean prevNightCheck;

    public TimedInvasionWorldData(ServerWorld worldIn) {
        super(worldIn);
        this.checkedDay = ServerTimeUtil.isServerNight(worldIn, this);
        this.checkedNight = ServerTimeUtil.isServerDay(worldIn, this);
    }

    @Override
    public void func_76184_a(CompoundNBT nbtIn) {
        this.spawner.load(nbtIn.func_74775_l("Spawner"));
        this.dayXPMultiplier = nbtIn.func_74769_h("DayXPMultiplier");
        this.nightXPMultiplier = nbtIn.func_74769_h("NightXPMultiplier");
        this.checkedDay = nbtIn.func_74767_n("CheckedDay");
        this.checkedNight = nbtIn.func_74767_n("CheckedNight");
        this.prevDayCheck = nbtIn.func_74767_n("PrevDayCheck");
        this.prevNightCheck = nbtIn.func_74767_n("PrevNightCheck");
        super.func_76184_a(nbtIn);
    }

    @Override
    public CompoundNBT func_189551_b(CompoundNBT nbtIn) {
        nbtIn.func_218657_a("Spawner", (INBT)this.spawner.save());
        nbtIn.func_74780_a("DayXPMultiplier", this.dayXPMultiplier);
        nbtIn.func_74780_a("NightXPMultiplier", this.nightXPMultiplier);
        nbtIn.func_74757_a("CheckedDay", this.checkedDay);
        nbtIn.func_74757_a("CheckedNight", this.checkedNight);
        nbtIn.func_74757_a("PrevDayCheck", this.prevDayCheck);
        nbtIn.func_74757_a("PrevNightCheck", this.prevNightCheck);
        return super.func_189551_b(nbtIn);
    }

    public TimedInvasionSpawner getInvasionSpawner() {
        return this.spawner;
    }

    public double getDayXPMultiplier() {
        return this.dayXPMultiplier;
    }

    public void setDayXPMultiplier(double dayXPMultiplierIn) {
        this.dayXPMultiplier = dayXPMultiplierIn;
        this.func_76185_a();
    }

    public double getNightXPMultiplier() {
        return this.nightXPMultiplier;
    }

    public void setNightXPMultiplier(double nightXPMultiplierIn) {
        this.nightXPMultiplier = nightXPMultiplierIn;
        this.func_76185_a();
    }

    public boolean hasCheckedDay() {
        return this.checkedDay;
    }

    public void setCheckedDay(boolean checkedDayIn) {
        this.checkedDay = checkedDayIn;
        this.func_76185_a();
    }

    public boolean hasCheckedNight() {
        return this.checkedNight;
    }

    public void setCheckedNight(boolean checkedNightIn) {
        this.checkedNight = checkedNightIn;
        this.func_76185_a();
    }

    public boolean getPrevDayCheck() {
        return this.prevDayCheck;
    }

    public void setPrevDayCheck(boolean prevDayCheckIn) {
        this.prevDayCheck = prevDayCheckIn;
        this.func_76185_a();
    }

    public boolean getPrevNightCheck() {
        return this.prevNightCheck;
    }

    public void setPrevNightCheck(boolean prevNightCheckIn) {
        this.prevNightCheck = prevNightCheckIn;
        this.func_76185_a();
    }
}

