/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.theagameplayer.puresuffering.PSEventManager;
import dev.theagameplayer.puresuffering.invasion.Invasion;
import dev.theagameplayer.puresuffering.invasion.InvasionType;
import dev.theagameplayer.puresuffering.world.FixedInvasionWorldData;
import dev.theagameplayer.puresuffering.world.InvasionWorldData;
import dev.theagameplayer.puresuffering.world.TimedInvasionWorldData;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public final class AddInvasionsCommand {
    private static final DynamicCommandExceptionType ERROR_UNKNOWN_INVASION_TYPE = new DynamicCommandExceptionType(resourceLocation -> new TranslatableComponent("commands.puresuffering.invasion_type.invasionTypeNotFound", new Object[]{resourceLocation}));
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_PRIMARY_DAY_INVASION_TYPES = (ctx, suggestionsBuilder) -> {
        Collection<InvasionType> collection = PSEventManager.BaseEvents.getInvasionTypeManager().getAllInvasionTypes();
        InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
        return SharedSuggestionProvider.m_82957_(collection.stream().filter(it -> !iwData.hasFixedTime() && it.getDimensions().contains(((CommandSourceStack)ctx.getSource()).m_81372_().m_46472_().m_135782_()) && it.getInvasionPriority() != InvasionType.InvasionPriority.SECONDARY_ONLY && it.getInvasionTime() != InvasionType.InvasionTime.NIGHT && it.getTimeChangeability() != InvasionType.TimeChangeability.ONLY_NIGHT).map(InvasionType::getId), (SuggestionsBuilder)suggestionsBuilder);
    };
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_SECONDARY_DAY_INVASION_TYPES = (ctx, suggestionsBuilder) -> {
        Collection<InvasionType> collection = PSEventManager.BaseEvents.getInvasionTypeManager().getAllInvasionTypes();
        InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
        return SharedSuggestionProvider.m_82957_(collection.stream().filter(it -> !iwData.hasFixedTime() && it.getDimensions().contains(((CommandSourceStack)ctx.getSource()).m_81372_().m_46472_().m_135782_()) && it.getInvasionPriority() != InvasionType.InvasionPriority.PRIMARY_ONLY && (AddInvasionsCommand.containsDayChangingInvasion(((TimedInvasionWorldData)iwData).getInvasionSpawner().getQueuedDayInvasions()) ? it.getInvasionTime() != InvasionType.InvasionTime.DAY && it.getTimeChangeability() != InvasionType.TimeChangeability.ONLY_DAY : it.getInvasionTime() != InvasionType.InvasionTime.NIGHT && it.getTimeChangeability() != InvasionType.TimeChangeability.ONLY_NIGHT)).map(InvasionType::getId), (SuggestionsBuilder)suggestionsBuilder);
    };
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_PRIMARY_NIGHT_INVASION_TYPES = (ctx, suggestionsBuilder) -> {
        Collection<InvasionType> collection = PSEventManager.BaseEvents.getInvasionTypeManager().getAllInvasionTypes();
        InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
        return SharedSuggestionProvider.m_82957_(collection.stream().filter(it -> !iwData.hasFixedTime() && it.getDimensions().contains(((CommandSourceStack)ctx.getSource()).m_81372_().m_46472_().m_135782_()) && it.getInvasionPriority() != InvasionType.InvasionPriority.SECONDARY_ONLY && it.getInvasionTime() != InvasionType.InvasionTime.DAY && it.getTimeChangeability() != InvasionType.TimeChangeability.ONLY_DAY).map(InvasionType::getId), (SuggestionsBuilder)suggestionsBuilder);
    };
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_SECONDARY_NIGHT_INVASION_TYPES = (ctx, suggestionsBuilder) -> {
        Collection<InvasionType> collection = PSEventManager.BaseEvents.getInvasionTypeManager().getAllInvasionTypes();
        InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
        return SharedSuggestionProvider.m_82957_(collection.stream().filter(it -> !iwData.hasFixedTime() && it.getDimensions().contains(((CommandSourceStack)ctx.getSource()).m_81372_().m_46472_().m_135782_()) && it.getInvasionPriority() != InvasionType.InvasionPriority.PRIMARY_ONLY && (AddInvasionsCommand.containsNightChangingInvasion(((TimedInvasionWorldData)iwData).getInvasionSpawner().getQueuedNightInvasions()) ? it.getInvasionTime() != InvasionType.InvasionTime.NIGHT && it.getTimeChangeability() != InvasionType.TimeChangeability.ONLY_NIGHT : it.getInvasionTime() != InvasionType.InvasionTime.DAY && it.getTimeChangeability() != InvasionType.TimeChangeability.ONLY_DAY)).map(InvasionType::getId), (SuggestionsBuilder)suggestionsBuilder);
    };
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_PRIMARY_FIXED_INVASION_TYPES = (ctx, suggestionsBuilder) -> {
        Collection<InvasionType> collection = PSEventManager.BaseEvents.getInvasionTypeManager().getAllInvasionTypes();
        InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
        return SharedSuggestionProvider.m_82957_(collection.stream().filter(it -> iwData.hasFixedTime() && it.getDimensions().contains(((CommandSourceStack)ctx.getSource()).m_81372_().m_46472_().m_135782_()) && it.getInvasionPriority() != InvasionType.InvasionPriority.SECONDARY_ONLY).map(InvasionType::getId), (SuggestionsBuilder)suggestionsBuilder);
    };
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_SECONDARY_FIXED_INVASION_TYPES = (ctx, suggestionsBuilder) -> {
        Collection<InvasionType> collection = PSEventManager.BaseEvents.getInvasionTypeManager().getAllInvasionTypes();
        InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
        return SharedSuggestionProvider.m_82957_(collection.stream().filter(it -> iwData.hasFixedTime() && it.getDimensions().contains(((CommandSourceStack)ctx.getSource()).m_81372_().m_46472_().m_135782_()) && it.getInvasionPriority() != InvasionType.InvasionPriority.PRIMARY_ONLY).map(InvasionType::getId), (SuggestionsBuilder)suggestionsBuilder);
    };

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"add").requires(player -> player.m_6761_(2))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"day").then(Commands.m_82127_((String)"primary").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"invasionType", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_PRIMARY_DAY_INVASION_TYPES).then(Commands.m_82129_((String)"severity", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (!iwData.hasFixedTime()) {
                TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSourceStack>)ctx, "invasionType", "severity", true);
                tiwData.getInvasionSpawner().getQueuedDayInvasions().removeIf(i -> i.isPrimary());
                tiwData.getInvasionSpawner().getQueuedDayInvasions().add(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("commands.puresuffering.add.success.day.primary").m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("commands.puresuffering.nonfixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        }))).then(Commands.m_82127_((String)"random").executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (!iwData.hasFixedTime()) {
                TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSourceStack>)ctx, "invasionType", null, true);
                tiwData.getInvasionSpawner().getQueuedDayInvasions().removeIf(i -> i.isPrimary());
                tiwData.getInvasionSpawner().getQueuedDayInvasions().add(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("commands.puresuffering.add.success.day.primary").m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("commands.puresuffering.nonfixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        }))))).then(Commands.m_82127_((String)"secondary").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"invasionType", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_SECONDARY_DAY_INVASION_TYPES).then(Commands.m_82129_((String)"severity", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (!iwData.hasFixedTime()) {
                TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSourceStack>)ctx, "invasionType", "severity", false);
                tiwData.getInvasionSpawner().getQueuedDayInvasions().add(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("commands.puresuffering.add.success.day.secondary").m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("commands.puresuffering.nonfixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        }))).then(Commands.m_82127_((String)"random").executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (!iwData.hasFixedTime()) {
                TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSourceStack>)ctx, "invasionType", null, false);
                tiwData.getInvasionSpawner().getQueuedDayInvasions().add(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("commands.puresuffering.add.success.day.secondary").m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("commands.puresuffering.nonfixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        })))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"night").then(Commands.m_82127_((String)"primary").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"invasionType", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_PRIMARY_NIGHT_INVASION_TYPES).then(Commands.m_82129_((String)"severity", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (!iwData.hasFixedTime()) {
                TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSourceStack>)ctx, "invasionType", "severity", true);
                tiwData.getInvasionSpawner().getQueuedNightInvasions().removeIf(i -> i.isPrimary());
                tiwData.getInvasionSpawner().getQueuedNightInvasions().add(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("commands.puresuffering.add.success.night.primary").m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("commands.puresuffering.nonfixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        }))).then(Commands.m_82127_((String)"random").executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (!iwData.hasFixedTime()) {
                TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSourceStack>)ctx, "invasionType", null, true);
                tiwData.getInvasionSpawner().getQueuedNightInvasions().removeIf(i -> i.isPrimary());
                tiwData.getInvasionSpawner().getQueuedNightInvasions().add(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("commands.puresuffering.add.success.night.primary").m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("commands.puresuffering.nonfixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        }))))).then(Commands.m_82127_((String)"secondary").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"invasionType", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_SECONDARY_NIGHT_INVASION_TYPES).then(Commands.m_82129_((String)"severity", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (!iwData.hasFixedTime()) {
                TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSourceStack>)ctx, "invasionType", "severity", false);
                tiwData.getInvasionSpawner().getQueuedNightInvasions().add(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("commands.puresuffering.add.success.night.secondary").m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("commands.puresuffering.nonfixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        }))).then(Commands.m_82127_((String)"random").executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (!iwData.hasFixedTime()) {
                TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSourceStack>)ctx, "invasionType", null, false);
                tiwData.getInvasionSpawner().getQueuedNightInvasions().add(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("commands.puresuffering.add.success.night.secondary").m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("commands.puresuffering.nonfixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        })))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"fixed").then(Commands.m_82127_((String)"primary").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"invasionType", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_PRIMARY_FIXED_INVASION_TYPES).then(Commands.m_82129_((String)"severity", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (iwData.hasFixedTime()) {
                FixedInvasionWorldData fiwData = (FixedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSourceStack>)ctx, "invasionType", "severity", true);
                fiwData.getInvasionSpawner().getQueuedInvasions().removeIf(i -> i.isPrimary());
                fiwData.getInvasionSpawner().getQueuedInvasions().add(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("commands.puresuffering.add.success.fixed.primary").m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("commands.puresuffering.fixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        }))).then(Commands.m_82127_((String)"random").executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (iwData.hasFixedTime()) {
                FixedInvasionWorldData fiwData = (FixedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSourceStack>)ctx, "invasionType", null, true);
                fiwData.getInvasionSpawner().getQueuedInvasions().removeIf(i -> i.isPrimary());
                fiwData.getInvasionSpawner().getQueuedInvasions().add(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("commands.puresuffering.add.success.fixed.primary").m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("commands.puresuffering.fixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        }))))).then(Commands.m_82127_((String)"secondary").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"invasionType", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_SECONDARY_FIXED_INVASION_TYPES).then(Commands.m_82129_((String)"severity", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (iwData.hasFixedTime()) {
                FixedInvasionWorldData fiwData = (FixedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSourceStack>)ctx, "invasionType", "severity", false);
                fiwData.getInvasionSpawner().getQueuedInvasions().add(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("commands.puresuffering.add.success.fixed.secondary").m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("commands.puresuffering.fixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        }))).then(Commands.m_82127_((String)"random").executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (iwData.hasFixedTime()) {
                FixedInvasionWorldData fiwData = (FixedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSourceStack>)ctx, "invasionType", null, false);
                fiwData.getInvasionSpawner().getQueuedInvasions().add(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("commands.puresuffering.add.success.fixed.secondary").m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("commands.puresuffering.fixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        })))));
    }

    private static boolean containsDayChangingInvasion(ArrayList<Invasion> invasionListIn) {
        for (Invasion invasion : invasionListIn) {
            if (invasion.getType().getInvasionTime() == InvasionType.InvasionTime.NIGHT || invasion.getType().getTimeModifier() != InvasionType.TimeModifier.DAY_TO_NIGHT) continue;
            return true;
        }
        return false;
    }

    private static boolean containsNightChangingInvasion(ArrayList<Invasion> invasionListIn) {
        for (Invasion invasion : invasionListIn) {
            if (invasion.getType().getInvasionTime() == InvasionType.InvasionTime.DAY || invasion.getType().getTimeModifier() != InvasionType.TimeModifier.NIGHT_TO_DAY) continue;
            return true;
        }
        return false;
    }

    private static Invasion getInvasion(CommandContext<CommandSourceStack> ctxIn, String argIn, String arg1In, boolean isPrimaryIn) throws CommandSyntaxException {
        ResourceLocation resourceLocation = (ResourceLocation)ctxIn.getArgument(argIn, ResourceLocation.class);
        InvasionType invasionType = PSEventManager.BaseEvents.getInvasionTypeManager().getInvasionType(resourceLocation);
        if (invasionType == null) {
            throw ERROR_UNKNOWN_INVASION_TYPE.create((Object)resourceLocation);
        }
        int severity = arg1In == null ? ((CommandSourceStack)ctxIn.getSource()).m_81372_().m_5822_().nextInt(invasionType.getMaxSeverity()) : Mth.m_14045_((int)IntegerArgumentType.getInteger(ctxIn, (String)arg1In), (int)1, (int)invasionType.getMaxSeverity()) - 1;
        return new Invasion(invasionType, severity, isPrimaryIn);
    }
}

