/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.command;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.theagameplayer.puresuffering.PSEventManager;
import dev.theagameplayer.puresuffering.invasion.Invasion;
import dev.theagameplayer.puresuffering.invasion.InvasionType;
import dev.theagameplayer.puresuffering.util.ServerTimeUtil;
import dev.theagameplayer.puresuffering.world.FixedInvasionWorldData;
import dev.theagameplayer.puresuffering.world.InvasionWorldData;
import dev.theagameplayer.puresuffering.world.TimedInvasionWorldData;
import java.util.Collection;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;

public final class RemoveInvasionsCommand {
    private static final DynamicCommandExceptionType ERROR_UNKNOWN_INVASION_TYPE = new DynamicCommandExceptionType(resourceLocation -> new TranslatableComponent("commands.puresuffering.invasion_type.invasionTypeNotFound", new Object[]{resourceLocation}));
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_CURRENT_INVASION_TYPES = (ctx, suggestionsBuilder) -> {
        Collection<InvasionType> collection = PSEventManager.BaseEvents.getInvasionTypeManager().getAllInvasionTypes();
        InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
        if (!iwData.hasFixedTime()) {
            TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
            return SharedSuggestionProvider.m_82957_(collection.stream().filter(invasionType -> {
                if (ServerTimeUtil.isServerDay(((CommandSourceStack)ctx.getSource()).m_81372_(), tiwData)) {
                    return RemoveInvasionsCommand.contains(tiwData.getInvasionSpawner().getDayInvasions(), invasionType);
                }
                if (ServerTimeUtil.isServerNight(((CommandSourceStack)ctx.getSource()).m_81372_(), tiwData)) {
                    return RemoveInvasionsCommand.contains(tiwData.getInvasionSpawner().getNightInvasions(), invasionType);
                }
                return false;
            }).map(InvasionType::getId), (SuggestionsBuilder)suggestionsBuilder);
        }
        FixedInvasionWorldData fiwData = (FixedInvasionWorldData)iwData;
        return SharedSuggestionProvider.m_82957_(collection.stream().filter(invasionType -> RemoveInvasionsCommand.contains(fiwData.getInvasionSpawner().getInvasions(), invasionType)).map(InvasionType::getId), (SuggestionsBuilder)suggestionsBuilder);
    };
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_DAY_INVASION_TYPES = (ctx, suggestionsBuilder) -> {
        Collection<InvasionType> collection = PSEventManager.BaseEvents.getInvasionTypeManager().getAllInvasionTypes();
        InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
        if (!iwData.hasFixedTime()) {
            TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
            return SharedSuggestionProvider.m_82957_(collection.stream().filter(invasionType -> RemoveInvasionsCommand.contains(tiwData.getInvasionSpawner().getDayInvasions(), invasionType)).map(InvasionType::getId), (SuggestionsBuilder)suggestionsBuilder);
        }
        return SharedSuggestionProvider.m_82957_((Stream)ImmutableList.of().stream(), (SuggestionsBuilder)suggestionsBuilder);
    };
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_NIGHT_INVASION_TYPES = (ctx, suggestionsBuilder) -> {
        Collection<InvasionType> collection = PSEventManager.BaseEvents.getInvasionTypeManager().getAllInvasionTypes();
        InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
        if (!iwData.hasFixedTime()) {
            TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
            return SharedSuggestionProvider.m_82957_(collection.stream().filter(invasionType -> RemoveInvasionsCommand.contains(tiwData.getInvasionSpawner().getNightInvasions(), invasionType)).map(InvasionType::getId), (SuggestionsBuilder)suggestionsBuilder);
        }
        return SharedSuggestionProvider.m_82957_((Stream)ImmutableList.of().stream(), (SuggestionsBuilder)suggestionsBuilder);
    };
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_FIXED_INVASION_TYPES = (ctx, suggestionsBuilder) -> {
        Collection<InvasionType> collection = PSEventManager.BaseEvents.getInvasionTypeManager().getAllInvasionTypes();
        InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
        if (iwData.hasFixedTime()) {
            FixedInvasionWorldData fiwData = (FixedInvasionWorldData)iwData;
            return SharedSuggestionProvider.m_82957_(collection.stream().filter(invasionType -> RemoveInvasionsCommand.contains(fiwData.getInvasionSpawner().getInvasions(), invasionType)).map(InvasionType::getId), (SuggestionsBuilder)suggestionsBuilder);
        }
        return SharedSuggestionProvider.m_82957_((Stream)ImmutableList.of().stream(), (SuggestionsBuilder)suggestionsBuilder);
    };
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_ALL_INVASION_TYPES = (ctx, suggestionsBuilder) -> {
        Collection<InvasionType> collection = PSEventManager.BaseEvents.getInvasionTypeManager().getAllInvasionTypes();
        InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
        if (!iwData.hasFixedTime()) {
            TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
            return SharedSuggestionProvider.m_82957_(collection.stream().filter(invasionType -> RemoveInvasionsCommand.contains(tiwData.getInvasionSpawner().getDayInvasions(), invasionType) || RemoveInvasionsCommand.contains(tiwData.getInvasionSpawner().getNightInvasions(), invasionType)).map(InvasionType::getId), (SuggestionsBuilder)suggestionsBuilder);
        }
        FixedInvasionWorldData fiwData = (FixedInvasionWorldData)iwData;
        return SharedSuggestionProvider.m_82957_(collection.stream().filter(invasionType -> RemoveInvasionsCommand.contains(fiwData.getInvasionSpawner().getInvasions(), invasionType)).map(InvasionType::getId), (SuggestionsBuilder)suggestionsBuilder);
    };
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_QUEUED_DAY_INVASION_TYPES = (ctx, suggestionsBuilder) -> {
        Collection<InvasionType> collection = PSEventManager.BaseEvents.getInvasionTypeManager().getAllInvasionTypes();
        InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
        if (!iwData.hasFixedTime()) {
            TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
            return SharedSuggestionProvider.m_82957_(collection.stream().filter(invasionType -> RemoveInvasionsCommand.contains(tiwData.getInvasionSpawner().getQueuedDayInvasions(), invasionType)).map(InvasionType::getId), (SuggestionsBuilder)suggestionsBuilder);
        }
        return SharedSuggestionProvider.m_82957_((Stream)ImmutableList.of().stream(), (SuggestionsBuilder)suggestionsBuilder);
    };
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_QUEUED_NIGHT_INVASION_TYPES = (ctx, suggestionsBuilder) -> {
        Collection<InvasionType> collection = PSEventManager.BaseEvents.getInvasionTypeManager().getAllInvasionTypes();
        InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
        if (!iwData.hasFixedTime()) {
            TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
            return SharedSuggestionProvider.m_82957_(collection.stream().filter(invasionType -> RemoveInvasionsCommand.contains(tiwData.getInvasionSpawner().getQueuedNightInvasions(), invasionType)).map(InvasionType::getId), (SuggestionsBuilder)suggestionsBuilder);
        }
        return SharedSuggestionProvider.m_82957_((Stream)ImmutableList.of().stream(), (SuggestionsBuilder)suggestionsBuilder);
    };
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_QUEUED_FIXED_INVASION_TYPES = (ctx, suggestionsBuilder) -> {
        Collection<InvasionType> collection = PSEventManager.BaseEvents.getInvasionTypeManager().getAllInvasionTypes();
        InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
        if (iwData.hasFixedTime()) {
            FixedInvasionWorldData fiwData = (FixedInvasionWorldData)iwData;
            return SharedSuggestionProvider.m_82957_(collection.stream().filter(invasionType -> RemoveInvasionsCommand.contains(fiwData.getInvasionSpawner().getQueuedInvasions(), invasionType)).map(InvasionType::getId), (SuggestionsBuilder)suggestionsBuilder);
        }
        return SharedSuggestionProvider.m_82957_((Stream)ImmutableList.of().stream(), (SuggestionsBuilder)suggestionsBuilder);
    };

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"remove").requires(player -> player.m_6761_(2))).then(Commands.m_82127_((String)"current").then(Commands.m_82129_((String)"invasionType", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_CURRENT_INVASION_TYPES).executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (!iwData.hasFixedTime()) {
                TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                if (ServerTimeUtil.isServerDay(((CommandSourceStack)ctx.getSource()).m_81372_(), tiwData)) {
                    Invasion invasion = RemoveInvasionsCommand.getInvasion(tiwData.getInvasionSpawner().getDayInvasions(), (CommandContext<CommandSourceStack>)ctx, "invasionType");
                    tiwData.getInvasionSpawner().getDayInvasions().remove(invasion);
                    ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("commands.puresuffering.remove.success.day." + (invasion.isPrimary() ? "primary" : "secondary")).m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
                } else if (ServerTimeUtil.isServerNight(((CommandSourceStack)ctx.getSource()).m_81372_(), tiwData)) {
                    Invasion invasion = RemoveInvasionsCommand.getInvasion(tiwData.getInvasionSpawner().getNightInvasions(), (CommandContext<CommandSourceStack>)ctx, "invasionType");
                    tiwData.getInvasionSpawner().getNightInvasions().remove(invasion);
                    ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("commands.puresuffering.remove.success.night." + (invasion.isPrimary() ? "primary" : "secondary")).m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
                } else {
                    ((CommandSourceStack)ctx.getSource()).m_81352_((Component)new TranslatableComponent("commands.puresuffering.remove.failure").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.DARK_RED)));
                }
            } else {
                FixedInvasionWorldData fiwData = (FixedInvasionWorldData)iwData;
                Invasion invasion = RemoveInvasionsCommand.getInvasion(fiwData.getInvasionSpawner().getInvasions(), (CommandContext<CommandSourceStack>)ctx, "invasionType");
                fiwData.getInvasionSpawner().getInvasions().remove(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("commands.puresuffering.remove.success.fixed." + (invasion.isPrimary() ? "primary" : "secondary")).m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            }
            return 0;
        })))).then(Commands.m_82127_((String)"day").then(Commands.m_82129_((String)"invasionType", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_DAY_INVASION_TYPES).executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (!iwData.hasFixedTime()) {
                TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                Invasion invasion = RemoveInvasionsCommand.getInvasion(tiwData.getInvasionSpawner().getDayInvasions(), (CommandContext<CommandSourceStack>)ctx, "invasionType");
                tiwData.getInvasionSpawner().getDayInvasions().remove(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("commands.puresuffering.remove.success.day." + (invasion.isPrimary() ? "primary" : "secondary")).m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("commands.puresuffering.nonfixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        })))).then(Commands.m_82127_((String)"night").then(Commands.m_82129_((String)"invasionType", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_NIGHT_INVASION_TYPES).executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (!iwData.hasFixedTime()) {
                TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                Invasion invasion = RemoveInvasionsCommand.getInvasion(tiwData.getInvasionSpawner().getNightInvasions(), (CommandContext<CommandSourceStack>)ctx, "invasionType");
                tiwData.getInvasionSpawner().getNightInvasions().remove(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("commands.puresuffering.remove.success.night." + (invasion.isPrimary() ? "primary" : "secondary")).m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("commands.puresuffering.nonfixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        })))).then(Commands.m_82127_((String)"fixed").then(Commands.m_82129_((String)"invasionType", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_FIXED_INVASION_TYPES).executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (iwData.hasFixedTime()) {
                FixedInvasionWorldData fiwData = (FixedInvasionWorldData)iwData;
                Invasion invasion = RemoveInvasionsCommand.getInvasion(fiwData.getInvasionSpawner().getInvasions(), (CommandContext<CommandSourceStack>)ctx, "invasionType");
                fiwData.getInvasionSpawner().getInvasions().remove(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("commands.puresuffering.remove.success.fixed." + (invasion.isPrimary() ? "primary" : "secondary")).m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("commands.puresuffering.fixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        })))).then(Commands.m_82127_((String)"all").then(Commands.m_82129_((String)"invasionType", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_ALL_INVASION_TYPES).executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (!iwData.hasFixedTime()) {
                TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                ResourceLocation resourceLocation = (ResourceLocation)ctx.getArgument("invasionType", ResourceLocation.class);
                Invasion invasion = null;
                if (RemoveInvasionsCommand.contains(tiwData.getInvasionSpawner().getDayInvasions(), PSEventManager.BaseEvents.getInvasionTypeManager().getInvasionType(resourceLocation))) {
                    invasion = RemoveInvasionsCommand.getInvasion(tiwData.getInvasionSpawner().getDayInvasions(), (CommandContext<CommandSourceStack>)ctx, "invasionType");
                    tiwData.getInvasionSpawner().getDayInvasions().remove(invasion);
                }
                if (RemoveInvasionsCommand.contains(tiwData.getInvasionSpawner().getNightInvasions(), PSEventManager.BaseEvents.getInvasionTypeManager().getInvasionType(resourceLocation))) {
                    invasion = RemoveInvasionsCommand.getInvasion(tiwData.getInvasionSpawner().getNightInvasions(), (CommandContext<CommandSourceStack>)ctx, "invasionType");
                    tiwData.getInvasionSpawner().getNightInvasions().remove(invasion);
                }
                if (invasion != null) {
                    ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("commands.puresuffering.remove.success.all." + (invasion.isPrimary() ? "primary" : "secondary")).m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
                }
            } else {
                FixedInvasionWorldData fiwData = (FixedInvasionWorldData)iwData;
                ResourceLocation resourceLocation = (ResourceLocation)ctx.getArgument("invasionType", ResourceLocation.class);
                Invasion invasion = null;
                if (RemoveInvasionsCommand.contains(fiwData.getInvasionSpawner().getInvasions(), PSEventManager.BaseEvents.getInvasionTypeManager().getInvasionType(resourceLocation))) {
                    invasion = RemoveInvasionsCommand.getInvasion(fiwData.getInvasionSpawner().getInvasions(), (CommandContext<CommandSourceStack>)ctx, "invasionType");
                    fiwData.getInvasionSpawner().getInvasions().remove(invasion);
                }
                if (invasion != null) {
                    ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("commands.puresuffering.remove.success.all." + (invasion.isPrimary() ? "primary" : "secondary")).m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
                }
            }
            return 0;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"queued").then(Commands.m_82127_((String)"day").then(Commands.m_82129_((String)"invasionType", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_QUEUED_DAY_INVASION_TYPES).executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (!iwData.hasFixedTime()) {
                TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                Invasion invasion = RemoveInvasionsCommand.getInvasion(tiwData.getInvasionSpawner().getQueuedDayInvasions(), (CommandContext<CommandSourceStack>)ctx, "invasionType");
                tiwData.getInvasionSpawner().getQueuedDayInvasions().remove(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("commands.puresuffering.remove.success.queued.day." + (invasion.isPrimary() ? "primary" : "secondary")).m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("commands.puresuffering.nonfixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        })))).then(Commands.m_82127_((String)"night").then(Commands.m_82129_((String)"invasionType", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_QUEUED_NIGHT_INVASION_TYPES).executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (!iwData.hasFixedTime()) {
                TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                Invasion invasion = RemoveInvasionsCommand.getInvasion(tiwData.getInvasionSpawner().getQueuedNightInvasions(), (CommandContext<CommandSourceStack>)ctx, "invasionType");
                tiwData.getInvasionSpawner().getQueuedDayInvasions().remove(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("commands.puresuffering.remove.success.queued.night." + (invasion.isPrimary() ? "primary" : "secondary")).m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("commands.puresuffering.nonfixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        })))).then(Commands.m_82127_((String)"fixed").then(Commands.m_82129_((String)"invasionType", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_QUEUED_FIXED_INVASION_TYPES).executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (iwData.hasFixedTime()) {
                FixedInvasionWorldData fiwData = (FixedInvasionWorldData)iwData;
                Invasion invasion = RemoveInvasionsCommand.getInvasion(fiwData.getInvasionSpawner().getQueuedInvasions(), (CommandContext<CommandSourceStack>)ctx, "invasionType");
                fiwData.getInvasionSpawner().getQueuedInvasions().remove(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("commands.puresuffering.remove.success.queued.fixed." + (invasion.isPrimary() ? "primary" : "secondary")).m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("commands.puresuffering.fixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        })))).then(Commands.m_82127_((String)"all").then(Commands.m_82129_((String)"invasionType", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_ALL_INVASION_TYPES).executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (!iwData.hasFixedTime()) {
                TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                ResourceLocation resourceLocation = (ResourceLocation)ctx.getArgument("invasionType", ResourceLocation.class);
                Invasion invasion = null;
                if (RemoveInvasionsCommand.contains(tiwData.getInvasionSpawner().getQueuedDayInvasions(), PSEventManager.BaseEvents.getInvasionTypeManager().getInvasionType(resourceLocation))) {
                    invasion = RemoveInvasionsCommand.getInvasion(tiwData.getInvasionSpawner().getQueuedDayInvasions(), (CommandContext<CommandSourceStack>)ctx, "invasionType");
                    tiwData.getInvasionSpawner().getQueuedDayInvasions().remove(invasion);
                }
                if (RemoveInvasionsCommand.contains(tiwData.getInvasionSpawner().getQueuedNightInvasions(), PSEventManager.BaseEvents.getInvasionTypeManager().getInvasionType(resourceLocation))) {
                    invasion = RemoveInvasionsCommand.getInvasion(tiwData.getInvasionSpawner().getQueuedNightInvasions(), (CommandContext<CommandSourceStack>)ctx, "invasionType");
                    tiwData.getInvasionSpawner().getQueuedNightInvasions().remove(invasion);
                }
                if (invasion != null) {
                    ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("commands.puresuffering.remove.success.queued.all." + (invasion.isPrimary() ? "primary" : "secondary")).m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
                }
            } else {
                FixedInvasionWorldData fiwData = (FixedInvasionWorldData)iwData;
                ResourceLocation resourceLocation = (ResourceLocation)ctx.getArgument("invasionType", ResourceLocation.class);
                Invasion invasion = null;
                if (RemoveInvasionsCommand.contains(fiwData.getInvasionSpawner().getQueuedInvasions(), PSEventManager.BaseEvents.getInvasionTypeManager().getInvasionType(resourceLocation))) {
                    invasion = RemoveInvasionsCommand.getInvasion(fiwData.getInvasionSpawner().getQueuedInvasions(), (CommandContext<CommandSourceStack>)ctx, "invasionType");
                    fiwData.getInvasionSpawner().getQueuedInvasions().remove(invasion);
                }
                if (invasion != null) {
                    ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("commands.puresuffering.remove.success.queued.all." + (invasion.isPrimary() ? "primary" : "secondary")).m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
                }
            }
            return 0;
        }))));
    }

    private static boolean contains(Iterable<Invasion> invasionListIn, InvasionType invasionTypeIn) {
        for (Invasion invasion : invasionListIn) {
            if (invasion.getType() != invasionTypeIn) continue;
            return true;
        }
        return false;
    }

    private static Invasion getInvasion(Iterable<Invasion> invasionListIn, CommandContext<CommandSourceStack> ctxIn, String argIn) throws CommandSyntaxException {
        ResourceLocation resourceLocation = (ResourceLocation)ctxIn.getArgument(argIn, ResourceLocation.class);
        InvasionType invasionType = PSEventManager.BaseEvents.getInvasionTypeManager().getInvasionType(resourceLocation);
        if (invasionType == null) {
            throw ERROR_UNKNOWN_INVASION_TYPE.create((Object)resourceLocation);
        }
        for (Invasion invasion : invasionListIn) {
            if (invasion.getType() != invasionType) continue;
            return invasion;
        }
        throw ERROR_UNKNOWN_INVASION_TYPE.create((Object)resourceLocation);
    }
}

