/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.invasion;

import dev.theagameplayer.puresuffering.PSEventManager;
import dev.theagameplayer.puresuffering.config.PSConfigValues;
import dev.theagameplayer.puresuffering.invasion.InvasionType;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Invasion {
    private static final ArrayList<Biome> MIXED_BIOMES = new ArrayList(ForgeRegistries.BIOMES.getValues());
    private final ArrayList<UUID> invasionMobs = new ArrayList();
    private final InvasionType invasionType;
    private final int severity;
    private final boolean isPrimary;
    private final int mobCap;
    private final boolean shouldTick;
    private final SimpleWeightedRandomList<SpawnData> spawnPotentials = SimpleWeightedRandomList.m_185864_();
    private SpawnData nextSpawnData = new SpawnData();
    private int spawnDelay;

    public Invasion(InvasionType invasionTypeIn, int severityIn, boolean isPrimaryIn) {
        InvasionType.SeverityInfo info = invasionTypeIn.getSeverityInfo().get(severityIn);
        int mobCap = isPrimaryIn ? PSConfigValues.common.primaryInvasionMobCap : PSConfigValues.common.secondaryInvasionMobCap;
        this.invasionType = invasionTypeIn;
        this.severity = severityIn;
        this.isPrimary = isPrimaryIn;
        this.mobCap = (int)((float)mobCap * info.getMobCapPercentage()) + 1;
        this.shouldTick = info.getTickDelay() > -1 && (invasionTypeIn.getSpawningSystem() != InvasionType.SpawningSystem.DEFAULT || info.getMobSpawnList() != null && invasionTypeIn.getSpawningSystem() == InvasionType.SpawningSystem.DEFAULT);
    }

    public InvasionType getType() {
        return this.invasionType;
    }

    public int getSeverity() {
        return this.severity;
    }

    public boolean isPrimary() {
        return this.isPrimary;
    }

    public int getMobCap() {
        return this.mobCap;
    }

    public InvasionType.SeverityInfo getSeverityInfo() {
        return this.invasionType.getSeverityInfo().get(this.severity);
    }

    public void tick(ServerLevel worldIn) {
        this.invasionMobs.removeIf(uuid -> worldIn.m_8791_(uuid) == null || !worldIn.m_8791_(uuid).m_6084_());
        switch (this.invasionType.getWeatherType()) {
            case DEFAULT: {
                break;
            }
            case CLEAR: {
                if (!worldIn.m_46471_() && !worldIn.m_46470_()) break;
                worldIn.m_8606_(600, 0, false, false);
                break;
            }
            case RAIN: {
                if (worldIn.m_46471_()) break;
                worldIn.m_8606_(0, 600, true, false);
                break;
            }
            case THUNDER: {
                if (worldIn.m_46470_()) break;
                worldIn.m_8606_(0, 600, true, true);
            }
        }
        if (this.shouldTick) {
            this.tickEntitySpawn(worldIn);
        }
    }

    protected void tickEntitySpawn(ServerLevel worldIn) {
        if (this.invasionMobs.size() < this.mobCap) {
            if (this.spawnDelay < 0) {
                this.delay(worldIn);
            }
            if (this.spawnDelay > 0) {
                --this.spawnDelay;
                return;
            }
            boolean flag1 = false;
            if (worldIn.m_6907_().size() < 1) {
                return;
            }
            ChunkPos chunkPos = this.getSpawnChunk(worldIn);
            if (chunkPos == null || !worldIn.m_46749_(chunkPos.m_45615_())) {
                return;
            }
            List<MobSpawnSettings.SpawnerData> mobs = this.getMobSpawnList(worldIn, chunkPos);
            if (mobs.isEmpty()) {
                return;
            }
            int clusterSize = worldIn.f_46441_.nextInt(this.getSeverityInfo().getClusterSize()) + 1;
            for (int cluster = 0; cluster < clusterSize && this.invasionMobs.size() < this.mobCap; ++cluster) {
                MobSpawnSettings.SpawnerData spawners = mobs.get(worldIn.f_46441_.nextInt(mobs.size()));
                int groupSize = worldIn.f_46441_.nextInt(spawners.f_48406_ - spawners.f_48405_ + 1) + spawners.f_48405_;
                this.nextSpawnData.m_186567_().m_128359_("id", ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)spawners.f_48404_).toString());
                CompoundTag compoundNBT = this.nextSpawnData.m_186567_();
                Optional optional = EntityType.m_20637_((CompoundTag)compoundNBT);
                if (!optional.isPresent()) {
                    this.delay(worldIn);
                    return;
                }
                for (int count = 0; count < groupSize && this.invasionMobs.size() < this.mobCap; ++count) {
                    BlockPos spawnPos = this.getSpawnPos(worldIn, chunkPos, false);
                    if (spawnPos == null || !SpawnPlacements.m_21759_((EntityType)((EntityType)optional.get()), (ServerLevelAccessor)worldIn, (MobSpawnType)MobSpawnType.EVENT, (BlockPos)spawnPos, (Random)worldIn.m_5822_())) continue;
                    Entity entity = EntityType.m_20645_((CompoundTag)compoundNBT, (Level)worldIn, e -> {
                        e.m_7678_((double)spawnPos.m_123341_(), (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_(), e.m_146908_(), e.m_146909_());
                        return e;
                    });
                    if (entity == null) {
                        this.delay(worldIn);
                        return;
                    }
                    entity.m_7678_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), worldIn.f_46441_.nextFloat() * 360.0f, 0.0f);
                    if (entity instanceof Mob) {
                        Mob mobEntity = (Mob)entity;
                        if (this.nextSpawnData.m_186567_().m_128440_() == 1 && this.nextSpawnData.m_186567_().m_128425_("id", 8) && !ForgeEventFactory.doSpecialSpawn((Mob)mobEntity, (LevelAccessor)worldIn, (float)((float)mobEntity.m_20185_()), (float)((float)mobEntity.m_20186_()), (float)((float)mobEntity.m_20189_()), null, (MobSpawnType)MobSpawnType.EVENT)) {
                            this.spawnInvasionMob(worldIn, mobEntity);
                        }
                    }
                    if (!worldIn.m_8860_(entity)) {
                        this.delay(worldIn);
                        return;
                    }
                    flag1 = true;
                }
            }
            if (flag1) {
                this.delay(worldIn);
            }
        }
    }

    protected void spawnInvasionMob(ServerLevel worldIn, Mob mobEntityIn) {
        mobEntityIn.getPersistentData().m_128359_("InvasionMob", this.invasionType.getId().toString());
        mobEntityIn.getPersistentData().m_128379_("AntiGrief", worldIn.m_6042_().m_63967_());
        mobEntityIn.m_6518_((ServerLevelAccessor)worldIn, worldIn.m_6436_(mobEntityIn.m_142538_()), MobSpawnType.EVENT, (SpawnGroupData)null, (CompoundTag)null);
        if (PSConfigValues.common.shouldMobsSpawnWithMaxRange) {
            mobEntityIn.m_21051_(Attributes.f_22277_).m_22100_(2048.0);
        }
        this.invasionMobs.add(mobEntityIn.m_142081_());
        worldIn.m_46796_(2004, mobEntityIn.m_142538_(), 0);
        mobEntityIn.m_21373_();
    }

    protected final void delay(ServerLevel worldIn) {
        this.spawnDelay = this.getSeverityInfo().getTickDelay();
        this.spawnPotentials.m_146335_(worldIn.f_46441_).ifPresent(entry -> {
            this.nextSpawnData = (SpawnData)entry.m_146310_();
        });
    }

    protected final List<MobSpawnSettings.SpawnerData> getMobSpawnList(ServerLevel worldIn, ChunkPos chunkPosIn) {
        BlockPos biomePos = this.getSpawnPos(worldIn, chunkPosIn, true);
        ArrayList<MobSpawnSettings.SpawnerData> originalList = new ArrayList<MobSpawnSettings.SpawnerData>(this.getSeverityInfo().getMobSpawnList());
        switch (this.invasionType.getSpawningSystem()) {
            case DEFAULT: {
                break;
            }
            case BIOME_BOOSTED: {
                originalList.addAll(this.getBiomeSpawnList(biomePos, worldIn.m_46865_(biomePos)));
                break;
            }
            case BIOME_MIXED: {
                originalList.addAll(this.getMixedSpawnList(worldIn));
            }
        }
        ArrayList<MobSpawnSettings.SpawnerData> newList = new ArrayList<MobSpawnSettings.SpawnerData>();
        if (!originalList.isEmpty()) {
            for (MobSpawnSettings.SpawnerData spawners : originalList) {
                for (int w = 0; w < spawners.m_142631_().m_146281_(); ++w) {
                    newList.add(spawners);
                }
            }
        }
        return newList;
    }

    private final ArrayList<MobSpawnSettings.SpawnerData> getBiomeSpawnList(BlockPos posIn, ChunkAccess chunkIn) {
        ArrayList<MobSpawnSettings.SpawnerData> spawners = new ArrayList<MobSpawnSettings.SpawnerData>(((Biome)chunkIn.m_203495_(posIn.m_123341_(), posIn.m_123342_(), posIn.m_123343_()).m_203334_()).m_47518_().m_151798_(MobCategory.MONSTER).m_146338_());
        spawners.removeIf(spawner -> {
            ResourceLocation name = spawner.f_48404_.getRegistryName();
            return PSConfigValues.common.modBiomeBoostedBlacklist.contains(name.m_135827_()) || PSConfigValues.common.mobBiomeBoostedBlacklist.contains(name.toString());
        });
        return spawners;
    }

    private final ArrayList<MobSpawnSettings.SpawnerData> getMixedSpawnList(ServerLevel worldIn) {
        ArrayList<MobSpawnSettings.SpawnerData> spawners = new ArrayList<MobSpawnSettings.SpawnerData>(MIXED_BIOMES.get(worldIn.f_46441_.nextInt(MIXED_BIOMES.size())).m_47518_().m_151798_(MobCategory.MONSTER).m_146338_());
        spawners.removeIf(spawner -> {
            ResourceLocation name = spawner.f_48404_.getRegistryName();
            return PSConfigValues.common.modBiomeBoostedBlacklist.contains(name.m_135827_()) || PSConfigValues.common.mobBiomeBoostedBlacklist.contains(name.toString());
        });
        return spawners;
    }

    protected final ChunkPos getSpawnChunk(ServerLevel worldIn) {
        int players = worldIn.m_6907_().size();
        if (players < 1) {
            return null;
        }
        ServerPlayer player = (ServerPlayer)worldIn.m_6907_().get(worldIn.f_46441_.nextInt(players));
        ChunkPos chunkPos = worldIn.m_46865_(player.m_142538_()).m_7697_();
        int chunkX = chunkPos.f_45578_ - 8 + worldIn.f_46441_.nextInt(17);
        int chunkZ = chunkPos.f_45579_ - 8 + worldIn.f_46441_.nextInt(17);
        boolean flag = chunkPos.f_45578_ == chunkX && chunkPos.f_45579_ == chunkZ;
        ChunkPos chunkPos1 = new ChunkPos(flag ? chunkX + this.getChunkOffset(worldIn) : chunkX, flag ? chunkZ + this.getChunkOffset(worldIn) : chunkZ);
        return chunkPos1;
    }

    private final int getChunkOffset(ServerLevel worldIn) {
        int offSet = worldIn.f_46441_.nextInt(8) + 1;
        return worldIn.f_46441_.nextBoolean() ? offSet : -offSet;
    }

    protected final BlockPos getSpawnPos(ServerLevel worldIn, ChunkPos chunkPosIn, boolean biomeCheckIn) {
        int x = chunkPosIn.m_45604_() + worldIn.f_46441_.nextInt(16);
        int z = chunkPosIn.m_45605_() + worldIn.f_46441_.nextInt(16);
        int surface = worldIn.m_6924_(Heightmap.Types.WORLD_SURFACE, x, z) + 1;
        if (biomeCheckIn || !worldIn.m_6042_().m_63946_() && worldIn.f_46441_.nextBoolean()) {
            return new BlockPos(x, surface, z);
        }
        BlockState air = Blocks.f_50016_.m_49966_();
        BlockState bedrock = Blocks.f_50752_.m_49966_();
        ArrayList<BlockPos> potentialPos = new ArrayList<BlockPos>();
        for (int y = 0; y < surface; ++y) {
            BlockPos pos = new BlockPos(x, y, z);
            if (worldIn.m_8055_(pos) == air || worldIn.m_8055_(pos) == bedrock || worldIn.m_8055_(pos.m_7494_()) != air) continue;
            potentialPos.add(pos.m_7494_());
        }
        return potentialPos.size() > 0 ? (BlockPos)potentialPos.get(worldIn.f_46441_.nextInt(potentialPos.size())) : new BlockPos(x, surface, z);
    }

    @Nullable
    public static Invasion load(CompoundTag nbtIn) {
        if (PSEventManager.BaseEvents.getInvasionTypeManager().verifyInvasion(nbtIn.m_128461_("InvasionType"))) {
            InvasionType invasionType = PSEventManager.BaseEvents.getInvasionTypeManager().getInvasionType(ResourceLocation.m_135820_((String)nbtIn.m_128461_("InvasionType")));
            Invasion invasion = new Invasion(invasionType, nbtIn.m_128451_("Severity"), nbtIn.m_128471_("IsPrimary"));
            CompoundTag invasionMobs = nbtIn.m_128469_("InvasionMobs");
            for (String name : invasionMobs.m_128431_()) {
                invasion.invasionMobs.add(invasionMobs.m_128342_(name));
            }
            return invasion;
        }
        return null;
    }

    public CompoundTag save() {
        CompoundTag nbt = new CompoundTag();
        CompoundTag mobs = new CompoundTag();
        for (UUID id : this.invasionMobs) {
            mobs.m_128362_(id.toString(), id);
        }
        nbt.m_128365_("InvasionMobs", (Tag)mobs);
        nbt.m_128359_("InvasionType", this.invasionType.toString());
        nbt.m_128405_("Severity", this.severity);
        nbt.m_128379_("IsPrimary", this.isPrimary);
        return nbt;
    }

    public String toString() {
        return this.invasionType.toString();
    }
}

