/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.network.packet;

import dev.theagameplayer.puresuffering.util.InvasionListType;
import dev.theagameplayer.puresuffering.world.ClientInvasionWorldInfo;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public final class ClearInvasionsPacket {
    private final InvasionListType listType;

    public ClearInvasionsPacket(InvasionListType listTypeIn) {
        this.listType = listTypeIn;
    }

    public static void encode(ClearInvasionsPacket msgIn, FriendlyByteBuf bufIn) {
        bufIn.m_130068_((Enum)msgIn.listType);
    }

    public static ClearInvasionsPacket decode(FriendlyByteBuf bufIn) {
        return new ClearInvasionsPacket((InvasionListType)bufIn.m_130066_(InvasionListType.class));
    }

    public static class Handler {
        public static boolean handle(ClearInvasionsPacket msgIn, Supplier<NetworkEvent.Context> ctxIn) {
            ctxIn.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> Handler.lambda$handle$1(msgIn, (Supplier)ctxIn)));
            return true;
        }

        private static void handlePacket(ClearInvasionsPacket msgIn, Supplier<NetworkEvent.Context> ctxIn) {
            Minecraft mc = Minecraft.m_91087_();
            switch (msgIn.listType) {
                case DAY: {
                    ClientInvasionWorldInfo.getDayClientInfo(mc.f_91073_).getRendererMap().clear();
                    break;
                }
                case NIGHT: {
                    ClientInvasionWorldInfo.getNightClientInfo(mc.f_91073_).getRendererMap().clear();
                    break;
                }
                case FIXED: {
                    ClientInvasionWorldInfo.getFixedClientInfo(mc.f_91073_).getRendererMap().clear();
                }
            }
        }

        private static /* synthetic */ Runnable lambda$handle$1(ClearInvasionsPacket msgIn, Supplier ctxIn) {
            return () -> Handler.lambda$handle$0(msgIn, (Supplier)ctxIn);
        }

        private static /* synthetic */ void lambda$handle$0(ClearInvasionsPacket msgIn, Supplier ctxIn) {
            Handler.handlePacket(msgIn, ctxIn);
        }
    }
}

