/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.network.packet;

import dev.theagameplayer.puresuffering.client.renderer.InvasionSkyRenderer;
import dev.theagameplayer.puresuffering.util.InvasionListType;
import dev.theagameplayer.puresuffering.world.ClientInvasionWorldInfo;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public final class RemoveInvasionPacket {
    private final InvasionSkyRenderer renderer;
    private final InvasionListType listType;

    public RemoveInvasionPacket(InvasionSkyRenderer rendererIn, InvasionListType listTypeIn) {
        this.renderer = rendererIn;
        this.listType = listTypeIn;
    }

    public static void encode(RemoveInvasionPacket msgIn, FriendlyByteBuf bufIn) {
        msgIn.renderer.deconstruct().serializeToNetwork(bufIn);
        bufIn.m_130085_(msgIn.renderer.getId());
        bufIn.m_130068_((Enum)msgIn.listType);
    }

    public static RemoveInvasionPacket decode(FriendlyByteBuf bufIn) {
        InvasionSkyRenderer renderer = InvasionSkyRenderer.Builder.fromNetwork(bufIn).build(bufIn.m_130281_());
        return new RemoveInvasionPacket(renderer, (InvasionListType)bufIn.m_130066_(InvasionListType.class));
    }

    public static class Handler {
        public static boolean handle(RemoveInvasionPacket msgIn, Supplier<NetworkEvent.Context> ctxIn) {
            ctxIn.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> Handler.lambda$handle$1(msgIn, (Supplier)ctxIn)));
            return true;
        }

        private static void handlePacket(RemoveInvasionPacket msgIn, Supplier<NetworkEvent.Context> ctxIn) {
            Minecraft mc = Minecraft.m_91087_();
            switch (msgIn.listType) {
                case DAY: {
                    ClientInvasionWorldInfo.getDayClientInfo(mc.f_91073_).getRendererMap().remove(msgIn.renderer);
                    break;
                }
                case NIGHT: {
                    ClientInvasionWorldInfo.getNightClientInfo(mc.f_91073_).getRendererMap().remove(msgIn.renderer);
                    break;
                }
                case FIXED: {
                    ClientInvasionWorldInfo.getFixedClientInfo(mc.f_91073_).getRendererMap().remove(msgIn.renderer);
                }
            }
        }

        private static /* synthetic */ Runnable lambda$handle$1(RemoveInvasionPacket msgIn, Supplier ctxIn) {
            return () -> Handler.lambda$handle$0(msgIn, (Supplier)ctxIn);
        }

        private static /* synthetic */ void lambda$handle$0(RemoveInvasionPacket msgIn, Supplier ctxIn) {
            Handler.handlePacket(msgIn, ctxIn);
        }
    }
}

