/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.spawner;

import dev.theagameplayer.puresuffering.PSEventManager;
import dev.theagameplayer.puresuffering.config.PSConfigValues;
import dev.theagameplayer.puresuffering.invasion.Invasion;
import dev.theagameplayer.puresuffering.invasion.InvasionType;
import dev.theagameplayer.puresuffering.util.InvasionChart;
import dev.theagameplayer.puresuffering.util.InvasionList;
import dev.theagameplayer.puresuffering.util.InvasionListType;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class FixedInvasionSpawner {
    private static final Logger LOGGER = LogManager.getLogger((String)"puresuffering");
    private final InvasionList invasions = new InvasionList(InvasionListType.FIXED);
    private final ArrayList<Invasion> queuedInvasions = new ArrayList();
    private int interval;

    public void setInvasions(ServerLevel worldIn, boolean isCanceledIn, int amountIn, long daysIn) {
        int totalInvasions;
        this.invasions.clear();
        Random random = worldIn.f_46441_;
        int n = !this.queuedInvasions.isEmpty() ? this.queuedInvasions.size() : (totalInvasions = this.calculateInvasions(random, amountIn, this.interval, isCanceledIn, daysIn == 0L));
        this.interval = this.interval > 0 ? this.interval - 1 : (PSConfigValues.common.consistentInvasions ? PSConfigValues.common.fixedInvasionRarity : random.nextInt(PSConfigValues.common.fixedInvasionRarity) + PSConfigValues.common.fixedInvasionRarity - (int)(daysIn % (long)PSConfigValues.common.fixedInvasionRarity));
        InvasionChart.refresh();
        InvasionChart potentialPrimaryInvasions = new InvasionChart(PSEventManager.BaseEvents.getInvasionTypeManager().getInvasionTypesOf(it -> !(!it.getDimensions().contains(worldIn.m_46472_().m_135782_()) || PSConfigValues.common.tieredInvasions && daysIn < (long)(it.getTier() * PSConfigValues.common.fixedDifficultyIncreaseDelay) || it.getInvasionPriority() == InvasionType.InvasionPriority.SECONDARY_ONLY || !PSConfigValues.common.primaryWhitelist.isEmpty() && !PSConfigValues.common.primaryWhitelist.contains(it.getId().toString()))));
        InvasionChart potentialSecondaryInvasions = new InvasionChart(PSEventManager.BaseEvents.getInvasionTypeManager().getInvasionTypesOf(it -> it.getDimensions().contains(worldIn.m_46472_().m_135782_()) && (!PSConfigValues.common.tieredInvasions || daysIn >= (long)(it.getTier() * PSConfigValues.common.fixedDifficultyIncreaseDelay)) && it.getInvasionPriority() != InvasionType.InvasionPriority.PRIMARY_ONLY));
        LOGGER.info("Setting Fixed Invasions: [");
        this.invasions.setCanceled(this.queuedInvasions.isEmpty() && isCanceledIn);
        if (!this.queuedInvasions.isEmpty()) {
            for (int q = 0; q < this.queuedInvasions.size(); ++q) {
                Invasion invasion = this.queuedInvasions.get(q);
                this.invasions.add(invasion);
                LOGGER.info("Queued Invasion " + (q + 1) + ": " + invasion.getType() + " - " + (invasion.getSeverity() + 1));
            }
            this.queuedInvasions.clear();
        } else {
            for (int inv = 0; inv < totalInvasions; ++inv) {
                InvasionType invasionType = this.getInvasionType(inv == 0 ? potentialPrimaryInvasions : potentialSecondaryInvasions, random);
                if (invasionType == null) continue;
                int severity = random.nextInt(random.nextInt(Mth.m_14045_((int)((int)daysIn / PSConfigValues.common.fixedDifficultyIncreaseDelay - invasionType.getTier()), (int)1, (int)invasionType.getMaxSeverity())) + 1);
                Invasion invasion = new Invasion(invasionType, severity, inv == 0);
                this.invasions.add(invasion);
                LOGGER.info("Invasion " + (inv + 1) + ": " + invasionType + " - " + (severity + 1));
            }
        }
        LOGGER.info("]");
    }

    private int calculateInvasions(Random randomIn, int amountIn, int intervalIn, boolean isCanceledIn, boolean isFirstDayIn) {
        return !isFirstDayIn && intervalIn == 0 && amountIn > 0 && !isCanceledIn ? randomIn.nextInt(amountIn) + 1 : 0;
    }

    private InvasionType getInvasionType(InvasionChart invasionChartIn, Random randomIn) {
        return invasionChartIn.getInvasionInRange(randomIn.nextFloat());
    }

    public void invasionTick(MinecraftServer serverIn, ServerLevel worldIn) {
        if (!this.invasions.isEmpty()) {
            Invasion invasion = this.invasions.get(worldIn.m_5822_().nextInt(this.invasions.size()));
            invasion.tick(worldIn);
        }
    }

    public void load(CompoundTag nbtIn) {
        ListTag invasionsNBT = nbtIn.m_128437_("Invasions", 10);
        ListTag queuedInvasionsNBT = nbtIn.m_128437_("QueuedInvasions", 10);
        for (Tag inbt : invasionsNBT) {
            this.invasions.add(Invasion.load((CompoundTag)inbt));
        }
        for (Tag inbt : queuedInvasionsNBT) {
            this.queuedInvasions.add(Invasion.load((CompoundTag)inbt));
        }
        this.interval = nbtIn.m_128451_("Interval");
    }

    public CompoundTag save() {
        CompoundTag nbt = new CompoundTag();
        ListTag invasionsNBT = new ListTag();
        ListTag queuedInvasionsNBT = new ListTag();
        for (Invasion invasion : this.invasions) {
            invasionsNBT.add((Object)invasion.save());
        }
        for (Invasion invasion : this.queuedInvasions) {
            invasionsNBT.add((Object)invasion.save());
        }
        nbt.m_128365_("Invasions", (Tag)invasionsNBT);
        nbt.m_128365_("QueuedInvasions", (Tag)queuedInvasionsNBT);
        nbt.m_128405_("Interval", this.interval);
        return nbt;
    }

    public InvasionList getInvasions() {
        return this.invasions;
    }

    public ArrayList<Invasion> getQueuedInvasions() {
        return this.queuedInvasions;
    }
}

