/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.spawner;

import dev.theagameplayer.puresuffering.PSEventManager;
import dev.theagameplayer.puresuffering.config.PSConfigValues;
import dev.theagameplayer.puresuffering.invasion.Invasion;
import dev.theagameplayer.puresuffering.invasion.InvasionType;
import dev.theagameplayer.puresuffering.util.InvasionChart;
import dev.theagameplayer.puresuffering.util.InvasionList;
import dev.theagameplayer.puresuffering.util.InvasionListType;
import dev.theagameplayer.puresuffering.util.ServerTimeUtil;
import dev.theagameplayer.puresuffering.world.InvasionWorldData;
import dev.theagameplayer.puresuffering.world.TimedInvasionWorldData;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class TimedInvasionSpawner {
    private static final Logger LOGGER = LogManager.getLogger((String)"puresuffering");
    private final InvasionList nightInvasions = new InvasionList(InvasionListType.NIGHT);
    private final InvasionList dayInvasions = new InvasionList(InvasionListType.DAY);
    private final ArrayList<Invasion> queuedNightInvasions = new ArrayList();
    private final ArrayList<Invasion> queuedDayInvasions = new ArrayList();
    private boolean isNightChangedToDay;
    private boolean isDayChangedToNight;
    private int nightInterval;
    private int dayInterval;

    public void setNightInvasions(ServerLevel worldIn, boolean isCanceledIn, int amountIn, long daysIn) {
        int totalInvasions;
        this.nightInvasions.clear();
        Random random = worldIn.f_46441_;
        this.isNightChangedToDay = false;
        int n = !this.queuedNightInvasions.isEmpty() ? this.queuedNightInvasions.size() : (totalInvasions = this.calculateInvasions(random, amountIn, this.nightInterval, isCanceledIn, daysIn == 0L));
        this.nightInterval = this.nightInterval > 0 ? this.nightInterval - 1 : (PSConfigValues.common.consistentInvasions ? PSConfigValues.common.nightInvasionRarity : random.nextInt(PSConfigValues.common.nightInvasionRarity) + PSConfigValues.common.nightInvasionRarity - (int)(daysIn % (long)PSConfigValues.common.nightInvasionRarity));
        InvasionChart.refresh();
        InvasionChart potentialPrimaryNightInvasions = new InvasionChart(PSEventManager.BaseEvents.getInvasionTypeManager().getInvasionTypesOf(it -> !(it.getInvasionTime() == InvasionType.InvasionTime.DAY || !it.getDimensions().contains(worldIn.m_46472_().m_135782_()) || PSConfigValues.common.tieredInvasions && daysIn < (long)(it.getTier() * PSConfigValues.common.nightDifficultyIncreaseDelay) || it.getInvasionPriority() == InvasionType.InvasionPriority.SECONDARY_ONLY || !PSConfigValues.common.primaryWhitelist.isEmpty() && !PSConfigValues.common.primaryWhitelist.contains(it.getId().toString()))));
        InvasionChart potentialSecondaryNightInvasions = new InvasionChart(PSEventManager.BaseEvents.getInvasionTypeManager().getInvasionTypesOf(it -> it.getInvasionTime() != InvasionType.InvasionTime.DAY && it.getDimensions().contains(worldIn.m_46472_().m_135782_()) && (!PSConfigValues.common.tieredInvasions || daysIn >= (long)(it.getTier() * PSConfigValues.common.nightDifficultyIncreaseDelay)) && it.getInvasionPriority() != InvasionType.InvasionPriority.PRIMARY_ONLY));
        InvasionChart potentialSecondaryDayInvasions = new InvasionChart(PSEventManager.BaseEvents.getInvasionTypeManager().getInvasionTypesOf(it -> it.getInvasionTime() != InvasionType.InvasionTime.NIGHT && it.getDimensions().contains(worldIn.m_46472_().m_135782_()) && (!PSConfigValues.common.tieredInvasions || daysIn >= (long)(it.getTier() * PSConfigValues.common.nightDifficultyIncreaseDelay)) && it.getInvasionPriority() != InvasionType.InvasionPriority.PRIMARY_ONLY && it.getTimeChangeability() != InvasionType.TimeChangeability.ONLY_DAY));
        LOGGER.info("Setting Night Invasions: [");
        this.nightInvasions.setCanceled(this.queuedNightInvasions.isEmpty() && isCanceledIn);
        if (!this.queuedNightInvasions.isEmpty()) {
            for (int q = 0; q < this.queuedNightInvasions.size(); ++q) {
                Invasion invasion = this.queuedNightInvasions.get(q);
                this.nightInvasions.add(invasion);
                LOGGER.info("Queued Invasion " + (q + 1) + ": " + invasion.getType() + " - " + (invasion.getSeverity() + 1));
            }
            this.queuedNightInvasions.clear();
        } else {
            for (int inv = 0; inv < totalInvasions; ++inv) {
                InvasionType invasionType = this.getInvasionType(inv == 0 ? potentialPrimaryNightInvasions : (this.isNightChangedToDay ? potentialSecondaryDayInvasions : potentialSecondaryNightInvasions), random);
                if (invasionType == null) continue;
                int severity = random.nextInt(random.nextInt(Mth.m_14045_((int)((int)daysIn / PSConfigValues.common.nightDifficultyIncreaseDelay - invasionType.getTier()), (int)1, (int)invasionType.getMaxSeverity())) + 1);
                Invasion invasion = new Invasion(invasionType, severity, inv == 0);
                this.nightInvasions.add(invasion);
                LOGGER.info("Invasion " + (inv + 1) + ": " + invasionType + " - " + (severity + 1));
                this.isNightChangedToDay |= invasionType.getTimeModifier() == InvasionType.TimeModifier.NIGHT_TO_DAY;
            }
        }
        LOGGER.info("]");
    }

    public void setDayInvasions(ServerLevel worldIn, boolean isCanceledIn, int amountIn, long daysIn) {
        int totalInvasions;
        this.dayInvasions.clear();
        Random random = worldIn.f_46441_;
        this.isDayChangedToNight = false;
        int n = !this.queuedDayInvasions.isEmpty() ? this.queuedDayInvasions.size() : (totalInvasions = this.calculateInvasions(random, amountIn, this.dayInterval, isCanceledIn, daysIn == 0L));
        this.dayInterval = this.dayInterval > 0 ? this.dayInterval - 1 : (PSConfigValues.common.consistentInvasions ? PSConfigValues.common.dayInvasionRarity : random.nextInt(PSConfigValues.common.dayInvasionRarity) + PSConfigValues.common.dayInvasionRarity - (int)(daysIn % (long)PSConfigValues.common.dayInvasionRarity));
        InvasionChart.refresh();
        InvasionChart potentialPrimaryDayInvasions = new InvasionChart(PSEventManager.BaseEvents.getInvasionTypeManager().getInvasionTypesOf(it -> !(it.getInvasionTime() == InvasionType.InvasionTime.NIGHT || !it.getDimensions().contains(worldIn.m_46472_().m_135782_()) || PSConfigValues.common.tieredInvasions && daysIn < (long)(it.getTier() * PSConfigValues.common.dayDifficultyIncreaseDelay) || it.getInvasionPriority() == InvasionType.InvasionPriority.SECONDARY_ONLY || !PSConfigValues.common.primaryWhitelist.isEmpty() && !PSConfigValues.common.primaryWhitelist.contains(it.getId().toString()))));
        InvasionChart potentialSecondaryDayInvasions = new InvasionChart(PSEventManager.BaseEvents.getInvasionTypeManager().getInvasionTypesOf(it -> it.getInvasionTime() != InvasionType.InvasionTime.NIGHT && it.getDimensions().contains(worldIn.m_46472_().m_135782_()) && (!PSConfigValues.common.tieredInvasions || daysIn >= (long)(it.getTier() * PSConfigValues.common.dayDifficultyIncreaseDelay)) && it.getInvasionPriority() != InvasionType.InvasionPriority.PRIMARY_ONLY));
        InvasionChart potentialSecondaryNightInvasions = new InvasionChart(PSEventManager.BaseEvents.getInvasionTypeManager().getInvasionTypesOf(it -> it.getInvasionTime() != InvasionType.InvasionTime.DAY && it.getDimensions().contains(worldIn.m_46472_().m_135782_()) && (!PSConfigValues.common.tieredInvasions || daysIn >= (long)(it.getTier() * PSConfigValues.common.dayDifficultyIncreaseDelay)) && it.getInvasionPriority() != InvasionType.InvasionPriority.PRIMARY_ONLY && it.getTimeChangeability() != InvasionType.TimeChangeability.ONLY_NIGHT));
        LOGGER.info("Setting Day Invasions: [");
        this.dayInvasions.setCanceled(this.queuedDayInvasions.isEmpty() && isCanceledIn);
        if (!this.queuedDayInvasions.isEmpty()) {
            for (int q = 0; q < this.queuedDayInvasions.size(); ++q) {
                Invasion invasion = this.queuedDayInvasions.get(q);
                this.dayInvasions.add(invasion);
                LOGGER.info("Queued Invasion " + (q + 1) + ": " + invasion.getType() + " - " + (invasion.getSeverity() + 1));
            }
            this.queuedDayInvasions.clear();
        } else {
            for (int inv = 0; inv < totalInvasions; ++inv) {
                InvasionType invasionType = this.getInvasionType(inv == 0 ? potentialPrimaryDayInvasions : (this.isDayChangedToNight ? potentialSecondaryNightInvasions : potentialSecondaryDayInvasions), random);
                if (invasionType == null) continue;
                int severity = random.nextInt(random.nextInt(Mth.m_14045_((int)((int)daysIn / PSConfigValues.common.dayDifficultyIncreaseDelay - invasionType.getTier()), (int)1, (int)invasionType.getMaxSeverity())) + 1);
                Invasion invasion = new Invasion(invasionType, severity, inv == 0);
                this.dayInvasions.add(invasion);
                LOGGER.info("Invasion " + (inv + 1) + ": " + invasionType + " - " + (severity + 1));
                this.isDayChangedToNight |= invasionType.getTimeModifier() == InvasionType.TimeModifier.DAY_TO_NIGHT;
            }
        }
        LOGGER.info("]");
    }

    private int calculateInvasions(Random randomIn, int amountIn, int intervalIn, boolean isCanceledIn, boolean isFirstDayIn) {
        return !isFirstDayIn && intervalIn == 0 && amountIn > 0 && !isCanceledIn ? randomIn.nextInt(amountIn) + 1 : 0;
    }

    private InvasionType getInvasionType(InvasionChart invasionChartIn, Random randomIn) {
        return invasionChartIn.getInvasionInRange(randomIn.nextFloat());
    }

    public void invasionTick(MinecraftServer serverIn, ServerLevel worldIn) {
        TimedInvasionWorldData tiwData = (TimedInvasionWorldData)InvasionWorldData.getInvasionData().get(worldIn);
        if (!this.nightInvasions.isEmpty() && ServerTimeUtil.isServerNight(worldIn, tiwData)) {
            Invasion invasion = this.nightInvasions.get(worldIn.m_5822_().nextInt(this.nightInvasions.size()));
            invasion.tick(worldIn);
        } else if (!this.dayInvasions.isEmpty() && ServerTimeUtil.isServerDay(worldIn, tiwData)) {
            Invasion invasion = this.dayInvasions.get(worldIn.m_5822_().nextInt(this.dayInvasions.size()));
            invasion.tick(worldIn);
        }
    }

    public void load(CompoundTag nbtIn) {
        ListTag nightInvasionsNBT = nbtIn.m_128437_("NightInvasions", 10);
        ListTag dayInvasionsNBT = nbtIn.m_128437_("DayInvasions", 10);
        ListTag queuedNightInvasionsNBT = nbtIn.m_128437_("QueuedNightInvasions", 10);
        ListTag queuedDayInvasionsNBT = nbtIn.m_128437_("QueuedDayInvasions", 10);
        for (Tag inbt : nightInvasionsNBT) {
            this.nightInvasions.add(Invasion.load((CompoundTag)inbt));
        }
        for (Tag inbt : dayInvasionsNBT) {
            this.dayInvasions.add(Invasion.load((CompoundTag)inbt));
        }
        for (Tag inbt : queuedNightInvasionsNBT) {
            this.queuedNightInvasions.add(Invasion.load((CompoundTag)inbt));
        }
        for (Tag inbt : queuedDayInvasionsNBT) {
            this.queuedDayInvasions.add(Invasion.load((CompoundTag)inbt));
        }
        this.isNightChangedToDay = nbtIn.m_128471_("IsNightChangedToDay");
        this.isDayChangedToNight = nbtIn.m_128471_("IsDayChangedToNight");
        this.nightInterval = nbtIn.m_128451_("NightInterval");
        this.dayInterval = nbtIn.m_128451_("DayInterval");
    }

    public CompoundTag save() {
        CompoundTag nbt = new CompoundTag();
        ListTag nightInvasionsNBT = new ListTag();
        ListTag dayInvasionsNBT = new ListTag();
        ListTag queuedNightInvasionsNBT = new ListTag();
        ListTag queuedDayInvasionsNBT = new ListTag();
        for (Invasion invasion : this.nightInvasions) {
            nightInvasionsNBT.add((Object)invasion.save());
        }
        for (Invasion invasion : this.dayInvasions) {
            dayInvasionsNBT.add((Object)invasion.save());
        }
        for (Invasion invasion : this.queuedNightInvasions) {
            queuedNightInvasionsNBT.add((Object)invasion.save());
        }
        for (Invasion invasion : this.queuedDayInvasions) {
            queuedDayInvasionsNBT.add((Object)invasion.save());
        }
        nbt.m_128365_("NightInvasions", (Tag)nightInvasionsNBT);
        nbt.m_128365_("DayInvasions", (Tag)dayInvasionsNBT);
        nbt.m_128365_("QueuedNightInvasions", (Tag)queuedNightInvasionsNBT);
        nbt.m_128365_("QueuedDayInvasions", (Tag)queuedDayInvasionsNBT);
        nbt.m_128379_("IsNightChangedToDay", this.isNightChangedToDay);
        nbt.m_128379_("IsDayChangedToNight", this.isDayChangedToNight);
        nbt.m_128405_("NightInterval", this.nightInterval);
        nbt.m_128405_("DayInterval", this.dayInterval);
        return nbt;
    }

    public InvasionList getNightInvasions() {
        return this.nightInvasions;
    }

    public InvasionList getDayInvasions() {
        return this.dayInvasions;
    }

    public ArrayList<Invasion> getQueuedNightInvasions() {
        return this.queuedNightInvasions;
    }

    public ArrayList<Invasion> getQueuedDayInvasions() {
        return this.queuedDayInvasions;
    }
}

