/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.world;

import dev.theagameplayer.puresuffering.spawner.TimedInvasionSpawner;
import dev.theagameplayer.puresuffering.util.ServerTimeUtil;
import dev.theagameplayer.puresuffering.world.InvasionWorldData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;

public final class TimedInvasionWorldData
extends InvasionWorldData {
    private final TimedInvasionSpawner spawner = new TimedInvasionSpawner();
    private double dayXPMultiplier;
    private double nightXPMultiplier;
    private boolean checkedDay;
    private boolean checkedNight;
    private boolean prevDayCheck;
    private boolean prevNightCheck;

    public TimedInvasionWorldData(ServerLevel worldIn) {
        super(worldIn);
        this.checkedDay = ServerTimeUtil.isServerNight(worldIn, this);
        this.checkedNight = ServerTimeUtil.isServerDay(worldIn, this);
    }

    public static TimedInvasionWorldData load(ServerLevel worldIn, CompoundTag nbtIn) {
        TimedInvasionWorldData tiwData = new TimedInvasionWorldData(worldIn);
        tiwData.spawner.load(nbtIn.m_128469_("Spawner"));
        tiwData.dayXPMultiplier = nbtIn.m_128459_("DayXPMultiplier");
        tiwData.nightXPMultiplier = nbtIn.m_128459_("NightXPMultiplier");
        tiwData.checkedDay = nbtIn.m_128471_("CheckedDay");
        tiwData.checkedNight = nbtIn.m_128471_("CheckedNight");
        tiwData.prevDayCheck = nbtIn.m_128471_("PrevDayCheck");
        tiwData.prevNightCheck = nbtIn.m_128471_("PrevNightCheck");
        tiwData.days = nbtIn.m_128454_("Days");
        return tiwData;
    }

    @Override
    public CompoundTag m_7176_(CompoundTag nbtIn) {
        nbtIn.m_128365_("Spawner", (Tag)this.spawner.save());
        nbtIn.m_128347_("DayXPMultiplier", this.dayXPMultiplier);
        nbtIn.m_128347_("NightXPMultiplier", this.nightXPMultiplier);
        nbtIn.m_128379_("CheckedDay", this.checkedDay);
        nbtIn.m_128379_("CheckedNight", this.checkedNight);
        nbtIn.m_128379_("PrevDayCheck", this.prevDayCheck);
        nbtIn.m_128379_("PrevNightCheck", this.prevNightCheck);
        return super.m_7176_(nbtIn);
    }

    public TimedInvasionSpawner getInvasionSpawner() {
        return this.spawner;
    }

    public double getDayXPMultiplier() {
        return this.dayXPMultiplier;
    }

    public void setDayXPMultiplier(double dayXPMultiplierIn) {
        this.dayXPMultiplier = dayXPMultiplierIn;
        this.m_77762_();
    }

    public double getNightXPMultiplier() {
        return this.nightXPMultiplier;
    }

    public void setNightXPMultiplier(double nightXPMultiplierIn) {
        this.nightXPMultiplier = nightXPMultiplierIn;
        this.m_77762_();
    }

    public boolean hasCheckedDay() {
        return this.checkedDay;
    }

    public void setCheckedDay(boolean checkedDayIn) {
        this.checkedDay = checkedDayIn;
        this.m_77762_();
    }

    public boolean hasCheckedNight() {
        return this.checkedNight;
    }

    public void setCheckedNight(boolean checkedNightIn) {
        this.checkedNight = checkedNightIn;
        this.m_77762_();
    }

    public boolean getPrevDayCheck() {
        return this.prevDayCheck;
    }

    public void setPrevDayCheck(boolean prevDayCheckIn) {
        this.prevDayCheck = prevDayCheckIn;
        this.m_77762_();
    }

    public boolean getPrevNightCheck() {
        return this.prevNightCheck;
    }

    public void setPrevNightCheck(boolean prevNightCheckIn) {
        this.prevNightCheck = prevNightCheckIn;
        this.m_77762_();
    }
}

