/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.invasion;

import dev.theagameplayer.puresuffering.PSEventManager;
import dev.theagameplayer.puresuffering.config.PSConfigValues;
import dev.theagameplayer.puresuffering.invasion.ClusterEntitySpawnData;
import dev.theagameplayer.puresuffering.invasion.HyperType;
import dev.theagameplayer.puresuffering.invasion.InvasionType;
import dev.theagameplayer.puresuffering.world.entity.PSHyperCharge;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.ForgeRegistries;

public final class Invasion {
    private static final ArrayList<Biome> MIXED_BIOMES = new ArrayList(ForgeRegistries.BIOMES.getValues());
    private final ArrayList<UUID> invasionMobs = new ArrayList();
    private final InvasionType invasionType;
    private final int severity;
    private final boolean isPrimary;
    private final HyperType hyperType;
    private final int mobCap;
    private final boolean shouldTick;
    private final SimpleWeightedRandomList<SpawnData> spawnPotentials = SimpleWeightedRandomList.m_185864_();
    private SpawnData nextSpawnData = new SpawnData();
    private int spawnDelay;

    public Invasion(InvasionType invasionTypeIn, int severityIn, boolean isPrimaryIn, HyperType hyperTypeIn) {
        InvasionType.SeverityInfo info = invasionTypeIn.getSeverityInfo().get(severityIn);
        int mobCap = isPrimaryIn ? PSConfigValues.common.primaryInvasionMobCap : PSConfigValues.common.secondaryInvasionMobCap;
        this.invasionType = invasionTypeIn;
        this.severity = severityIn;
        this.isPrimary = isPrimaryIn;
        this.hyperType = hyperTypeIn;
        this.mobCap = (int)((float)mobCap * info.getMobCapPercentage()) + 1;
        this.shouldTick = info.getTickDelay() > -1 && (invasionTypeIn.getSpawningSystem() != InvasionType.SpawningSystem.DEFAULT || info.getMobSpawnList() != null && invasionTypeIn.getSpawningSystem() == InvasionType.SpawningSystem.DEFAULT);
    }

    public final InvasionType getType() {
        return this.invasionType;
    }

    public final int getSeverity() {
        return this.severity;
    }

    public final boolean isPrimary() {
        return this.isPrimary;
    }

    public final HyperType getHyperType() {
        return this.hyperType;
    }

    public final int getMobCap() {
        return this.mobCap;
    }

    public final InvasionType.SeverityInfo getSeverityInfo() {
        return this.invasionType.getSeverityInfo().get(this.severity);
    }

    public final void tick(ServerLevel worldIn) {
        this.invasionMobs.removeIf(uuid -> worldIn.m_8791_(uuid) == null || !worldIn.m_8791_(uuid).m_6084_());
        switch (this.invasionType.getWeatherType()) {
            case DEFAULT: {
                break;
            }
            case CLEAR: {
                if (!worldIn.m_46471_() && !worldIn.m_46470_()) break;
                worldIn.m_8606_(600, 0, false, false);
                break;
            }
            case RAIN: {
                if (worldIn.m_46471_()) break;
                worldIn.m_8606_(0, 600, true, false);
                break;
            }
            case THUNDER: {
                if (worldIn.m_46470_()) break;
                worldIn.m_8606_(0, 600, true, true);
            }
        }
        if (this.shouldTick) {
            this.tickEntitySpawn(worldIn);
        }
    }

    private final void tickEntitySpawn(ServerLevel levelIn) {
        if (this.invasionMobs.size() < this.mobCap) {
            if (this.spawnDelay < 0) {
                this.delay(levelIn);
            }
            if (this.spawnDelay > 0) {
                --this.spawnDelay;
                return;
            }
            if (levelIn.m_6907_().size() < 1) {
                return;
            }
            boolean flag1 = false;
            ChunkPos chunkPos = this.getSpawnChunk(levelIn);
            List<MobSpawnSettings.SpawnerData> mobs = this.getMobSpawnList(levelIn, chunkPos);
            if (mobs.isEmpty()) {
                return;
            }
            int clusterSize = levelIn.f_46441_.m_188503_(this.getSeverityInfo().getClusterSize()) + 1;
            for (int cluster = 0; cluster < clusterSize && this.invasionMobs.size() < this.mobCap; ++cluster) {
                List<ClusterEntitySpawnData> clusterEntities = this.getSeverityInfo().getClusterEntities();
                if (!clusterEntities.isEmpty() && cluster == 0) {
                    ClusterEntitySpawnData spawnInfo = clusterEntities.get(levelIn.f_46441_.m_188503_(clusterEntities.size()));
                    int t = levelIn.f_46441_.m_188503_(spawnInfo.getChance()) == 0 ? levelIn.f_46441_.m_216332_(spawnInfo.getMinCount(), spawnInfo.getMaxCount()) : 0;
                    for (int c = 0; c < t; ++c) {
                        this.spawnClusterEntity(this.getSpawnPos(levelIn, chunkPos, false), levelIn, spawnInfo.getEntityType());
                    }
                }
                MobSpawnSettings.SpawnerData spawners = mobs.get(levelIn.f_46441_.m_188503_(mobs.size()));
                int groupSize = levelIn.f_46441_.m_188503_(spawners.f_48406_ - spawners.f_48405_ + 1) + spawners.f_48405_;
                this.nextSpawnData.m_186567_().m_128359_("id", ForgeRegistries.ENTITY_TYPES.getKey((Object)spawners.f_48404_).toString());
                CompoundTag compoundNBT = this.nextSpawnData.m_186567_();
                Optional optional = EntityType.m_20637_((CompoundTag)compoundNBT);
                if (!optional.isPresent()) {
                    this.delay(levelIn);
                    return;
                }
                for (int count = 0; count < groupSize && this.invasionMobs.size() < this.mobCap; ++count) {
                    BlockPos spawnPos = this.getSpawnPos(levelIn, chunkPos, false);
                    if (spawnPos == null || !SpawnPlacements.m_217074_((EntityType)((EntityType)optional.get()), (ServerLevelAccessor)levelIn, (MobSpawnType)MobSpawnType.EVENT, (BlockPos)spawnPos, (RandomSource)levelIn.m_213780_())) continue;
                    Entity entity = EntityType.m_20645_((CompoundTag)compoundNBT, (Level)levelIn, e -> {
                        e.m_7678_((double)spawnPos.m_123341_(), (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_(), e.m_146908_(), e.m_146909_());
                        return e;
                    });
                    if (entity == null) {
                        this.delay(levelIn);
                        return;
                    }
                    entity.m_7678_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), levelIn.f_46441_.m_188501_() * 360.0f, 0.0f);
                    if (entity instanceof Mob) {
                        Mob mobEntity = (Mob)entity;
                        if (this.nextSpawnData.m_186567_().m_128440_() == 1 && this.nextSpawnData.m_186567_().m_128425_("id", 8) && !ForgeEventFactory.doSpecialSpawn((Mob)mobEntity, (LevelAccessor)levelIn, (float)((float)mobEntity.m_20185_()), (float)((float)mobEntity.m_20186_()), (float)((float)mobEntity.m_20189_()), null, (MobSpawnType)MobSpawnType.EVENT)) {
                            this.spawnInvasionMob(levelIn, mobEntity);
                        }
                    }
                    if (!levelIn.m_8860_(entity)) {
                        this.delay(levelIn);
                        return;
                    }
                    flag1 = true;
                }
            }
            if (flag1) {
                this.delay(levelIn);
            }
        }
    }

    private final void spawnClusterEntity(BlockPos posIn, ServerLevel levelIn, EntityType<?> entityTypeIn) {
        if (Level.m_46741_((BlockPos)posIn)) {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128359_("id", ForgeRegistries.ENTITY_TYPES.getKey(entityTypeIn).toString());
            Entity entity = EntityType.m_20645_((CompoundTag)compoundTag, (Level)levelIn, e -> {
                e.m_7678_((double)posIn.m_123341_(), (double)posIn.m_123342_(), (double)posIn.m_123343_(), e.m_146908_(), e.m_146909_());
                return e;
            });
            if (entity != null) {
                if (entity instanceof Mob) {
                    ((Mob)entity).m_6518_((ServerLevelAccessor)levelIn, levelIn.m_6436_(entity.m_20183_()), MobSpawnType.EVENT, null, null);
                }
                levelIn.m_8860_(entity);
            }
        }
    }

    private final void spawnInvasionMob(ServerLevel worldIn, Mob mobEntityIn) {
        boolean hyperCharged = PSConfigValues.common.hyperCharge && PSConfigValues.common.maxHyperCharge > 1 && !PSConfigValues.common.hyperChargeBlacklist.contains(mobEntityIn.m_6095_().m_20675_()) && this.hyperType != HyperType.DEFAULT ? true : worldIn.f_46441_.m_188503_(PSConfigValues.common.hyperChargeChance + 1) <= this.severity;
        mobEntityIn.getPersistentData().m_128359_("InvasionMob", this.invasionType.getId().toString());
        mobEntityIn.getPersistentData().m_128379_("AntiGrief", worldIn.m_6042_().m_63967_());
        mobEntityIn.m_6518_((ServerLevelAccessor)worldIn, worldIn.m_6436_(mobEntityIn.m_20183_()), MobSpawnType.EVENT, null, null);
        if (hyperCharged && mobEntityIn instanceof PSHyperCharge) {
            int hyperCharge = this.hyperType != HyperType.DEFAULT ? (this.hyperType == HyperType.MYSTERY ? PSConfigValues.common.maxHyperCharge : worldIn.f_46441_.m_188503_(PSConfigValues.common.maxHyperCharge > 1 ? PSConfigValues.common.maxHyperCharge - 1 : 1) + 1) : worldIn.f_46441_.m_188503_(worldIn.f_46441_.m_188503_(PSConfigValues.common.maxHyperCharge - 1) + 1) + 1;
            ((PSHyperCharge)mobEntityIn).psSetHyperCharge(hyperCharge);
            for (AttributeInstance attribute : mobEntityIn.m_21204_().m_22170_()) {
                attribute.m_22100_(attribute.m_22115_() * (1.0 + 0.2 * (double)hyperCharge));
            }
        }
        if (PSConfigValues.common.shouldMobsSpawnWithMaxRange) {
            mobEntityIn.m_21051_(Attributes.f_22277_).m_22100_(2048.0);
        }
        this.invasionMobs.add(mobEntityIn.m_20148_());
        worldIn.m_46796_(2004, mobEntityIn.m_20183_(), 0);
        mobEntityIn.m_21373_();
    }

    private final void delay(ServerLevel worldIn) {
        this.spawnDelay = this.getSeverityInfo().getTickDelay();
        this.spawnPotentials.m_216829_(worldIn.f_46441_).ifPresent(entry -> {
            this.nextSpawnData = (SpawnData)entry.m_146310_();
        });
    }

    private final List<MobSpawnSettings.SpawnerData> getMobSpawnList(ServerLevel worldIn, ChunkPos chunkPosIn) {
        BlockPos biomePos = this.getSpawnPos(worldIn, chunkPosIn, true);
        ArrayList<MobSpawnSettings.SpawnerData> originalList = new ArrayList<MobSpawnSettings.SpawnerData>(this.getSeverityInfo().getMobSpawnList());
        switch (this.invasionType.getSpawningSystem()) {
            case DEFAULT: {
                break;
            }
            case BIOME_BOOSTED: {
                originalList.addAll(this.getBiomeSpawnList(biomePos, worldIn.m_46865_(biomePos)));
                break;
            }
            case BIOME_MIXED: {
                originalList.addAll(this.getMixedSpawnList(worldIn));
            }
        }
        ArrayList<MobSpawnSettings.SpawnerData> newList = new ArrayList<MobSpawnSettings.SpawnerData>();
        if (!originalList.isEmpty()) {
            for (MobSpawnSettings.SpawnerData spawners : originalList) {
                for (int w = 0; w < spawners.m_142631_().m_146281_(); ++w) {
                    newList.add(spawners);
                }
            }
        }
        return newList;
    }

    private final ArrayList<MobSpawnSettings.SpawnerData> getBiomeSpawnList(BlockPos posIn, ChunkAccess chunkIn) {
        ArrayList<MobSpawnSettings.SpawnerData> spawners = new ArrayList<MobSpawnSettings.SpawnerData>(((Biome)chunkIn.m_203495_(posIn.m_123341_(), posIn.m_123342_(), posIn.m_123343_()).m_203334_()).m_47518_().m_151798_(MobCategory.MONSTER).m_146338_());
        spawners.removeIf(spawner -> {
            ResourceLocation name = spawner.f_48404_.m_20677_();
            return PSConfigValues.common.modBiomeBoostedBlacklist.contains(name.m_135827_()) || PSConfigValues.common.mobBiomeBoostedBlacklist.contains(name.toString());
        });
        return spawners;
    }

    private final ArrayList<MobSpawnSettings.SpawnerData> getMixedSpawnList(ServerLevel worldIn) {
        ArrayList<MobSpawnSettings.SpawnerData> spawners = new ArrayList<MobSpawnSettings.SpawnerData>(MIXED_BIOMES.get(worldIn.f_46441_.m_188503_(MIXED_BIOMES.size())).m_47518_().m_151798_(MobCategory.MONSTER).m_146338_());
        spawners.removeIf(spawner -> {
            ResourceLocation name = spawner.f_48404_.m_20677_();
            return PSConfigValues.common.modBiomeBoostedBlacklist.contains(name.m_135827_()) || PSConfigValues.common.mobBiomeBoostedBlacklist.contains(name.toString());
        });
        return spawners;
    }

    protected final ChunkPos getSpawnChunk(ServerLevel worldIn) {
        ServerPlayer player = (ServerPlayer)worldIn.m_6907_().get(worldIn.f_46441_.m_188503_(worldIn.m_6907_().size()));
        ChunkPos chunkPos = worldIn.m_46865_(player.m_20183_()).m_7697_();
        int chunkX = chunkPos.f_45578_ - 8 + worldIn.f_46441_.m_188503_(17);
        int chunkZ = chunkPos.f_45579_ - 8 + worldIn.f_46441_.m_188503_(17);
        boolean flag = chunkPos.f_45578_ == chunkX && chunkPos.f_45579_ == chunkZ;
        ChunkPos chunkPos1 = new ChunkPos(flag ? chunkX + this.getChunkOffset(worldIn) : chunkX, flag ? chunkZ + this.getChunkOffset(worldIn) : chunkZ);
        return chunkPos1;
    }

    private final int getChunkOffset(ServerLevel worldIn) {
        int offSet = worldIn.f_46441_.m_188503_(8) + 1;
        return worldIn.f_46441_.m_188499_() ? offSet : -offSet;
    }

    private final BlockPos getSpawnPos(ServerLevel worldIn, ChunkPos chunkPosIn, boolean biomeCheckIn) {
        int x = chunkPosIn.m_45604_() + worldIn.f_46441_.m_188503_(16);
        int z = chunkPosIn.m_45605_() + worldIn.f_46441_.m_188503_(16);
        int surface = worldIn.m_6924_(Heightmap.Types.WORLD_SURFACE, x, z);
        if (biomeCheckIn || !worldIn.m_6042_().f_63856_() && worldIn.f_46441_.m_188499_()) {
            return new BlockPos(x, surface, z);
        }
        BlockState air = Blocks.f_50016_.m_49966_();
        BlockState bedrock = Blocks.f_50752_.m_49966_();
        ArrayList<BlockPos> potentialPos = new ArrayList<BlockPos>();
        for (int y = 0; y < surface; ++y) {
            BlockPos pos = new BlockPos(x, y, z);
            if (worldIn.m_8055_(pos) == air || worldIn.m_8055_(pos) == bedrock || worldIn.m_8055_(pos.m_7494_()) != air) continue;
            potentialPos.add(pos.m_7494_());
        }
        return potentialPos.size() > 0 ? (BlockPos)potentialPos.get(worldIn.f_46441_.m_188503_(potentialPos.size())) : new BlockPos(x, surface, z);
    }

    @Nullable
    public static final Invasion load(CompoundTag nbtIn) {
        if (PSEventManager.BaseEvents.getInvasionTypeManager().verifyInvasion(nbtIn.m_128461_("InvasionType"))) {
            InvasionType invasionType = PSEventManager.BaseEvents.getInvasionTypeManager().getInvasionType(ResourceLocation.m_135820_((String)nbtIn.m_128461_("InvasionType")));
            Invasion invasion = new Invasion(invasionType, nbtIn.m_128451_("Severity"), nbtIn.m_128471_("IsPrimary"), PSConfigValues.common.hyperInvasions ? HyperType.values()[nbtIn.m_128451_("HyperType")] : HyperType.DEFAULT);
            CompoundTag invasionMobs = nbtIn.m_128469_("InvasionMobs");
            for (String name : invasionMobs.m_128431_()) {
                invasion.invasionMobs.add(invasionMobs.m_128342_(name));
            }
            return invasion;
        }
        return null;
    }

    public final CompoundTag save() {
        CompoundTag nbt = new CompoundTag();
        CompoundTag mobs = new CompoundTag();
        for (UUID id : this.invasionMobs) {
            mobs.m_128362_(id.toString(), id);
        }
        nbt.m_128365_("InvasionMobs", (Tag)mobs);
        nbt.m_128359_("InvasionType", this.invasionType.toString());
        nbt.m_128405_("Severity", this.severity);
        nbt.m_128379_("IsPrimary", this.isPrimary);
        nbt.m_128405_("HyperType", this.hyperType.ordinal());
        return nbt;
    }

    public final String toString() {
        return this.invasionType.toString();
    }
}

