/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.invasion;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.theagameplayer.puresuffering.client.renderer.InvasionSkyRenderer;
import dev.theagameplayer.puresuffering.invasion.ClusterEntitySpawnData;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class InvasionType {
    private final ResourceLocation id;
    private final int rarity;
    private final int tier;
    private final InvasionTime invasionTime;
    private final InvasionPriority invasionPriority;
    private final SpawningSystem spawningSystem;
    private final TimeModifier timeModifier;
    private final TimeChangeability timeChangeability;
    private final WeatherType weatherType;
    private final List<SeverityInfo> severityInfo;
    private final List<ResourceLocation> dimensions;
    private final Component component;

    public InvasionType(ResourceLocation idIn, int rarityIn, int tierIn, InvasionTime invasionTimeIn, InvasionPriority invasionPriorityIn, SpawningSystem spawningSystemIn, TimeModifier timeModifierIn, TimeChangeability timeChangeabilityIn, WeatherType weatherTypeIn, List<SeverityInfo> severityInfoIn, List<ResourceLocation> dimensionsIn) {
        this.id = idIn;
        this.rarity = rarityIn;
        this.tier = tierIn;
        this.invasionTime = invasionTimeIn;
        this.invasionPriority = invasionPriorityIn;
        this.spawningSystem = spawningSystemIn;
        this.timeModifier = timeModifierIn;
        this.timeChangeability = timeChangeabilityIn;
        this.weatherType = weatherTypeIn;
        this.severityInfo = severityInfoIn;
        this.dimensions = dimensionsIn;
        String text = "invasion." + idIn.m_135827_() + "." + idIn.m_135815_();
        MutableComponent component = Component.m_237115_((String)text);
        this.component = component.getString().equals(text) ? Component.m_237115_((String)this.formatDefaultText(idIn)) : component;
    }

    private final String formatDefaultText(ResourceLocation idIn) {
        String str = idIn.m_135815_().replace('_', ' ');
        if (str == null || str.length() == 0) {
            return str;
        }
        char[] buffer = str.toCharArray();
        boolean capitalizeNext = true;
        for (int i = 0; i < buffer.length; ++i) {
            char ch = buffer[i];
            if (Character.isWhitespace(ch)) {
                capitalizeNext = true;
                continue;
            }
            if (!capitalizeNext) continue;
            buffer[i] = Character.toTitleCase(ch);
            capitalizeNext = false;
        }
        return new String(buffer);
    }

    public final Builder deconstruct() {
        ArrayList<SeverityInfo.Builder> severityInfo = new ArrayList<SeverityInfo.Builder>();
        for (SeverityInfo info : this.severityInfo) {
            severityInfo.add(info.deconstruct());
        }
        return new Builder(this.rarity, this.tier, this.invasionTime, this.invasionPriority, this.spawningSystem, this.timeModifier, this.timeChangeability, this.weatherType, severityInfo, this.dimensions);
    }

    public final ResourceLocation getId() {
        return this.id;
    }

    public final int getRarity() {
        return this.rarity;
    }

    public final int getTier() {
        return this.tier;
    }

    public final InvasionTime getInvasionTime() {
        return this.invasionTime;
    }

    public final InvasionPriority getInvasionPriority() {
        return this.invasionPriority;
    }

    public final SpawningSystem getSpawningSystem() {
        return this.spawningSystem;
    }

    public final TimeModifier getTimeModifier() {
        return this.timeModifier;
    }

    public final TimeChangeability getTimeChangeability() {
        return this.timeChangeability;
    }

    public final WeatherType getWeatherType() {
        return this.weatherType;
    }

    public final List<SeverityInfo> getSeverityInfo() {
        return this.severityInfo;
    }

    public final List<ResourceLocation> getDimensions() {
        return this.dimensions;
    }

    public final Component getComponent() {
        return this.component;
    }

    public final int getMaxSeverity() {
        return this.severityInfo.isEmpty() ? 1 : this.severityInfo.size();
    }

    public final String toString() {
        return this.getId().toString();
    }

    public static enum InvasionTime {
        BOTH,
        NIGHT,
        DAY;

    }

    public static enum InvasionPriority {
        BOTH,
        PRIMARY_ONLY,
        SECONDARY_ONLY;

    }

    public static enum SpawningSystem {
        DEFAULT,
        BIOME_BOOSTED,
        BIOME_MIXED;

    }

    public static enum TimeModifier {
        NONE,
        DAY_TO_NIGHT,
        NIGHT_TO_DAY;

    }

    public static enum TimeChangeability {
        DEFAULT,
        ONLY_NIGHT,
        ONLY_DAY;

    }

    public static enum WeatherType {
        DEFAULT,
        CLEAR,
        RAIN,
        THUNDER;

    }

    public static final class SeverityInfo {
        private final InvasionSkyRenderer skyRenderer;
        private final List<MobSpawnSettings.SpawnerData> mobSpawnList;
        private final List<ClusterEntitySpawnData> clusterEntitiesList;
        private final float mobCapPercentage;
        private final boolean forceNoSleep;
        private final int lightLevel;
        private final int tickDelay;
        private final int clusterSize;

        private SeverityInfo(InvasionSkyRenderer skyRendererIn, List<MobSpawnSettings.SpawnerData> mobSpawnListIn, List<ClusterEntitySpawnData> clusterEntitiesListIn, float mobCapPercentageIn, boolean forceNoSleepIn, int lightLevelIn, int tickDelayIn, int clusterSizeIn) {
            this.skyRenderer = skyRendererIn;
            this.mobSpawnList = mobSpawnListIn;
            this.clusterEntitiesList = clusterEntitiesListIn;
            this.mobCapPercentage = mobCapPercentageIn;
            this.forceNoSleep = forceNoSleepIn;
            this.lightLevel = lightLevelIn;
            this.tickDelay = tickDelayIn;
            this.clusterSize = clusterSizeIn;
        }

        public final Builder deconstruct() {
            return new Builder(this.skyRenderer == null ? null : this.skyRenderer.deconstruct(), this.mobSpawnList, this.clusterEntitiesList, this.mobCapPercentage, this.forceNoSleep, this.lightLevel, this.tickDelay, this.clusterSize);
        }

        public final InvasionSkyRenderer getSkyRenderer() {
            return this.skyRenderer;
        }

        public final List<MobSpawnSettings.SpawnerData> getMobSpawnList() {
            return this.mobSpawnList;
        }

        public final List<ClusterEntitySpawnData> getClusterEntities() {
            return this.clusterEntitiesList;
        }

        public final float getMobCapPercentage() {
            return this.mobCapPercentage;
        }

        public final boolean forcesNoSleep() {
            return this.forceNoSleep;
        }

        public final int getLightLevel() {
            return this.lightLevel;
        }

        public final int getTickDelay() {
            return this.tickDelay;
        }

        public final int getClusterSize() {
            return this.clusterSize;
        }

        public static final class Builder {
            private static final Logger LOGGER = LogManager.getLogger((String)"puresuffering");
            private InvasionSkyRenderer.Builder skyRenderer = null;
            private List<MobSpawnSettings.SpawnerData> mobSpawnList;
            private List<ClusterEntitySpawnData> clusterEntitiesList;
            private float mobCapPercentage = 1.0f;
            private boolean forceNoSleep = false;
            private int lightLevel = -1;
            private int tickDelay = 6;
            private int clusterSize = 1;

            private Builder(InvasionSkyRenderer.Builder skyRendererIn, List<MobSpawnSettings.SpawnerData> mobSpawnListIn, List<ClusterEntitySpawnData> clusterEntitiesListIn, float mobCapPercentageIn, boolean forceNoSleepIn, int lightLevelIn, int tickDelayIn, int clusterSizeIn) {
                this.skyRenderer = skyRendererIn;
                this.mobSpawnList = mobSpawnListIn;
                this.clusterEntitiesList = clusterEntitiesListIn;
                this.mobCapPercentage = mobCapPercentageIn;
                this.forceNoSleep = forceNoSleepIn;
                this.lightLevel = lightLevelIn;
                this.tickDelay = tickDelayIn;
                this.clusterSize = clusterSizeIn;
            }

            private Builder() {
            }

            public static final Builder severityInfo() {
                return new Builder();
            }

            public final Builder skyRenderer(InvasionSkyRenderer.Builder skyRendererIn) {
                this.skyRenderer = skyRendererIn;
                return this;
            }

            public final Builder mobSpawnList(List<MobSpawnSettings.SpawnerData> mobSpawnListIn) {
                this.mobSpawnList = mobSpawnListIn;
                return this;
            }

            public final Builder clusterEntitiesList(List<ClusterEntitySpawnData> clusterEntitiesListIn) {
                this.clusterEntitiesList = clusterEntitiesListIn;
                return this;
            }

            public final Builder setMobCapMultiplier(float mobCapPercentageIn) {
                this.mobCapPercentage = mobCapPercentageIn;
                return this;
            }

            public final Builder setForcesNoSleep() {
                this.forceNoSleep = true;
                return this;
            }

            public final Builder withLightLevel(int lightLevelIn) {
                this.lightLevel = lightLevelIn;
                return this;
            }

            public final Builder withTickDelay(int tickDelayIn) {
                this.tickDelay = tickDelayIn;
                return this;
            }

            public final Builder withClusterSize(int clusterSizeIn) {
                this.clusterSize = clusterSizeIn;
                return this;
            }

            public final SeverityInfo build(ResourceLocation idIn) {
                return new SeverityInfo(this.skyRenderer == null ? null : this.skyRenderer.build(idIn), this.mobSpawnList, this.clusterEntitiesList, this.mobCapPercentage, this.forceNoSleep, this.lightLevel, this.tickDelay, this.clusterSize);
            }

            public final JsonObject serializeToJson() {
                JsonObject jsonObject1;
                JsonArray jsonArray;
                JsonObject jsonObject = new JsonObject();
                if (this.skyRenderer != null) {
                    jsonObject.add("SkyRenderer", (JsonElement)this.skyRenderer.serializeToJson());
                }
                if (this.mobSpawnList != null) {
                    jsonArray = new JsonArray();
                    for (MobSpawnSettings.SpawnerData spawnerData : this.mobSpawnList) {
                        jsonObject1 = new JsonObject();
                        jsonObject1.addProperty("EntityType", ForgeRegistries.ENTITY_TYPES.getKey((Object)spawnerData.f_48404_).toString());
                        jsonObject1.addProperty("Weight", (Number)spawnerData.m_142631_().m_146281_());
                        jsonObject1.addProperty("MinCount", (Number)spawnerData.f_48405_);
                        jsonObject1.addProperty("MaxCount", (Number)spawnerData.f_48406_);
                        jsonArray.add((JsonElement)jsonObject1);
                    }
                    jsonObject.add("MobSpawnList", (JsonElement)jsonArray);
                }
                if (this.clusterEntitiesList != null) {
                    jsonArray = new JsonArray();
                    for (ClusterEntitySpawnData clusterEntitySpawnData : this.clusterEntitiesList) {
                        jsonObject1 = new JsonObject();
                        jsonObject1.addProperty("EntityType", ForgeRegistries.ENTITY_TYPES.getKey(clusterEntitySpawnData.getEntityType()).toString());
                        jsonObject1.addProperty("MinCount", (Number)clusterEntitySpawnData.getMinCount());
                        jsonObject1.addProperty("MaxCount", (Number)clusterEntitySpawnData.getMaxCount());
                        jsonObject1.addProperty("Chance", (Number)clusterEntitySpawnData.getChance());
                        jsonArray.add((JsonElement)jsonObject1);
                    }
                    jsonObject.add("ClusterEntitiesList", (JsonElement)jsonArray);
                }
                jsonObject.addProperty("MobCapPercentage", (Number)Float.valueOf(this.mobCapPercentage));
                jsonObject.addProperty("ForceNoSleep", Boolean.valueOf(this.forceNoSleep));
                if (this.lightLevel > -1) {
                    jsonObject.addProperty("LightLevel", (Number)this.lightLevel);
                }
                jsonObject.addProperty("TickDelay", (Number)this.tickDelay);
                jsonObject.addProperty("ClusterSize", (Number)this.clusterSize);
                return jsonObject;
            }

            public static final Builder fromJson(JsonObject jsonObjectIn) {
                JsonArray jsonElement2;
                int maxCount;
                int minCount;
                JsonArray jsonElement1;
                InvasionSkyRenderer.Builder skyRenderer = null;
                boolean errored = false;
                ArrayList<MobSpawnSettings.SpawnerData> mobSpawnList = new ArrayList<MobSpawnSettings.SpawnerData>();
                ArrayList<ClusterEntitySpawnData> clusterEntitiesList = new ArrayList<ClusterEntitySpawnData>();
                float mobCapPercentage = Mth.m_14036_((float)jsonObjectIn.get("MobCapPercentage").getAsFloat(), (float)0.0f, (float)1.0f);
                boolean forceNoSleep = jsonObjectIn.get("ForceNoSleep").getAsBoolean();
                int lightLevel = jsonObjectIn.has("LightLevel") ? Mth.m_14045_((int)jsonObjectIn.get("LightLevel").getAsInt(), (int)0, (int)15) : -1;
                int tickDelay = jsonObjectIn.get("TickDelay").getAsInt();
                int clusterSize = jsonObjectIn.get("ClusterSize").getAsInt();
                JsonObject jsonElement = jsonObjectIn.getAsJsonObject("SkyRenderer");
                if (jsonElement != null) {
                    if (jsonElement.isJsonObject()) {
                        skyRenderer = InvasionSkyRenderer.Builder.fromJson(jsonElement.getAsJsonObject());
                    } else {
                        errored = true;
                    }
                }
                if ((jsonElement1 = jsonObjectIn.getAsJsonArray("MobSpawnList")) != null) {
                    if (jsonElement1.isJsonArray()) {
                        JsonArray jsonArray = jsonElement1.getAsJsonArray();
                        for (JsonElement jsonElement22 : jsonArray) {
                            if (jsonElement22.isJsonObject()) {
                                JsonObject jsonObject = jsonElement22.getAsJsonObject();
                                EntityType type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(ResourceLocation.m_135820_((String)jsonObject.get("EntityType").getAsString()));
                                int weight = jsonObject.get("Weight").getAsInt();
                                minCount = jsonObject.get("MinCount").getAsInt();
                                maxCount = jsonObject.get("MaxCount").getAsInt();
                                mobSpawnList.add(new MobSpawnSettings.SpawnerData(type, weight, minCount, maxCount));
                                continue;
                            }
                            errored = true;
                            break;
                        }
                    } else {
                        errored = true;
                    }
                }
                if ((jsonElement2 = jsonObjectIn.getAsJsonArray("ClusterEntitiesList")) != null) {
                    if (jsonElement2.isJsonArray()) {
                        JsonArray jsonArray = jsonElement2.getAsJsonArray();
                        for (JsonElement jsonElement3 : jsonArray) {
                            if (jsonElement3.isJsonObject()) {
                                JsonObject jsonObject = jsonElement3.getAsJsonObject();
                                EntityType type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(ResourceLocation.m_135820_((String)jsonObject.get("EntityType").getAsString()));
                                minCount = jsonObject.get("MinCount").getAsInt();
                                maxCount = jsonObject.get("MaxCount").getAsInt();
                                int chance = jsonObject.get("Chance").getAsInt();
                                clusterEntitiesList.add(new ClusterEntitySpawnData(type, minCount, maxCount, chance));
                                continue;
                            }
                            errored = true;
                            break;
                        }
                    } else {
                        errored = true;
                    }
                }
                if (errored) {
                    LOGGER.error("JsonElement is incorrectly setup: " + jsonObjectIn.toString() + ". Therefore InvasionType wasn't registered! Most likely a datapack error?");
                }
                return new Builder(skyRenderer, mobSpawnList, clusterEntitiesList, mobCapPercentage, forceNoSleep, lightLevel, tickDelay, clusterSize);
            }
        }
    }

    public static final class Builder {
        private static final Logger LOGGER = LogManager.getLogger((String)"puresuffering");
        private int rarity = 0;
        private int tier = 0;
        private InvasionTime invasionTime;
        private InvasionPriority invasionPriority = InvasionPriority.BOTH;
        private SpawningSystem spawningSystem = SpawningSystem.DEFAULT;
        private TimeModifier timeModifier = TimeModifier.NONE;
        private TimeChangeability timeChangeability = TimeChangeability.DEFAULT;
        private WeatherType weatherType = WeatherType.DEFAULT;
        private List<SeverityInfo.Builder> severityInfo;
        private List<ResourceLocation> dimensions;

        private Builder(int rarityIn, int tierIn, InvasionTime invasionTimeIn, InvasionPriority invasionPriorityIn, SpawningSystem spawningSystemIn, TimeModifier timeModifierIn, TimeChangeability timeChangeabilityIn, WeatherType weatherTypeIn, List<SeverityInfo.Builder> severityInfoIn, List<ResourceLocation> dimensionsIn) {
            this.rarity = rarityIn;
            this.tier = tierIn;
            this.invasionTime = invasionTimeIn;
            this.invasionPriority = invasionPriorityIn;
            this.spawningSystem = spawningSystemIn;
            this.timeModifier = timeModifierIn;
            this.timeChangeability = timeChangeabilityIn;
            this.weatherType = weatherTypeIn;
            this.severityInfo = severityInfoIn;
            this.dimensions = dimensionsIn;
        }

        private Builder() {
        }

        public static final Builder invasionType() {
            return new Builder();
        }

        public final Builder withRarity(int rarityIn) {
            this.rarity = rarityIn;
            return this;
        }

        public final Builder withTier(int tierIn) {
            this.tier = tierIn;
            return this;
        }

        public final Builder withInvasionTime(InvasionTime invasionTimeIn) {
            this.invasionTime = invasionTimeIn;
            return this;
        }

        public final Builder withInvasionPriority(InvasionPriority invasionPriorityIn) {
            this.invasionPriority = invasionPriorityIn;
            return this;
        }

        public final Builder withSpawningSystem(SpawningSystem spawningSystemIn) {
            this.spawningSystem = spawningSystemIn;
            return this;
        }

        public final Builder withTimeModifier(TimeModifier timeModifierIn) {
            this.timeModifier = timeModifierIn;
            return this;
        }

        public final Builder withTimeChangeability(TimeChangeability timeChangeabilityIn) {
            this.timeChangeability = timeChangeabilityIn;
            return this;
        }

        public final Builder withWeatherType(WeatherType weatherTypeIn) {
            this.weatherType = weatherTypeIn;
            return this;
        }

        public final Builder severityInfo(List<SeverityInfo.Builder> severityInfoIn) {
            this.severityInfo = severityInfoIn;
            return this;
        }

        public final Builder dimensions(List<ResourceLocation> dimensionsIn) {
            this.dimensions = dimensionsIn;
            return this;
        }

        public final InvasionType save(Consumer<InvasionType> consumerIn, String pathIn) {
            InvasionType invasionType = this.build(new ResourceLocation("puresuffering", pathIn));
            consumerIn.accept(invasionType);
            return invasionType;
        }

        public final InvasionType build(ResourceLocation idIn) {
            ArrayList<SeverityInfo> severityInfo = new ArrayList<SeverityInfo>();
            if (this.severityInfo != null) {
                for (SeverityInfo.Builder builder : this.severityInfo) {
                    severityInfo.add(builder.build(idIn));
                }
            }
            return new InvasionType(idIn, this.rarity, this.tier, this.invasionTime, this.invasionPriority, this.spawningSystem, this.timeModifier, this.timeChangeability, this.weatherType, severityInfo, this.dimensions);
        }

        public final JsonObject serializeToJson() {
            JsonArray jsonArray;
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("Rarity", (Number)this.rarity);
            jsonObject.addProperty("Tier", (Number)this.tier);
            jsonObject.addProperty("InvasionTime", this.invasionTime.toString());
            jsonObject.addProperty("InvasionPriority", this.invasionPriority.toString());
            jsonObject.addProperty("SpawningSystem", this.spawningSystem.toString());
            if (this.invasionTime != InvasionTime.DAY && this.timeModifier != TimeModifier.DAY_TO_NIGHT || this.invasionTime != InvasionTime.NIGHT && this.timeModifier != TimeModifier.NIGHT_TO_DAY || this.timeModifier == TimeModifier.NONE) {
                jsonObject.addProperty("TimeModifier", this.timeModifier.toString());
            }
            if (this.invasionTime != InvasionTime.DAY && this.timeChangeability != TimeChangeability.ONLY_DAY || this.invasionTime != InvasionTime.NIGHT && this.timeChangeability != TimeChangeability.ONLY_NIGHT || this.timeChangeability == TimeChangeability.DEFAULT) {
                jsonObject.addProperty("TimeChangeability", this.timeChangeability.toString());
            }
            jsonObject.addProperty("WeatherType", this.weatherType.toString());
            if (this.severityInfo != null) {
                jsonArray = new JsonArray();
                for (SeverityInfo.Builder builder : this.severityInfo) {
                    jsonArray.add((JsonElement)builder.serializeToJson());
                }
                jsonObject.add("SeverityInfo", (JsonElement)jsonArray);
            }
            if (this.dimensions != null) {
                jsonArray = new JsonArray();
                for (ResourceLocation id : this.dimensions) {
                    jsonArray.add(id.toString());
                }
                jsonObject.add("Dimensions", (JsonElement)jsonArray);
            }
            return jsonObject;
        }

        public static final Builder fromJson(JsonObject jsonObjectIn) {
            int rarity = jsonObjectIn.get("Rarity").getAsInt();
            int tier = jsonObjectIn.get("Tier").getAsInt();
            InvasionTime invasionTime = null;
            for (InvasionTime time : InvasionTime.values()) {
                if (!time.toString().equals(jsonObjectIn.get("InvasionTime").getAsString())) continue;
                invasionTime = time;
                break;
            }
            InvasionPriority invasionPriority = null;
            for (InvasionPriority order : InvasionPriority.values()) {
                if (!order.toString().equals(jsonObjectIn.get("InvasionPriority").getAsString())) continue;
                invasionPriority = order;
                break;
            }
            SpawningSystem spawningSystem = null;
            for (SpawningSystem system : SpawningSystem.values()) {
                if (!system.toString().equals(jsonObjectIn.get("SpawningSystem").getAsString())) continue;
                spawningSystem = system;
                break;
            }
            TimeModifier timeModifier = null;
            for (TimeModifier modifier : TimeModifier.values()) {
                if (!modifier.toString().equals(jsonObjectIn.get("TimeModifier").getAsString()) || !(invasionTime != InvasionTime.DAY && modifier != TimeModifier.DAY_TO_NIGHT || invasionTime != InvasionTime.NIGHT && modifier != TimeModifier.NIGHT_TO_DAY) && modifier != TimeModifier.NONE) continue;
                timeModifier = modifier;
                break;
            }
            TimeChangeability timeChangeability = null;
            for (TimeChangeability changeability : TimeChangeability.values()) {
                if (!changeability.toString().equals(jsonObjectIn.get("TimeChangeability").getAsString()) || !(invasionTime != InvasionTime.DAY && changeability != TimeChangeability.ONLY_DAY || invasionTime != InvasionTime.NIGHT && changeability != TimeChangeability.ONLY_NIGHT) && changeability != TimeChangeability.DEFAULT) continue;
                timeChangeability = changeability;
                break;
            }
            WeatherType weatherType = null;
            for (WeatherType weather : WeatherType.values()) {
                if (!weather.toString().equals(jsonObjectIn.get("WeatherType").getAsString())) continue;
                weatherType = weather;
                break;
            }
            boolean errored = false;
            ArrayList<SeverityInfo.Builder> severityInfo = new ArrayList<SeverityInfo.Builder>();
            JsonArray jsonElement = jsonObjectIn.getAsJsonArray("SeverityInfo");
            if (jsonElement != null) {
                if (jsonElement.isJsonArray()) {
                    JsonArray jsonArray = jsonElement.getAsJsonArray();
                    for (int info = 0; info < jsonArray.size(); ++info) {
                        JsonElement jsonElement1 = jsonArray.get(info);
                        if (!jsonElement1.isJsonObject()) {
                            errored = true;
                            break;
                        }
                        severityInfo.add(SeverityInfo.Builder.fromJson(jsonElement1.getAsJsonObject()));
                    }
                } else {
                    errored = true;
                }
            }
            ArrayList<ResourceLocation> dimensions = new ArrayList<ResourceLocation>();
            JsonArray jsonElement2 = jsonObjectIn.getAsJsonArray("Dimensions");
            if (jsonElement2 != null) {
                if (jsonElement2.isJsonArray()) {
                    JsonArray jsonArray = jsonElement2.getAsJsonArray();
                    for (int dim = 0; dim < jsonArray.size(); ++dim) {
                        dimensions.add(ResourceLocation.m_135820_((String)jsonArray.get(dim).getAsString()));
                    }
                } else {
                    errored = true;
                }
            }
            if (invasionTime == null || invasionPriority == null || spawningSystem == null || timeModifier == null || timeChangeability == null || weatherType == null || errored) {
                LOGGER.error("JsonElement is incorrectly setup: " + jsonObjectIn.toString() + ". Therefore InvasionType wasn't registered! Most likely a datapack error?");
            }
            return new Builder(rarity, tier, invasionTime, invasionPriority, spawningSystem, timeModifier, timeChangeability, weatherType, severityInfo, dimensions);
        }
    }
}

