/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.network.packet;

import dev.theagameplayer.puresuffering.client.renderer.InvasionSkyRenderer;
import dev.theagameplayer.puresuffering.util.InvasionListType;
import dev.theagameplayer.puresuffering.world.ClientInvasionWorldInfo;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public final class AddInvasionPacket {
    private final InvasionSkyRenderer renderer;
    private final InvasionListType listType;
    private final boolean isPrimary;

    public AddInvasionPacket(InvasionSkyRenderer rendererIn, InvasionListType listTypeIn, boolean isPrimaryIn) {
        this.renderer = rendererIn;
        this.listType = listTypeIn;
        this.isPrimary = isPrimaryIn;
    }

    public static final void encode(AddInvasionPacket msgIn, FriendlyByteBuf bufIn) {
        msgIn.renderer.deconstruct().serializeToNetwork(bufIn);
        bufIn.m_130085_(msgIn.renderer.getId());
        bufIn.m_130068_((Enum)msgIn.listType);
        bufIn.writeBoolean(msgIn.isPrimary);
    }

    public static final AddInvasionPacket decode(FriendlyByteBuf bufIn) {
        InvasionSkyRenderer renderer = InvasionSkyRenderer.Builder.fromNetwork(bufIn).build(bufIn.m_130281_());
        return new AddInvasionPacket(renderer, (InvasionListType)bufIn.m_130066_(InvasionListType.class), bufIn.readBoolean());
    }

    public static final class Handler {
        public static final boolean handle(AddInvasionPacket msgIn, Supplier<NetworkEvent.Context> ctxIn) {
            ctxIn.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> Handler.lambda$handle$1(msgIn, (Supplier)ctxIn)));
            return true;
        }

        private static final void handlePacket(AddInvasionPacket msgIn, Supplier<NetworkEvent.Context> ctxIn) {
            Minecraft mc = Minecraft.m_91087_();
            switch (msgIn.listType) {
                case DAY: {
                    ClientInvasionWorldInfo.getDayClientInfo(mc.f_91073_).getRendererMap().add(msgIn.renderer, msgIn.isPrimary);
                    break;
                }
                case NIGHT: {
                    ClientInvasionWorldInfo.getNightClientInfo(mc.f_91073_).getRendererMap().add(msgIn.renderer, msgIn.isPrimary);
                    break;
                }
                case FIXED: {
                    ClientInvasionWorldInfo.getFixedClientInfo(mc.f_91073_).getRendererMap().add(msgIn.renderer, msgIn.isPrimary);
                }
            }
        }

        private static /* synthetic */ Runnable lambda$handle$1(AddInvasionPacket msgIn, Supplier ctxIn) {
            return () -> Handler.lambda$handle$0(msgIn, (Supplier)ctxIn);
        }

        private static /* synthetic */ void lambda$handle$0(AddInvasionPacket msgIn, Supplier ctxIn) {
            Handler.handlePacket(msgIn, ctxIn);
        }
    }
}

