/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.spawner;

import dev.theagameplayer.puresuffering.PSEventManager;
import dev.theagameplayer.puresuffering.config.PSConfigValues;
import dev.theagameplayer.puresuffering.invasion.HyperType;
import dev.theagameplayer.puresuffering.invasion.Invasion;
import dev.theagameplayer.puresuffering.invasion.InvasionType;
import dev.theagameplayer.puresuffering.util.InvasionChart;
import dev.theagameplayer.puresuffering.util.InvasionList;
import dev.theagameplayer.puresuffering.util.InvasionListType;
import java.util.ArrayList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class FixedInvasionSpawner {
    private static final Logger LOGGER = LogManager.getLogger((String)"puresuffering");
    private final InvasionList invasions = new InvasionList(InvasionListType.FIXED);
    private final ArrayList<Invasion> queuedInvasions = new ArrayList();
    private int interval;
    private int hyperInterval;
    private int mysteryInterval;

    public final void setInvasions(ServerLevel levelIn, boolean isCanceledIn, int amountIn, long daysIn) {
        int totalInvasions;
        this.invasions.clear();
        RandomSource random = levelIn.f_46441_;
        int n = !this.queuedInvasions.isEmpty() ? this.queuedInvasions.size() : (totalInvasions = this.calculateInvasions(random, amountIn, this.interval, isCanceledIn, daysIn == 0L));
        int n2 = this.interval > 0 ? this.interval - 1 : (this.interval = PSConfigValues.common.consistentInvasions ? PSConfigValues.common.fixedInvasionRarity : random.m_188503_(PSConfigValues.common.fixedInvasionRarity) + PSConfigValues.common.fixedInvasionRarity - (int)(daysIn % (long)PSConfigValues.common.fixedInvasionRarity));
        int n3 = this.hyperInterval > 0 ? (this.interval == 0 ? (PSConfigValues.common.hyperInvasions && PSConfigValues.common.hyperCharge ? this.hyperInterval - 1 : this.hyperInterval) : this.hyperInterval) : (this.hyperInterval = PSConfigValues.common.consistentInvasions ? PSConfigValues.common.hyperInvasionRarity : random.m_188503_(PSConfigValues.common.hyperInvasionRarity) + PSConfigValues.common.hyperInvasionRarity - (int)(daysIn % (long)PSConfigValues.common.hyperInvasionRarity));
        this.mysteryInterval = this.mysteryInterval > 0 ? (this.hyperInterval == 0 ? (PSConfigValues.common.mysteryInvasions && PSConfigValues.common.hyperCharge ? this.mysteryInterval - 1 : this.mysteryInterval) : this.mysteryInterval) : (PSConfigValues.common.consistentInvasions ? PSConfigValues.common.mysteryInvasionRarity : random.m_188503_(PSConfigValues.common.mysteryInvasionRarity) + PSConfigValues.common.mysteryInvasionRarity - (int)(daysIn % (long)PSConfigValues.common.mysteryInvasionRarity));
        InvasionChart.refresh();
        InvasionChart potentialPrimaryInvasions = new InvasionChart(PSEventManager.BaseEvents.getInvasionTypeManager().getInvasionTypesOf(it -> !(!it.getDimensions().contains(levelIn.m_46472_().m_135782_()) || PSConfigValues.common.tieredInvasions && daysIn < (long)(it.getTier() * PSConfigValues.common.fixedDifficultyIncreaseDelay) || it.getInvasionPriority() == InvasionType.InvasionPriority.SECONDARY_ONLY || !PSConfigValues.common.primaryWhitelist.isEmpty() && !PSConfigValues.common.primaryWhitelist.contains(it.getId().toString()))));
        InvasionChart potentialSecondaryInvasions = new InvasionChart(PSEventManager.BaseEvents.getInvasionTypeManager().getInvasionTypesOf(it -> it.getDimensions().contains(levelIn.m_46472_().m_135782_()) && (!PSConfigValues.common.tieredInvasions || daysIn >= (long)(it.getTier() * PSConfigValues.common.fixedDifficultyIncreaseDelay)) && it.getInvasionPriority() != InvasionType.InvasionPriority.PRIMARY_ONLY));
        LOGGER.info("Setting Fixed Invasions: [");
        this.invasions.setCanceled(this.queuedInvasions.isEmpty() && isCanceledIn);
        if (!this.queuedInvasions.isEmpty()) {
            for (int q = 0; q < this.queuedInvasions.size(); ++q) {
                Invasion invasion = this.queuedInvasions.get(q);
                this.invasions.add(invasion);
                LOGGER.info("Queued " + (invasion.getHyperType() != HyperType.DEFAULT ? (invasion.getHyperType() == HyperType.MYSTERY ? "Mystery " : "Hyper ") : "") + "Invasion " + (q + 1) + ": " + invasion.getType() + " - " + (invasion.getSeverity() + 1));
            }
            this.queuedInvasions.clear();
        } else {
            for (int inv = 0; inv < totalInvasions; ++inv) {
                InvasionType invasionType = this.getInvasionType(inv == 0 ? potentialPrimaryInvasions : potentialSecondaryInvasions, random);
                if (invasionType == null) continue;
                int severity = this.hyperInterval == 0 ? invasionType.getMaxSeverity() - 1 : random.m_188503_(random.m_188503_(Mth.m_14045_((int)((int)daysIn / PSConfigValues.common.fixedDifficultyIncreaseDelay - invasionType.getTier()), (int)1, (int)invasionType.getMaxSeverity())) + 1);
                Invasion invasion = new Invasion(invasionType, severity, inv == 0, this.hyperInterval == 0 ? (this.mysteryInterval == 0 ? HyperType.MYSTERY : HyperType.HYPER) : HyperType.DEFAULT);
                this.invasions.add(invasion);
                LOGGER.info((this.hyperInterval == 0 ? (invasion.getHyperType() == HyperType.MYSTERY ? "Mystery " : "Hyper ") : "") + "Invasion " + (inv + 1) + ": " + invasionType + " - " + (severity + 1));
            }
        }
        LOGGER.info("]");
    }

    private final int calculateInvasions(RandomSource randomIn, int amountIn, int intervalIn, boolean isCanceledIn, boolean isFirstDayIn) {
        return !isFirstDayIn && intervalIn == 0 && amountIn > 0 && !isCanceledIn ? randomIn.m_188503_(amountIn) + 1 : 0;
    }

    private final InvasionType getInvasionType(InvasionChart invasionChartIn, RandomSource randomIn) {
        return invasionChartIn.getInvasionInRange(randomIn.m_188501_());
    }

    public final void invasionTick(MinecraftServer serverIn, ServerLevel levelIn) {
        if (!this.invasions.isEmpty()) {
            Invasion invasion = this.invasions.get(levelIn.m_213780_().m_188503_(this.invasions.size()));
            invasion.tick(levelIn);
        }
    }

    public final void load(CompoundTag nbtIn) {
        ListTag invasionsNBT = nbtIn.m_128437_("Invasions", 10);
        ListTag queuedInvasionsNBT = nbtIn.m_128437_("QueuedInvasions", 10);
        for (Tag inbt : invasionsNBT) {
            this.invasions.add(Invasion.load((CompoundTag)inbt));
        }
        for (Tag inbt : queuedInvasionsNBT) {
            this.queuedInvasions.add(Invasion.load((CompoundTag)inbt));
        }
        this.interval = nbtIn.m_128451_("Interval");
        this.hyperInterval = nbtIn.m_128451_("HyperInterval");
        this.mysteryInterval = nbtIn.m_128451_("MysteryInterval");
    }

    public final CompoundTag save() {
        CompoundTag nbt = new CompoundTag();
        ListTag invasionsNBT = new ListTag();
        ListTag queuedInvasionsNBT = new ListTag();
        for (Invasion invasion : this.invasions) {
            invasionsNBT.add((Object)invasion.save());
        }
        for (Invasion invasion : this.queuedInvasions) {
            invasionsNBT.add((Object)invasion.save());
        }
        nbt.m_128365_("Invasions", (Tag)invasionsNBT);
        nbt.m_128365_("QueuedInvasions", (Tag)queuedInvasionsNBT);
        nbt.m_128405_("Interval", this.interval);
        nbt.m_128405_("HyperInterval", this.hyperInterval);
        nbt.m_128405_("MysteryInterval", this.mysteryInterval);
        return nbt;
    }

    public final InvasionList getInvasions() {
        return this.invasions;
    }

    public final ArrayList<Invasion> getQueuedInvasions() {
        return this.queuedInvasions;
    }
}

