/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.util;

import dev.theagameplayer.puresuffering.client.ClientTransitionHandler;
import dev.theagameplayer.puresuffering.client.renderer.InvasionSkyRenderer;
import dev.theagameplayer.puresuffering.util.InvasionRendererMap;
import dev.theagameplayer.puresuffering.world.ClientInvasionWorldInfo;
import java.util.ArrayList;
import net.minecraft.client.multiplayer.ClientLevel;

public final class ClientInvasionUtil {
    public static final float handleBrightness(float brightnessIn, ClientLevel levelIn) {
        if (!levelIn.m_6042_().m_63967_()) {
            float brightness = 0.0f;
            ClientInvasionWorldInfo dayInfo = ClientInvasionWorldInfo.getDayClientInfo(levelIn);
            ClientInvasionWorldInfo nightInfo = ClientInvasionWorldInfo.getNightClientInfo(levelIn);
            if (dayInfo.isClientTime() && !dayInfo.getRendererMap().isEmpty()) {
                ArrayList<InvasionSkyRenderer> rendererList = dayInfo.getRendererMap().getRenderersOf(renderer -> renderer.isBrightnessChanged());
                for (InvasionSkyRenderer renderer2 : rendererList) {
                    brightness += renderer2.getBrightness() / (float)rendererList.size();
                }
                return ClientTransitionHandler.tickBrightness(brightnessIn, brightness, levelIn.m_46468_() % 12000L);
            }
            if (nightInfo.isClientTime() && !nightInfo.getRendererMap().isEmpty()) {
                ArrayList<InvasionSkyRenderer> rendererList = nightInfo.getRendererMap().getRenderersOf(renderer -> renderer.isBrightnessChanged());
                for (InvasionSkyRenderer renderer3 : rendererList) {
                    brightness += renderer3.getBrightness() / (float)rendererList.size();
                }
                return ClientTransitionHandler.tickBrightness(brightnessIn, brightness, levelIn.m_46468_() % 12000L);
            }
        } else {
            float brightness = 0.0f;
            InvasionRendererMap fixedRenderers = ClientInvasionWorldInfo.getFixedClientInfo(levelIn).getRendererMap();
            if (!fixedRenderers.isEmpty()) {
                ArrayList<InvasionSkyRenderer> rendererList = fixedRenderers.getRenderersOf(renderer -> renderer.isBrightnessChanged());
                for (InvasionSkyRenderer renderer4 : rendererList) {
                    brightness += renderer4.getBrightness() / (float)rendererList.size();
                }
                return ClientTransitionHandler.tickBrightness(brightnessIn, brightness, levelIn.m_46468_() % 12000L);
            }
        }
        return brightnessIn;
    }

    public static final boolean handleLightMap(boolean resultIn, ClientLevel levelIn) {
        if (!levelIn.m_6042_().m_63967_()) {
            ArrayList<InvasionSkyRenderer> rendererList;
            ClientInvasionWorldInfo dayInfo = ClientInvasionWorldInfo.getDayClientInfo(levelIn);
            ClientInvasionWorldInfo nightInfo = ClientInvasionWorldInfo.getNightClientInfo(levelIn);
            if (dayInfo.isClientTime() && !dayInfo.getRendererMap().isEmpty() ? !(rendererList = dayInfo.getRendererMap().getRenderersOf(renderer -> renderer.isBrightnessChanged())).isEmpty() : nightInfo.isClientTime() && !nightInfo.getRendererMap().isEmpty() && !(rendererList = nightInfo.getRendererMap().getRenderersOf(renderer -> renderer.isBrightnessChanged())).isEmpty()) {
                return false;
            }
        } else {
            ArrayList<InvasionSkyRenderer> rendererList;
            InvasionRendererMap fixedRenderers = ClientInvasionWorldInfo.getFixedClientInfo(levelIn).getRendererMap();
            if (!fixedRenderers.isEmpty() && !(rendererList = fixedRenderers.getRenderersOf(renderer -> renderer.isBrightnessChanged())).isEmpty()) {
                return false;
            }
        }
        return resultIn;
    }
}

