/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.CommandDispatcher;
import dev.theagameplayer.puresuffering.client.ClientTransitionHandler;
import dev.theagameplayer.puresuffering.client.renderer.InvasionFogRenderer;
import dev.theagameplayer.puresuffering.client.renderer.InvasionSkyRenderer;
import dev.theagameplayer.puresuffering.client.renderer.entity.layers.HyperChargeLayer;
import dev.theagameplayer.puresuffering.command.PSCommands;
import dev.theagameplayer.puresuffering.config.PSConfigValues;
import dev.theagameplayer.puresuffering.data.InvasionTypeManager;
import dev.theagameplayer.puresuffering.invasion.HyperType;
import dev.theagameplayer.puresuffering.invasion.Invasion;
import dev.theagameplayer.puresuffering.network.PSPacketHandler;
import dev.theagameplayer.puresuffering.network.packet.UpdateXPMultPacket;
import dev.theagameplayer.puresuffering.registries.PSMobEffects;
import dev.theagameplayer.puresuffering.registries.other.PSEntityPredicates;
import dev.theagameplayer.puresuffering.registries.other.PSGameRulesRegistry;
import dev.theagameplayer.puresuffering.util.InvasionListType;
import dev.theagameplayer.puresuffering.util.InvasionRendererMap;
import dev.theagameplayer.puresuffering.util.ServerTimeUtil;
import dev.theagameplayer.puresuffering.util.text.InvasionText;
import dev.theagameplayer.puresuffering.world.ClientInvasionWorldInfo;
import dev.theagameplayer.puresuffering.world.FixedInvasionWorldData;
import dev.theagameplayer.puresuffering.world.InvasionWorldData;
import dev.theagameplayer.puresuffering.world.TimedInvasionWorldData;
import dev.theagameplayer.puresuffering.world.entity.PSHyperCharge;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.monster.Zoglin;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityMobGriefingEvent;
import net.minecraftforge.event.entity.living.LivingConversionEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class PSEventManager {
    private static final Logger LOGGER = LogManager.getLogger((String)"puresuffering");

    public static final void attachClientEventListeners(IEventBus modBusIn, IEventBus forgeBusIn) {
        modBusIn.addListener(ClientEvents::addLayers);
        forgeBusIn.addListener(ClientEvents::loggedIn);
        forgeBusIn.addListener(ClientEvents::loggedOut);
        forgeBusIn.addListener(ClientEvents::fogColors);
        forgeBusIn.addListener(ClientEvents::customizeGuiOverlayDebugText);
    }

    public static final void attachCommonEventListeners(IEventBus modBusIn, IEventBus forgeBusIn) {
        forgeBusIn.addListener(BaseEvents::addReloadListeners);
        forgeBusIn.addListener(BaseEvents::registerCommands);
        forgeBusIn.addListener(BaseEvents::levelTick);
        forgeBusIn.addListener(EntityEvents::joinLevel);
        forgeBusIn.addListener(EntityEvents::mobGriefing);
        forgeBusIn.addListener(LivingEvents::livingConversion);
        forgeBusIn.addListener(LivingEvents::livingTick);
        forgeBusIn.addListener(LivingEvents::experienceDrop);
        forgeBusIn.addListener(LivingEvents::checkSpawn);
        forgeBusIn.addListener(LivingEvents::specialSpawn);
        forgeBusIn.addListener(LivingEvents::allowDespawn);
        forgeBusIn.addListener(PlayerEvents::playerLoggedIn);
        forgeBusIn.addListener(PlayerEvents::playerRespawn);
        forgeBusIn.addListener(PlayerEvents::playerChangeDimension);
        forgeBusIn.addListener(PlayerEvents::playerSleepInBed);
        forgeBusIn.addListener(ServerEvents::serverStarted);
        forgeBusIn.addListener(ServerEvents::serverStarting);
        forgeBusIn.addListener(ServerEvents::serverStopping);
    }

    public static final class ServerEvents {
        public static final void serverStarted(ServerStartedEvent eventIn) {
            if (PSConfigValues.common.multiThreadedInvasions) {
                for (InvasionWorldData iwData : InvasionWorldData.getInvasionData().values()) {
                    eventIn.getServer().m_129946_((Runnable)new Thread(() -> {
                        if (!iwData.hasFixedTime()) {
                            ((TimedInvasionWorldData)iwData).getInvasionSpawner().invasionTick(eventIn.getServer(), iwData.getWorld());
                        } else {
                            ((FixedInvasionWorldData)iwData).getInvasionSpawner().invasionTick(eventIn.getServer(), iwData.getWorld());
                        }
                    }, "Invasion Ticker: " + iwData.getWorld().m_46472_().m_135782_()));
                }
            } else {
                eventIn.getServer().m_129946_((Runnable)new Thread(() -> {
                    for (InvasionWorldData iwData : InvasionWorldData.getInvasionData().values()) {
                        if (iwData.getWorld().m_6907_().isEmpty()) continue;
                        if (!iwData.hasFixedTime()) {
                            ((TimedInvasionWorldData)iwData).getInvasionSpawner().invasionTick(eventIn.getServer(), iwData.getWorld());
                            continue;
                        }
                        ((FixedInvasionWorldData)iwData).getInvasionSpawner().invasionTick(eventIn.getServer(), iwData.getWorld());
                    }
                }, "Invasion Ticker"));
            }
        }

        public static final void serverStarting(ServerStartingEvent eventIn) {
            PSConfigValues.resync(PSConfigValues.common);
            eventIn.getServer().m_129785_().forEach(level -> {
                boolean hasFixedTime = level.m_6042_().m_63967_();
                InvasionWorldData.getInvasionData().put((ServerLevel)level, (InvasionWorldData)level.m_8895_().m_164861_(data -> hasFixedTime ? FixedInvasionWorldData.load(level, data) : TimedInvasionWorldData.load(level, data), () -> hasFixedTime ? new FixedInvasionWorldData((ServerLevel)level) : new TimedInvasionWorldData((ServerLevel)level), InvasionWorldData.getFileId((Holder<DimensionType>)level.m_204156_())));
            });
        }

        public static final void serverStopping(ServerStoppingEvent eventIn) {
            PSConfigValues.resync(PSConfigValues.common);
        }
    }

    public static final class PlayerEvents {
        public static final void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent eventIn) {
            PlayerEvents.updatePlayer((PlayerEvent)eventIn);
        }

        public static final void playerRespawn(PlayerEvent.PlayerRespawnEvent eventIn) {
            if (PSConfigValues.common.hyperAggression) {
                eventIn.getEntity().m_7292_(new MobEffectInstance((MobEffect)PSMobEffects.BLESSING.get(), PSConfigValues.common.blessingEffectRespawnDuration, 0));
            }
            PlayerEvents.updatePlayer((PlayerEvent)eventIn);
        }

        public static final void playerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent eventIn) {
            if (PSConfigValues.common.hyperAggression) {
                eventIn.getEntity().m_7292_(new MobEffectInstance((MobEffect)PSMobEffects.BLESSING.get(), PSConfigValues.common.blessingEffectDimensionChangeDuration, 0));
            }
            PlayerEvents.updatePlayer((PlayerEvent)eventIn);
        }

        private static final void updatePlayer(PlayerEvent eventIn) {
            if (eventIn.getEntity() instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)eventIn.getEntity();
                InvasionWorldData iwData = InvasionWorldData.getInvasionData().get((ServerLevel)player.f_19853_);
                if (iwData != null) {
                    if (!iwData.hasFixedTime()) {
                        TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                        tiwData.getInvasionSpawner().getDayInvasions().update(player);
                        tiwData.getInvasionSpawner().getNightInvasions().update(player);
                    } else {
                        FixedInvasionWorldData fiwData = (FixedInvasionWorldData)iwData;
                        fiwData.getInvasionSpawner().getInvasions().update(player);
                    }
                }
                ServerTimeUtil.updateTime(player);
            }
        }

        public static final void playerSleepInBed(PlayerSleepInBedEvent eventIn) {
            block2: {
                TimedInvasionWorldData tiwData;
                ServerLevel level;
                block3: {
                    level = (ServerLevel)eventIn.getEntity().f_19853_;
                    InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(level);
                    if (iwData == null || iwData.hasFixedTime()) break block2;
                    tiwData = (TimedInvasionWorldData)iwData;
                    if (!ServerTimeUtil.isServerDay(level, tiwData) || tiwData.getInvasionSpawner().getDayInvasions().isEmpty()) break block3;
                    for (Invasion invasion : tiwData.getInvasionSpawner().getDayInvasions()) {
                        if (!PSConfigValues.common.forceInvasionSleeplessness && !invasion.getType().getSeverityInfo().get(invasion.getSeverity()).forcesNoSleep()) continue;
                        eventIn.setResult(Player.BedSleepingProblem.NOT_POSSIBLE_NOW);
                        return;
                    }
                    break block2;
                }
                if (!ServerTimeUtil.isServerNight(level, tiwData) || tiwData.getInvasionSpawner().getNightInvasions().isEmpty()) break block2;
                for (Invasion invasion : tiwData.getInvasionSpawner().getNightInvasions()) {
                    if (!PSConfigValues.common.forceInvasionSleeplessness && !invasion.getType().getSeverityInfo().get(invasion.getSeverity()).forcesNoSleep()) continue;
                    eventIn.setResult(Player.BedSleepingProblem.NOT_POSSIBLE_NOW);
                    return;
                }
            }
        }
    }

    public static final class LivingEvents {
        public static final void livingConversion(LivingConversionEvent.Post eventIn) {
            if (eventIn.getOutcome().getClassification(false) == MobCategory.MONSTER) {
                CompoundTag persistentData = eventIn.getEntity().getPersistentData();
                CompoundTag outcomeData = eventIn.getOutcome().getPersistentData();
                if (persistentData.m_128441_("InvasionMob")) {
                    outcomeData.m_128359_("InvasionMob", persistentData.m_128461_("InvasionMob"));
                }
                if (persistentData.m_128441_("AntiGrief")) {
                    outcomeData.m_128359_("AntiGrief", persistentData.m_128461_("AntiGrief"));
                }
            }
        }

        public static final void livingTick(LivingEvent.LivingTickEvent eventIn) {
            if (eventIn.getEntity() instanceof Mob && eventIn.getEntity().getPersistentData().m_128441_("InvasionMob") && (eventIn.getEntity().m_21188_() == null || !eventIn.getEntity().m_21188_().m_6084_()) && PSConfigValues.common.hyperAggression && !PSConfigValues.common.hyperAggressionBlacklist.contains(eventIn.getEntity().m_6095_().m_20675_())) {
                Mob mob = (Mob)eventIn.getEntity();
                if (mob.m_5448_() instanceof Player) {
                    return;
                }
                Player player = mob.f_19853_.m_5788_(mob.m_20185_(), mob.m_20186_(), mob.m_20189_(), 144.0, PSEntityPredicates.HYPER_AGGRESSION);
                if (player != null && player.m_6084_()) {
                    if (mob instanceof AbstractPiglin) {
                        mob.m_6274_().m_21882_(MemoryModuleType.f_26334_, (Object)player.m_20148_(), 12000L);
                    } else if (mob instanceof Hoglin) {
                        mob.m_6274_().m_21936_(MemoryModuleType.f_26326_);
                        mob.m_6274_().m_21936_(MemoryModuleType.f_26375_);
                        mob.m_6274_().m_21882_(MemoryModuleType.f_26372_, (Object)player, 12000L);
                    } else if (mob instanceof Zoglin) {
                        mob.m_6274_().m_21936_(MemoryModuleType.f_26326_);
                        mob.m_6274_().m_21882_(MemoryModuleType.f_26372_, (Object)player, 12000L);
                    } else {
                        mob.m_6710_((LivingEntity)player);
                    }
                }
            }
        }

        public static final void experienceDrop(LivingExperienceDropEvent eventIn) {
            CompoundTag persistentData = eventIn.getEntity().getPersistentData();
            if (PSConfigValues.common.useXPMultiplier && persistentData.m_128441_("InvasionMob")) {
                ServerLevel serverLevel = (ServerLevel)eventIn.getEntity().f_19853_;
                InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(serverLevel);
                if (iwData != null) {
                    if (!iwData.hasFixedTime()) {
                        TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                        if (ServerTimeUtil.isServerDay(serverLevel, tiwData)) {
                            tiwData.setDayXPMultiplier(tiwData.getDayXPMultiplier() + 1.0);
                            double log = Math.log1p(tiwData.getDayXPMultiplier()) / Math.E;
                            for (int hc = 0; hc < (eventIn.getEntity() instanceof PSHyperCharge ? ((PSHyperCharge)eventIn.getEntity()).psGetHyperCharge() + 1 : 1); ++hc) {
                                eventIn.setDroppedExperience((int)((double)eventIn.getOriginalExperience() * log));
                            }
                            PSPacketHandler.sendToAllClients(new UpdateXPMultPacket(log, InvasionListType.DAY));
                        } else if (ServerTimeUtil.isServerNight(serverLevel, tiwData)) {
                            tiwData.setNightXPMultiplier(tiwData.getNightXPMultiplier() + 1.0);
                            double log = Math.log1p(tiwData.getNightXPMultiplier()) / Math.E;
                            for (int hc = 0; hc < (eventIn.getEntity() instanceof PSHyperCharge ? ((PSHyperCharge)eventIn.getEntity()).psGetHyperCharge() + 1 : 1); ++hc) {
                                eventIn.setDroppedExperience((int)((double)eventIn.getOriginalExperience() * log));
                            }
                            PSPacketHandler.sendToAllClients(new UpdateXPMultPacket(log, InvasionListType.NIGHT));
                        }
                    } else {
                        FixedInvasionWorldData fiwData = (FixedInvasionWorldData)iwData;
                        fiwData.setXPMultiplier(fiwData.getXPMultiplier() + 1.0);
                        double log = Math.log1p(fiwData.getXPMultiplier()) / Math.E;
                        for (int hc = 0; hc < (eventIn.getEntity() instanceof PSHyperCharge ? ((PSHyperCharge)eventIn.getEntity()).psGetHyperCharge() + 1 : 1); ++hc) {
                            eventIn.setDroppedExperience((int)((double)eventIn.getOriginalExperience() * log));
                        }
                        PSPacketHandler.sendToAllClients(new UpdateXPMultPacket(log, InvasionListType.FIXED));
                    }
                }
            }
        }

        public static final void checkSpawn(LivingSpawnEvent.CheckSpawn eventIn) {
            if (!eventIn.getLevel().m_5776_() && eventIn.getSpawnReason().equals((Object)MobSpawnType.NATURAL)) {
                ServerLevel serverLevel = (ServerLevel)eventIn.getLevel();
                InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(serverLevel);
                if (iwData != null) {
                    if (serverLevel.f_46441_.m_188503_(10000) < PSConfigValues.common.naturalSpawnChance) {
                        eventIn.setResult(Event.Result.DEFAULT);
                    } else if (!iwData.hasFixedTime()) {
                        TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                        if (ServerTimeUtil.isServerDay(serverLevel, tiwData) && !tiwData.getInvasionSpawner().getDayInvasions().isEmpty() || ServerTimeUtil.isServerNight(serverLevel, tiwData) && !tiwData.getInvasionSpawner().getNightInvasions().isEmpty()) {
                            eventIn.setResult(Event.Result.DENY);
                        }
                    } else {
                        FixedInvasionWorldData fiwData = (FixedInvasionWorldData)iwData;
                        if (!fiwData.getInvasionSpawner().getInvasions().isEmpty()) {
                            eventIn.setResult(Event.Result.DENY);
                        }
                    }
                }
            }
        }

        public static final void specialSpawn(LivingSpawnEvent.SpecialSpawn eventIn) {
            if (!eventIn.getLevel().m_5776_() && eventIn.getEntity().getClassification(false) == MobCategory.MONSTER && eventIn.getSpawnReason() == MobSpawnType.NATURAL) {
                ServerLevel serverLevel = (ServerLevel)eventIn.getLevel();
                InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(serverLevel);
                if (iwData != null) {
                    if (!iwData.hasFixedTime()) {
                        TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                        if (!tiwData.getInvasionSpawner().getDayInvasions().isEmpty() || !tiwData.getInvasionSpawner().getNightInvasions().isEmpty()) {
                            eventIn.getEntity().getPersistentData().m_128379_("AntiGrief", false);
                        }
                    } else {
                        FixedInvasionWorldData fiwData = (FixedInvasionWorldData)iwData;
                        if (!fiwData.getInvasionSpawner().getInvasions().isEmpty()) {
                            eventIn.getEntity().getPersistentData().m_128379_("AntiGrief", true);
                        }
                    }
                }
            }
        }

        public static final void allowDespawn(LivingSpawnEvent.AllowDespawn eventIn) {
            if (!eventIn.getLevel().m_5776_() && PSConfigValues.common.shouldMobsDieAtEndOfInvasions && eventIn.getEntity() instanceof Mob) {
                ServerLevel serverLevel = (ServerLevel)eventIn.getLevel();
                InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(serverLevel);
                Mob mobEntity = eventIn.getEntity();
                CompoundTag persistentData = mobEntity.getPersistentData();
                if (iwData != null && persistentData.m_128441_("InvasionMob")) {
                    if (!iwData.hasFixedTime()) {
                        TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                        if (ServerTimeUtil.isServerDay(serverLevel, tiwData)) {
                            for (Invasion invasion : tiwData.getInvasionSpawner().getDayInvasions()) {
                                if (!persistentData.m_128461_("InvasionMob").equals(invasion.getType().getId().toString())) continue;
                                return;
                            }
                            eventIn.setResult(Event.Result.ALLOW);
                        } else if (ServerTimeUtil.isServerNight(serverLevel, tiwData)) {
                            for (Invasion invasion : tiwData.getInvasionSpawner().getNightInvasions()) {
                                if (!persistentData.m_128461_("InvasionMob").equals(invasion.getType().getId().toString())) continue;
                                return;
                            }
                            eventIn.setResult(Event.Result.ALLOW);
                        }
                    } else {
                        FixedInvasionWorldData fiwData = (FixedInvasionWorldData)iwData;
                        for (Invasion invasion : fiwData.getInvasionSpawner().getInvasions()) {
                            if (!persistentData.m_128461_("InvasionMob").equals(invasion.getType().getId().toString())) continue;
                            return;
                        }
                        eventIn.setResult(Event.Result.ALLOW);
                    }
                }
            }
        }
    }

    public static final class EntityEvents {
        public static final void joinLevel(EntityJoinLevelEvent eventIn) {
            Vex vexEntity;
            if (eventIn.getEntity() instanceof TamableAnimal) {
                TamableAnimal tameableEntity = (TamableAnimal)eventIn.getEntity();
                if (tameableEntity.m_21826_() != null && tameableEntity.m_21826_().getPersistentData().m_128441_("AntiGrief")) {
                    tameableEntity.getPersistentData().m_128379_("AntiGrief", tameableEntity.m_21826_().getPersistentData().m_128471_("AntiGrief"));
                }
            } else if (PSConfigValues.common.weakenedVexes && eventIn.getEntity() instanceof Vex && (vexEntity = (Vex)eventIn.getEntity()).m_34026_() != null && vexEntity.m_34026_().getPersistentData().m_128441_("InvasionMob")) {
                vexEntity.m_33987_(25 + eventIn.getLevel().m_213780_().m_188503_(65));
            }
        }

        public static final void mobGriefing(EntityMobGriefingEvent eventIn) {
            if (!PSConfigValues.common.explosionsDestroyBlocks && eventIn.getEntity() != null && eventIn.getEntity().getPersistentData().m_128441_("AntiGrief")) {
                eventIn.setResult(Event.Result.DENY);
            }
        }
    }

    public static final class BaseEvents {
        private static InvasionTypeManager invasionTypeManager = new InvasionTypeManager();

        public static final void addReloadListeners(AddReloadListenerEvent eventIn) {
            eventIn.addListener((PreparableReloadListener)invasionTypeManager);
        }

        public static final InvasionTypeManager getInvasionTypeManager() {
            return invasionTypeManager;
        }

        public static final void registerCommands(RegisterCommandsEvent eventIn) {
            PSCommands.build((CommandDispatcher<CommandSourceStack>)eventIn.getDispatcher());
        }

        public static final void levelTick(TickEvent.LevelTickEvent eventIn) {
            block11: {
                boolean flag;
                InvasionWorldData iwData;
                ServerLevel level;
                block12: {
                    TimedInvasionWorldData tiwData;
                    block14: {
                        block13: {
                            if (!eventIn.side.isServer() || eventIn.phase != TickEvent.Phase.END) break block11;
                            level = (ServerLevel)eventIn.level;
                            iwData = InvasionWorldData.getInvasionData().get(level);
                            if (iwData == null || !PSGameRulesRegistry.getEnableInvasions((Level)level)) break block11;
                            if (iwData.hasFixedTime()) break block12;
                            tiwData = (TimedInvasionWorldData)iwData;
                            if (!ServerTimeUtil.isServerDay(level, tiwData) || tiwData.hasCheckedNight()) break block13;
                            tiwData.setDays(level.m_46468_() / 24000L);
                            int amount = Mth.m_14045_((int)((int)(level.m_46468_() / (24000L * (long)PSConfigValues.common.nightDifficultyIncreaseDelay)) + 1), (int)0, (int)PSConfigValues.common.maxNightInvasions);
                            int chance = level.f_46441_.m_188503_((int)((double)PSConfigValues.common.nightDifficultyIncreaseDelay * PSConfigValues.common.nightCancelChanceMultiplier) + 1);
                            boolean cancelFlag = chance == 0 && amount > 1 && tiwData.getInvasionSpawner().getQueuedNightInvasions().isEmpty() && PSConfigValues.common.canNightInvasionsBeCanceled;
                            LOGGER.info("Day: " + iwData.getDays() + ", Possible Invasions: " + amount);
                            tiwData.getInvasionSpawner().setNightInvasions(level, cancelFlag, amount, tiwData.getDays());
                            PSPacketHandler.sendToAllClients(new UpdateXPMultPacket(0.0, InvasionListType.DAY));
                            tiwData.setDayXPMultiplier(0.0);
                            tiwData.setCheckedDay(false);
                            tiwData.setCheckedNight(true);
                            if (tiwData.getInvasionSpawner().getDayInvasions().isEmpty() && !tiwData.getInvasionSpawner().getDayInvasions().isCanceled()) break block11;
                            HyperType hyperType = HyperType.DEFAULT;
                            for (Invasion invasion : tiwData.getInvasionSpawner().getDayInvasions()) {
                                if (invasion.getHyperType().ordinal() <= hyperType.ordinal()) continue;
                                hyperType = invasion.getHyperType();
                            }
                            for (ServerPlayer player : level.m_6907_()) {
                                if (tiwData.getInvasionSpawner().getDayInvasions().isCanceled()) {
                                    player.m_213846_((Component)Component.m_237115_((String)"invasion.puresuffering.day.cancel").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)));
                                    continue;
                                }
                                player.m_213846_((Component)Component.m_237115_((String)(hyperType != HyperType.DEFAULT ? (hyperType == HyperType.MYSTERY ? "invasion.puresuffering.message1" : "invasion.puresuffering.message2") : "invasion.puresuffering.message3")).m_130948_(Style.f_131099_.m_178520_(hyperType == HyperType.MYSTERY ? (ChatFormatting.DARK_PURPLE.m_126665_() + ChatFormatting.DARK_RED.m_126665_()) / 2 : ChatFormatting.RED.m_126665_()).m_131136_(Boolean.valueOf(hyperType != HyperType.DEFAULT)).m_131155_(Boolean.valueOf(hyperType == HyperType.MYSTERY))));
                                player.m_213846_((Component)InvasionText.create("invasion.puresuffering.message4", new Color(hyperType == HyperType.MYSTERY ? (ChatFormatting.DARK_PURPLE.m_126665_() + ChatFormatting.DARK_RED.m_126665_()) / 3 : ChatFormatting.DARK_RED.m_126665_()), tiwData.getInvasionSpawner().getDayInvasions()).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(hyperType != HyperType.DEFAULT)).m_131155_(Boolean.valueOf(hyperType == HyperType.MYSTERY))));
                            }
                            break block11;
                        }
                        if (!ServerTimeUtil.isServerNight(level, tiwData) || tiwData.hasCheckedDay()) break block14;
                        tiwData.setDays(level.m_46468_() / 24000L);
                        int amount = Mth.m_14045_((int)((int)(level.m_46468_() / (24000L * (long)PSConfigValues.common.dayDifficultyIncreaseDelay)) + 1), (int)0, (int)PSConfigValues.common.maxDayInvasions);
                        int chance = level.f_46441_.m_188503_((int)((double)PSConfigValues.common.dayDifficultyIncreaseDelay * PSConfigValues.common.dayCancelChanceMultiplier) + 1);
                        boolean cancelFlag = chance == 0 && amount > 1 && tiwData.getInvasionSpawner().getQueuedDayInvasions().isEmpty() && PSConfigValues.common.canDayInvasionsBeCanceled;
                        LOGGER.info("Night: " + iwData.getDays() + ", Possible Invasions: " + amount);
                        tiwData.getInvasionSpawner().setDayInvasions(level, cancelFlag, amount, tiwData.getDays());
                        PSPacketHandler.sendToAllClients(new UpdateXPMultPacket(0.0, InvasionListType.NIGHT));
                        tiwData.setNightXPMultiplier(0.0);
                        tiwData.setCheckedDay(true);
                        tiwData.setCheckedNight(false);
                        if (tiwData.getInvasionSpawner().getNightInvasions().isEmpty() && !tiwData.getInvasionSpawner().getNightInvasions().isCanceled()) break block11;
                        HyperType hyperType = HyperType.DEFAULT;
                        for (Invasion invasion : tiwData.getInvasionSpawner().getNightInvasions()) {
                            if (invasion.getHyperType().ordinal() <= hyperType.ordinal()) continue;
                            hyperType = invasion.getHyperType();
                        }
                        for (ServerPlayer player : level.m_6907_()) {
                            if (tiwData.getInvasionSpawner().getNightInvasions().isCanceled()) {
                                player.m_213846_((Component)Component.m_237115_((String)"invasion.puresuffering.night.cancel").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)));
                                continue;
                            }
                            player.m_213846_((Component)Component.m_237115_((String)(hyperType != HyperType.DEFAULT ? (hyperType == HyperType.MYSTERY ? "invasion.puresuffering.message1" : "invasion.puresuffering.message2") : "invasion.puresuffering.message3")).m_130948_(Style.f_131099_.m_178520_(hyperType == HyperType.MYSTERY ? (ChatFormatting.DARK_PURPLE.m_126665_() + ChatFormatting.DARK_RED.m_126665_()) / 2 : ChatFormatting.RED.m_126665_()).m_131136_(Boolean.valueOf(hyperType != HyperType.DEFAULT)).m_131155_(Boolean.valueOf(hyperType == HyperType.MYSTERY))));
                            player.m_213846_((Component)InvasionText.create("invasion.puresuffering.message4", new Color(hyperType == HyperType.MYSTERY ? (ChatFormatting.DARK_PURPLE.m_126665_() + ChatFormatting.DARK_RED.m_126665_()) / 3 : ChatFormatting.DARK_RED.m_126665_()), tiwData.getInvasionSpawner().getNightInvasions()).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(hyperType != HyperType.DEFAULT)).m_131155_(Boolean.valueOf(hyperType == HyperType.MYSTERY))));
                        }
                        break block11;
                    }
                    tiwData.setCheckedDay(ServerTimeUtil.isServerNight(level, tiwData));
                    tiwData.setCheckedNight(ServerTimeUtil.isServerDay(level, tiwData));
                    break block11;
                }
                FixedInvasionWorldData fiwData = (FixedInvasionWorldData)iwData;
                boolean bl = flag = level.m_46468_() % 24000L < 12000L;
                if (fiwData.isFirstCycle() ? flag : !flag) {
                    fiwData.setDays(level.m_46468_() / 24000L);
                    int amount = Mth.m_14045_((int)((int)(level.m_46468_() / (24000L * (long)PSConfigValues.common.fixedDifficultyIncreaseDelay)) + 1), (int)0, (int)PSConfigValues.common.maxFixedInvasions);
                    int chance = level.f_46441_.m_188503_((int)((double)PSConfigValues.common.fixedDifficultyIncreaseDelay * PSConfigValues.common.fixedCancelChanceMultiplier) + 1);
                    boolean cancelFlag = chance == 0 && amount > 1 && fiwData.getInvasionSpawner().getQueuedInvasions().isEmpty() && PSConfigValues.common.canFixedInvasionsBeCanceled;
                    LOGGER.info("Cycle: " + iwData.getDays() + ", Possible Invasions: " + amount);
                    fiwData.getInvasionSpawner().setInvasions(level, cancelFlag, amount, fiwData.getDays());
                    fiwData.setFirstCycle(!fiwData.isFirstCycle());
                    PSPacketHandler.sendToAllClients(new UpdateXPMultPacket(0.0, InvasionListType.FIXED));
                    fiwData.setXPMultiplier(0.0);
                    if (!fiwData.getInvasionSpawner().getInvasions().isEmpty() || fiwData.getInvasionSpawner().getInvasions().isCanceled()) {
                        HyperType hyperType = HyperType.DEFAULT;
                        for (Invasion invasion : fiwData.getInvasionSpawner().getInvasions()) {
                            if (invasion.getHyperType().ordinal() <= hyperType.ordinal()) continue;
                            hyperType = invasion.getHyperType();
                        }
                        for (ServerPlayer player : level.m_6907_()) {
                            if (fiwData.getInvasionSpawner().getInvasions().isCanceled()) {
                                player.m_213846_((Component)Component.m_237115_((String)"invasion.puresuffering.fixed.cancel").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)));
                                continue;
                            }
                            player.m_213846_((Component)Component.m_237115_((String)(hyperType != HyperType.DEFAULT ? (hyperType == HyperType.MYSTERY ? "invasion.puresuffering.message1" : "invasion.puresuffering.message2") : "invasion.puresuffering.message3")).m_130948_(Style.f_131099_.m_178520_(hyperType == HyperType.MYSTERY ? (ChatFormatting.DARK_PURPLE.m_126665_() + ChatFormatting.DARK_RED.m_126665_()) / 2 : ChatFormatting.RED.m_126665_()).m_131136_(Boolean.valueOf(hyperType != HyperType.DEFAULT)).m_131155_(Boolean.valueOf(hyperType == HyperType.MYSTERY))));
                            player.m_213846_((Component)InvasionText.create("invasion.puresuffering.message4", new Color(hyperType == HyperType.MYSTERY ? (ChatFormatting.DARK_PURPLE.m_126665_() + ChatFormatting.DARK_RED.m_126665_()) / 3 : ChatFormatting.DARK_RED.m_126665_()), fiwData.getInvasionSpawner().getInvasions()).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(hyperType != HyperType.DEFAULT)).m_131155_(Boolean.valueOf(hyperType == HyperType.MYSTERY))));
                        }
                    }
                }
            }
        }
    }

    public static final class ClientEvents {
        public static final void addLayers(EntityRenderersEvent.AddLayers eventIn) {
            ImmutableList entityTypes = ImmutableList.copyOf((Collection)ForgeRegistries.ENTITY_TYPES.getValues().stream().filter(DefaultAttributes::m_22301_).map(et -> et).collect(Collectors.toList()));
            entityTypes.forEach(et -> {
                LivingEntityRenderer renderer = null;
                try {
                    renderer = eventIn.getRenderer(et);
                }
                catch (Exception eIn) {
                    LOGGER.warn("HyperChargeLayer failed to apply to " + ForgeRegistries.ENTITY_TYPES.getKey(et) + ", perhaps renderer is not instance of LivingEntityRenderer?");
                }
                if (renderer != null) {
                    renderer.m_115326_(new HyperChargeLayer(renderer, PSConfigValues.common.maxHyperCharge));
                }
            });
        }

        public static final void loggedIn(ClientPlayerNetworkEvent.LoggingIn eventIn) {
            PSConfigValues.resync(PSConfigValues.client);
        }

        public static final void loggedOut(ClientPlayerNetworkEvent.LoggingOut eventIn) {
            Minecraft mc = Minecraft.m_91087_();
            ClientInvasionWorldInfo.getDayClientInfo(mc.f_91073_).getRendererMap().clear();
            ClientInvasionWorldInfo.getNightClientInfo(mc.f_91073_).getRendererMap().clear();
            ClientInvasionWorldInfo.getFixedClientInfo(mc.f_91073_).getRendererMap().clear();
            PSConfigValues.resync(PSConfigValues.client);
        }

        public static final void fogColors(ViewportEvent.ComputeFogColor eventIn) {
            Minecraft mc = Minecraft.m_91087_();
            if (!mc.f_91073_.m_6042_().m_63967_()) {
                float red = 0.0f;
                float green = 0.0f;
                float blue = 0.0f;
                ClientInvasionWorldInfo dayInfo = ClientInvasionWorldInfo.getDayClientInfo(mc.f_91073_);
                ClientInvasionWorldInfo nightInfo = ClientInvasionWorldInfo.getNightClientInfo(mc.f_91073_);
                if (dayInfo.isClientTime() && !dayInfo.getRendererMap().isEmpty()) {
                    ArrayList<InvasionSkyRenderer> rendererList = dayInfo.getRendererMap().getRenderersOf(renderer -> renderer.getFogRenderer().isFogColorChanged());
                    for (InvasionSkyRenderer renderer2 : rendererList) {
                        InvasionFogRenderer fogRenderer = renderer2.getFogRenderer();
                        red += fogRenderer.getRedOffset() / (float)rendererList.size();
                        green += fogRenderer.getGreenOffset() / (float)rendererList.size();
                        blue += fogRenderer.getBlueOffset() / (float)rendererList.size();
                    }
                } else if (nightInfo.isClientTime() && !nightInfo.getRendererMap().isEmpty()) {
                    ArrayList<InvasionSkyRenderer> rendererList = nightInfo.getRendererMap().getRenderersOf(renderer -> renderer.getFogRenderer().isFogColorChanged());
                    for (InvasionSkyRenderer renderer3 : rendererList) {
                        InvasionFogRenderer fogRenderer = renderer3.getFogRenderer();
                        red += fogRenderer.getRedOffset() / (float)rendererList.size();
                        green += fogRenderer.getGreenOffset() / (float)rendererList.size();
                        blue += fogRenderer.getBlueOffset() / (float)rendererList.size();
                    }
                }
                ClientTransitionHandler.tickFogColor(eventIn, red, green, blue, mc.f_91073_.m_46468_() % 12000L);
            } else {
                float red = 0.0f;
                float green = 0.0f;
                float blue = 0.0f;
                InvasionRendererMap fixedRenderers = ClientInvasionWorldInfo.getFixedClientInfo(mc.f_91073_).getRendererMap();
                if (!fixedRenderers.isEmpty()) {
                    ArrayList<InvasionSkyRenderer> rendererList = fixedRenderers.getRenderersOf(renderer -> renderer.getFogRenderer().isFogColorChanged());
                    for (InvasionSkyRenderer renderer4 : rendererList) {
                        InvasionFogRenderer fogRenderer = renderer4.getFogRenderer();
                        red += fogRenderer.getRedOffset() / (float)rendererList.size();
                        green += fogRenderer.getGreenOffset() / (float)rendererList.size();
                        blue += fogRenderer.getBlueOffset() / (float)rendererList.size();
                    }
                }
                ClientTransitionHandler.tickFogColor(eventIn, red, green, blue, mc.f_91073_.m_46468_() % 12000L);
            }
        }

        public static final void customizeGuiOverlayDebugText(CustomizeGuiOverlayEvent.DebugText eventIn) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91066_.f_92063_) {
                eventIn.getLeft().add("");
                if (!mc.f_91073_.m_6042_().m_63967_()) {
                    ClientInvasionWorldInfo dayInfo = ClientInvasionWorldInfo.getDayClientInfo(mc.f_91073_);
                    ClientInvasionWorldInfo nightInfo = ClientInvasionWorldInfo.getNightClientInfo(mc.f_91073_);
                    if (dayInfo.isClientTime()) {
                        eventIn.getLeft().add(ChatFormatting.RED + "[PureSuffering]" + ChatFormatting.RESET + " Current Day Invasions: " + dayInfo.getInvasionsCount());
                        eventIn.getLeft().add(ChatFormatting.RED + "[PureSuffering]" + ChatFormatting.RESET + " Day Invasion XP Multiplier: " + (String)(PSConfigValues.common.useXPMultiplier ? dayInfo.getXPMultiplier() + "x" : "Disabled"));
                        eventIn.getLeft().add(ChatFormatting.RED + "[PureSuffering]" + ChatFormatting.RESET + " Night Invasion XP Multiplier: " + (String)(PSConfigValues.common.useXPMultiplier ? nightInfo.getXPMultiplier() + "x" : "Disabled"));
                        return;
                    }
                    if (nightInfo.isClientTime()) {
                        eventIn.getLeft().add(ChatFormatting.RED + "[PureSuffering]" + ChatFormatting.RESET + " Current Night Invasions: " + nightInfo.getInvasionsCount());
                        eventIn.getLeft().add(ChatFormatting.RED + "[PureSuffering]" + ChatFormatting.RESET + " Night Invasion XP Multiplier: " + (String)(PSConfigValues.common.useXPMultiplier ? nightInfo.getXPMultiplier() + "x" : "Disabled"));
                        eventIn.getLeft().add(ChatFormatting.RED + "[PureSuffering]" + ChatFormatting.RESET + " Day Invasion XP Multiplier: " + (String)(PSConfigValues.common.useXPMultiplier ? dayInfo.getXPMultiplier() + "x" : "Disabled"));
                        return;
                    }
                } else {
                    ClientInvasionWorldInfo fixedInfo = ClientInvasionWorldInfo.getFixedClientInfo(mc.f_91073_);
                    eventIn.getLeft().add(ChatFormatting.RED + "[PureSuffering]" + ChatFormatting.RESET + " Current Invasions: " + fixedInfo.getInvasionsCount());
                    eventIn.getLeft().add(ChatFormatting.RED + "[PureSuffering]" + ChatFormatting.RESET + " Invasion XP Multiplier: " + (String)(PSConfigValues.common.useXPMultiplier ? fixedInfo.getXPMultiplier() + "x" : "Disabled"));
                }
            }
        }
    }
}

