/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import dev.theagameplayer.puresuffering.client.ClientTransitionHandler;
import dev.theagameplayer.puresuffering.client.renderer.InvasionSkyRenderer;
import dev.theagameplayer.puresuffering.world.ClientInvasionWorldInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public final class InvasionSkyRenderHandler {
    private static final ResourceLocation DEFAULT_SUN = new ResourceLocation("textures/environment/sun.png");
    private static final ResourceLocation DEFAULT_MOON = new ResourceLocation("textures/environment/moon_phases.png");
    private static final ResourceLocation DEFAULT_END_SKY = new ResourceLocation("textures/environment/end_sky.png");
    private final HashMap<InvasionSkyRenderer, Boolean> rendererMap = new HashMap();
    private final ArrayList<InvasionSkyRenderer> weatherVisibilityList = new ArrayList();
    private final ArrayList<InvasionSkyRenderer> skyColorList = new ArrayList();
    private ResourceLocation sunTexture;
    private ResourceLocation moonTexture;
    private ResourceLocation skyTexture;

    public final boolean hasRenderedInvasionSky(float partialTicksIn, PoseStack poseStackIn, Matrix4f mat4In, ClientLevel levelIn, Minecraft mcIn) {
        this.rendererMap.clear();
        if (!levelIn.m_6907_().isEmpty()) {
            if (!levelIn.m_6042_().m_63967_()) {
                ClientInvasionWorldInfo dayInfo = ClientInvasionWorldInfo.getDayClientInfo(mcIn.f_91073_);
                ClientInvasionWorldInfo nightInfo = ClientInvasionWorldInfo.getNightClientInfo(mcIn.f_91073_);
                if (dayInfo.isClientTime() && !dayInfo.getRendererMap().isEmpty()) {
                    for (Map.Entry<InvasionSkyRenderer, Boolean> entry : dayInfo.getRendererMap()) {
                        this.rendererMap.put(entry.getKey(), entry.getValue());
                    }
                } else if (nightInfo.isClientTime() && !nightInfo.getRendererMap().isEmpty()) {
                    for (Map.Entry<InvasionSkyRenderer, Boolean> entry : nightInfo.getRendererMap()) {
                        this.rendererMap.put(entry.getKey(), entry.getValue());
                    }
                }
            } else {
                for (Map.Entry entry : ClientInvasionWorldInfo.getFixedClientInfo(mcIn.f_91073_).getRendererMap()) {
                    this.rendererMap.put((InvasionSkyRenderer)entry.getKey(), (Boolean)entry.getValue());
                }
            }
        }
        if (this.rendererMap.isEmpty()) {
            return false;
        }
        Camera cam = mcIn.f_91063_.m_109153_();
        boolean flag = levelIn.m_104583_().m_5781_(Mth.m_14107_((double)cam.m_90583_().m_7096_()), Mth.m_14107_((double)cam.m_90583_().m_7098_())) || mcIn.f_91065_.m_93090_().m_93715_();
        Runnable fogTick = () -> FogRenderer.m_234172_((Camera)cam, (FogRenderer.FogMode)FogRenderer.FogMode.FOG_SKY, (float)mcIn.f_91063_.m_109152_(), (boolean)flag, (float)partialTicksIn);
        ClientInvasionWorldInfo dayInfo = ClientInvasionWorldInfo.getDayClientInfo(mcIn.f_91073_);
        ClientInvasionWorldInfo nightInfo = ClientInvasionWorldInfo.getNightClientInfo(mcIn.f_91073_);
        if (levelIn.m_104583_().m_108883_() == DimensionSpecialEffects.SkyType.NORMAL) {
            this.weatherVisibilityList.clear();
            this.skyColorList.clear();
            this.sunTexture = null;
            this.moonTexture = null;
            for (Map.Entry<InvasionSkyRenderer, Boolean> entry : this.rendererMap.entrySet()) {
                InvasionSkyRenderer renderer = entry.getKey();
                if (renderer.getSunTexture() != null && entry.getValue().booleanValue() && dayInfo.isClientTime()) {
                    this.sunTexture = renderer.getSunTexture();
                }
                if (renderer.getMoonTexture() != null && entry.getValue().booleanValue() && nightInfo.isClientTime()) {
                    this.moonTexture = renderer.getMoonTexture();
                }
                if (renderer.isWeatherVisibilityChanged()) {
                    this.weatherVisibilityList.add(renderer);
                }
                if (!renderer.isSkyColorChanged()) continue;
                this.skyColorList.add(renderer);
            }
            this.renderInvasionSky(poseStackIn, mat4In, mcIn, levelIn, fogTick, partialTicksIn, levelIn.m_46468_() % 12000L);
            return true;
        }
        if (levelIn.m_104583_().m_108883_() == DimensionSpecialEffects.SkyType.END) {
            for (Map.Entry<InvasionSkyRenderer, Boolean> entry : this.rendererMap.entrySet()) {
                InvasionSkyRenderer renderer = entry.getKey();
                if (renderer.getFixedSkyTexture() == null || !entry.getValue().booleanValue()) continue;
                this.skyTexture = renderer.getFixedSkyTexture();
            }
            this.renderEndInvasionSkybox(poseStackIn, levelIn, partialTicksIn);
            return true;
        }
        return false;
    }

    private final void renderInvasionSky(PoseStack poseStackIn, Matrix4f mat4In, Minecraft mcIn, ClientLevel levelIn, Runnable fogTickIn, float partialTicksIn, long dayTimeIn) {
        ClientInvasionWorldInfo dayInfo = ClientInvasionWorldInfo.getDayClientInfo(levelIn);
        ClientInvasionWorldInfo nightInfo = ClientInvasionWorldInfo.getNightClientInfo(levelIn);
        Vec3 vec3 = levelIn.m_171660_(mcIn.f_91063_.m_109153_().m_90583_(), partialTicksIn);
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        for (InvasionSkyRenderer renderer : this.skyColorList) {
            r += renderer.getRedOffset() / (float)this.skyColorList.size();
            g += renderer.getGreenOffset() / (float)this.skyColorList.size();
            b += renderer.getBlueOffset() / (float)this.skyColorList.size();
        }
        float f = ClientTransitionHandler.tickSkyColor((float)vec3.f_82479_, r, dayTimeIn);
        float f1 = ClientTransitionHandler.tickSkyColor((float)vec3.f_82480_, g, dayTimeIn);
        float f2 = ClientTransitionHandler.tickSkyColor((float)vec3.f_82481_, b, dayTimeIn);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.m_69472_();
        FogRenderer.m_109036_();
        RenderSystem.m_69458_((boolean)false);
        RenderSystem.m_157429_((float)f, (float)f1, (float)f2, (float)1.0f);
        ShaderInstance shaderInstance = RenderSystem.m_157196_();
        mcIn.f_91060_.f_109472_.m_85921_();
        mcIn.f_91060_.f_109472_.m_253207_(poseStackIn.m_85850_().m_252922_(), mat4In, shaderInstance);
        VertexBuffer.m_85931_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        float[] afloat = levelIn.m_104583_().m_7518_(levelIn.m_46942_(partialTicksIn), partialTicksIn);
        if (afloat != null) {
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            RenderSystem.m_69472_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            poseStackIn.m_85836_();
            poseStackIn.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            float f3 = Mth.m_14031_((float)levelIn.m_46490_(partialTicksIn)) < 0.0f ? 180.0f : 0.0f;
            poseStackIn.m_252781_(Axis.f_252403_.m_252977_(f3));
            poseStackIn.m_252781_(Axis.f_252403_.m_252977_(90.0f));
            float f4 = afloat[0];
            float f5 = afloat[1];
            float f6 = afloat[2];
            Matrix4f matrix4f = poseStackIn.m_85850_().m_252922_();
            bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
            bufferBuilder.m_252986_(matrix4f, 0.0f, 100.0f, 0.0f).m_85950_(f4, f5, f6, afloat[3] / (float)this.rendererMap.size()).m_5752_();
            for (int j = 0; j <= 16; ++j) {
                float f7 = (float)j * ((float)Math.PI * 2) / 16.0f;
                float f8 = Mth.m_14031_((float)f7);
                float f9 = Mth.m_14089_((float)f7);
                bufferBuilder.m_252986_(matrix4f, f8 * 120.0f, f9 * 120.0f, -f9 * 40.0f * afloat[3]).m_85950_(afloat[0], afloat[1], afloat[2], 0.0f).m_5752_();
            }
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
            poseStackIn.m_85849_();
        }
        RenderSystem.m_69493_();
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        poseStackIn.m_85836_();
        float f11 = Mth.m_14036_((float)((this.sunTexture == null && dayInfo.isClientTime() || this.moonTexture == null && nightInfo.isClientTime() ? 1.0f : ClientTransitionHandler.tickSunMoonAlpha(1.0f, dayTimeIn)) - levelIn.m_46722_(partialTicksIn)), (float)0.0f, (float)1.0f);
        float f12 = 0.0f;
        for (InvasionSkyRenderer renderer : this.weatherVisibilityList) {
            f12 += renderer.getWeatherVisibility() / (float)this.weatherVisibilityList.size();
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)(f11 + Mth.m_14036_((float)ClientTransitionHandler.tickWeatherVisibility(f12, dayTimeIn), (float)0.0f, (float)1.0f)));
        poseStackIn.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
        poseStackIn.m_252781_(Axis.f_252529_.m_252977_(levelIn.m_46942_(partialTicksIn) * 360.0f));
        Matrix4f matrix4f1 = poseStackIn.m_85850_().m_252922_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        this.renderSun(bufferBuilder, matrix4f1, 30.0f, dayTimeIn);
        this.renderMoon(bufferBuilder, matrix4f1, levelIn, 20.0f, dayTimeIn);
        RenderSystem.m_69472_();
        float f10 = levelIn.m_104811_(partialTicksIn) * f11;
        if (f10 > 0.0f) {
            RenderSystem.m_157429_((float)f10, (float)f10, (float)f10, (float)(f10 / (float)this.rendererMap.size()));
            FogRenderer.m_109017_();
            mcIn.f_91060_.f_109471_.m_85921_();
            mcIn.f_91060_.f_109471_.m_253207_(poseStackIn.m_85850_().m_252922_(), mat4In, GameRenderer.m_172808_());
            VertexBuffer.m_85931_();
            fogTickIn.run();
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69461_();
        poseStackIn.m_85849_();
        RenderSystem.m_69472_();
        RenderSystem.m_157429_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        double d0 = mcIn.f_91074_.m_20299_((float)partialTicksIn).f_82480_ - levelIn.m_6106_().m_171687_((LevelHeightAccessor)levelIn);
        if (d0 < 0.0) {
            poseStackIn.m_85836_();
            poseStackIn.m_85837_(0.0, 12.0, 0.0);
            mcIn.f_91060_.f_109473_.m_85921_();
            mcIn.f_91060_.f_109473_.m_253207_(poseStackIn.m_85850_().m_252922_(), mat4In, shaderInstance);
            VertexBuffer.m_85931_();
            poseStackIn.m_85849_();
        }
        if (levelIn.m_104583_().m_108882_()) {
            RenderSystem.m_157429_((float)(f * 0.2f + 0.04f), (float)(f1 * 0.2f + 0.04f), (float)(f2 * 0.6f + 0.1f), (float)1.0f);
        } else {
            RenderSystem.m_157429_((float)f, (float)f1, (float)f2, (float)1.0f);
        }
        RenderSystem.m_69493_();
        RenderSystem.m_69458_((boolean)true);
    }

    private final void renderSun(BufferBuilder bufferBuilderIn, Matrix4f matrix4fIn, float f13In, long dayTimeIn) {
        boolean flag = dayTimeIn < 300L || dayTimeIn > 11699L;
        RenderSystem.m_157456_((int)0, (ResourceLocation)(this.sunTexture == null || flag ? DEFAULT_SUN : this.sunTexture));
        bufferBuilderIn.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilderIn.m_252986_(matrix4fIn, -f13In, 100.0f, -f13In).m_7421_(0.0f, 0.0f).m_5752_();
        bufferBuilderIn.m_252986_(matrix4fIn, f13In, 100.0f, -f13In).m_7421_(1.0f, 0.0f).m_5752_();
        bufferBuilderIn.m_252986_(matrix4fIn, f13In, 100.0f, f13In).m_7421_(1.0f, 1.0f).m_5752_();
        bufferBuilderIn.m_252986_(matrix4fIn, -f13In, 100.0f, f13In).m_7421_(0.0f, 1.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilderIn.m_231175_());
    }

    private final void renderMoon(BufferBuilder bufferBuilderIn, Matrix4f matrix4fIn, ClientLevel levelIn, float f13In, long dayTimeIn) {
        boolean flag = dayTimeIn < 300L || dayTimeIn > 11699L;
        RenderSystem.m_157456_((int)0, (ResourceLocation)(this.moonTexture == null || flag ? DEFAULT_MOON : this.moonTexture));
        int k = levelIn.m_46941_();
        int l = k % 4;
        int i1 = k / 4 % 2;
        float f14 = (float)(l + 0) / 4.0f;
        float f15 = (float)(i1 + 0) / 2.0f;
        float f16 = (float)(l + 1) / 4.0f;
        float f17 = (float)(i1 + 1) / 2.0f;
        bufferBuilderIn.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilderIn.m_252986_(matrix4fIn, -f13In, -100.0f, f13In).m_7421_(f16, f17).m_5752_();
        bufferBuilderIn.m_252986_(matrix4fIn, f13In, -100.0f, f13In).m_7421_(f14, f17).m_5752_();
        bufferBuilderIn.m_252986_(matrix4fIn, f13In, -100.0f, -f13In).m_7421_(f14, f15).m_5752_();
        bufferBuilderIn.m_252986_(matrix4fIn, -f13In, -100.0f, -f13In).m_7421_(f16, f15).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilderIn.m_231175_());
    }

    private final void renderEndInvasionSkybox(PoseStack matrixStackIn, ClientLevel levelIn, float partialTicksIn) {
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69458_((boolean)false);
        RenderSystem.m_157427_(GameRenderer::m_172820_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)(this.skyTexture == null ? DEFAULT_END_SKY : this.skyTexture));
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        for (int i = 0; i < 6; ++i) {
            matrixStackIn.m_85836_();
            if (i == 1) {
                matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            } else if (i == 2) {
                matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
            } else if (i == 3) {
                matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(180.0f));
            } else if (i == 4) {
                matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(90.0f));
            } else if (i == 5) {
                matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(-90.0f));
            }
            Matrix4f matrix4f = matrixStackIn.m_85850_().m_252922_();
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
            bufferBuilder.m_252986_(matrix4f, -100.0f, -100.0f, -100.0f).m_7421_(0.0f, 0.0f).m_6122_(40, 40, 40, 255).m_5752_();
            bufferBuilder.m_252986_(matrix4f, -100.0f, -100.0f, 100.0f).m_7421_(0.0f, 16.0f).m_6122_(40, 40, 40, 255).m_5752_();
            bufferBuilder.m_252986_(matrix4f, 100.0f, -100.0f, 100.0f).m_7421_(16.0f, 16.0f).m_6122_(40, 40, 40, 255).m_5752_();
            bufferBuilder.m_252986_(matrix4f, 100.0f, -100.0f, -100.0f).m_7421_(16.0f, 0.0f).m_6122_(40, 40, 40, 255).m_5752_();
            tessellator.m_85914_();
            matrixStackIn.m_85849_();
        }
        RenderSystem.m_69458_((boolean)true);
        RenderSystem.m_69493_();
        RenderSystem.m_69461_();
    }
}

