/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.client.renderer;

import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public final class InvasionFogRenderer {
    private final ResourceLocation id;
    private final boolean fogColorChanged;
    private final float red;
    private final float green;
    private final float blue;

    public InvasionFogRenderer(ResourceLocation idIn, boolean fogColorChangedIn, float redIn, float greenIn, float blueIn) {
        this.fogColorChanged = fogColorChangedIn;
        this.id = idIn;
        this.red = redIn;
        this.green = greenIn;
        this.blue = blueIn;
    }

    public final Builder deconstruct() {
        return new Builder(this.fogColorChanged, this.red, this.green, this.blue);
    }

    public final ResourceLocation getId() {
        return this.id;
    }

    public final boolean isFogColorChanged() {
        return this.fogColorChanged;
    }

    public final float getRedOffset() {
        return this.red;
    }

    public final float getGreenOffset() {
        return this.green;
    }

    public final float getBlueOffset() {
        return this.blue;
    }

    public static final class Builder {
        private boolean fogColorChanged;
        private float red;
        private float green;
        private float blue;

        private Builder(boolean fogColorChangedIn, float redIn, float greenIn, float blueIn) {
            this.fogColorChanged = fogColorChangedIn;
            this.red = redIn;
            this.green = greenIn;
            this.blue = blueIn;
        }

        private Builder() {
        }

        public static final Builder fogRenderer() {
            return new Builder();
        }

        public final Builder withRGB(float redIn, float greenIn, float blueIn) {
            this.red = redIn;
            this.green = greenIn;
            this.blue = blueIn;
            this.fogColorChanged = true;
            return this;
        }

        public final InvasionFogRenderer build(ResourceLocation idIn) {
            return new InvasionFogRenderer(idIn, this.fogColorChanged, this.red, this.green, this.blue);
        }

        public final JsonObject serializeToJson() {
            JsonObject jsonObject = new JsonObject();
            if (this.fogColorChanged) {
                jsonObject.addProperty("RedOffset", (Number)Float.valueOf(this.red));
                jsonObject.addProperty("GreenOffset", (Number)Float.valueOf(this.green));
                jsonObject.addProperty("BlueOffset", (Number)Float.valueOf(this.blue));
            }
            return jsonObject.entrySet().isEmpty() ? null : jsonObject;
        }

        public static final Builder fromJson(JsonObject jsonObjectIn) {
            boolean fogColorChanged = jsonObjectIn.has("RedOffset") && jsonObjectIn.has("GreenOffset") && jsonObjectIn.has("BlueOffset");
            float red = fogColorChanged ? jsonObjectIn.get("RedOffset").getAsFloat() : 0.0f;
            float green = fogColorChanged ? jsonObjectIn.get("GreenOffset").getAsFloat() : 0.0f;
            float blue = fogColorChanged ? jsonObjectIn.get("BlueOffset").getAsFloat() : 0.0f;
            return new Builder(fogColorChanged, red, green, blue);
        }

        public final void serializeToNetwork(FriendlyByteBuf bufIn) {
            bufIn.writeBoolean(this.fogColorChanged);
            bufIn.writeFloat(this.red);
            bufIn.writeFloat(this.green);
            bufIn.writeFloat(this.blue);
        }

        public static final Builder fromNetwork(FriendlyByteBuf bufIn) {
            boolean fogColorChanged = bufIn.readBoolean();
            float red = bufIn.readFloat();
            float green = bufIn.readFloat();
            float blue = bufIn.readFloat();
            return new Builder(fogColorChanged, red, green, blue);
        }
    }
}

