/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.client.renderer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.theagameplayer.puresuffering.client.renderer.InvasionFogRenderer;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public final class InvasionSkyRenderer {
    private final ResourceLocation id;
    private final InvasionFogRenderer fogRenderer;
    private final ResourceLocation sun;
    private final ResourceLocation moon;
    private final ResourceLocation fixedSky;
    private final boolean weatherVisibilityChanged;
    private final boolean brightnessChanged;
    private final boolean skyColorChanged;
    private final float weatherVisibility;
    private final float brightness;
    private final float red;
    private final float green;
    private final float blue;

    public InvasionSkyRenderer(ResourceLocation idIn, InvasionFogRenderer fogRendererIn, ResourceLocation sunIn, ResourceLocation moonIn, ResourceLocation fixedSkyIn, boolean weatherVisibilityChangedIn, boolean brightnessChangedIn, boolean skyColorChangedIn, float weatherVisibilityIn, float brightnessIn, float redIn, float greenIn, float blueIn) {
        this.fogRenderer = fogRendererIn;
        this.id = idIn;
        this.sun = sunIn;
        this.moon = moonIn;
        this.fixedSky = fixedSkyIn;
        this.weatherVisibilityChanged = weatherVisibilityChangedIn;
        this.brightnessChanged = brightnessChangedIn;
        this.skyColorChanged = skyColorChangedIn;
        this.weatherVisibility = weatherVisibilityIn;
        this.brightness = brightnessIn;
        this.red = redIn;
        this.green = greenIn;
        this.blue = blueIn;
    }

    public final Builder deconstruct() {
        return new Builder(this.fogRenderer.deconstruct(), this.sun, this.moon, this.fixedSky, this.weatherVisibilityChanged, this.brightnessChanged, this.skyColorChanged, this.weatherVisibility, this.brightness, this.red, this.green, this.blue);
    }

    public final ResourceLocation getId() {
        return this.id;
    }

    public final InvasionFogRenderer getFogRenderer() {
        return this.fogRenderer;
    }

    public final ResourceLocation getSunTexture() {
        return this.sun;
    }

    public final ResourceLocation getMoonTexture() {
        return this.moon;
    }

    public final ResourceLocation getFixedSkyTexture() {
        return this.fixedSky;
    }

    public final boolean isWeatherVisibilityChanged() {
        return this.weatherVisibilityChanged;
    }

    public final boolean isBrightnessChanged() {
        return this.brightnessChanged;
    }

    public final boolean isSkyColorChanged() {
        return this.skyColorChanged;
    }

    public final float getWeatherVisibility() {
        return this.weatherVisibility;
    }

    public final float getBrightness() {
        return this.brightness;
    }

    public final float getRedOffset() {
        return this.red;
    }

    public final float getGreenOffset() {
        return this.green;
    }

    public final float getBlueOffset() {
        return this.blue;
    }

    public final String toString() {
        return this.getId().toString();
    }

    public static final class Builder {
        private InvasionFogRenderer.Builder fogRenderer = InvasionFogRenderer.Builder.fogRenderer();
        private ResourceLocation sun;
        private ResourceLocation moon;
        private ResourceLocation fixedSky;
        private boolean weatherVisibilityChanged;
        private boolean brightnessChanged;
        private boolean skyColorChanged;
        private float weatherVisibility;
        private float brightness;
        private float red;
        private float green;
        private float blue;

        private Builder(InvasionFogRenderer.Builder fogRendererIn, @Nullable ResourceLocation sunIn, @Nullable ResourceLocation moonIn, @Nullable ResourceLocation fixedSkyIn, boolean weatherVisibilityChangedIn, boolean brightnessChangedIn, boolean skyColorChangedIn, float weatherVisibilityIn, float brightnessIn, float redIn, float greenIn, float blueIn) {
            this.fogRenderer = fogRendererIn;
            this.sun = sunIn;
            this.moon = moonIn;
            this.fixedSky = fixedSkyIn;
            this.weatherVisibilityChanged = weatherVisibilityChangedIn;
            this.brightnessChanged = brightnessChangedIn;
            this.skyColorChanged = skyColorChangedIn;
            this.weatherVisibility = weatherVisibilityIn;
            this.brightness = brightnessIn;
            this.red = redIn;
            this.green = greenIn;
            this.blue = blueIn;
        }

        private Builder() {
        }

        public static final Builder skyRenderer() {
            return new Builder();
        }

        public final Builder withFog(InvasionFogRenderer.Builder fogRendererIn) {
            this.fogRenderer = fogRendererIn;
            return this;
        }

        public final Builder sunTexture(ResourceLocation sunTextureIn) {
            this.sun = sunTextureIn;
            return this;
        }

        public final Builder moonTexture(ResourceLocation moonTextureIn) {
            this.moon = moonTextureIn;
            return this;
        }

        public final Builder fixedSkyTexture(ResourceLocation fixedTextureIn) {
            this.fixedSky = fixedTextureIn;
            return this;
        }

        public final Builder weatherVisibility(float weatherVisibilityIn) {
            this.weatherVisibility = weatherVisibilityIn;
            this.weatherVisibilityChanged = true;
            return this;
        }

        public final Builder withSkyBrightness(float brightnessIn) {
            this.brightness = brightnessIn;
            this.brightnessChanged = true;
            return this;
        }

        public final Builder withRGB(float redIn, float greenIn, float blueIn) {
            this.red = redIn;
            this.green = greenIn;
            this.blue = blueIn;
            this.skyColorChanged = true;
            return this;
        }

        public final InvasionSkyRenderer build(ResourceLocation idIn) {
            return new InvasionSkyRenderer(idIn, this.fogRenderer.build(idIn), this.sun, this.moon, this.fixedSky, this.weatherVisibilityChanged, this.brightnessChanged, this.skyColorChanged, this.weatherVisibility, this.brightness, this.red, this.green, this.blue);
        }

        public final JsonObject serializeToJson() {
            JsonObject jsonObject = new JsonObject();
            JsonObject fogRendererObject = this.fogRenderer.serializeToJson();
            if (fogRendererObject != null) {
                jsonObject.add("FogRenderer", (JsonElement)fogRendererObject);
            }
            if (this.sun != null) {
                jsonObject.addProperty("SunTexture", this.sun.toString());
            }
            if (this.moon != null) {
                jsonObject.addProperty("MoonTexture", this.moon.toString());
            }
            if (this.fixedSky != null) {
                jsonObject.addProperty("FixedSkyTexture", this.fixedSky.toString());
            }
            if ((this.sun != null || this.moon != null || this.fixedSky != null) && this.weatherVisibilityChanged) {
                jsonObject.addProperty("WeatherVisibility", (Number)Float.valueOf(this.weatherVisibility));
            }
            if (this.brightnessChanged) {
                jsonObject.addProperty("Brightness", (Number)Float.valueOf(this.brightness));
            }
            if (this.skyColorChanged) {
                jsonObject.addProperty("RedOffset", (Number)Float.valueOf(this.red));
                jsonObject.addProperty("GreenOffset", (Number)Float.valueOf(this.green));
                jsonObject.addProperty("BlueOffset", (Number)Float.valueOf(this.blue));
            }
            return jsonObject.entrySet().isEmpty() ? null : jsonObject;
        }

        public static final Builder fromJson(JsonObject jsonObjectIn) {
            InvasionFogRenderer.Builder fogRenderer = jsonObjectIn.has("FogRenderer") ? InvasionFogRenderer.Builder.fromJson(jsonObjectIn.get("FogRenderer").getAsJsonObject()) : InvasionFogRenderer.Builder.fogRenderer();
            ResourceLocation sun = jsonObjectIn.has("SunTexture") ? ResourceLocation.m_135820_((String)jsonObjectIn.get("SunTexture").getAsString()) : null;
            ResourceLocation moon = jsonObjectIn.has("MoonTexture") ? ResourceLocation.m_135820_((String)jsonObjectIn.get("MoonTexture").getAsString()) : null;
            ResourceLocation fixedSky = jsonObjectIn.has("FixedSkyTexture") ? ResourceLocation.m_135820_((String)jsonObjectIn.get("FixedSkyTexture").getAsString()) : null;
            boolean weatherVisibilityChanged = jsonObjectIn.has("WeatherVisibility");
            boolean brightnessChanged = jsonObjectIn.has("Brightness");
            boolean skyColorChanged = jsonObjectIn.has("RedOffset") && jsonObjectIn.has("GreenOffset") && jsonObjectIn.has("BlueOffset");
            float weatherVisibility = weatherVisibilityChanged ? jsonObjectIn.get("WeatherVisibility").getAsFloat() : 0.0f;
            float brightness = brightnessChanged ? 1.0f - jsonObjectIn.get("Brightness").getAsFloat() : 1.0f;
            float red = skyColorChanged ? jsonObjectIn.get("RedOffset").getAsFloat() : 0.0f;
            float green = skyColorChanged ? jsonObjectIn.get("GreenOffset").getAsFloat() : 0.0f;
            float blue = skyColorChanged ? jsonObjectIn.get("BlueOffset").getAsFloat() : 0.0f;
            return new Builder(fogRenderer, sun, moon, fixedSky, weatherVisibilityChanged, brightnessChanged, skyColorChanged, weatherVisibility, brightness, red, green, blue);
        }

        public final void serializeToNetwork(FriendlyByteBuf bufIn) {
            this.fogRenderer.serializeToNetwork(bufIn);
            bufIn.writeBoolean(this.sun != null);
            if (this.sun != null) {
                bufIn.m_130085_(this.sun);
            }
            bufIn.writeBoolean(this.moon != null);
            if (this.moon != null) {
                bufIn.m_130085_(this.moon);
            }
            bufIn.writeBoolean(this.fixedSky != null);
            if (this.fixedSky != null) {
                bufIn.m_130085_(this.fixedSky);
            }
            bufIn.writeBoolean(this.weatherVisibilityChanged);
            bufIn.writeBoolean(this.brightnessChanged);
            bufIn.writeBoolean(this.skyColorChanged);
            bufIn.writeFloat(this.weatherVisibility);
            bufIn.writeFloat(this.brightness);
            bufIn.writeFloat(this.red);
            bufIn.writeFloat(this.green);
            bufIn.writeFloat(this.blue);
        }

        public static final Builder fromNetwork(FriendlyByteBuf bufIn) {
            InvasionFogRenderer.Builder fogRenderer = InvasionFogRenderer.Builder.fromNetwork(bufIn);
            ResourceLocation sun = null;
            ResourceLocation moon = null;
            ResourceLocation fixedSky = null;
            if (bufIn.readBoolean()) {
                sun = bufIn.m_130281_();
            }
            if (bufIn.readBoolean()) {
                moon = bufIn.m_130281_();
            }
            if (bufIn.readBoolean()) {
                fixedSky = bufIn.m_130281_();
            }
            boolean weatherVisibilityChanged = bufIn.readBoolean();
            boolean brightnessChanged = bufIn.readBoolean();
            boolean skyColorChanged = bufIn.readBoolean();
            float weatherVisibility = bufIn.readFloat();
            float brightness = bufIn.readFloat();
            float red = bufIn.readFloat();
            float green = bufIn.readFloat();
            float blue = bufIn.readFloat();
            return new Builder(fogRenderer, sun, moon, fixedSky, weatherVisibilityChanged, brightnessChanged, skyColorChanged, weatherVisibility, brightness, red, green, blue);
        }
    }
}

