/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.theagameplayer.puresuffering.world.entity.PSHyperCharge;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public final class HyperChargeLayer<LE extends LivingEntity, EM extends EntityModel<LE>>
extends RenderLayer<LE, EM> {
    private static final ResourceLocation HYPER_CHARGE_LOCATION = new ResourceLocation("puresuffering", "textures/entity/charged_armor.png");
    private static final ResourceLocation HYPER_CHARGE_LOCATION2 = new ResourceLocation("puresuffering", "textures/entity/charged_armor2.png");
    private final EM model;
    private final int maxHyperCharge;

    public HyperChargeLayer(LivingEntityRenderer<LE, EM> rendererIn, int maxHyperChargeIn) {
        super(rendererIn);
        this.model = rendererIn.m_7200_();
        this.maxHyperCharge = maxHyperChargeIn;
    }

    public final void render(PoseStack poseStackIn, MultiBufferSource bufferIn, int packedLightIn, LE entityIn, float limbSwingIn, float limbSwingAmountIn, float partialTicksIn, float ageInTicksIn, float netHeadYawIn, float headPitchIn) {
        if (entityIn instanceof PSHyperCharge && ((PSHyperCharge)entityIn).psGetHyperCharge() > 0) {
            int hyperCharge = ((PSHyperCharge)entityIn).psGetHyperCharge();
            float tick = (float)((LivingEntity)entityIn).f_19797_ + partialTicksIn;
            EM entityModel = this.model;
            entityModel.m_6839_(entityIn, limbSwingIn, limbSwingAmountIn, partialTicksIn);
            this.m_117386_().m_102624_(entityModel);
            VertexConsumer vertexConsumer = bufferIn.m_6299_(RenderType.m_110436_((ResourceLocation)(hyperCharge == this.maxHyperCharge ? HYPER_CHARGE_LOCATION2 : HYPER_CHARGE_LOCATION), (float)(tick * (0.01f * (float)hyperCharge) % 1.0f), (float)(tick * (0.01f * (float)hyperCharge) % 1.0f)));
            entityModel.m_6973_(entityIn, limbSwingIn, limbSwingAmountIn, ageInTicksIn, netHeadYawIn, headPitchIn);
            entityModel.m_7695_(poseStackIn, vertexConsumer, packedLightIn, OverlayTexture.f_118083_, 0.2f * (float)hyperCharge, 0.2f * (float)hyperCharge, 0.2f * (float)hyperCharge, 0.2f * (float)hyperCharge);
        }
    }
}

