/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.command;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.theagameplayer.puresuffering.PSEventManager;
import dev.theagameplayer.puresuffering.invasion.HyperType;
import dev.theagameplayer.puresuffering.invasion.Invasion;
import dev.theagameplayer.puresuffering.invasion.InvasionType;
import dev.theagameplayer.puresuffering.world.FixedInvasionWorldData;
import dev.theagameplayer.puresuffering.world.InvasionWorldData;
import dev.theagameplayer.puresuffering.world.TimedInvasionWorldData;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;

public final class AddInvasionsCommand {
    private static final DynamicCommandExceptionType ERROR_UNKNOWN_INVASION_TYPE = new DynamicCommandExceptionType(resourceLocation -> Component.m_237110_((String)"commands.puresuffering.invasion_type.invasionTypeNotFound", (Object[])new Object[]{resourceLocation}));
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_PRIMARY_DAY_INVASION_TYPES = (ctx, suggestionsBuilder) -> {
        Collection<InvasionType> collection = PSEventManager.BaseEvents.getInvasionTypeManager().getAllInvasionTypes();
        InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
        return SharedSuggestionProvider.m_82957_(collection.stream().filter(it -> !iwData.hasFixedTime() && it.getDimensions().contains(((CommandSourceStack)ctx.getSource()).m_81372_().m_46472_().m_135782_()) && it.getInvasionPriority() != InvasionType.InvasionPriority.SECONDARY_ONLY && it.getInvasionTime() != InvasionType.InvasionTime.NIGHT && it.getTimeChangeability() != InvasionType.TimeChangeability.ONLY_NIGHT).map(InvasionType::getId), (SuggestionsBuilder)suggestionsBuilder);
    };
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_SECONDARY_DAY_INVASION_TYPES = (ctx, suggestionsBuilder) -> {
        Collection<InvasionType> collection = PSEventManager.BaseEvents.getInvasionTypeManager().getAllInvasionTypes();
        InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
        return SharedSuggestionProvider.m_82957_(collection.stream().filter(it -> !iwData.hasFixedTime() && it.getDimensions().contains(((CommandSourceStack)ctx.getSource()).m_81372_().m_46472_().m_135782_()) && it.getInvasionPriority() != InvasionType.InvasionPriority.PRIMARY_ONLY && (AddInvasionsCommand.containsDayChangingInvasion(((TimedInvasionWorldData)iwData).getInvasionSpawner().getQueuedDayInvasions()) ? it.getInvasionTime() != InvasionType.InvasionTime.DAY && it.getTimeChangeability() != InvasionType.TimeChangeability.ONLY_DAY : it.getInvasionTime() != InvasionType.InvasionTime.NIGHT && it.getTimeChangeability() != InvasionType.TimeChangeability.ONLY_NIGHT)).map(InvasionType::getId), (SuggestionsBuilder)suggestionsBuilder);
    };
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_PRIMARY_NIGHT_INVASION_TYPES = (ctx, suggestionsBuilder) -> {
        Collection<InvasionType> collection = PSEventManager.BaseEvents.getInvasionTypeManager().getAllInvasionTypes();
        InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
        return SharedSuggestionProvider.m_82957_(collection.stream().filter(it -> !iwData.hasFixedTime() && it.getDimensions().contains(((CommandSourceStack)ctx.getSource()).m_81372_().m_46472_().m_135782_()) && it.getInvasionPriority() != InvasionType.InvasionPriority.SECONDARY_ONLY && it.getInvasionTime() != InvasionType.InvasionTime.DAY && it.getTimeChangeability() != InvasionType.TimeChangeability.ONLY_DAY).map(InvasionType::getId), (SuggestionsBuilder)suggestionsBuilder);
    };
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_SECONDARY_NIGHT_INVASION_TYPES = (ctx, suggestionsBuilder) -> {
        Collection<InvasionType> collection = PSEventManager.BaseEvents.getInvasionTypeManager().getAllInvasionTypes();
        InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
        return SharedSuggestionProvider.m_82957_(collection.stream().filter(it -> !iwData.hasFixedTime() && it.getDimensions().contains(((CommandSourceStack)ctx.getSource()).m_81372_().m_46472_().m_135782_()) && it.getInvasionPriority() != InvasionType.InvasionPriority.PRIMARY_ONLY && (AddInvasionsCommand.containsNightChangingInvasion(((TimedInvasionWorldData)iwData).getInvasionSpawner().getQueuedNightInvasions()) ? it.getInvasionTime() != InvasionType.InvasionTime.NIGHT && it.getTimeChangeability() != InvasionType.TimeChangeability.ONLY_NIGHT : it.getInvasionTime() != InvasionType.InvasionTime.DAY && it.getTimeChangeability() != InvasionType.TimeChangeability.ONLY_DAY)).map(InvasionType::getId), (SuggestionsBuilder)suggestionsBuilder);
    };
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_PRIMARY_FIXED_INVASION_TYPES = (ctx, suggestionsBuilder) -> {
        Collection<InvasionType> collection = PSEventManager.BaseEvents.getInvasionTypeManager().getAllInvasionTypes();
        InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
        return SharedSuggestionProvider.m_82957_(collection.stream().filter(it -> iwData.hasFixedTime() && it.getDimensions().contains(((CommandSourceStack)ctx.getSource()).m_81372_().m_46472_().m_135782_()) && it.getInvasionPriority() != InvasionType.InvasionPriority.SECONDARY_ONLY).map(InvasionType::getId), (SuggestionsBuilder)suggestionsBuilder);
    };
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_SECONDARY_FIXED_INVASION_TYPES = (ctx, suggestionsBuilder) -> {
        Collection<InvasionType> collection = PSEventManager.BaseEvents.getInvasionTypeManager().getAllInvasionTypes();
        InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
        return SharedSuggestionProvider.m_82957_(collection.stream().filter(it -> iwData.hasFixedTime() && it.getDimensions().contains(((CommandSourceStack)ctx.getSource()).m_81372_().m_46472_().m_135782_()) && it.getInvasionPriority() != InvasionType.InvasionPriority.PRIMARY_ONLY).map(InvasionType::getId), (SuggestionsBuilder)suggestionsBuilder);
    };

    public static final ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"add").requires(player -> player.m_6761_(2))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"day").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"primary").then(Commands.m_82127_((String)"random").executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (!iwData.hasFixedTime()) {
                TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getRandomInvasion((CommandContext<CommandSourceStack>)ctx, iwData, false, true, true);
                tiwData.getInvasionSpawner().getQueuedDayInvasions().removeIf(i -> i.isPrimary());
                tiwData.getInvasionSpawner().getQueuedDayInvasions().add(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)(invasion.getHyperType() != HyperType.DEFAULT ? (invasion.getHyperType() == HyperType.MYSTERY ? "commands.puresuffering.add.success.day.primary.mystery" : "commands.puresuffering.add.success.day.primary.hyper") : "commands.puresuffering.add.success.day.primary")).m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.nonfixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        }))).then(Commands.m_82127_((String)"hyper").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"invasionType", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_PRIMARY_DAY_INVASION_TYPES).then(Commands.m_82129_((String)"severity", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (!iwData.hasFixedTime()) {
                TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSourceStack>)ctx, "invasionType", "severity", true, HyperType.HYPER);
                tiwData.getInvasionSpawner().getQueuedDayInvasions().removeIf(i -> i.isPrimary());
                tiwData.getInvasionSpawner().getQueuedDayInvasions().add(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.add.success.day.primary.hyper").m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.nonfixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        }))).then(Commands.m_82127_((String)"random").executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (!iwData.hasFixedTime()) {
                TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSourceStack>)ctx, "invasionType", null, true, HyperType.HYPER);
                tiwData.getInvasionSpawner().getQueuedDayInvasions().removeIf(i -> i.isPrimary());
                tiwData.getInvasionSpawner().getQueuedDayInvasions().add(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.add.success.day.primary.hyper").m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.nonfixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        }))))).then(Commands.m_82127_((String)"mystery").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"invasionType", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_PRIMARY_DAY_INVASION_TYPES).then(Commands.m_82129_((String)"severity", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (!iwData.hasFixedTime()) {
                TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSourceStack>)ctx, "invasionType", "severity", true, HyperType.MYSTERY);
                tiwData.getInvasionSpawner().getQueuedDayInvasions().removeIf(i -> i.isPrimary());
                tiwData.getInvasionSpawner().getQueuedDayInvasions().add(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.add.success.day.primary.mystery").m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.nonfixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        }))).then(Commands.m_82127_((String)"random").executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (!iwData.hasFixedTime()) {
                TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSourceStack>)ctx, "invasionType", null, true, HyperType.MYSTERY);
                tiwData.getInvasionSpawner().getQueuedDayInvasions().removeIf(i -> i.isPrimary());
                tiwData.getInvasionSpawner().getQueuedDayInvasions().add(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.add.success.day.primary.mystery").m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.nonfixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        }))))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"invasionType", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_PRIMARY_DAY_INVASION_TYPES).then(Commands.m_82129_((String)"severity", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (!iwData.hasFixedTime()) {
                TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSourceStack>)ctx, "invasionType", "severity", true, HyperType.DEFAULT);
                tiwData.getInvasionSpawner().getQueuedDayInvasions().removeIf(i -> i.isPrimary());
                tiwData.getInvasionSpawner().getQueuedDayInvasions().add(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.add.success.day.primary").m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.nonfixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        }))).then(Commands.m_82127_((String)"random").executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (!iwData.hasFixedTime()) {
                TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSourceStack>)ctx, "invasionType", null, true, HyperType.DEFAULT);
                tiwData.getInvasionSpawner().getQueuedDayInvasions().removeIf(i -> i.isPrimary());
                tiwData.getInvasionSpawner().getQueuedDayInvasions().add(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.add.success.day.primary").m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.nonfixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        }))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"secondary").then(Commands.m_82127_((String)"random").executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (!iwData.hasFixedTime()) {
                TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getRandomInvasion((CommandContext<CommandSourceStack>)ctx, iwData, false, true, false);
                tiwData.getInvasionSpawner().getQueuedDayInvasions().add(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)(invasion.getHyperType() != HyperType.DEFAULT ? (invasion.getHyperType() == HyperType.MYSTERY ? "commands.puresuffering.add.success.day.primary.mystery" : "commands.puresuffering.add.success.day.primary.hyper") : "commands.puresuffering.add.success.day.primary")).m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.nonfixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        }))).then(Commands.m_82127_((String)"hyper").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"invasionType", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_SECONDARY_DAY_INVASION_TYPES).then(Commands.m_82129_((String)"severity", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (!iwData.hasFixedTime()) {
                TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSourceStack>)ctx, "invasionType", "severity", false, HyperType.HYPER);
                tiwData.getInvasionSpawner().getQueuedDayInvasions().add(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.add.success.day.secondary.hyper").m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.nonfixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        }))).then(Commands.m_82127_((String)"random").executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (!iwData.hasFixedTime()) {
                TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSourceStack>)ctx, "invasionType", null, false, HyperType.HYPER);
                tiwData.getInvasionSpawner().getQueuedDayInvasions().add(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.add.success.day.secondary.hyper").m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.nonfixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        }))))).then(Commands.m_82127_((String)"mystery").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"invasionType", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_SECONDARY_DAY_INVASION_TYPES).then(Commands.m_82129_((String)"severity", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (!iwData.hasFixedTime()) {
                TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSourceStack>)ctx, "invasionType", "severity", false, HyperType.MYSTERY);
                tiwData.getInvasionSpawner().getQueuedDayInvasions().add(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.add.success.day.secondary.mystery").m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.nonfixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        }))).then(Commands.m_82127_((String)"random").executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (!iwData.hasFixedTime()) {
                TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSourceStack>)ctx, "invasionType", null, false, HyperType.MYSTERY);
                tiwData.getInvasionSpawner().getQueuedDayInvasions().add(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.add.success.day.secondary.mystery").m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.nonfixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        }))))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"invasionType", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_SECONDARY_DAY_INVASION_TYPES).then(Commands.m_82129_((String)"severity", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (!iwData.hasFixedTime()) {
                TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSourceStack>)ctx, "invasionType", "severity", false, HyperType.DEFAULT);
                tiwData.getInvasionSpawner().getQueuedDayInvasions().add(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.add.success.day.secondary").m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.nonfixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        }))).then(Commands.m_82127_((String)"random").executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (!iwData.hasFixedTime()) {
                TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSourceStack>)ctx, "invasionType", null, false, HyperType.DEFAULT);
                tiwData.getInvasionSpawner().getQueuedDayInvasions().add(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.add.success.day.secondary").m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.nonfixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        })))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"night").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"primary").then(Commands.m_82127_((String)"random").executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (!iwData.hasFixedTime()) {
                TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getRandomInvasion((CommandContext<CommandSourceStack>)ctx, iwData, false, false, true);
                tiwData.getInvasionSpawner().getQueuedNightInvasions().removeIf(i -> i.isPrimary());
                tiwData.getInvasionSpawner().getQueuedNightInvasions().add(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)(invasion.getHyperType() != HyperType.DEFAULT ? (invasion.getHyperType() == HyperType.MYSTERY ? "commands.puresuffering.add.success.day.primary.mystery" : "commands.puresuffering.add.success.day.primary.hyper") : "commands.puresuffering.add.success.day.primary")).m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.nonfixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        }))).then(Commands.m_82127_((String)"hyper").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"invasionType", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_PRIMARY_NIGHT_INVASION_TYPES).then(Commands.m_82129_((String)"severity", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (!iwData.hasFixedTime()) {
                TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSourceStack>)ctx, "invasionType", "severity", true, HyperType.HYPER);
                tiwData.getInvasionSpawner().getQueuedNightInvasions().removeIf(i -> i.isPrimary());
                tiwData.getInvasionSpawner().getQueuedNightInvasions().add(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.add.success.night.primary.hyper").m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.nonfixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        }))).then(Commands.m_82127_((String)"random").executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (!iwData.hasFixedTime()) {
                TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSourceStack>)ctx, "invasionType", null, true, HyperType.HYPER);
                tiwData.getInvasionSpawner().getQueuedNightInvasions().removeIf(i -> i.isPrimary());
                tiwData.getInvasionSpawner().getQueuedNightInvasions().add(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.add.success.night.primary.hyper").m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.nonfixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        }))))).then(Commands.m_82127_((String)"mystery").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"invasionType", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_PRIMARY_NIGHT_INVASION_TYPES).then(Commands.m_82129_((String)"severity", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (!iwData.hasFixedTime()) {
                TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSourceStack>)ctx, "invasionType", "severity", true, HyperType.MYSTERY);
                tiwData.getInvasionSpawner().getQueuedNightInvasions().removeIf(i -> i.isPrimary());
                tiwData.getInvasionSpawner().getQueuedNightInvasions().add(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.add.success.night.primary.mystery").m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.nonfixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        }))).then(Commands.m_82127_((String)"random").executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (!iwData.hasFixedTime()) {
                TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSourceStack>)ctx, "invasionType", null, true, HyperType.MYSTERY);
                tiwData.getInvasionSpawner().getQueuedNightInvasions().removeIf(i -> i.isPrimary());
                tiwData.getInvasionSpawner().getQueuedNightInvasions().add(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.add.success.night.primary.mystery").m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.nonfixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        }))))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"invasionType", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_PRIMARY_NIGHT_INVASION_TYPES).then(Commands.m_82129_((String)"severity", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (!iwData.hasFixedTime()) {
                TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSourceStack>)ctx, "invasionType", "severity", true, HyperType.DEFAULT);
                tiwData.getInvasionSpawner().getQueuedNightInvasions().removeIf(i -> i.isPrimary());
                tiwData.getInvasionSpawner().getQueuedNightInvasions().add(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.add.success.night.primary").m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.nonfixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        }))).then(Commands.m_82127_((String)"random").executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (!iwData.hasFixedTime()) {
                TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSourceStack>)ctx, "invasionType", null, true, HyperType.DEFAULT);
                tiwData.getInvasionSpawner().getQueuedNightInvasions().removeIf(i -> i.isPrimary());
                tiwData.getInvasionSpawner().getQueuedNightInvasions().add(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.add.success.night.primary").m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.nonfixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        }))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"secondary").then(Commands.m_82127_((String)"random").executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (!iwData.hasFixedTime()) {
                TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getRandomInvasion((CommandContext<CommandSourceStack>)ctx, iwData, false, false, false);
                tiwData.getInvasionSpawner().getQueuedNightInvasions().add(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)(invasion.getHyperType() != HyperType.DEFAULT ? (invasion.getHyperType() == HyperType.MYSTERY ? "commands.puresuffering.add.success.day.primary.mystery" : "commands.puresuffering.add.success.day.primary.hyper") : "commands.puresuffering.add.success.day.primary")).m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.nonfixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        }))).then(Commands.m_82127_((String)"hyper").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"invasionType", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_SECONDARY_NIGHT_INVASION_TYPES).then(Commands.m_82129_((String)"severity", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (!iwData.hasFixedTime()) {
                TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSourceStack>)ctx, "invasionType", "severity", false, HyperType.HYPER);
                tiwData.getInvasionSpawner().getQueuedNightInvasions().add(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.add.success.night.secondary.hyper").m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.nonfixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        }))).then(Commands.m_82127_((String)"random").executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (!iwData.hasFixedTime()) {
                TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSourceStack>)ctx, "invasionType", null, false, HyperType.HYPER);
                tiwData.getInvasionSpawner().getQueuedNightInvasions().add(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.add.success.night.secondary.hyper").m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.nonfixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        }))))).then(Commands.m_82127_((String)"mystery").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"invasionType", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_SECONDARY_NIGHT_INVASION_TYPES).then(Commands.m_82129_((String)"severity", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (!iwData.hasFixedTime()) {
                TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSourceStack>)ctx, "invasionType", "severity", false, HyperType.MYSTERY);
                tiwData.getInvasionSpawner().getQueuedNightInvasions().add(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.add.success.night.secondary.mystery").m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.nonfixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        }))).then(Commands.m_82127_((String)"random").executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (!iwData.hasFixedTime()) {
                TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSourceStack>)ctx, "invasionType", null, false, HyperType.MYSTERY);
                tiwData.getInvasionSpawner().getQueuedNightInvasions().add(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.add.success.night.secondary.mystery").m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.nonfixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        }))))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"invasionType", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_SECONDARY_NIGHT_INVASION_TYPES).then(Commands.m_82129_((String)"severity", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (!iwData.hasFixedTime()) {
                TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSourceStack>)ctx, "invasionType", "severity", false, HyperType.DEFAULT);
                tiwData.getInvasionSpawner().getQueuedNightInvasions().add(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.add.success.night.secondary").m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.nonfixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        }))).then(Commands.m_82127_((String)"random").executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (!iwData.hasFixedTime()) {
                TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSourceStack>)ctx, "invasionType", null, false, HyperType.DEFAULT);
                tiwData.getInvasionSpawner().getQueuedNightInvasions().add(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.add.success.night.secondary").m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.nonfixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        })))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"fixed").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"primary").then(Commands.m_82127_((String)"random").executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (iwData.hasFixedTime()) {
                FixedInvasionWorldData fiwData = (FixedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getRandomInvasion((CommandContext<CommandSourceStack>)ctx, iwData, true, false, true);
                fiwData.getInvasionSpawner().getQueuedInvasions().removeIf(i -> i.isPrimary());
                fiwData.getInvasionSpawner().getQueuedInvasions().add(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)(invasion.getHyperType() != HyperType.DEFAULT ? (invasion.getHyperType() == HyperType.MYSTERY ? "commands.puresuffering.add.success.day.primary.mystery" : "commands.puresuffering.add.success.day.primary.hyper") : "commands.puresuffering.add.success.day.primary")).m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.fixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        }))).then(Commands.m_82127_((String)"hyper").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"invasionType", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_PRIMARY_FIXED_INVASION_TYPES).then(Commands.m_82129_((String)"severity", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (iwData.hasFixedTime()) {
                FixedInvasionWorldData fiwData = (FixedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSourceStack>)ctx, "invasionType", "severity", true, HyperType.HYPER);
                fiwData.getInvasionSpawner().getQueuedInvasions().removeIf(i -> i.isPrimary());
                fiwData.getInvasionSpawner().getQueuedInvasions().add(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.add.success.fixed.primary.hyper").m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.fixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        }))).then(Commands.m_82127_((String)"random").executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (iwData.hasFixedTime()) {
                FixedInvasionWorldData fiwData = (FixedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSourceStack>)ctx, "invasionType", null, true, HyperType.HYPER);
                fiwData.getInvasionSpawner().getQueuedInvasions().removeIf(i -> i.isPrimary());
                fiwData.getInvasionSpawner().getQueuedInvasions().add(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.add.success.fixed.primary.hyper").m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.fixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        }))))).then(Commands.m_82127_((String)"mystery").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"invasionType", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_PRIMARY_FIXED_INVASION_TYPES).then(Commands.m_82129_((String)"severity", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (iwData.hasFixedTime()) {
                FixedInvasionWorldData fiwData = (FixedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSourceStack>)ctx, "invasionType", "severity", true, HyperType.MYSTERY);
                fiwData.getInvasionSpawner().getQueuedInvasions().removeIf(i -> i.isPrimary());
                fiwData.getInvasionSpawner().getQueuedInvasions().add(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.add.success.fixed.primary.mystery").m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.fixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        }))).then(Commands.m_82127_((String)"random").executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (iwData.hasFixedTime()) {
                FixedInvasionWorldData fiwData = (FixedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSourceStack>)ctx, "invasionType", null, true, HyperType.MYSTERY);
                fiwData.getInvasionSpawner().getQueuedInvasions().removeIf(i -> i.isPrimary());
                fiwData.getInvasionSpawner().getQueuedInvasions().add(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.add.success.fixed.primary.mystery").m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.fixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        }))))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"invasionType", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_PRIMARY_FIXED_INVASION_TYPES).then(Commands.m_82129_((String)"severity", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (iwData.hasFixedTime()) {
                FixedInvasionWorldData fiwData = (FixedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSourceStack>)ctx, "invasionType", "severity", true, HyperType.DEFAULT);
                fiwData.getInvasionSpawner().getQueuedInvasions().removeIf(i -> i.isPrimary());
                fiwData.getInvasionSpawner().getQueuedInvasions().add(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.add.success.fixed.primary").m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.fixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        }))).then(Commands.m_82127_((String)"random").executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (iwData.hasFixedTime()) {
                FixedInvasionWorldData fiwData = (FixedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSourceStack>)ctx, "invasionType", null, true, HyperType.DEFAULT);
                fiwData.getInvasionSpawner().getQueuedInvasions().removeIf(i -> i.isPrimary());
                fiwData.getInvasionSpawner().getQueuedInvasions().add(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.add.success.fixed.primary").m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.fixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        }))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"secondary").then(Commands.m_82127_((String)"random").executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (iwData.hasFixedTime()) {
                FixedInvasionWorldData fiwData = (FixedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getRandomInvasion((CommandContext<CommandSourceStack>)ctx, iwData, true, false, false);
                fiwData.getInvasionSpawner().getQueuedInvasions().add(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)(invasion.getHyperType() != HyperType.DEFAULT ? (invasion.getHyperType() == HyperType.MYSTERY ? "commands.puresuffering.add.success.day.primary.mystery" : "commands.puresuffering.add.success.day.primary.hyper") : "commands.puresuffering.add.success.day.primary")).m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.fixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        }))).then(Commands.m_82127_((String)"hyper").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"invasionType", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_SECONDARY_FIXED_INVASION_TYPES).then(Commands.m_82129_((String)"severity", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (iwData.hasFixedTime()) {
                FixedInvasionWorldData fiwData = (FixedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSourceStack>)ctx, "invasionType", "severity", false, HyperType.HYPER);
                fiwData.getInvasionSpawner().getQueuedInvasions().add(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.add.success.fixed.secondary.hyper").m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.fixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        }))).then(Commands.m_82127_((String)"random").executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (iwData.hasFixedTime()) {
                FixedInvasionWorldData fiwData = (FixedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSourceStack>)ctx, "invasionType", null, false, HyperType.HYPER);
                fiwData.getInvasionSpawner().getQueuedInvasions().add(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.add.success.fixed.secondary.hyper").m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.fixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        }))))).then(Commands.m_82127_((String)"mystery").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"invasionType", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_SECONDARY_FIXED_INVASION_TYPES).then(Commands.m_82129_((String)"severity", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (iwData.hasFixedTime()) {
                FixedInvasionWorldData fiwData = (FixedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSourceStack>)ctx, "invasionType", "severity", false, HyperType.MYSTERY);
                fiwData.getInvasionSpawner().getQueuedInvasions().add(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.add.success.fixed.secondary.mystery").m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.fixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        }))).then(Commands.m_82127_((String)"random").executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (iwData.hasFixedTime()) {
                FixedInvasionWorldData fiwData = (FixedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSourceStack>)ctx, "invasionType", null, false, HyperType.MYSTERY);
                fiwData.getInvasionSpawner().getQueuedInvasions().add(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.add.success.fixed.secondary.mystery").m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.fixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        }))))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"invasionType", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_SECONDARY_FIXED_INVASION_TYPES).then(Commands.m_82129_((String)"severity", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (iwData.hasFixedTime()) {
                FixedInvasionWorldData fiwData = (FixedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSourceStack>)ctx, "invasionType", "severity", false, HyperType.DEFAULT);
                fiwData.getInvasionSpawner().getQueuedInvasions().add(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.add.success.fixed.secondary").m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.fixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        }))).then(Commands.m_82127_((String)"random").executes(ctx -> {
            InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(((CommandSourceStack)ctx.getSource()).m_81372_());
            if (iwData.hasFixedTime()) {
                FixedInvasionWorldData fiwData = (FixedInvasionWorldData)iwData;
                Invasion invasion = AddInvasionsCommand.getInvasion((CommandContext<CommandSourceStack>)ctx, "invasionType", null, false, HyperType.DEFAULT);
                fiwData.getInvasionSpawner().getQueuedInvasions().add(invasion);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.add.success.fixed.secondary").m_7220_(invasion.getType().getComponent()).m_130946_("!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"commands.puresuffering.fixed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 0;
        })))));
    }

    private static final boolean containsDayChangingInvasion(ArrayList<Invasion> invasionListIn) {
        for (Invasion invasion : invasionListIn) {
            if (invasion.getType().getInvasionTime() == InvasionType.InvasionTime.NIGHT || invasion.getType().getTimeModifier() != InvasionType.TimeModifier.DAY_TO_NIGHT) continue;
            return true;
        }
        return false;
    }

    private static final boolean containsNightChangingInvasion(ArrayList<Invasion> invasionListIn) {
        for (Invasion invasion : invasionListIn) {
            if (invasion.getType().getInvasionTime() == InvasionType.InvasionTime.DAY || invasion.getType().getTimeModifier() != InvasionType.TimeModifier.NIGHT_TO_DAY) continue;
            return true;
        }
        return false;
    }

    private static final Invasion getInvasion(CommandContext<CommandSourceStack> ctxIn, String argIn, String arg1In, boolean isPrimaryIn, HyperType hyperTypeIn) throws CommandSyntaxException {
        ResourceLocation resourceLocation = (ResourceLocation)ctxIn.getArgument(argIn, ResourceLocation.class);
        InvasionType invasionType = PSEventManager.BaseEvents.getInvasionTypeManager().getInvasionType(resourceLocation);
        if (invasionType == null) {
            throw ERROR_UNKNOWN_INVASION_TYPE.create((Object)resourceLocation);
        }
        int severity = arg1In == null ? ((CommandSourceStack)ctxIn.getSource()).m_81372_().m_213780_().m_188503_(invasionType.getMaxSeverity()) : Mth.m_14045_((int)IntegerArgumentType.getInteger(ctxIn, (String)arg1In), (int)1, (int)invasionType.getMaxSeverity()) - 1;
        return new Invasion(invasionType, hyperTypeIn != HyperType.DEFAULT ? invasionType.getMaxSeverity() - 1 : severity, isPrimaryIn, hyperTypeIn);
    }

    private static final Invasion getRandomInvasion(CommandContext<CommandSourceStack> ctxIn, InvasionWorldData iwDataIn, boolean hasFixedTimeIn, boolean isDayIn, boolean isPrimaryIn) throws CommandSyntaxException {
        ArrayList<InvasionType> list = new ArrayList<InvasionType>(PSEventManager.BaseEvents.getInvasionTypeManager().getAllInvasionTypes());
        list.removeIf(it -> {
            boolean result = false;
            result = hasFixedTimeIn ? (isPrimaryIn ? it.getDimensions().contains(((CommandSourceStack)ctxIn.getSource()).m_81372_().m_46472_().m_135782_()) && it.getInvasionPriority() != InvasionType.InvasionPriority.SECONDARY_ONLY : it.getDimensions().contains(((CommandSourceStack)ctxIn.getSource()).m_81372_().m_46472_().m_135782_()) && it.getInvasionPriority() != InvasionType.InvasionPriority.PRIMARY_ONLY) : (isDayIn ? (isPrimaryIn ? it.getDimensions().contains(((CommandSourceStack)ctxIn.getSource()).m_81372_().m_46472_().m_135782_()) && it.getInvasionPriority() != InvasionType.InvasionPriority.SECONDARY_ONLY && it.getInvasionTime() != InvasionType.InvasionTime.NIGHT && it.getTimeChangeability() != InvasionType.TimeChangeability.ONLY_NIGHT : it.getDimensions().contains(((CommandSourceStack)ctxIn.getSource()).m_81372_().m_46472_().m_135782_()) && it.getInvasionPriority() != InvasionType.InvasionPriority.PRIMARY_ONLY && (AddInvasionsCommand.containsDayChangingInvasion(((TimedInvasionWorldData)iwDataIn).getInvasionSpawner().getQueuedDayInvasions()) ? it.getInvasionTime() != InvasionType.InvasionTime.DAY && it.getTimeChangeability() != InvasionType.TimeChangeability.ONLY_DAY : it.getInvasionTime() != InvasionType.InvasionTime.NIGHT && it.getTimeChangeability() != InvasionType.TimeChangeability.ONLY_NIGHT)) : (isPrimaryIn ? it.getDimensions().contains(((CommandSourceStack)ctxIn.getSource()).m_81372_().m_46472_().m_135782_()) && it.getInvasionPriority() != InvasionType.InvasionPriority.SECONDARY_ONLY && it.getInvasionTime() != InvasionType.InvasionTime.DAY && it.getTimeChangeability() != InvasionType.TimeChangeability.ONLY_DAY : it.getDimensions().contains(((CommandSourceStack)ctxIn.getSource()).m_81372_().m_46472_().m_135782_()) && it.getInvasionPriority() != InvasionType.InvasionPriority.PRIMARY_ONLY && (AddInvasionsCommand.containsNightChangingInvasion(((TimedInvasionWorldData)iwDataIn).getInvasionSpawner().getQueuedNightInvasions()) ? it.getInvasionTime() != InvasionType.InvasionTime.NIGHT && it.getTimeChangeability() != InvasionType.TimeChangeability.ONLY_NIGHT : it.getInvasionTime() != InvasionType.InvasionTime.DAY && it.getTimeChangeability() != InvasionType.TimeChangeability.ONLY_DAY)));
            return !result;
        });
        RandomSource random = ((CommandSourceStack)ctxIn.getSource()).m_81372_().m_213780_();
        InvasionType invasionType = list.get(random.m_188503_(list.size()));
        ImmutableList hyper = ImmutableList.of((Object)random.m_188499_(), (Object)random.m_188499_(), (Object)random.m_188499_(), (Object)random.m_188499_());
        HyperType hyperType = hyper.contains((Object)true) && random.m_188499_() ? (hyper.contains((Object)false) ? HyperType.HYPER : HyperType.MYSTERY) : HyperType.DEFAULT;
        int severity = hyperType != HyperType.DEFAULT ? invasionType.getMaxSeverity() - 1 : random.m_188503_(invasionType.getMaxSeverity());
        return new Invasion(invasionType, severity, isPrimaryIn, hyperType);
    }
}

