/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.network.packet;

import dev.theagameplayer.puresuffering.world.ClientInvasionWorldInfo;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public final class UpdateTimePacket {
    private final boolean isDay;
    private final boolean isTime;

    public UpdateTimePacket(boolean isDayIn, boolean isTimeIn) {
        this.isDay = isDayIn;
        this.isTime = isTimeIn;
    }

    public static final void encode(UpdateTimePacket msgIn, FriendlyByteBuf bufIn) {
        bufIn.writeBoolean(msgIn.isDay);
        bufIn.writeBoolean(msgIn.isTime);
    }

    public static final UpdateTimePacket decode(FriendlyByteBuf bufIn) {
        return new UpdateTimePacket(bufIn.readBoolean(), bufIn.readBoolean());
    }

    public static class Handler {
        public static final boolean handle(UpdateTimePacket msgIn, Supplier<NetworkEvent.Context> ctxIn) {
            ctxIn.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> Handler.lambda$handle$1(msgIn, (Supplier)ctxIn)));
            return true;
        }

        private static final void handlePacket(UpdateTimePacket msgIn, Supplier<NetworkEvent.Context> ctxIn) {
            Minecraft mc = Minecraft.m_91087_();
            if (msgIn.isDay) {
                ClientInvasionWorldInfo.getDayClientInfo(mc.f_91073_).updateClientTime(msgIn.isTime);
            } else {
                ClientInvasionWorldInfo.getNightClientInfo(mc.f_91073_).updateClientTime(msgIn.isTime);
            }
        }

        private static /* synthetic */ Runnable lambda$handle$1(UpdateTimePacket msgIn, Supplier ctxIn) {
            return () -> Handler.lambda$handle$0(msgIn, (Supplier)ctxIn);
        }

        private static /* synthetic */ void lambda$handle$0(UpdateTimePacket msgIn, Supplier ctxIn) {
            Handler.handlePacket(msgIn, ctxIn);
        }
    }
}

