/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.util;

import dev.theagameplayer.puresuffering.invasion.Invasion;
import dev.theagameplayer.puresuffering.util.ServerTimeUtil;
import dev.theagameplayer.puresuffering.world.FixedInvasionWorldData;
import dev.theagameplayer.puresuffering.world.InvasionWorldData;
import dev.theagameplayer.puresuffering.world.TimedInvasionWorldData;
import net.minecraft.server.level.ServerLevel;

public final class ServerInvasionUtil {
    public static final int handleLightLevel(int lightLevelIn, ServerLevel levelIn) {
        InvasionWorldData iwData = InvasionWorldData.getInvasionData().get(levelIn);
        if (iwData != null) {
            if (!iwData.hasFixedTime()) {
                TimedInvasionWorldData tiwData = (TimedInvasionWorldData)iwData;
                if (ServerTimeUtil.isServerDay(levelIn, tiwData) && !tiwData.getInvasionSpawner().getDayInvasions().isEmpty()) {
                    int lightLevel = 0;
                    int changed = 0;
                    for (Invasion invasion : tiwData.getInvasionSpawner().getDayInvasions()) {
                        int amount = invasion.getType().getSeverityInfo().get(invasion.getSeverity()).getLightLevel();
                        if (amount <= -1) continue;
                        lightLevel += amount;
                        ++changed;
                    }
                    return changed == 0 ? lightLevelIn : lightLevel / changed;
                }
                if (ServerTimeUtil.isServerNight(levelIn, tiwData) && !tiwData.getInvasionSpawner().getNightInvasions().isEmpty()) {
                    int lightLevel = 0;
                    int changed = 0;
                    for (Invasion invasion : tiwData.getInvasionSpawner().getNightInvasions()) {
                        int amount = invasion.getType().getSeverityInfo().get(invasion.getSeverity()).getLightLevel();
                        if (amount <= -1) continue;
                        lightLevel += amount;
                        ++changed;
                    }
                    return changed == 0 ? lightLevelIn : lightLevel / changed;
                }
            } else {
                FixedInvasionWorldData fiwData = (FixedInvasionWorldData)iwData;
                if (!fiwData.getInvasionSpawner().getInvasions().isEmpty()) {
                    int lightLevel = 0;
                    int changed = 0;
                    for (Invasion invasion : fiwData.getInvasionSpawner().getInvasions()) {
                        int amount = invasion.getType().getSeverityInfo().get(invasion.getSeverity()).getLightLevel();
                        if (amount <= -1) continue;
                        lightLevel += amount;
                        ++changed;
                    }
                    return changed == 0 ? lightLevelIn : lightLevel / changed;
                }
            }
        }
        return lightLevelIn;
    }
}

