/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.util.text;

import dev.theagameplayer.puresuffering.invasion.HyperType;
import dev.theagameplayer.puresuffering.invasion.Invasion;
import dev.theagameplayer.puresuffering.util.InvasionList;
import java.awt.Color;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;

public class InvasionText {
    private final boolean isPrimary;
    private final HyperType hyperType;
    private final int severity;
    private final int rarity;
    private final int tier;
    private final int mobCap;

    public InvasionText(Invasion invasionIn) {
        this.isPrimary = invasionIn.isPrimary();
        this.severity = invasionIn.getSeverity() + 1;
        this.hyperType = invasionIn.getHyperType();
        this.rarity = invasionIn.getType().getRarity() + 1;
        this.tier = invasionIn.getType().getTier() + 1;
        this.mobCap = invasionIn.getMobCap() - 1;
    }

    public final MutableComponent getHoverText() {
        MutableComponent primaryComponent = Component.m_237115_((String)"invasion.puresuffering.info1").m_130946_(this.isPrimary + ", ");
        MutableComponent severityComponent = Component.m_237115_((String)"invasion.puresuffering.info2").m_130946_(this.severity + "\n");
        MutableComponent hyperComponent = Component.m_237115_((String)"invasion.puresuffering.info3").m_130946_(this.hyperType + "\n");
        MutableComponent infoComponent = Component.m_237115_((String)"invasion.puresuffering.info4").m_130946_("\n");
        MutableComponent rarityComponent = Component.m_237115_((String)"invasion.puresuffering.info5").m_130946_(this.rarity + ", ");
        MutableComponent tierComponent = Component.m_237115_((String)"invasion.puresuffering.info6").m_130946_(this.tier + ", ");
        MutableComponent mobCapComponent = Component.m_237115_((String)"invasion.puresuffering.info7").m_130946_("" + this.mobCap);
        return primaryComponent.m_7220_((Component)severityComponent).m_7220_((Component)hyperComponent).m_7220_((Component)infoComponent).m_7220_((Component)rarityComponent).m_7220_((Component)tierComponent).m_7220_((Component)mobCapComponent);
    }

    public static final MutableComponent create(String keyIn, Color baseIn, InvasionList invasionListIn) {
        MutableComponent component = Component.m_237115_((String)keyIn).m_130948_(Style.f_131099_.m_178520_(baseIn.getRGB()));
        for (Invasion invasion : invasionListIn) {
            if (!component.m_7360_().isEmpty()) {
                component.m_130946_(", ").m_130948_(Style.f_131099_.m_178520_(baseIn.getRGB()));
            }
            MutableComponent component1 = ComponentUtils.m_130750_((MutableComponent)invasion.getType().getComponent().m_6881_(), (Style)Style.f_131099_.m_131140_(ChatFormatting.GRAY)).m_130946_("\n").m_7220_((Component)new InvasionText(invasion).getHoverText().m_130940_(ChatFormatting.DARK_GRAY));
            MutableComponent component2 = invasion.getType().getComponent().m_6881_().m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)component1)));
            component.m_7220_((Component)component2.m_130948_(Style.f_131099_.m_178520_(new Color(baseIn.getRed(), InvasionText.getInvColor(baseIn.getGreen(), invasion), invasion.getHyperType() == HyperType.MYSTERY ? baseIn.getBlue() : InvasionText.getInvColor(baseIn.getBlue(), invasion)).getRGB()).m_131162_(Boolean.valueOf(invasion.isPrimary()))));
        }
        return component;
    }

    private static final int getInvColor(int colorIn, Invasion invasionIn) {
        int amount = 100 / invasionIn.getType().getMaxSeverity();
        return Mth.m_14045_((int)(colorIn + invasionIn.getType().getMaxSeverity() * amount - invasionIn.getSeverity() * amount), (int)0, (int)255);
    }
}

