/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.world;

import dev.theagameplayer.puresuffering.spawner.TimedInvasionSpawner;
import dev.theagameplayer.puresuffering.util.ServerTimeUtil;
import dev.theagameplayer.puresuffering.world.InvasionWorldData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;

public final class TimedInvasionWorldData
extends InvasionWorldData {
    private final TimedInvasionSpawner spawner = new TimedInvasionSpawner();
    private double dayXPMultiplier;
    private double nightXPMultiplier;
    private boolean checkedDay;
    private boolean checkedNight;
    private boolean prevDayCheck;
    private boolean prevNightCheck;

    public TimedInvasionWorldData(ServerLevel levelIn) {
        super(levelIn);
        this.checkedDay = ServerTimeUtil.isServerNight(levelIn, this);
        this.checkedNight = ServerTimeUtil.isServerDay(levelIn, this);
    }

    public static final TimedInvasionWorldData load(ServerLevel levelIn, CompoundTag nbtIn) {
        TimedInvasionWorldData tiwData = new TimedInvasionWorldData(levelIn);
        tiwData.spawner.load(nbtIn.m_128469_("Spawner"));
        tiwData.dayXPMultiplier = nbtIn.m_128459_("DayXPMultiplier");
        tiwData.nightXPMultiplier = nbtIn.m_128459_("NightXPMultiplier");
        tiwData.checkedDay = nbtIn.m_128471_("CheckedDay");
        tiwData.checkedNight = nbtIn.m_128471_("CheckedNight");
        tiwData.prevDayCheck = nbtIn.m_128471_("PrevDayCheck");
        tiwData.prevNightCheck = nbtIn.m_128471_("PrevNightCheck");
        tiwData.days = nbtIn.m_128454_("Days");
        return tiwData;
    }

    @Override
    public final CompoundTag m_7176_(CompoundTag nbtIn) {
        nbtIn.m_128365_("Spawner", (Tag)this.spawner.save());
        nbtIn.m_128347_("DayXPMultiplier", this.dayXPMultiplier);
        nbtIn.m_128347_("NightXPMultiplier", this.nightXPMultiplier);
        nbtIn.m_128379_("CheckedDay", this.checkedDay);
        nbtIn.m_128379_("CheckedNight", this.checkedNight);
        nbtIn.m_128379_("PrevDayCheck", this.prevDayCheck);
        nbtIn.m_128379_("PrevNightCheck", this.prevNightCheck);
        return super.m_7176_(nbtIn);
    }

    public final TimedInvasionSpawner getInvasionSpawner() {
        return this.spawner;
    }

    public final double getDayXPMultiplier() {
        return this.dayXPMultiplier;
    }

    public final void setDayXPMultiplier(double dayXPMultiplierIn) {
        this.dayXPMultiplier = dayXPMultiplierIn;
        this.m_77762_();
    }

    public final double getNightXPMultiplier() {
        return this.nightXPMultiplier;
    }

    public final void setNightXPMultiplier(double nightXPMultiplierIn) {
        this.nightXPMultiplier = nightXPMultiplierIn;
        this.m_77762_();
    }

    public final boolean hasCheckedDay() {
        return this.checkedDay;
    }

    public final void setCheckedDay(boolean checkedDayIn) {
        this.checkedDay = checkedDayIn;
        this.m_77762_();
    }

    public final boolean hasCheckedNight() {
        return this.checkedNight;
    }

    public final void setCheckedNight(boolean checkedNightIn) {
        this.checkedNight = checkedNightIn;
        this.m_77762_();
    }

    public final boolean getPrevDayCheck() {
        return this.prevDayCheck;
    }

    public final void setPrevDayCheck(boolean prevDayCheckIn) {
        this.prevDayCheck = prevDayCheckIn;
        this.m_77762_();
    }

    public final boolean getPrevNightCheck() {
        return this.prevNightCheck;
    }

    public final void setPrevNightCheck(boolean prevNightCheckIn) {
        this.prevNightCheck = prevNightCheckIn;
        this.m_77762_();
    }
}

