/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.simplebackups;

import de.melanx.simplebackups.BackupData;
import de.melanx.simplebackups.ConfigHandler;
import de.melanx.simplebackups.DefaultTranslator;
import de.melanx.simplebackups.StorageSize;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.FileUtil;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BackupThread
extends Thread {
    private static final Path OUTPUT_PATH = FMLPaths.GAMEDIR.get().resolve("simplebackups");
    private static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('_').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral('-').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral('-').appendValue(ChronoField.SECOND_OF_MINUTE, 2).toFormatter();
    public static final Logger LOGGER = LogManager.getLogger(BackupThread.class);
    private final MinecraftServer server;
    private final LevelStorageSource.LevelStorageAccess storageSource;

    private BackupThread(@Nonnull MinecraftServer server) {
        this.server = server;
        this.storageSource = server.f_129744_;
        this.setName("SimpleBackups");
        this.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(LOGGER));
    }

    public static boolean tryCreateBackup(MinecraftServer server) {
        BackupThread thread = new BackupThread(server);
        BackupData backupData = BackupData.get(server);
        if (!server.m_6846_().m_11314_().isEmpty() && System.currentTimeMillis() - (long)ConfigHandler.getTimer() > backupData.getLastSaved()) {
            File[] files;
            File backups = OUTPUT_PATH.toFile();
            if (backups.isDirectory() && (files = backups.listFiles()) != null && files.length >= ConfigHandler.getBackupsToKeep()) {
                Arrays.sort(files, Comparator.comparingLong(File::lastModified));
                while (files.length >= ConfigHandler.getBackupsToKeep()) {
                    boolean deleted = files[0].delete();
                    String name = files[0].getName();
                    if (!deleted) continue;
                    LOGGER.info("Successfully deleted \"" + name + "\"");
                    files = Arrays.copyOfRange(files, 1, files.length);
                }
            }
            thread.start();
            backupData.updateSaveTime(System.currentTimeMillis());
            return true;
        }
        return false;
    }

    public static void saveStorageSize() {
        try {
            while (BackupThread.getOutputFolderSize() > ConfigHandler.getMaxDiskSize()) {
                File[] files = OUTPUT_PATH.toFile().listFiles();
                if (Objects.requireNonNull(files).length == 1) {
                    LOGGER.error("Cannot delete old files to save disk space. Only one backup file left!");
                    return;
                }
                Arrays.sort(Objects.requireNonNull(files), Comparator.comparingLong(File::lastModified));
                File file = files[0];
                String name = file.getName();
                if (!file.delete()) continue;
                LOGGER.info("Successfully deleted \"" + name + "\"");
            }
        }
        catch (IOException | NullPointerException e) {
            LOGGER.error("Cannot delete old files to save disk space", (Throwable)e);
        }
    }

    @Override
    public void run() {
        try {
            Files.createDirectories(OUTPUT_PATH, new FileAttribute[0]);
            long start = System.currentTimeMillis();
            this.broadcast("simplebackups.backup_started", Style.f_131099_.m_131140_(ChatFormatting.GOLD), new Object[0]);
            long size = this.makeWorldBackup();
            long end = System.currentTimeMillis();
            String time = Timer.getTimer(end - start);
            BackupThread.saveStorageSize();
            this.broadcast("simplebackups.backup_finished", Style.f_131099_.m_131140_(ChatFormatting.GOLD), time, StorageSize.getFormattedSize(size), StorageSize.getFormattedSize(BackupThread.getOutputFolderSize()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static long getOutputFolderSize() throws IOException {
        File[] files = OUTPUT_PATH.toFile().listFiles();
        long size = 0L;
        try {
            for (File file : Objects.requireNonNull(files)) {
                size += Files.size(file.toPath());
            }
        }
        catch (NullPointerException e) {
            return 0L;
        }
        return size;
    }

    private void broadcast(String message, Style style, Object ... parameters) {
        MutableComponent defaultComponent = new TextComponent(DefaultTranslator.parseKey(message, parameters)).m_130948_(style);
        MutableComponent realComponent = new TranslatableComponent(message, parameters).m_130948_(style);
        this.server.m_6846_().m_11314_().forEach(arg_0 -> BackupThread.lambda$broadcast$0((Component)defaultComponent, (Component)realComponent, arg_0));
    }

    private long makeWorldBackup() throws IOException {
        this.storageSource.m_78313_();
        String fileName = this.storageSource.f_78272_ + "_" + LocalDateTime.now().format(FORMATTER);
        Path path = FMLPaths.GAMEDIR.get().resolve("simplebackups");
        try {
            Files.createDirectories(Files.exists(path, new LinkOption[0]) ? path.toRealPath(new LinkOption[0]) : path, new FileAttribute[0]);
        }
        catch (IOException ioexception) {
            throw new RuntimeException(ioexception);
        }
        Path outputFile = path.resolve(FileUtil.m_133730_((Path)path, (String)fileName, (String)".zip"));
        final ZipOutputStream zipStream = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(outputFile, new OpenOption[0])));
        try {
            final Path levelName = Paths.get(this.storageSource.f_78272_, new String[0]);
            final Path levelPath = this.storageSource.f_78271_;
            Files.walkFileTree(levelPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (!file.endsWith("session.lock")) {
                        String completePath = levelName.resolve(levelPath.relativize(file)).toString().replace('\\', '/');
                        ZipEntry zipentry = new ZipEntry(completePath);
                        zipStream.putNextEntry(zipentry);
                        com.google.common.io.Files.asByteSource((File)file.toFile()).copyTo((OutputStream)zipStream);
                        zipStream.closeEntry();
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            try {
                zipStream.close();
            }
            catch (IOException e1) {
                e.addSuppressed(e1);
            }
            throw e;
        }
        zipStream.close();
        return Files.size(outputFile);
    }

    private static /* synthetic */ void lambda$broadcast$0(Component defaultComponent, Component realComponent, ServerPlayer player) {
        if (DefaultTranslator.PLAYERS_WITHOUT_MOD.contains(player.m_36316_().getId())) {
            player.m_6352_(defaultComponent, Util.f_137441_);
        } else {
            player.m_6352_(realComponent, Util.f_137441_);
        }
    }

    private static class Timer {
        private static final SimpleDateFormat SECONDS = new SimpleDateFormat("s.SSS");
        private static final SimpleDateFormat MINUTES = new SimpleDateFormat("mm:ss");
        private static final SimpleDateFormat HOURS = new SimpleDateFormat("HH:mm");

        private Timer() {
        }

        public static String getTimer(long milliseconds) {
            Date date = new Date(milliseconds);
            double seconds = (double)milliseconds / 1000.0;
            if (seconds < 60.0) {
                return SECONDS.format(date) + "s";
            }
            if (seconds < 3600.0) {
                return MINUTES.format(date) + "min";
            }
            return HOURS.format(date) + "h";
        }
    }
}

