/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.simplebackups;

import de.melanx.simplebackups.StorageSize;
import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigHandler {
    public static final ForgeConfigSpec COMMON_CONFIG;
    private static final ForgeConfigSpec.Builder COMMON_BUILDER;
    private static ForgeConfigSpec.IntValue backupsToKeep;
    private static ForgeConfigSpec.IntValue timer;
    private static ForgeConfigSpec.ConfigValue<String> maxDiskSize;

    public static void init(ForgeConfigSpec.Builder builder) {
        backupsToKeep = builder.comment("The max amount of backup files to keep.").defineInRange("backupsToKeep", 10, 1, Short.MAX_VALUE);
        timer = builder.comment(new String[]{"The time between two backups in minutes", "5 = each 5 minutes", "60 = each hour", "1440 = each day"}).defineInRange("timer", 120, 1, Short.MAX_VALUE);
        maxDiskSize = builder.comment(new String[]{"The max size of storage the backup folder. If it takes more storage, old files will be deleted.", "Needs to be written as <number><space><storage type>", "Valid storage types: B, KB, MB, GB, TB"}).define("maxDiskSize", (Object)"25 GB");
    }

    public static int getBackupsToKeep() {
        return (Integer)backupsToKeep.get();
    }

    public static int getTimer() {
        return (Integer)timer.get() * 60 * 1000;
    }

    public static long getMaxDiskSize() {
        String s = (String)maxDiskSize.get();
        if (s.split(" ").length != 2) {
            s = "25 GB";
        }
        return StorageSize.getBytes(s);
    }

    static {
        COMMON_BUILDER = new ForgeConfigSpec.Builder();
        ConfigHandler.init(COMMON_BUILDER);
        COMMON_CONFIG = COMMON_BUILDER.build();
    }
}

