/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.simplebackups;

import de.melanx.simplebackups.StorageSize;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigHandler {
    public static final ForgeConfigSpec COMMON_CONFIG;
    private static final ForgeConfigSpec.Builder COMMON_BUILDER;
    private static ForgeConfigSpec.IntValue backupsToKeep;
    private static ForgeConfigSpec.IntValue timer;
    private static ForgeConfigSpec.BooleanValue sendMessages;
    private static ForgeConfigSpec.ConfigValue<String> maxDiskSize;
    private static ForgeConfigSpec.ConfigValue<String> outputPath;

    public static void init(ForgeConfigSpec.Builder builder) {
        backupsToKeep = builder.comment("The max amount of backup files to keep.").defineInRange("backupsToKeep", 10, 1, Short.MAX_VALUE);
        timer = builder.comment(new String[]{"The time between two backups in minutes", "5 = each 5 minutes", "60 = each hour", "1440 = each day"}).defineInRange("timer", 120, 1, Short.MAX_VALUE);
        sendMessages = builder.comment("Should message be sent when backup is in the making?").define("sendMessages", true);
        maxDiskSize = builder.comment(new String[]{"The max size of storage the backup folder. If it takes more storage, old files will be deleted.", "Needs to be written as <number><space><storage type>", "Valid storage types: B, KB, MB, GB, TB"}).define("maxDiskSize", (Object)"25 GB");
        outputPath = builder.comment("Used to define the output path.").define("outputPath", (Object)"simplebackups");
    }

    public static int getBackupsToKeep() {
        return (Integer)backupsToKeep.get();
    }

    public static int getTimer() {
        return (Integer)timer.get() * 60 * 1000;
    }

    public static long getMaxDiskSize() {
        String s = (String)maxDiskSize.get();
        if (s.split(" ").length != 2) {
            s = "25 GB";
        }
        return StorageSize.getBytes(s);
    }

    public static Path getOutputPath() {
        try {
            return Paths.get((String)outputPath.get(), new String[0]).toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            return Paths.get((String)outputPath.get(), new String[0]);
        }
    }

    public static boolean sendMessages() {
        return (Boolean)sendMessages.get();
    }

    static {
        COMMON_BUILDER = new ForgeConfigSpec.Builder();
        ConfigHandler.init(COMMON_BUILDER);
        COMMON_CONFIG = COMMON_BUILDER.build();
    }
}

