/*
 * Decompiled with CFR 0.152.
 */
package cech12.solarcooker.block;

import cech12.solarcooker.api.block.SolarCookerBlocks;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ReflectorBlock
extends Block {
    public static final IntegerProperty TYPE = IntegerProperty.m_61631_((String)"type", (int)1, (int)15);
    protected static final List<Integer> TYPES_WITH_ONE_REFLECTOR = Arrays.asList(1, 2, 4, 8);
    protected static final List<Integer> TYPES_WITH_TWO_REFLECTORS = Arrays.asList(3, 5, 6, 9, 10, 12);
    protected static final List<Integer> TYPES_WITH_THREE_REFLECTORS = Arrays.asList(7, 11, 13, 14);
    protected static final List<Integer> TYPES_WITH_FOUR_REFLECTORS = Collections.singletonList(15);
    protected static final VoxelShape SHAPE_NORTH_WEST = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)5.0);
    protected static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)16.0, (double)5.0);
    protected static final VoxelShape SHAPE_NORTH_EAST = Block.m_49796_((double)11.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)5.0);
    protected static final VoxelShape SHAPE_EAST = Block.m_49796_((double)11.0, (double)0.0, (double)5.0, (double)16.0, (double)16.0, (double)11.0);
    protected static final VoxelShape SHAPE_SOUTH_EAST = Block.m_49796_((double)11.0, (double)0.0, (double)11.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_SOUTH = Block.m_49796_((double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_SOUTH_WEST = Block.m_49796_((double)0.0, (double)0.0, (double)11.0, (double)5.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_WEST = Block.m_49796_((double)0.0, (double)0.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0);
    protected static final VoxelShape[] SHAPES = ReflectorBlock.makeShapes();

    private static VoxelShape[] makeShapes() {
        return (VoxelShape[])IntStream.range(0, 16).mapToObj(type -> {
            HashSet<VoxelShape> shapes = new HashSet<VoxelShape>();
            if ((type | 8) == type) {
                shapes.add(SHAPE_NORTH_WEST);
                shapes.add(SHAPE_NORTH);
                shapes.add(SHAPE_NORTH_EAST);
            }
            if ((type | 4) == type) {
                shapes.add(SHAPE_NORTH_EAST);
                shapes.add(SHAPE_EAST);
                shapes.add(SHAPE_SOUTH_EAST);
            }
            if ((type | 2) == type) {
                shapes.add(SHAPE_SOUTH_EAST);
                shapes.add(SHAPE_SOUTH);
                shapes.add(SHAPE_SOUTH_WEST);
            }
            if ((type | 1) == type) {
                shapes.add(SHAPE_SOUTH_WEST);
                shapes.add(SHAPE_WEST);
                shapes.add(SHAPE_NORTH_WEST);
            }
            VoxelShape voxelshape = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
            for (VoxelShape shape : shapes) {
                voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)shape);
            }
            return voxelshape;
        }).toArray(VoxelShape[]::new);
    }

    public static int getType(Direction direction) {
        switch (direction) {
            case NORTH: {
                return 8;
            }
            case EAST: {
                return 4;
            }
            case SOUTH: {
                return 2;
            }
            case WEST: {
                return 1;
            }
        }
        return 8;
    }

    public static boolean isFacingTo(BlockState blockstate, Direction direction) {
        if (direction != Direction.UP && direction != Direction.DOWN) {
            int type = (Integer)blockstate.m_61143_((Property)TYPE);
            return (type | ReflectorBlock.getType(direction)) == type;
        }
        return false;
    }

    private static int getCount(int type) {
        if (TYPES_WITH_ONE_REFLECTOR.contains(type)) {
            return 1;
        }
        if (TYPES_WITH_TWO_REFLECTORS.contains(type)) {
            return 2;
        }
        if (TYPES_WITH_THREE_REFLECTORS.contains(type)) {
            return 3;
        }
        if (TYPES_WITH_FOUR_REFLECTORS.contains(type)) {
            return 4;
        }
        return 1;
    }

    public ReflectorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)TYPE, (Comparable)Integer.valueOf(ReflectorBlock.getType(Direction.NORTH))));
    }

    @Nonnull
    public List<ItemStack> m_7381_(@Nonnull BlockState state, @Nonnull LootContext.Builder context) {
        ItemStack stack;
        List drops = super.m_7381_(state, context);
        int count = ReflectorBlock.getCount((Integer)state.m_61143_((Property)TYPE));
        if (!drops.isEmpty() && count > 1 && (stack = (ItemStack)drops.get(0)).m_41720_().equals(SolarCookerBlocks.REFLECTOR.m_5456_())) {
            stack.m_41764_(count);
        }
        return drops;
    }

    public void m_5871_(@Nonnull ItemStack stack, @Nullable BlockGetter worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        super.m_5871_(stack, worldIn, tooltip, flagIn);
        tooltip.add((Component)new TranslatableComponent("item.solarcooker.reflector.description").m_130940_(ChatFormatting.BLUE));
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPES[(Integer)state.m_61143_((Property)TYPE)];
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{TYPE});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate = context.m_43725_().m_8055_(context.m_8083_());
        Direction direction = context.m_8125_().m_122424_();
        if (blockstate.m_60713_((Block)this)) {
            return (BlockState)blockstate.m_61124_((Property)TYPE, (Comparable)Integer.valueOf((Integer)blockstate.m_61143_((Property)TYPE) | ReflectorBlock.getType(direction)));
        }
        return (BlockState)this.m_49966_().m_61124_((Property)TYPE, (Comparable)Integer.valueOf(ReflectorBlock.getType(direction)));
    }

    public boolean m_6864_(@Nonnull BlockState state, BlockPlaceContext context) {
        return context.m_43722_().m_41720_() == this.m_5456_() && !ReflectorBlock.isFacingTo(state, context.m_8125_().m_122424_()) || super.m_6864_(state, context);
    }

    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation direction) {
        int bits;
        if (direction == Rotation.CLOCKWISE_90) {
            bits = 1;
        } else if (direction == Rotation.CLOCKWISE_180) {
            bits = 2;
        } else if (direction == Rotation.COUNTERCLOCKWISE_90) {
            bits = 3;
        } else {
            return state;
        }
        int type = (Integer)state.m_61143_((Property)TYPE);
        int rotated = (type >> bits | type << 4 - bits) & 0xF;
        return (BlockState)state.m_61124_((Property)TYPE, (Comparable)Integer.valueOf(rotated));
    }
}

