/*
 * Decompiled with CFR 0.152.
 */
package cech12.solarcooker.inventory;

import cech12.solarcooker.api.inventory.ContainerTypes;
import cech12.solarcooker.config.ServerConfig;
import cech12.solarcooker.inventory.SolarCookerResultSlot;
import cech12.solarcooker.tileentity.AbstractSolarCookerBlockEntity;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SolarCookerContainer
extends AbstractContainerMenu {
    private final RecipeType<? extends AbstractCookingRecipe> specificRecipeType;
    private final AbstractSolarCookerBlockEntity cooker;
    protected final Level world;

    public SolarCookerContainer(RecipeType<? extends AbstractCookingRecipe> specificRecipeTypeIn, int id, Inventory playerInventoryIn, AbstractSolarCookerBlockEntity cooker) {
        super(ContainerTypes.SOLAR_COOKER, id);
        this.specificRecipeType = specificRecipeTypeIn;
        SolarCookerContainer.m_38869_((Container)cooker, (int)2);
        this.cooker = cooker;
        cooker.m_5856_(playerInventoryIn.f_35978_);
        this.world = playerInventoryIn.f_35978_.f_19853_;
        this.m_38897_(new Slot((Container)cooker, 0, 56, 17));
        this.m_38897_((Slot)new SolarCookerResultSlot(playerInventoryIn.f_35978_, (Container)cooker, 1, 116, 35));
        for (int playerInvRow = 0; playerInvRow < 3; ++playerInvRow) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.m_38897_(new Slot((Container)playerInventoryIn, j1 + playerInvRow * 9 + 9, 8 + j1 * 18, 84 + playerInvRow * 18));
            }
        }
        for (int playerHotbarSlot = 0; playerHotbarSlot < 9; ++playerHotbarSlot) {
            this.m_38897_(new Slot((Container)playerInventoryIn, playerHotbarSlot, 8 + playerHotbarSlot * 18, 142));
        }
    }

    public SolarCookerContainer(RecipeType<? extends AbstractCookingRecipe> specificRecipeTypeIn, int id, Inventory playerInventoryIn, BlockPos pos) {
        this(specificRecipeTypeIn, id, playerInventoryIn, (AbstractSolarCookerBlockEntity)playerInventoryIn.f_35978_.f_19853_.m_7702_(pos));
    }

    public boolean m_6875_(@Nonnull Player playerIn) {
        return this.cooker.m_6542_(playerIn);
    }

    @Nonnull
    public ItemStack m_7648_(@Nonnull Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index == 1) {
                if (!this.m_38903_(itemstack1, 2, 38, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (index != 0 ? (this.hasRecipe(itemstack1) ? !this.m_38903_(itemstack1, 0, 1, false) : (index >= 2 && index < 29 ? !this.m_38903_(itemstack1, 29, 38, false) : index >= 29 && index < 38 && !this.m_38903_(itemstack1, 2, 29, false))) : !this.m_38903_(itemstack1, 2, 38, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, itemstack1);
        }
        return itemstack;
    }

    public void m_182406_(int slotID, int stateId, @Nonnull ItemStack stack) {
        super.m_182406_(slotID, stateId, stack);
    }

    protected boolean hasRecipe(ItemStack stack) {
        if (this.world != null) {
            if (this.world.m_7465_().m_44015_(this.specificRecipeType, (Container)new SimpleContainer(new ItemStack[]{stack}), this.world).isPresent()) {
                return true;
            }
            if (((Boolean)ServerConfig.VANILLA_RECIPES_ENABLED.get()).booleanValue()) {
                return this.world.m_7465_().m_44056_(ServerConfig.getRecipeType(), (Container)new SimpleContainer(new ItemStack[]{stack}), this.world).stream().anyMatch(abstractCookingRecipe -> ServerConfig.isRecipeNotBlacklisted(abstractCookingRecipe.m_6423_()));
            }
        }
        return false;
    }

    public void m_6877_(@Nonnull Player playerIn) {
        super.m_6877_(playerIn);
        this.cooker.m_5785_(playerIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getCookProgressionScaled() {
        int i = this.cooker.getCookTime();
        int j = this.cooker.getCookTimeTotal();
        return j != 0 && i != 0 ? i * 24 / j : 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isBurning() {
        return this.cooker.getCookTime() > 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isSunlit() {
        return this.cooker.isSunlit();
    }
}

