/*
 * Decompiled with CFR 0.152.
 */
package cech12.solarcooker.blockentity;

import cech12.solarcooker.block.AbstractSolarCookerBlock;
import cech12.solarcooker.block.ReflectorBlock;
import cech12.solarcooker.block.SolarCookerBlock;
import cech12.solarcooker.config.ServerConfig;
import cech12.solarcooker.init.ModTags;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public abstract class AbstractSolarCookerBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
RecipeHolder,
StackedContentsCompatible,
LidBlockEntity {
    private static final int[] SLOTS = new int[]{0, 1};
    private static final int[] SLOTS_UP = new int[0];
    protected static final int INPUT = 0;
    protected static final int OUTPUT = 1;
    protected NonNullList<ItemStack> items = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
    protected int cookTime;
    protected int cookTimeTotal;
    protected float lidAngle;
    protected float prevLidAngle;
    protected int numPlayersUsing;
    protected int reflectorCount = 0;
    protected final RecipeType<? extends AbstractCookingRecipe> specificRecipeType;
    private final Object2IntOpenHashMap<ResourceLocation> usedRecipes = new Object2IntOpenHashMap();
    protected AbstractCookingRecipe curRecipe;
    protected ItemStack failedMatch = ItemStack.f_41583_;
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.NORTH});

    public AbstractSolarCookerBlockEntity(BlockEntityType<?> tileTypeIn, BlockPos pos, BlockState state, RecipeType<? extends AbstractCookingRecipe> specificRecipeTypeIn) {
        super(tileTypeIn, pos, state);
        this.specificRecipeType = specificRecipeTypeIn;
    }

    private boolean hasShiningBlockAbove() {
        BlockPos checkPos;
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && this.f_58857_.m_8055_(checkPos = this.f_58858_.m_7494_()).m_60631_((BlockGetter)this.f_58857_, checkPos)) {
            for (int i = 0; i < 5; ++i) {
                BlockState state = this.f_58857_.m_8055_(checkPos = checkPos.m_7494_());
                if (state.m_204336_(ModTags.Blocks.SOLAR_COOKER_SHINING)) {
                    return true;
                }
                if (state.m_60631_((BlockGetter)this.f_58857_, checkPos)) continue;
                return false;
            }
        }
        return false;
    }

    public boolean isSunlit() {
        if (this.f_58857_ != null) {
            if (!this.f_58857_.f_46443_) {
                return this.hasShiningBlockAbove() || this.f_58857_.m_6042_().f_223549_() && this.f_58857_.m_46461_() && !this.f_58857_.m_46471_() && this.f_58857_.m_45527_(this.f_58858_.m_7494_());
            }
            return (Boolean)this.m_58900_().m_61143_((Property)SolarCookerBlock.SUNLIT);
        }
        return false;
    }

    public int getCookTime() {
        return this.cookTime;
    }

    public int getCookTimeTotal() {
        return this.cookTimeTotal;
    }

    public void m_142466_(@Nonnull CompoundTag nbtIn) {
        super.m_142466_(nbtIn);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)nbtIn, this.items);
        this.cookTime = nbtIn.m_128451_("CookTime");
        this.cookTimeTotal = nbtIn.m_128451_("CookTimeTotal");
    }

    protected void m_183515_(@Nonnull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("CookTime", this.cookTime);
        compound.m_128405_("CookTimeTotal", this.cookTimeTotal);
        ContainerHelper.m_18973_((CompoundTag)compound, this.items);
    }

    @Nonnull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public static void tick(Level level, BlockPos pos, BlockState state, AbstractSolarCookerBlockEntity entity) {
        if (level != null) {
            boolean isBurning;
            boolean dirty = false;
            entity.calculateLidAngle();
            boolean isSunlit = entity.isSunlit();
            if (isSunlit && !((ItemStack)entity.items.get(0)).m_41619_()) {
                AbstractCookingRecipe recipe = entity.getRecipe();
                if (entity.canSmelt((Recipe<?>)recipe)) {
                    ++entity.cookTime;
                    if (entity.cookTime == entity.cookTimeTotal) {
                        entity.cookTime = 0;
                        entity.cookTimeTotal = entity.getRecipeCookTime();
                        if (!level.f_46443_) {
                            entity.smeltItem((Recipe<?>)recipe);
                            dirty = true;
                        }
                    }
                } else {
                    entity.cookTime = 0;
                }
            } else if (!isSunlit && entity.cookTime > 0) {
                entity.cookTime = Mth.m_14045_((int)(entity.cookTime - 2), (int)0, (int)entity.cookTimeTotal);
            }
            boolean bl = isBurning = entity.cookTime > 0;
            if (!(level.f_46443_ || (Boolean)entity.m_58900_().m_61143_((Property)SolarCookerBlock.BURNING) == isBurning && (Boolean)entity.m_58900_().m_61143_((Property)SolarCookerBlock.SUNLIT) == isSunlit)) {
                dirty = true;
                entity.f_58857_.m_7731_(entity.f_58858_, (BlockState)((BlockState)entity.f_58857_.m_8055_(entity.f_58858_).m_61124_((Property)SolarCookerBlock.SUNLIT, (Comparable)Boolean.valueOf(isSunlit))).m_61124_((Property)SolarCookerBlock.BURNING, (Comparable)Boolean.valueOf(isBurning)), 3);
            }
            if (dirty) {
                entity.m_6596_();
            }
        }
    }

    public boolean shouldLidBeOpen() {
        return this.numPlayersUsing > 0 || this.canSmelt((Recipe<?>)this.getRecipe()) && this.isSunlit();
    }

    private void calculateLidAngle() {
        if (this.f_58857_ != null) {
            this.prevLidAngle = this.lidAngle;
            boolean shouldLidBeOpen = this.shouldLidBeOpen();
            if (shouldLidBeOpen && this.lidAngle == 0.0f) {
                this.playSound(SoundEvents.f_11749_);
                if (!this.f_58857_.f_46443_) {
                    this.m_6596_();
                }
            }
            if (!shouldLidBeOpen && this.lidAngle > 0.0f || shouldLidBeOpen && this.lidAngle < 1.0f) {
                float f1 = this.lidAngle;
                this.lidAngle = shouldLidBeOpen ? (this.lidAngle += 0.1f) : (this.lidAngle -= 0.1f);
                if (this.lidAngle > 1.0f) {
                    this.lidAngle = 1.0f;
                }
                if (this.lidAngle < 0.5f && f1 >= 0.5f) {
                    this.playSound(SoundEvents.f_11747_);
                }
                if (this.lidAngle < 0.0f) {
                    this.lidAngle = 0.0f;
                }
            }
        }
    }

    public boolean m_7531_(int id, int type) {
        if (id == 1) {
            this.numPlayersUsing = type;
            return true;
        }
        return super.m_7531_(id, type);
    }

    public void m_5856_(Player player) {
        if (!player.m_5833_()) {
            if (this.numPlayersUsing < 0) {
                this.numPlayersUsing = 0;
            }
            ++this.numPlayersUsing;
            this.onOpenOrClose();
        }
    }

    public void m_5785_(Player player) {
        if (!player.m_5833_()) {
            --this.numPlayersUsing;
            this.onOpenOrClose();
        }
    }

    protected void onOpenOrClose() {
        Block block = this.m_58900_().m_60734_();
        if (this.f_58857_ != null && block instanceof SolarCookerBlock) {
            this.f_58857_.m_7696_(this.f_58858_, block, 1, this.numPlayersUsing);
        }
    }

    private void playSound(SoundEvent soundIn) {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            double x = (double)this.f_58858_.m_123341_() + 0.5;
            double y = (double)this.f_58858_.m_123342_() + 0.5;
            double z = (double)this.f_58858_.m_123343_() + 0.5;
            this.f_58857_.m_6263_(null, x, y, z, soundIn, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.9f);
        }
    }

    protected boolean canSmelt(@Nullable Recipe<?> recipe) {
        ItemStack recipeOutput;
        if (!((ItemStack)this.items.get(0)).m_41619_() && recipe != null && !(recipeOutput = recipe.m_5874_((Container)this)).m_41619_()) {
            ItemStack output = (ItemStack)this.items.get(1);
            if (output.m_41619_()) {
                return true;
            }
            if (!output.m_41656_(recipeOutput)) {
                return false;
            }
            return output.m_41613_() + recipeOutput.m_41613_() <= output.m_41741_();
        }
        return false;
    }

    private void smeltItem(@Nullable Recipe<?> recipe) {
        if (recipe != null && this.canSmelt(recipe)) {
            ItemStack itemstack = (ItemStack)this.items.get(0);
            ItemStack itemstack1 = recipe.m_5874_((Container)this);
            ItemStack itemstack2 = (ItemStack)this.items.get(1);
            if (itemstack2.m_41619_()) {
                this.items.set(1, (Object)itemstack1.m_41777_());
            } else if (itemstack2.m_41720_() == itemstack1.m_41720_()) {
                itemstack2.m_41769_(itemstack1.m_41613_());
            }
            if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
                this.m_6029_(recipe);
            }
            itemstack.m_41774_(1);
        }
    }

    protected int getRecipeCookTime() {
        double reflectorFactor;
        AbstractCookingRecipe rec = this.getRecipe();
        if (rec == null) {
            return 200;
        }
        this.checkForReflectors();
        double d = reflectorFactor = this.reflectorCount > 0 ? 1.0 - (1.0 - (Double)ServerConfig.MAX_REFLECTOR_TIME_FACTOR.get()) / 4.0 * (double)this.reflectorCount : 1.0;
        if (this.specificRecipeType.getClass().isInstance(rec.m_6671_())) {
            return (int)((double)rec.m_43753_() * reflectorFactor);
        }
        return (int)((double)rec.m_43753_() * ((Double)ServerConfig.COOK_TIME_FACTOR.get() * reflectorFactor));
    }

    protected AbstractCookingRecipe getRecipe() {
        ItemStack input = this.m_8020_(0);
        if (input.m_41619_() || input == this.failedMatch) {
            return null;
        }
        if (this.f_58857_ != null && this.curRecipe != null && this.curRecipe.m_5818_((Container)this, this.f_58857_)) {
            return this.curRecipe;
        }
        AbstractCookingRecipe rec = null;
        if (this.f_58857_ != null && (rec = (AbstractCookingRecipe)this.f_58857_.m_7465_().m_44015_(this.specificRecipeType, (Container)this, this.f_58857_).orElse(null)) == null && ((Boolean)ServerConfig.VANILLA_RECIPES_ENABLED.get()).booleanValue()) {
            rec = this.f_58857_.m_7465_().m_44056_(ServerConfig.getRecipeType(), (Container)this, this.f_58857_).stream().filter(abstractCookingRecipe -> ServerConfig.isRecipeNotBlacklisted(abstractCookingRecipe.m_6423_())).findFirst().orElse(null);
        }
        this.failedMatch = rec == null ? input : ItemStack.f_41583_;
        this.curRecipe = rec;
        return this.curRecipe;
    }

    private void checkForReflectors() {
        BlockState state;
        this.reflectorCount = 0;
        if (this.f_58857_ != null && (state = this.f_58857_.m_8055_(this.f_58858_)).m_60734_() instanceof AbstractSolarCookerBlock) {
            Direction facing = (Direction)state.m_61143_((Property)AbstractSolarCookerBlock.FACING);
            this.reflectorCount += this.countReflectorsOnSide(facing.m_122427_());
            this.reflectorCount += this.countReflectorsOnSide(facing.m_122428_());
        }
    }

    private int countReflectorsOnSide(Direction direction) {
        int count = 0;
        if (this.f_58857_ != null) {
            BlockPos blockPos = this.f_58858_.m_121945_(direction);
            for (BlockPos position : new BlockPos[]{blockPos, blockPos.m_7494_()}) {
                BlockState state = this.f_58857_.m_8055_(position);
                if (!(state.m_60734_() instanceof ReflectorBlock) || !ReflectorBlock.isFacingTo(state, direction.m_122424_())) continue;
                ++count;
            }
        }
        return count;
    }

    @Nonnull
    public int[] m_7071_(@Nonnull Direction side) {
        if (side == Direction.UP) {
            return SLOTS_UP;
        }
        return SLOTS;
    }

    public boolean m_7155_(int index, @Nonnull ItemStack itemStackIn, @Nullable Direction direction) {
        return this.m_7013_(index, itemStackIn);
    }

    public boolean m_7157_(int index, @Nonnull ItemStack stack, @Nullable Direction direction) {
        return direction != Direction.UP && index == 1;
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public ItemStack m_8020_(int index) {
        return (ItemStack)this.items.get(index);
    }

    @Nonnull
    public ItemStack m_7407_(int index, int count) {
        return ContainerHelper.m_18969_(this.items, (int)index, (int)count);
    }

    @Nonnull
    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.items, (int)index);
    }

    public void m_6836_(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.items.get(index);
        boolean flag = !stack.m_41619_() && stack.m_41656_(itemstack) && ItemStack.m_41658_((ItemStack)stack, (ItemStack)itemstack);
        this.items.set(index, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        if (index == 0 && !flag) {
            this.cookTimeTotal = this.getRecipeCookTime();
            this.cookTime = 0;
            this.m_6596_();
        }
    }

    public boolean m_6542_(@Nonnull Player player) {
        if (this.f_58857_ != null && this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public boolean m_7013_(int index, @Nonnull ItemStack stack) {
        return index == 0;
    }

    public void m_6211_() {
        this.items.clear();
    }

    public void m_6029_(@Nullable Recipe<?> recipe) {
        if (recipe != null) {
            this.usedRecipes.addTo((Object)recipe.m_6423_(), 1);
        }
    }

    @Nullable
    public Recipe<?> m_7928_() {
        return null;
    }

    public void awardUsedRecipesAndPopExperience(Player p_235645_1_) {
        List<Recipe<?>> list = this.getRecipesToAwardAndPopExperience(p_235645_1_.f_19853_, p_235645_1_.m_20182_());
        p_235645_1_.m_7281_(list);
        this.usedRecipes.clear();
    }

    public List<Recipe<?>> getRecipesToAwardAndPopExperience(Level p_235640_1_, Vec3 p_235640_2_) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.usedRecipes.object2IntEntrySet()) {
            p_235640_1_.m_7465_().m_44043_((ResourceLocation)entry.getKey()).ifPresent(p_235642_4_ -> {
                list.add(p_235642_4_);
                AbstractSolarCookerBlockEntity.createExperience(p_235640_1_, p_235640_2_, entry.getIntValue(), ((AbstractCookingRecipe)p_235642_4_).m_43750_());
            });
        }
        return list;
    }

    private static void createExperience(Level p_235641_0_, Vec3 p_235641_1_, int p_235641_2_, float p_235641_3_) {
        int i = Mth.m_14143_((float)((float)p_235641_2_ * p_235641_3_));
        float f = Mth.m_14187_((float)((float)p_235641_2_ * p_235641_3_));
        if (f != 0.0f && Math.random() < (double)f) {
            ++i;
        }
        while (i > 0) {
            int j = ExperienceOrb.m_20782_((int)i);
            i -= j;
            p_235641_0_.m_7967_((Entity)new ExperienceOrb(p_235641_0_, p_235641_1_.f_82479_, p_235641_1_.f_82480_, p_235641_1_.f_82481_, j));
        }
    }

    public void m_5809_(@Nonnull StackedContents helper) {
        for (ItemStack itemstack : this.items) {
            helper.m_36491_(itemstack);
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (!this.f_58859_ && facing != null && capability == ForgeCapabilities.ITEM_HANDLER) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            return this.handlers[1].cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        for (LazyOptional<? extends IItemHandler> handler : this.handlers) {
            handler.invalidate();
        }
    }

    public float m_6683_(float partialTicks) {
        if (this.f_58857_ != null) {
            return Mth.m_14179_((float)partialTicks, (float)this.prevLidAngle, (float)this.lidAngle);
        }
        return 0.0f;
    }
}

